/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   jotopt.h
Author(s)   :   J. Wang (CIC)
Company     :   Communication Intelligence Corporation
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for jot option 
Revision    :   1.1
Note        :   None
===========================================================================
*/              
                
#ifndef JOT_OPTIONS_H
#define JOT_OPTIONS_H

#define ZORRO_TRAINABLE     0   
                /* Set to 0 will disable internal trainer               */
#define ZORRO_EXTERNAL_TRAINER  1
                /* Set to 1 to use external trainer                     */
#define ZORRO_SPACE_DETECTION   0
                /* Default is character recognition, set to 1 to allow   */
                /*   sentence recognition                                */
#define ZORRO_RESOLUTION_128	0
#define ZORRO_RESOLUTION_1016     0
                /* The resolution is 1016 ppi      */
#define ZORRO_RESOLUTION_80		1
#define ZORRO_REENTRANT     0
                /* Set to 0 will use global variable instead of dynamicly */
                /*   allocated memory                                     */                
#define ZORRO_EXTERNALMEMORY 1
				/* Memory allocated by caller		*/
#define ZO_REC_SPECIALKEY	0
				/* Under Windows, set to 1 will recognize some special key*/
				/*   such as Home, End, PageUp, PageDown etc.			  */

#define JOT_MAX_DOT_SIZE  48
				/* Size of a dot, measured as the box len				*/

#define MS_EXTENDED_CHAR		1
#define JOT_BACKSLASH_AS_EXT_GESTURE 0
#define JOT_UPSTROKE_AS_EXT_GESTURE 0
#endif
