/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   sndmgr.h
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for sound manager
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef _SNDMGR_H__
#define _SNDMGR_H__
#include "datatype.h"

/*===============================================================*/
#define SND_STOP			0
#define SND_PLAY_REC		1
#define SND_PLAY_EFF		2
#define SND_PAUSE			3

#define SND_ACTION_SUCCESS  4
#define INV_SND_ACTION      5
#define	END_OF_REC			6

/*---------------------------------------------------------------*/
#define	SND_MAX_VOL			31
#define	SND_MAX_GAIN		13
/*---------------------------------------------------------------*/

#define BIT         		2                   
#define BITORDER			(2*(BIT+(BIT/4)-1))	
												
												

#define W					256                 
#define N           		160	     			
#define WmN					(W-N)
#define Pth         		4                   
#define TTCodeLen   		(Pth + N*BIT/8)		
#define SCALE       		2047                
#define ASCALE      		40                  
#define	FFFrame				50					
#define	BYTEPS				2201				

/*---------------------------------------------------------------*/
/*- Sound Device Driver Initialization --------*/
void 	SndDDInit(void);
BOOLEAN SndSetSndSettings(SHORT mic_gain, SHORT vol, SHORT click, SHORT set_para);

/*------------ API Functions for Sound Playback System ---------------*/
BOOLEAN SndDataHandler(DatabaseID dbid, RecordID rec_id, USHORT field_num);
BOOLEAN SndDataPlay(void);
BOOLEAN SndDataPlaySndEffect(void);
BOOLEAN SndDataPlayComSndEffect(void);
void	SndDataPlaySndEffectStart(SHORT sndres_num);
BOOLEAN SndDataPlayStart(UWORD start_frame);
BOOLEAN	SndDataRec(void);

void	SndMgr(void);
void	SndMgrMsgDecode(MsgType* message);

UWORD   SndPause(void);
BOOLEAN SndPlay(UWORD start_time, DatabaseID dbid, RecordID rec_id, USHORT field_num);
BOOLEAN SndPlaySndEffect(SHORT sndres_num);
BOOLEAN SndREPlay(UWORD start_frame, DatabaseID dbid, RecordID rec_id, USHORT field_num);
BOOLEAN	SndRERec(DatabaseID dbid, RecordID rec_id, USHORT field_num);
BOOLEAN	SndRec(DatabaseID dbid, RecordID rec_id, USHORT field_num);
void	SndStop(void);
void	Ader(void);
void	Kder(void);
void 	Iautoco(SHORT[], double[], SHORT, SHORT);
UWORD 	CalAgcCo(UWORD Iinbuf[], UWORD n);
void 	Icalcoef(double[], BYTE[], SHORT);
void 	Iwindow(SHORT[], SHORT[], SHORT);

void 	Ipack(UBYTE, SHORT, USHORT*, USHORT*);
UBYTE	Iunpack(SHORT, USHORT*, USHORT*);

#endif

