/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   strapi.h
Author(s)   :   Brian Lee, Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for string API functions
Revision    :   1.1
Note        :   None
===========================================================================
*/              

#ifndef	_STRAPI_
#define	_STRAPI_

#include "Font.h"
#include "Ui.h"
#include "dm_os.h"

#define	SPACE_CHAR	1
#define SPACE_LINE	1


void 	_strrev(char* string);
void 	StrExtract(BYTE *string1, WORD start, WORD length, BYTE *string2);
UWORD 	StrGetWidth(BYTE *string, BYTE font);
void 	StrAnalyzeWord(BYTE *string, BYTE font, SHORT width, WORD *length, SHORT *word_width);
void 	StrAnalyzeLine(Field *field_ptr);
void 	StrChopString(ObjectBounds *bounds, BYTE *string, BYTE font, BOOLEAN dotdot, SHORT margin);
void 	StrGetInsertPtPos(Field *field_ptr, SHORT xcoord, SHORT ycoord, WORD *insert_pos, SHORT *insert_pt_x, SHORT *insert_pt_y);
void 	StrCharPosToXY(Field *field_ptr, WORD char_pos, SHORT *xcoord, SHORT *ycoord);
void 	StrXYToCharPos(Field *field_ptr, SHORT xcoord, SHORT ycoord, WORD *char_pos);
void 	StrTextboxGetInsertPtPos(Textbox *tb_ptr, SHORT xcoord, SHORT ycoord, WORD *insert_pos, SHORT *insert_pt_x, SHORT *insert_pt_y);
void 	StrTextboxCharPosToXY(Textbox *tb_ptr, WORD char_pos, SHORT *xcoord, SHORT *ycoord);
void 	StrTextboxXYToCharPos(Textbox *tb_ptr, SHORT xcoord, SHORT ycoord, WORD *char_pos);
void 	StrTextboxAnalyze(Textbox *tb_ptr);

#endif	_STRAPI_
