/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   uidef.h
Author(s)   :   Henry Fok, David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for ui global defines
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#ifndef _UIDEF_H_
#define _UIDEF_H_
#include "DataType.h"
#include "QType.h"
#include "uierr.h"
#include "uievent.h"
#include "ui.h"
#include "mmu.h"
#include "dm_os.h"
#include "dm_user.h"
#include "resmgr.h"
#include "DDApi.h"


#define DIR_RIGHT	1
#define DIR_LEFT	0


#ifndef PC_SIM
#ifndef	max
#define max(a,b)	(((a) > (b)) ? (a) : (b))	// return the max variable about a & b
#endif	max
#ifndef	min
#define min(a,b)	(((a) < (b)) ? (a) : (b))	// return the min variable about a & b
#endif	min
#ifndef	dim
#define	dim(a)		(sizeof(a)/sizeof(*(a)))	// get dimension of a structure
#endif	dim
#endif


extern LinkListForm     *main_pointer;
extern LookupTable      *lookup_table_ptr;
extern EvtType          old_event;
extern EvtType          inlay_event;
extern Clipboard        clipboard;
extern Clipboard        undo_buffer;
extern BOOLEAN          insert;
extern BYTE             undo_action;
extern BOOLEAN          keyboard_status;
extern BOOLEAN          menu_status;
extern BOOLEAN          popup_status;
extern Keyboard         keyboard;
extern BYTE             form_loaded_once;
extern BOOLEAN          by_pass_scrollbar_event;

/*=====================================================
=====================BACKSPACE UNDO DEFINE=======================
=====================================================*/
typedef struct _BACKSPACE_UNDO
{
	ObjectID current_object_id;
	UBYTE key[256];
	SHORT index;
}BackspaceUndo;

extern BackspaceUndo backspace_undo;


/*=====================================================
==================== TYPING UNDO DEFINE================
======================================================*/
typedef struct _TYPING_UNDO
{
	WORD	focus_object_id;
	WORD	start_char;
	WORD	length;
}TypingUndo;

extern TypingUndo typing_undo;




/*=====================================================
=====================DRAW DEFINE=======================
=====================================================*/
#define CLICK_OFF				0
#define CLICK_ON				1
#define DRAW_EMPTY				0
#define DRAW_FILL				1
#define	DRAW_NOT_FILL			0

#define NO_LINE					0
#define DOT_LINE				1
#define GREY_LINE				2

#define	NOT_INVERT				0
#define	INVERT					1

/*		Control Draw Define		*/
#define LEFT_ALIGN	            0
#define CENTRE_ALIGN	        1
#define RIGHT_ALIGN			    2

#define QUARTER_1				0
#define QUARTER_2				1
#define QUARTER_3				2
#define QUARTER_4				3

#define BUTTON_NO_BORDER		0
#define TAP_BUTTON_BORDER		1
#define BUTTON_BORDER           2
#define BUTTON_FIXED_CORNER		2

#define POPUP_TOP_BORDER		2
#define	POPUP_LEFT_BORDER		3
#define POPUP_HIGHLIGHT_BORDER	3
#define POPUP_SCROLL_ARROW_SIZE 7
#define POPUP_INDICATOR_WIDTH   7
#define POPUP_INDICATOR_HEIGHT  4

/*		Form Draw Define		*/
#define FORM_TOP_HEIGHT			14
#define FORM_BITMAP_LEFT_BORDER	7
#define FORM_BITMAP_TOP_BORDER	3
#define DIALOG_RADIUS			2
#define	DIALOG_TEXT_SEPARATOR	3
#define DIALOG_BORDER			3
#define	DIALOG_TOP_BORDER		3
#define DIALOG_HEADER1_HEIGHT 	12
#define BITMAP_DIALOG_HEADER 	25
#define NON_BITMAP_DIALOG_HEADER 	15

/*		Scrollbar Draw Define	*/
#define VERTICAL			    0
#define HORIZONTAL			    1

/*		String Draw Define		*/
#define STRING_1_BORDER			1
#define STRING_2_BORDER			2

/*		List Draw Define		*/
#define LIST_SEPARATOR		    1
#define	LIST_BORDER				2
#define	LIST_FIXED_CORNER		2
#define	LIST_STYLE_12_BORDER	0
#define	LIST_STYLE_34_BORDER	2

/*		Menu Draw Define		*/
#define	MENU_BORDER				2

/*		Table Draw Define		*/
#define	TABLE_BORDER			5
#define NO_FRAME				0
#define FRAMED					1

/* Textbox Draw Define */
#define TEXTBOX_FIXED_CORNER	2

/*=====================================================
=====================OBJECT TYPE=======================
=====================================================*/
#define FORM                	0
#define CONTROL             	1
#define FIELD               	2
#define LIST                	3
#define MENU                	4
#define SCROLLBAR           	5
#define TABLE               	6
#define SCHLINE             	7
#define STRING              	8
#define BITMAP              	9
#define TEXTBOX					10
#define LINE                	11


#define BUTTON              	0
#define PUSH_BUTTON         	1
#define REPEAT_BUTTON       	2
#define CHECKBOX            	3
#define POPUP_TRIGGER       	4

/*=====================================================
===================== GLOBAL DEFINE ===============
=====================================================*/
//brian lee
#define TOTAL_REPEAT_COUNT      8
#define ARROW_DELAY             50
#define NO_MOVEMENT             0
#define MOVE_UP              	1
#define MOVE_DOWN            	2
#define MOVE_LEFT               3
#define MOVE_RIGHT              4
#define ARROW_UP             	1
#define ARROW_DOWN           	2

#define NO_SELECTION			-1	// Menu, List, Popup ....


/*=====================================================
===================== Form DEFINE ====================
=====================================================*/
#define BACKGROUND				0
#define NORMAL_FORM				1
#define BITMAP_DIALOG			2
#define NON_BITMAP_DIALOG		3
#define NORMAL_FORM_WIO_LINE	4


#define LOAD					1
#define NO_LOAD					0

/*=====================================================
===================== Clipboard DEFINE ================
=====================================================*/
#define CLIP_EMPTY              0
#define CLIP_TEXT_DATA          1
#define CLIP_BITMAP_DATA        2
#define CLIP_BINARY_DATA        3

/*=====================================================
=====================SCROLLBAR DEFINE==================
=====================================================*/
#define SCROLL_NOT_HITTED		0
#define SCROLL_UP_ARROW			1
#define SCROLLBAR_UP_REGION		2
#define SCROLLCAR_REGION		3
#define SCROLLBAR_DOWN_REGION           4
#define SCROLL_DOWN_ARROW		5

#define SCROLLBAR_UP_ARROW              0
#define SCROLLBAR_DOWN_ARROW            1


#define SCROLL_EXT_WIDTH	5
#define SCROLL_SEPARATOR	0
#define SCROLL_MIN_VALUE	8

#define SCROLLBAR_STYLE_0			0
#define SCROLLBAR_STYLE_1			1
#define SCROLLBAR_STYLE_2			2
#define SCROLLBAR_STYLE_3			3
#define SCROLLBAR_STYLE_4			4
#define SCROLLBAR_STYLE_5			5
#define SCROLLBAR_STYLE_6			6


/*=====================================================
===================== Field DEFINE ===================
=====================================================*/
#define UNDO_EMPTY                  0
#define UNDO_CUT                    1
#define UNDO_PASTE                  2
#define UNDO_BACKSPACE              3
#define UNDO_BACKSPACE_HIGHLIGHT    4
#define UNDO_TYPING					5


#define STEP_SIZE               128
#define FIELD_DRAG_REPEAT_COUNT 4

#define FIELD_STYLE_0			0
#define FIELD_STYLE_1			1
#define FIELD_STYLE_2			2
#define FIELD_STYLE_3			3
#define FIELD_STYLE_4			4
#define FIELD_STYLE_5			5
#define FIELD_STYLE_6			6

/*=====================================================
===================== Textbox DEFINE ===================
=====================================================*/
#define TEXTBOX_DRAG_REPEAT_COUNT 4

#define TEXTBOX_STYLE_0			0
#define TEXTBOX_STYLE_1			1
#define TEXTBOX_STYLE_2			2
#define TEXTBOX_STYLE_3			3
#define TEXTBOX_STYLE_4			4
#define TEXTBOX_STYLE_5			5
#define TEXTBOX_STYLE_6			6


/*=====================================================
===================== Keyboard DEFINE =================
=====================================================*/
#define KEYBOARD_ON		1
#define KEYBOARD_OFF	0

#define KEYBOARD_BITMAP_1		1
#define KEYBOARD_BITMAP_2		2
#define KEYBOARD_BITMAP_3		3
#define KEYBOARD_BITMAP_4		4
#define KEYBOARD_BITMAP_5		5
#define KEYBOARD_BITMAP_6		6


/*=====================================================
===================== Line DEFINE =================
=====================================================*/
#define SINGLE_LINE		1
#define DOUBLE_LINE		2

#define LINE_STYLE_0		0
#define LINE_STYLE_1		1
#define LINE_STYLE_2		2
#define LINE_STYLE_3		3
#define LINE_STYLE_4		4
#define LINE_STYLE_5		5
#define LINE_STYLE_6		6


/*=====================================================
===================== Bitmap DEFINE =================
=====================================================*/
#define BITMAP_STYLE_0		0
#define BITMAP_STYLE_1		1
#define BITMAP_STYLE_2		2
#define BITMAP_STYLE_3		3
#define BITMAP_STYLE_4		4
#define BITMAP_STYLE_5		5
#define BITMAP_STYLE_6		6


/*=====================================================
===================== List DEFINE =================
=====================================================*/
#define REGION_UP_ARROW		1
#define REGION_DN_ARROW		2
#define REGION_ITEMS		0

#define LIST_STYLE_0		0
#define LIST_STYLE_1		1
#define LIST_STYLE_2		2
#define LIST_STYLE_3		3
#define LIST_STYLE_4		4
#define LIST_STYLE_5		5
#define LIST_STYLE_6		6
#define LIST_STYLE_7        7


/*=====================================================
===================== Table DEFINE =================
=====================================================*/
#define TABLE_TEXT		0
#define TABLE_VALUE		1
#define TABLE_UI_OBJECT	2

#define TABLE_STYLE_0		0
#define TABLE_STYLE_1		1
#define TABLE_STYLE_2		2
#define TABLE_STYLE_3		3
#define TABLE_STYLE_4		4
#define TABLE_STYLE_5		5
#define TABLE_STYLE_6		6


/*=====================================================
===================== Menu DEFINE =================
=====================================================*/
#define MENU_STYLE_0		0
#define MENU_STYLE_1		1
#define MENU_STYLE_2		2
#define MENU_STYLE_3		3
#define MENU_STYLE_4		4
#define MENU_STYLE_5		5
#define MENU_STYLE_6		6


/*=====================================================
===================== String DEFINE =================
=====================================================*/
#define STRING_STYLE_0		0
#define STRING_STYLE_1		1
#define STRING_STYLE_2		2
#define STRING_STYLE_3		3
#define STRING_STYLE_4		4
#define STRING_STYLE_5		5
#define STRING_STYLE_6		6


/*=====================================================
===================== Scheduler Line DEFINE ==========
=====================================================*/
#define SCHLINE_STYLE_0		0
#define SCHLINE_STYLE_1		1
#define SCHLINE_STYLE_2		2
#define SCHLINE_STYLE_3		3
#define SCHLINE_STYLE_4		4
#define SCHLINE_STYLE_5		5
#define SCHLINE_STYLE_6		6

#define	SCHLINE_24_BG_WIDTH		9
#define	SCHLINE_24_BG_NUM		17
#define	SCHLINE_24_NUM_REGION	16
#define	SCHLINE_12_BG_WIDTH		7
#define	SCHLINE_12_BG_NUM		22
#define	SCHLINE_12_NUM_REGION	21
#define SCHLINE_NOT_CLICKED		-1
#define SCHLINE_MODE_12			0
#define SCHLINE_MODE_24			1
#define SCHLINE_MAX_TEXT		10
#define	SCHLINE_NO_PICTURE		-1
#define	SCHLINE_TODO_12_TONE	0		
#define	SCHLINE_TODO_12_VOICE	1
#define	SCHLINE_SCH_12_TONE		2		
#define	SCHLINE_SCH_12_VOICE	3
#define	SCHLINE_ANN_12_TONE		4		
#define	SCHLINE_TODO_24_TONE	5
#define	SCHLINE_TODO_24_VOICE	6	
#define	SCHLINE_SCH_24_TONE		7	
#define	SCHLINE_SCH_24_VOICE	8
#define	SCHLINE_ANN_24_VOICE	9



/*=====================================================
===================== CONTROL DEFINE =================
=====================================================*/
#define BUTTON_STYLE_0		0
#define BUTTON_STYLE_1		1
#define BUTTON_STYLE_2		2
#define BUTTON_STYLE_3		3
#define BUTTON_STYLE_4		4
#define BUTTON_STYLE_5		5
#define BUTTON_STYLE_6		6

#define REPEATBUTTON_STYLE_0		0
#define REPEATBUTTON_STYLE_1		1
#define REPEATBUTTON_STYLE_2		2
#define REPEATBUTTON_STYLE_3		3
#define REPEATBUTTON_STYLE_4		4
#define REPEATBUTTON_STYLE_5		5
#define REPEATBUTTON_STYLE_6		6

#define CHECKBOX_STYLE_0		0
#define CHECKBOX_STYLE_1		1
#define CHECKBOX_STYLE_2		2
#define CHECKBOX_STYLE_3		3
#define CHECKBOX_STYLE_4		4
#define CHECKBOX_STYLE_5		5
#define CHECKBOX_STYLE_6		6

#define PUSHBUTTON_STYLE_0		0
#define PUSHBUTTON_STYLE_1		1
#define PUSHBUTTON_STYLE_2		2
#define PUSHBUTTON_STYLE_3		3
#define PUSHBUTTON_STYLE_4		4
#define PUSHBUTTON_STYLE_5		5
#define PUSHBUTTON_STYLE_6		6

#define POPUP_TRIGGER_STYLE_0		0
#define POPUP_TRIGGER_STYLE_1		1
#define POPUP_TRIGGER_STYLE_2		2
#define POPUP_TRIGGER_STYLE_3		3
#define POPUP_TRIGGER_STYLE_4		4
#define POPUP_TRIGGER_STYLE_5		5
#define POPUP_TRIGGER_STYLE_6		6



#endif
