/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   app.h
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#ifndef __APP_H_
#define __APP_H_

#include "system.h"
#include "appfunc.h"
#include "listdis.h"
#include "pblang.h"
#include "pbsize.h"

//#include <emudbg.h>

#ifdef DEBUG
extern char debug_msg[80];
#endif

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
extern AppID            app_id;
extern DatabaseID       pb_dbid;
extern ObjectID         pressed_object;
extern BYTE             *current_cate;
extern BYTE             char_start;
extern BYTE             *temp_cate;
extern ListDisplay      list_tel_list;
extern ListDisplay      list_find;
extern BYTE             **field_buffers;
extern BYTE             *save_cate;
extern BYTE             save_first_letter;
extern BYTE             table_font_size;
extern BYTE             edit_dirty;
extern BYTE             find_string[];
extern BYTE             font_size;
extern BOOLEAN          draw_scrollbar;
extern BOOLEAN          gf_entry;
extern ObjectID         gf_in_form_id;
extern ObjectID         low_memory_form_id;
extern BOOLEAN	        entry_low_memory;
extern BOOLEAN	        entry_old_edit;
extern BOOLEAN			letter_bar;
extern WORD				gTopNum;
extern WORD				gSelNum;
extern BYTE				sort_mode;
extern BYTE				show_mode;
extern WORD				char_pos[];

/*****************************************************************
*********************** Global Defines ***************************
*****************************************************************/
//#define     EL32(x)     ((x <<24) | ((x &0xff00) <<8) | ((x &0xff0000) >>8) | (x>>24))
#define     MemoryLow     MemoryCheckMemLow()
#define     MemoryNormal  !MemoryCheckMemLow()


//======================= Phonebook Database ========================
#define PB_STATUS		0x80001000
#define PB_EDIT_INFO	0x80001001
#define PB_ADDR_LIST	0x80001002

//======================= Phonebook Status Define (Close Application) ========================
//#define RESTART			0	
//#define ADDRESS_LIST	1
//#define EDITING			2
//#define VIEWING			3
//#define NOTES			4

//======================= Phonebook Application Status ========================
//Field 0 --------------- application_status
//Field 1 --------------- edit_dirty
//Field 2 --------------- find_string


//======================= Phonebook Address List Information ========================
//Field 0 --------------- current_cate
//Field 1 --------------- char_start

//======================= Phonebook Edit Information ========================
//Field 0 --------------- STRING_NAME
//Field 1 --------------- STRING_LAST_NAME
//Field 2 --------------- STRING_FIRST_NAME
//Field 3 --------------- TEXTBOX_FIRST_NAME
//Field 4 --------------- TEXTBOX_LAST_NAME
//Field 5 - 32 ---------- field_buffers

//Field 33 -------------- company info (BOOLEAN)
//Field 34 -------------- home info (BOOLEAN)
//Field 35 -------------- Key in ??
//Field 36 -------------- record ID
//Field 37 -------------- new_record ??
//Field 38 -------------- temp_cate


/* app_status */
#define TEL_LIST		0
#define VIEW			1
#define EDIT			2
#define NOTES_VIEW		3
#define NOTES_EDIT		4

/*==================== Compare two Strings ===========================*/
#define FIRST				0
#define SECOND				1
#define SAME				2

/*==================== Scrollbar Movement ===========================*/
#define MOVE_DOWNWARD		0
#define MOVE_UPWARD			1

/*==================== Menu Item ===========================*/
#define MENU_ITEM_COPY			0
#define MENU_ITEM_CUT			1
#define MENU_ITEM_PASTE			2
#define MENU_ITEM_UNDO			3
#define MENU_ITEM_ZOOM			4
#define MENU_ITEM_SHOW			5
#define MENU_ITEM_FONT			0
#define MENU_ITEM_FIND			1
#define MENU_ITEM_SORT			2

/*==================== App Status ===========================*/
typedef struct _AppStatus
{
	BYTE status;
	BOOLEAN company;	/*whether the company section is opened*/
	BOOLEAN home;		/*whether the home section is opened */
	RecordID rec_id;	/*the rec_id if the data is passed from
						  database to field objects */
	BOOLEAN new_record;
}AppStatus;

#define SetStatus(p1, p2, p3, p4 , p5) { app_status.status = p1;\
												     app_status.company = p2;\
											         app_status.home = p3; \
											         app_status.rec_id = p4; \
													 app_status.new_record = p5;}	
extern AppStatus app_status;

typedef struct _Scroll
{
	WORD value;
	WORD max_value;
	WORD min_value;
	WORD pagesize;
	WORD total_num_lines;
}Scroll;

#define SetScroll(p1, p2, p3, p4, p5) { virtual_scrollbar.value = p1;\
									    virtual_scrollbar.max_value = p2;\
										virtual_scrollbar.min_value = p3; \
										virtual_scrollbar.pagesize = p4; \
										virtual_scrollbar.total_num_lines = p5;}
extern Scroll virtual_scrollbar;

/*****************************************************************
********************** OBJECT ID Defines **************************
*****************************************************************/
#define BITMAP_X			            24

//==================== FORM_TEL_LIST ===================================
#define FORM_TEL_LIST                   0
#define POPUP_TRIGGER_CATE              1
#define PUSHBUTTON_ABC                  2
#define PUSHBUTTON_DEF                  3
#define PUSHBUTTON_GHI                  4
#define PUSHBUTTON_JKL                  5
#define PUSHBUTTON_MNO                  6
#define PUSHBUTTON_PQR                  7
#define PUSHBUTTON_STU                  8
#define PUSHBUTTON_VWX                  9
#define PUSHBUTTON_YZ                   10
#define LIST_NAME                       11
#define LIST_PHONENUM                   12
#define SCROLLBAR_TEL_LIST              13
#define BUTTON_NEW_RECORD               14
#define BUTTON_TEL_LIST_FIND            15
#define BUTTON_TEL_LIST_ZOOMIN          16

#define TEXTBOX_LOOKUP					133
#define STRING_LOOKUP					134
#define BITMAP_PAGE_UP					135
#define BITMAP_PAGE_DN					136
#define BUTTON_LETTER_BAR				137
#define PUSHBUTTON_LF					153
#define PUSHBUTTON_FL					154
#define PUSHBUTTON_CL					172

//==================== FORM_EDIT_CATE ===================================
#define FORM_EDIT_CATE                  17
#define LIST_CATE                       18
#define SCROLLBAR_CATE                  19
#define BUTTON_CATE_NEW                 20
#define BUTTON_CATE_DEL                 21
#define BUTTON_CATE_RENAME              22
#define STRING_EDIT_CATE				51
#define BUTTON_CATE_ZOOMIN              121

//==================== FORM_INPUT_CATE ===================================
#define FORM_INPUT_CATE                 23
//#define BITMAP_INPUT_CATE_X             24
#define STRING_INPUT_CATE               25
#define TEXTBOX_INPUT_CATE              26

//==================== FORM_NO_CATE ======================================
#define FORM_NO_CATE                    27
//#define BITMAP_NO_CATE_X                28
#define STRING_NO_CATE                  29


//==================== FORM_CATE_NAME_EXISTS =============================
#define FORM_CATE_NAME_EXISTS           30
//#define BITMAP_CATE_NAME_EXISTS_X       31
#define STRING_CATE_NAME_EXISTS_0       32
#define STRING_CATE_NAME_EXISTS_1       33
#define STRING_CATE_NAME_EXISTS_2       34

//==================== FORM_ERASE_CATE =============================
#define FORM_ERASE_CATE                 35
#define STRING_ERASE_CATE               36
#define BUTTON_ERASE_CATE_YES           37
#define BUTTON_ERASE_CATE_NO            38

//==================== FORM_REMOVE_CATE =============================
#define FORM_REMOVE_CATE                39
#define STRING_REMOVE_CATE_0            40
#define STRING_REMOVE_CATE_1            41
#define STRING_REMOVE_CATE_2            42
#define STRING_REMOVE_CATE_3            43
#define BUTTON_REMOVE_CATE_YES          44
#define BUTTON_REMOVE_CATE_NO           45

//==================== FORM_CATE_FULL =============================
#define FORM_CATE_FULL           46
//#define BITMAP_CATE_FULL_X       47
#define STRING_CATE_FULL_0       48
#define STRING_CATE_FULL_1       49
#define STRING_CATE_FULL_2       50

//==================== FORM_FIND_BACKGROUND =============================
#define FORM_FIND_BACKGROUND	 52
#define STRING_FIND_IND			 53

//==================== FORM_FIND_INPUT =============================
#define FORM_FIND_INPUT				54
//#define BITMAP_FIND_INPUT_X			55
#define TEXTBOX_FIND_INPUT			56

//==================== FORM_NOT_FOUND =============================
#define FORM_NOT_FOUND				57
//#define BITMAP_NOT_FOUND_X			58
#define STRING_NOT_FOUND			59

//==================== FORM_FIND_RESULT =============================
#define FORM_FIND_RESULT			60
//#define BITMAP_FIND_RESULT			61
#define STRING_FIND_RESULT			62
#define LIST_FIND_RESULT_NAME		63
#define LIST_FIND_RESULT_PHONE		64
#define SCROLLBAR_FIND_RESULT		65
#define BUTTON_FIND_RESULT_NEW		66
#define BUTTON_FIND_RESULT_ZOOMIN   122

//==================== FORM_VIEW_EDIT =============================
#define FORM_VIEW_EDIT				67
//#define STRING_NAME					68
//#define STRING_LAST_NAME			69
//#define STRING_FIRST_NAME			70
//#define TEXTBOX_FIRST_NAME			71
//#define TEXTBOX_LAST_NAME			72
//#define BITMAP_LINE					73
#define PUSHBUTTON_CINFO			74
#define PUSHBUTTON_HINFO			75
#define BUTTON_VIEW_DEL				78
#define BUTTON_VIEW_ZOOMIN			79
#define FIELD_ROW0					80
#define FIELD_ROW1					81
#define FIELD_ROW2					82
#define FIELD_ROW3					83
#define FIELD_ROW4					84
#define FIELD_ROW5					85
#define FIELD_ROW6					86
#define FIELD_ROW7					87
#define FIELD_ROW8					88
#define FIELD_ROW9					89
#define FIELD_ROW10					90
#define FIELD_ROW11					91
#define TABLE_VIEW_EDIT				92
#define STRING_ROW0					104
#define STRING_ROW1					105
#define STRING_ROW2					106
#define STRING_ROW3					107
#define STRING_ROW4					108
#define STRING_ROW5					109
#define STRING_ROW6					110
#define STRING_ROW7					111
#define STRING_ROW8					112
#define STRING_ROW9					113
#define STRING_ROW10				114
#define STRING_ROW11				115
#define BUTTON_VIEW_COMPANY			120
#define STRING_VIEW_EDIT_LARGE_NAME	126
#define STRING_VIEW_EDIT_LARGE_TITLE	127
#define STRING_VIEW_EDIT_LARGE_COMPANY	128
#define BUTTON_SHOW					138
#define BUTTON_VIEW_HOME			139
#define BUTTON_DEL_HOME_COMPANY		140
#define	POPUP_TRIGGER_OT			160
#define	POPUP_TRIGGER_DL			161
#define	POPUP_TRIGGER_OF			162
#define	POPUP_TRIGGER_HT			163
#define	POPUP_TRIGGER_HF			164
#define	POPUP_TRIGGER_HP			165
#define	POPUP_TRIGGER_HM			166
#define BITMAP_NOTES				168

//==================== FORM_ADD_ERASE =============================
#define FORM_ADD_ERASE				93
#define STRING_ADD_ERASE_0			94
#define STRING_ADD_ERASE_1			95
#define CHECKBOX_ADD_ERASE			96
#define BUTTON_ADD_ERASE_YES		97
#define BUTTON_ADD_ERASE_NO			98

//==================== FORM_SAVE_CHANGES =============================
#define FORM_SAVE_CHANGES			99
//#define BITMAP_SAVE_CHANGES			100
#define STRING_SAVE_CHANGES			101
#define BUTTON_SAVE_CHANGES_YES		102
#define BUTTON_SAVE_CHANGES_NO		103

#define MENU_POPUP					116
#define MENU_POPUP1					117
#define MENU_TEL_LIST				123
#define MENU_FIND_RESULT			124
#define MENU_EDIT_CATE				125

#define SCROLLBAR_VIEW_EDIT			118
#define STRING_VIEW_EDIT_CATE		119

//==================== FORM_PB_LOW_MEMORY =============================
#define FORM_PB_LOW_MEMORY			129
//#define BITMAP_PB_LOW_MEMORY		130
#define STRING_PB_LOW_MEMORY_0		131
#define STRING_PB_LOW_MEMORY_1		132


//==================== FORM_PB_DISCARD_CHANGES =============================
#define FORM_PB_DISCARD_CHANGES 	    141
#define STRING_PB_DISCARD_CHANGES_0	    142
#define STRING_PB_DISCARD_CHANGES_1	    143
#define STRING_PB_DISCARD_CHANGES_2	    144
#define BUTTON_PB_DISCARD_CHANGES_YES   145
#define BUTTON_PB_DISCARD_CHANGES_NO    146
//#define BITMAP_PB_DISCARD_CHANGES       147

//==================== FORM_ALERT =============================
#define FORM_ALERT				 	    148
#define STRING_ALERT_0				    149
#define STRING_ALERT_1					150
#define BUTTON_ALERT				    151
//#define BITMAP_ALERT					152

//==================== FORM_SORT =============================
#define FORM_SORT				 	    155
#define POPUP_TRIGGER_SHOW			    156
#define STRING_R_COL				    157
#define POPUP_TRIGGER_SORT			    158
#define STRING_L_COL					159

//==================== FORM_SORT =============================
#define FORM_SHOW				 	    167

//==================== FORM_NOTES =============================
#define FORM_NOTES				 	    169
#define FIELD_NOTES				 	    170
#define SCROLLBAR_NOTES			 	    171

#endif
