/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   appfunc.h
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#ifndef __APPFUNC_H_
#define __APPFUNC_H_

//#include "app.h"

/*==========================================================
================= Application Event Handler ================
===========================================================*/
BOOLEAN PhonebookTelList(EvtType *Event);
BOOLEAN PhonebookEditCate(EvtType* Event);
BOOLEAN PhonebookInputCate(EvtType *Event);
BOOLEAN PhonebookNoCate(EvtType *Event);
BOOLEAN PhonebookNameExists(EvtType *Event);
BOOLEAN PhonebookEraseCate(EvtType *Event);
BOOLEAN PhonebookRemoveCate(EvtType *Event);
BOOLEAN PhonebookCateFull(EvtType *Event);
BOOLEAN PhonebookFindBackground(EvtType *Event);
BOOLEAN PhonebookFindInput(EvtType *Event);
BOOLEAN PhonebookNotFound(EvtType *Event);
BOOLEAN PhonebookFindResult(EvtType *Event);
BOOLEAN PhonebookViewEdit(EvtType *Event);
BOOLEAN PhonebookSaveChanges(EvtType *Event);
BOOLEAN PhonebookAddErase(EvtType *Event);
BOOLEAN PhonebookLowMemoryHandle(EvtType *Event);
BOOLEAN PhonebookDiscardChangesHandle(EvtType *Event);
BOOLEAN PhonebookAlertEventHandler(EvtType *Event);
BOOLEAN PhonebookSortEventHandler(EvtType *Event);
BOOLEAN PhonebookShowEventHandler(EvtType *Event);
BOOLEAN PhonebookNotesEventHandler(EvtType *Event);

void EventLoop(void);
/*==========================================================
================= Environment Setup Function ===============
===========================================================*/
void PhonebookDatabaseInit();
BYTE ** PhonebookDataSorting(BYTE ** input_data, UWORD num_data);
BYTE PhonebookCompareTwoStrings(BYTE *string1, BYTE *string2);
BOOLEAN PhonebookCateNameToNum(DatabaseID dbid, BYTE *cate_name, UBYTE *cate_num);
BOOLEAN PhonebookRecordToList(DatabaseID dbid, BYTE *cate_name, BYTE starting_char, BYTE *starting_string);
BOOLEAN PhonebookGetRecNumWithCateName(DatabaseID dbid, BYTE *cate_name,
									   UWORD rec_num[], UWORD *num_rec);
BOOLEAN PhonebookGetRecNumWithCateNameEx(DatabaseID dbid, BYTE *cate_name,
									   UWORD rec_num[], UWORD *num_rec);
BOOLEAN PhonebookSearchForText(BYTE *short_string, BYTE *whole_string);
void PhonebookUpperString(BYTE *in_string, BYTE **out_string);
/*==========================================================
================= Input Cate Functions =====================
===========================================================*/
BOOLEAN InputCatCheckCharIn();
/*==========================================================
================= Edit Categories Functions ================
===========================================================*/
BOOLEAN DeleteCateCheck(SHORT selected_item);
BOOLEAN DeleteCate(SHORT selected_item);
BOOLEAN PhonebookEditCateSetScrollbar();
void PhonebookScrollbarSetEditCate(EvtType *Event);
/*==========================================================
================= TEL LIST Functions =======================
===========================================================*/
BOOLEAN PhonebookPopupCateActions(SHORT selected_item);
void PhonebookCateNameToPopupTrigger(DatabaseID dbid);
BOOLEAN PhonebookSetTelListTopItemNum(BYTE start_char, UWORD nth_record, BOOLEAN preset);
BOOLEAN PhonebookTelListSetScrollbar();
void PhonebookScrollbarSetTelList(EvtType *Event);
void PhonebookStartCharSetTab(BYTE in_char);

void PhonebookChangeListFont(void);
void PhonebookChangeFontSize(ObjectID form_id, BYTE required_font_size);
void DisplayScrollbarIfNeeded();

/*==========================================================
================= Find Input Functions =====================
===========================================================*/
BOOLEAN InputFindCharInCheck();

/*==========================================================
================= Find Result Functions =====================
===========================================================*/
BOOLEAN PhonebookScrollbarSetFindResult(EvtType *Event);

/*==========================================================
================= View Edit Functions =====================
===========================================================*/
void PhonebookViewEditSetupScreen();
void PhonebookRedrawWithKeyboard();
void PhonebookClearFieldBuffers();
void PhonebookFieldToFieldBuffer();
BOOLEAN PhonebookChangeFieldSize(ObjectID field_id, ObjectID table_id, ObjectID scroll_id);
BOOLEAN PhonebookSaveRecord(DatabaseID pb_dbid, RecordID rec_id, BOOLEAN new_record);
void PhonebookFieldBuffersToField();
BOOLEAN PhonebookRecordToFieldBuffers(RecordID rec_id);
void PhonebookInitFieldBuffers();
void PhonebookCombineFirstLastName(BYTE *in_string1, BYTE *in_string2);
BOOLEAN PhonebookSwitchInfoInit(ObjectID table_id);
BOOLEAN PhonebookViewEditChangeFont();
BOOLEAN PhonebookGetTableNumLines(ObjectID table_id, USHORT ref_col, WORD *total_num_lines);
BOOLEAN PhonebookGetTableMaxNumLines(ObjectID table_id, BYTE font_id, WORD *max_num_lines);
WORD PhonebookGetScrollbarMaxValue(ObjectID table_id, USHORT ref_col);
BOOLEAN PhonebookDecideTopRowNum(ObjectID table_id, ObjectID active_id);
BOOLEAN PhonebookSetViewEditTable(ObjectID form_id, ObjectID table_id);
BOOLEAN PhonebookKeyInChangeViewEditTable(ObjectID form_id, ObjectID table_id, ObjectID scrollbar_id);
BOOLEAN PhonebookViewEditTableSetScrollbar(ObjectID table_id, ObjectID scrollbar_id);
BOOLEAN PhonebookScrollbarSetViewEditTable(ObjectID table_id, ObjectID scrollbar_id, EvtType *Event);
BOOLEAN PhonebookViewEditCheckEmptyFields();
void PhonebookPrepareFirstLastName(BYTE *in_string1, BYTE *in_string2, BYTE *out_string);
void PhonebookPrepareLastFirstName(BYTE *in_string1, BYTE *in_string2, BYTE *out_string);
void PhonebookPrepareLastFirstNameForDisplay(BYTE *in_string1, BYTE *in_string2, BYTE *out_string);
void PhonebookPrepareLastFirstNameForDisplay1(BYTE *in_string1, BYTE *in_string2, BYTE *out_string);
void PhonebookPrepareChangeInfo();
void PhonebookChangeViewInfo();
void PhonebookGotoEditMode();
/*==========================================================
================= Application Save and Restore Functions =====================
===========================================================*/
void PhonebookAppSave();
void PhonebookAppRestore(BOOLEAN restart);
void PhonebookDatabaseChecking();
void PhonebookGlobalFindReentranceRestore();
void PhonebookGotoItem(DatabaseID dbid, RecordID rec_id, USHORT field_num, BYTE *search_string);
void PhonebookGetMappedRowNum(SHORT *array);


/*==========================================================
================= Menu Item Functions =====================
===========================================================*/
void MenuItemSelectedAction(USHORT item_num);
void MenuItemSelectedAction1(USHORT item_num);

/*==========================================================
================= Application Launch Functions =====================
===========================================================*/
BOOLEAN PhonebookAppLaunch(WORD cmd, void *cmd_ptr);
void PhonebookPrepareFindText(DatabaseID dbid, RecordID rec_id, BYTE **prepare_string);
#endif
