#ifndef __LISTDIS_H_
#define __LISTDIS_H_

typedef struct _RecordIDBlock
{
	BYTE num_records;
	RecordID record_id[20];
	struct _RecordIDBlock *next;
} RecordIDBlock;


typedef struct _ListDisplay
{
	ObjectID list_id;
	DatabaseID dbid;
	USHORT max_num_items_display;
	USHORT num_items_display;
	USHORT total_num_items;
	USHORT top_item_num;
	RecordIDBlock *record_id_block;
} ListDisplay;



/*==========================================================
================= List Display Functions =====================
===========================================================*/
void ListDisplaySetNumItemsDisplay(ListDisplay *list_display, USHORT num_items);
void ListDisplaySetTotalNumItems(ListDisplay *list_display, USHORT num_items);
void ListDisplaySetTopItemNum(ListDisplay *list_display, USHORT item_num);
void ListDisplayInsertRecordID(ListDisplay *list_display, RecordID record_id);
BOOLEAN ListDisplayDeleteAllRecordID(ListDisplay *list_display);
BOOLEAN ListDisplayDraw(ListDisplay *list_display);
BOOLEAN ListDisplayGetText(ListDisplay *list_display, USHORT item_num, BYTE **text);
BOOLEAN ListDisplayGetRecordID(ListDisplay *list_display, USHORT item_num, RecordID *rec_id);
#endif
