/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   listdis.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              

#include "app.h"
#include "appfunc.h"

/********************************************************
* Function:	ListDisplaySetNumItemsDisplay
* Purpose: 	This function is called in order to set the value of 
num of items on display of a list object
* Scope:		application
* Input:		list_display	list_display structure
num_items		number of items on the display of a list object
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void ListDisplaySetNumItemsDisplay(ListDisplay *list_display, USHORT num_items)
{
	list_display->num_items_display = num_items;
}

/********************************************************
* Function:	ListDisplaySetTotalNumItems
* Purpose: 	This function is called in order to set the value of 
total number of items
* Scope:		application
* Input:		list_display	list_display structure
num_items		total number of items
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void ListDisplaySetTotalNumItems(ListDisplay *list_display, USHORT num_items)
{
	list_display->total_num_items = num_items;
	
}

/********************************************************
* Function:	ListDisplaySetTopItemNum
* Purpose: 	This function is called in order to set 
the top item number of a list object
* Scope:		application
* Input:		list_display	list_display structure
item_num		the top item number
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void ListDisplaySetTopItemNum(ListDisplay *list_display, USHORT item_num)
{
	list_display->top_item_num = item_num;
}


/********************************************************
* Function:	ListDisplayInsertRecordID
* Purpose: 	This function is called in order to insert a record ID	
* Scope:		application
* Input:		list_display	list_display structure
record_id		record_id being inserted
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void ListDisplayInsertRecordID(ListDisplay *list_display, RecordID record_id)
{
	USHORT i;
	BOOLEAN create = FALSE;
	RecordIDBlock *temp;
	
	
	if (list_display->record_id_block == NULL)
	{
		list_display->record_id_block = (RecordIDBlock*)qmalloc(sizeof(RecordIDBlock));
		temp = list_display->record_id_block;
		create = TRUE;
	}
	else
	{
		temp = list_display->record_id_block;
		while (temp != NULL)
		{
			if (temp->num_records != 20)
				break;
			if (temp->next == NULL)
			{	
				create = TRUE;
				temp ->next = (RecordIDBlock*)qmalloc(sizeof(RecordIDBlock));
				temp = temp->next;
				break;
			}
			else 
				temp = temp->next;
		}
	}
	
	if (create == TRUE)
	{
		temp->next = NULL;
		temp->num_records = 0;
		for (i = 0; i<20; i++)
			temp->record_id[i] = 0;
	}
	
	temp->num_records ++;
	list_display->total_num_items ++;
	temp->record_id[temp->num_records - 1] = record_id;		
}



/********************************************************
* Function:	ListDisplayDelete
* Purpose: 	This function is called in order to insert a record ID	
* Scope:		application
* Input:		list_display	list_display structure
record_id		record_id being inserted
* Output:		None
* Return:		TRUE    handled
FALSE   not-handled
* Comment: 	None
*********************************************************/
BOOLEAN ListDisplayDeleteAllRecordID(ListDisplay *list_display)
{
	RecordIDBlock *temp = list_display->record_id_block;
	RecordIDBlock *temp1 = NULL;
	
	if (temp != NULL)
	{
		temp1 = temp->next;
		if (temp1 == NULL)
		{
			qfree(temp);
			list_display->max_num_items_display = 10;
			list_display->num_items_display = 0;
			list_display->total_num_items = 0;
			list_display->top_item_num = 0;
			list_display->record_id_block = NULL;
			return TRUE;
		}
		while (temp1 != NULL)
		{
			qfree(temp);
			temp = temp1;
			temp1 = temp->next;
		}
		if (temp1 == NULL)
			qfree(temp);
	}
	list_display->max_num_items_display = 10;
	list_display->num_items_display = 0;
	list_display->total_num_items = 0;
	list_display->top_item_num = 0;
	list_display->record_id_block = NULL;
	return TRUE;
}

BYTE GetDefaultRecord(BYTE bVal, BYTE* buffer)
{
	BYTE show_rec = bVal;
	
	switch(bVal)
	{
	case 10:  //home mobil show_rec = 3
	case 9:  //home pager show_rec = 2
		show_rec--;
	case 7:  //home fax show_rec = 1
	case 6:  //home tel show_rec = 0
		show_rec -=6;
		if(buffer[3]==show_rec)
			show_rec = 15;
		else if(buffer[4]==show_rec)
			show_rec = 16;
		else if(buffer[5]==show_rec)
			show_rec = 23;
		else if(buffer[6]==show_rec)
			show_rec = 24;
		else
			show_rec = -1;
		break;
	case 5:  //office mobile show_rec = 4
	case 4:  //office pager show_rec = 3
		show_rec--;
	case 2:  //office fax show_rec = 2
	case 1:  //direct line show_rec = 1
	case 0:  //office tel show_rec = 0
		if(buffer[0]==show_rec)
			show_rec = 5;
		else if(buffer[1]==show_rec)
			show_rec = 6;
		else if(buffer[2]==show_rec)
			show_rec = 7;
		else
			show_rec = -1;
		break;
	case 3:  //office e-mail
		show_rec = 8;
		break;
	case 8:  //home email
		show_rec = 22;	
		break;
	}
	return show_rec;
}

BYTE CheckData(BYTE show_rec, BYTE show_type, DatabaseID db_id, RecordID rec_id, BYTE* index)
{
	UWORD byte_read;
	BYTE *buffer;
	UWORD len;
	
	switch(show_rec)
	{
	case 5:  //so index[0]==show_type
		DataGetField(db_id, rec_id, 5, &buffer, &byte_read);
		len = strlen(buffer);
		qfree(buffer);
		if(len!=0)
			return 5;
	case 6:
		if(index[1]==show_type)
		{
			DataGetField(db_id, rec_id, 6, &buffer, &byte_read);
			len = strlen(buffer);
			qfree(buffer);
			if(len!=0)
				return 6;
		}
	case 7:
		if(index[2]==show_type)
		{
			DataGetField(db_id, rec_id, 7, &buffer, &byte_read);
			len = strlen(buffer);
			qfree(buffer);
			if(len!=0)
				return 7;
		}
		break;
	case 15:
		DataGetField(db_id, rec_id, 15, &buffer, &byte_read);
		len = strlen(buffer);
		qfree(buffer);
		if(len!=0)
			return 15;
	case 16:
		if(index[4]==show_type)
		{
			DataGetField(db_id, rec_id, 16, &buffer, &byte_read);
			len = strlen(buffer);
			qfree(buffer);
			if(len!=0)
				return 16;
		}
	case 23:
		if(index[5]==show_type)
		{
			DataGetField(db_id, rec_id, 23, &buffer, &byte_read);
			len = strlen(buffer);
			qfree(buffer);
			if(len!=0)
				return 23;
		}
	case 24:
		if(index[6]==show_type)
		{
			DataGetField(db_id, rec_id, 24, &buffer, &byte_read);
			len = strlen(buffer);
			qfree(buffer);
			if(len!=0)
				return 24;
		}
		break;
	default:
		return -1;
	}
	return -1;
}

/********************************************************
* Function:	ListDisplayDraw
* Purpose: 	This function is called to draw the content of
in the list_display to a list object
* Scope:		application
* Input:		list_display	list-display structure
dbid			DatabaseID
* Output:		None
* Return:		TRUE    handled
FALSE   not-handled
* Comment: 	None
*********************************************************/
BOOLEAN ListDisplayDraw(ListDisplay *list_display)
{
	ObjectID list_id, list_id1;
	USHORT list_total_num_items;
	USHORT list_max_num_items;
	USHORT total_num_items;
	USHORT top_item_num;
	USHORT count = 0, i = 0;
	RecordIDBlock *temp = list_display->record_id_block;
	RecordID rec_id;
	UWORD rec_num;
	UWORD byte_read;
	BYTE *buffer,*buffer1,*buffer2;
	SHORT num_items_to_display;
    USHORT count1 = 0;
	SHORT show_rec;
	BYTE bVal;
	ObjectBounds ob;
	
	list_id = list_display->list_id;
	if (list_id == LIST_NAME)
		list_id1 = LIST_PHONENUM;
	else if (list_id == LIST_FIND_RESULT_NAME)
		list_id1 = LIST_FIND_RESULT_PHONE;
	
	ListRecalculateMaxNumItemsDisplay(list_id);
	ListGetMaxNumItemsDisplay (list_id, &list_max_num_items);
	
	list_display->max_num_items_display = list_max_num_items;
	
	total_num_items = list_display->total_num_items;
	top_item_num = list_display->top_item_num;
	
	ListGetTotalItems(list_id, &list_total_num_items);
	if (list_total_num_items != 0)
	{
		ListDeleteAllItems(list_id);
		ListDeleteAllItems(list_id1);
	}
	
	if ((top_item_num + list_max_num_items) <= total_num_items)
		list_display->num_items_display = list_max_num_items;
	else 
		list_display->num_items_display = total_num_items - top_item_num;
	
	num_items_to_display = list_display->num_items_display;
	
	while (temp != NULL && num_items_to_display > 0)
	{
		if ((top_item_num >= count) && (top_item_num < (count + 20)))
		{
			show_rec = show_mode;
			DataRecIDtoNum(list_display->dbid, temp->record_id[top_item_num - count], &rec_num);
			DataOpenRecord(list_display->dbid, rec_num, &rec_id, NULL);
			DataGetField(list_display->dbid, rec_id, sort_mode, &buffer, &byte_read);
			//if sort_mode = company, last
			if(sort_mode==29)
			{
				ListGetListBounds(list_id, &ob);
				if(StrGetWidth(buffer, font_size) > ob.width)
				{
					buffer1 = strchr(buffer,',');
					if(buffer1)
					{
						buffer2 = qmalloc((strlen(buffer1) + 1)*sizeof(BYTE));
						strcpy(buffer2,buffer1);
						ob.width *= .667;  //company takes 2/3 of display
						StrChopString(&ob, buffer, font_size,TRUE,0);
						strcat(buffer,buffer2);
					}
				}
			}
			ListInsertItem(list_id, count1, buffer);
			qfree(buffer);
			
			DataGetField(list_display->dbid, rec_id, 27, &buffer, &byte_read);
			switch(show_mode)
			{
			case 0:  //default
				DataGetField(list_display->dbid, rec_id, 28, &buffer1, &byte_read);
				bVal = *(BYTE*)buffer1;
				qfree(buffer1);
				show_rec = GetDefaultRecord(bVal,buffer);
				break;
			case 11:  //home mobil show_rec = 3
			case 10:  //home pager show_rec = 2
				show_rec--;
			case 8:  //home fax show_rec = 1
			case 7:  //home tel show_rec = 0
				show_rec -=7;
				if(buffer[3]==show_rec)
					show_rec = CheckData(15,show_rec,list_display->dbid,rec_id,buffer);
				else if(buffer[4]==show_rec)
					show_rec = CheckData(16,show_rec,list_display->dbid,rec_id,buffer);
				else if(buffer[5]==show_rec)
					show_rec = CheckData(23,show_rec,list_display->dbid,rec_id,buffer);
				else if(buffer[6]==show_rec)
					show_rec = 24;
				else
				{	
					show_rec = -1;
					//							//show default
					//							DataGetField(list_display->dbid, rec_id, 28, &buffer1, &byte_read);
					//							bVal = *(BYTE*)buffer1;
					//							qfree(buffer1);
					//							show_rec = GetDefaultRecord(bVal,buffer);
				}
				break;
			case 6:  //office mobile show_rec = 4
			case 5:  //office pager show_rec = 3
				show_rec--;
			case 3:  //office fax show_rec = 2
			case 2:  //direct line show_rec = 1
			case 1:  //office tel show_rec = 0
				show_rec--;
				if(buffer[0]==show_rec)
					show_rec = CheckData(5,show_rec,list_display->dbid,rec_id,buffer);
				else if(buffer[1]==show_rec)
					show_rec = CheckData(6,show_rec,list_display->dbid,rec_id,buffer);
				else if(buffer[2]==show_rec)
					show_rec = 7;
				else
				{
					show_rec = -1;
					//							//show default
					//							DataGetField(list_display->dbid, rec_id, 28, &buffer1, &byte_read);
					//							bVal = *(BYTE*)buffer1;
					//							qfree(buffer1);
					//							show_rec = GetDefaultRecord(bVal,buffer);
				}
				break;
			case 4:  //office e-mail
				show_rec = 8;
				break;
			case 9:  //home email
				show_rec = 22;	
				break;
			}
			qfree(buffer);
			if(show_rec!=-1)
			{
				DataGetField(list_display->dbid, rec_id, show_rec, &buffer, &byte_read);
				ListInsertItem(list_id1, count1, buffer);
				qfree(buffer);
			}
			else
			{
				ListInsertItem(list_id1, count1, (BYTE*)" ");
			}
			count1 ++;
			num_items_to_display --;
			top_item_num ++;
			DataCloseRecord(list_display->dbid, rec_id);
		}
		else
		{
			count += 20;
			temp = temp->next;
		}
	}
	ListSetTopItemNum(list_id, 0);
	ListSetTopItemNum(list_id1, 0);
	ListSetNumItemsDisplay (list_id, list_display->num_items_display);
	ListSetNumItemsDisplay (list_id1, list_display->num_items_display);
	return TRUE;
}

/********************************************************
* Function:	ListDisplayGetText
* Purpose: 	This function is called to get the text of LIST_NAME or 
LIST_FIND_RESULT_NAME
* Scope:		application
* Input:		list_display	list-display structure
item_num		item number
* Output:		text			Pointer reference to text
* Return:		TRUE    handled
FALSE   not-handled
* Comment: 	None
*********************************************************/
BOOLEAN ListDisplayGetText(ListDisplay *list_display, USHORT item_num, BYTE **text)
{
	RecordIDBlock *temp = list_display->record_id_block;
	USHORT count = 0;
	UWORD rec_num;
	RecordID rec_id;
	BYTE *buffer;
	UWORD byte_read;
	
	if ((item_num >= list_display->total_num_items)||(list_display->record_id_block == NULL)) 
		return FALSE;
	
	while (temp != NULL)
	{
		if ((item_num >= count) && (item_num < (count + 20)))
		{
			DataRecIDtoNum(list_display->dbid, temp->record_id[item_num - count], &rec_num);
			DataOpenRecord(list_display->dbid, rec_num, &rec_id, NULL);
			DataGetField(list_display->dbid, rec_id, sort_mode, &buffer, &byte_read);
			*text = buffer;
			DataCloseRecord(list_display->dbid, rec_id);
			return TRUE;
		}
		else
		{
			count += 20;
			temp = temp->next;
		}
	}
	return FALSE;
}

/********************************************************
* Function:	ListDisplayGetRecordID
* Purpose: 	This function is called in order to get the record ID 
of a particular list item in teh list object
* Scope:		application
* Input:		list_display	list-display structure
item_num		item number
* Output:		rec_id			Pointer to record ID of the list object
* Return:		TRUE    handled
FALSE   not-handled
* Comment: 	None
*********************************************************/
BOOLEAN ListDisplayGetRecordID(ListDisplay *list_display, USHORT item_num, RecordID *rec_id)
{
	
	RecordIDBlock *temp = list_display->record_id_block;
	USHORT count = 0;
	
	if ((item_num >= list_display->total_num_items)||(list_display->record_id_block == NULL)) 
		return FALSE;
	while (temp != NULL)
	{
		if ((item_num >= count) && (item_num < (count + 20)))
		{
			*rec_id = temp->record_id[item_num-count];
			return TRUE;
		}
		else
		{
			count += 20;
			temp = temp->next;
		}
	}
	return FALSE;
}
