/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   tellist.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "app.h"

/********************************************************
* Function:	DisplayScrollbarIfNeeded
* Purpose: 	This function is called in order to determine whether or not
to draw scrollbar on screen
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void DisplayScrollbarIfNeeded()
{
    BYTE        object_type;
	List		*list_ptr;
	
	FormGetObjectPointer(LIST_NAME, &object_type, (void**)&list_ptr);
	list_tel_list.max_num_items_display = list_ptr->list_max_num_items_on_display;
	
    if (list_tel_list.total_num_items > list_ptr->list_max_num_items_on_display)
    {
        if (list_tel_list.top_item_num > (list_tel_list.total_num_items - list_ptr->list_max_num_items_on_display))
            list_tel_list.num_items_display = (list_tel_list.total_num_items - list_tel_list.top_item_num);
        else 
			list_tel_list.num_items_display = list_ptr->list_max_num_items_on_display;
    }
    else if (list_tel_list.total_num_items == list_ptr->list_max_num_items_on_display)
        list_tel_list.num_items_display = list_ptr->list_max_num_items_on_display;
    else 
		list_tel_list.num_items_display = list_tel_list.total_num_items;
	
	PhonebookTelListSetScrollbar();
}

/********************************************************
* Function:	PhonebookChangePopupCate
* Purpose: 	This function is called in order to take actions when the 
popup trigger of categories is changed
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE			success
FALSE			error occure
* Comment: 	None
*********************************************************/
BOOLEAN PhonebookPopupCateActions(SHORT selected_item)
{
	USHORT popup_total_num_items;
	UBYTE cate[256], num_cate;
	SHORT i = 0;
	BYTE *cate_name;
	BYTE *item_text;
	
	ControlPopupGetTotalItems(POPUP_TRIGGER_CATE, &popup_total_num_items);
	
	if (popup_total_num_items == ((USHORT)selected_item + 1))
	{		
		ListInitList(LIST_CATE);
		num_cate = DataCategorySort(pb_dbid,cate);
		ListDeleteAllItems(LIST_CATE);
		cate_name = (BYTE*)qmalloc(30*sizeof(BYTE));
		for (i = 0; i < num_cate; i++)
		{
			DataCategoryName(pb_dbid,cate[i],cate_name);
			ListInsertItem(LIST_CATE,i,cate_name);
		}
		qfree(cate_name);
		ScrollbarInitScrollbar(SCROLLBAR_CATE);
		PhonebookEditCateSetScrollbar();
        MenuInitMenu(MENU_EDIT_CATE);
        PhonebookChangeFontSize(FORM_EDIT_CATE, font_size);
		FormPopupForm(FORM_EDIT_CATE);		
		return TRUE;
	}
	else
	{	
		ControlPopupGetPopupItem(POPUP_TRIGGER_CATE, (USHORT)selected_item, &item_text);
		strcpy(current_cate, item_text);
		PhonebookRecordToList(pb_dbid, item_text, PBCHARA, NULL);
		char_start = PBCHARA;
		FormSetControlGroupSelection(FORM_TEL_LIST,PUSHBUTTON_ABC);		
		ListDrawList(LIST_NAME);
		ListDrawList(LIST_PHONENUM);
		return TRUE;
	}
	return FALSE;
}

/********************************************************
* Function:	PhonebookTelListSetScrollbar
* Purpose: 	This function is called in order to set the values for a scrollbar		
* Scope:		application
* Input:		BYTE				the starting_char
* Output:		None
* Return:		TRUE		scrollbar is erased
FALSE		scrollbar is drawn
* Comment: 	If a scrollbar is not required, then the scrollbar will be erased 
If a scrollbar is required, the scrollbar will be displayed accordingly 
*********************************************************/
BOOLEAN PhonebookTelListSetScrollbar()
{
	USHORT total_num_items;
	USHORT max_num_items_display;
	USHORT top_item_num;
	USHORT current_num_items_display;
	WORD max_value, min_value, pagesize, total_num_lines;
	BYTE object_type;
	Scrollbar *scroll_ptr;
	
	
	FormGetObjectPointer(SCROLLBAR_TEL_LIST, &object_type, (void**)&scroll_ptr);
	
	max_num_items_display = list_tel_list.max_num_items_display;
	total_num_items = list_tel_list.total_num_items;
	top_item_num = list_tel_list.top_item_num;
	current_num_items_display = list_tel_list.num_items_display;
	
	
	total_num_lines = total_num_items;
	min_value = 0;
	
	if (top_item_num == 65535)
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_TEL_LIST,TRUE);
		pagesize = 1;
		max_value = total_num_lines - pagesize;
		top_item_num = max_value;
		scroll_ptr->scrollbar_draw_pagesize = pagesize;
	}
	else if (top_item_num > 0 && total_num_items <= max_num_items_display)
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_TEL_LIST,TRUE);
		pagesize = total_num_items - top_item_num;
		max_value = total_num_lines - pagesize;
		scroll_ptr->scrollbar_draw_pagesize = pagesize;
	}
	else if (total_num_items > max_num_items_display)
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_TEL_LIST,TRUE);
		pagesize = max_num_items_display;
		max_value = total_num_lines - pagesize;	
		scroll_ptr->scrollbar_draw_pagesize = max_num_items_display;
	}
	else
	{
		ScrollbarSetScrollbarVisible(SCROLLBAR_TEL_LIST,FALSE);
        if (draw_scrollbar)
            ScrollbarEraseScrollbar(SCROLLBAR_TEL_LIST);
		return FALSE;
	}
	
	if (top_item_num > (total_num_items - max_num_items_display) && total_num_items >= max_num_items_display)
	{	
		pagesize = total_num_lines - top_item_num;	
		scroll_ptr->scrollbar_draw_pagesize = max_num_items_display;
		max_value = total_num_items - pagesize;
		ScrollbarSetScrollbar(SCROLLBAR_TEL_LIST, max_value, max_value, min_value,
			pagesize, total_num_lines);
	}
	else
	{
		ScrollbarSetScrollbar(SCROLLBAR_TEL_LIST, top_item_num, max_value, min_value,
			pagesize, total_num_lines);
	}
    if (draw_scrollbar)
        ScrollbarDrawScrollbar(SCROLLBAR_TEL_LIST);
	return TRUE;         
}

/********************************************************
* Function:	PhonebookScrollbarSetTelList
* Purpose: 	This function is called to set the telephone list
when the scrollbar is moved.
* Scope:		application
* Input:		Event		
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void PhonebookScrollbarSetTelList(EvtType *Event)
{
	
	WORD max,min,value,pagesize;
	WORD scroll_total_lines;
	BYTE *list_text, starting_char;
	BYTE object_type;
	Scrollbar *scroll_ptr;
	List *list_ptr, *list1_ptr;
	
	FormGetObjectPointer(SCROLLBAR_TEL_LIST, &object_type, (void**)&scroll_ptr);
	
	if (!scroll_ptr->scrollbar_attr.scrollbar_visible)
		return;
	ScrollbarGetScrollbar(SCROLLBAR_TEL_LIST, &value, &max, &min, &pagesize, &scroll_total_lines);
	FormGetObjectPointer(LIST_NAME, &object_type, (void**)&list_ptr);
	FormGetObjectPointer(LIST_PHONENUM, &object_type, (void**)&list1_ptr);
	
	if (list_tel_list.total_num_items > list_tel_list.max_num_items_display)
	{
		if ((Event->para2 - Event->para1) >= pagesize && pagesize != 1)
		{
			ScrollbarSetScrollbar(SCROLLBAR_TEL_LIST, (Event->para2 - 1), max, min, pagesize, scroll_total_lines);
			list_tel_list.top_item_num = (USHORT)(Event->para2) - 1;
		}
		else if ((Event->para1 - Event->para2) >= pagesize && pagesize != 1)
		{
			ScrollbarSetScrollbar(SCROLLBAR_TEL_LIST, (Event->para2 + 1), max, min, pagesize, scroll_total_lines);
			list_tel_list.top_item_num = (USHORT)(Event->para2) + 1;
		}
		else
		{	
			ScrollbarSetScrollbar(SCROLLBAR_TEL_LIST, Event->para2, max, min, pagesize, scroll_total_lines);
			list_tel_list.top_item_num = (USHORT)(Event->para2); 
		}	
		ScrollbarGetScrollbar(SCROLLBAR_TEL_LIST, &value, &max, &min, &pagesize, &scroll_total_lines);
		if (list_tel_list.top_item_num >(scroll_total_lines - list_tel_list.max_num_items_display))
			pagesize = scroll_total_lines - list_tel_list.top_item_num;
		else pagesize = list_tel_list.max_num_items_display;
		max = scroll_total_lines - pagesize;
		ScrollbarSetScrollbar(SCROLLBAR_TEL_LIST, value, max, min, pagesize, scroll_total_lines);
	}
	else
	{
		if (list_ptr->list_attr.list_visible == FALSE)
		{
			ScrollbarSetScrollbar(SCROLLBAR_TEL_LIST, Event->para1, max, min, scroll_ptr->scrollbar_draw_pagesize, scroll_total_lines);
			list_tel_list.top_item_num = (USHORT)(Event->para1);
		}
		else
		{	
			ScrollbarSetScrollbar(SCROLLBAR_TEL_LIST, Event->para2, max, min, scroll_ptr->scrollbar_draw_pagesize, scroll_total_lines);
			list_tel_list.top_item_num = (USHORT)(Event->para2);
		}
		//remark on 30th of July		
		//scroll_ptr->scrollbar_draw_pagesize = pagesize;
		if (list_tel_list.top_item_num == 0)
		{	
			scroll_ptr->scrollbar_attr.scrollbar_visible = FALSE;
            if (draw_scrollbar)
                ScrollbarEraseScrollbar(SCROLLBAR_TEL_LIST);
		}
		else ScrollbarDrawScrollbar(SCROLLBAR_TEL_LIST);
	}
	
	if (scroll_ptr->scrollbar_total_num_lines > list_tel_list.max_num_items_display)
		ScrollbarDrawScrollbar(SCROLLBAR_TEL_LIST);		
	
	list_ptr->list_attr.list_visible = TRUE;
	list1_ptr->list_attr.list_visible = TRUE;
	ListDisplayDraw(&list_tel_list);
	
	
    if (Event->eventType == EVT_SCROLLBAR_SELECT ||
        (Event->eventType == EVT_SCROLLBAR_REPEAT && (Event->para1 != Event->para2 || scroll_ptr->scrollbar_total_num_lines == 1)))
    {
        ListDrawList(LIST_NAME);
        ListDrawList(LIST_PHONENUM);
		
        ListDisplayGetText(&list_tel_list, list_tel_list.top_item_num, &list_text);
		
        if ((UBYTE)list_text[0] >=  'a' && (UBYTE)list_text[0] <= 'z')
            starting_char = (UBYTE)list_text[0] - 32;
        else starting_char = (UBYTE)list_text[0];
		
		PhonebookStartCharSetTab(starting_char);
		
        qfree(list_text);
    }
}

/********************************************************
* Function:    PhonebookStarCharSetTab
* Purpose: 	This function is called to set the telephone list
when the scrollbar is moved.
* Scope:		application
* Input:		Event		
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void PhonebookStartCharSetTab(BYTE in_char)
{
	BYTE object_type;
	Control *ctrl_addr;
	ObjectID ctrl_id;
	
	if (in_char == -1) //clear all
	{
		ControlGetPushedPushButton(FORM_TEL_LIST,1,&ctrl_id);
		if(ControlGetPushedPushButton(FORM_TEL_LIST,1,&ctrl_id)!=TRUE)
			return;
		if(UISearchForAddress(ctrl_id,&object_type,(void**)&ctrl_addr))
			((ControlTemplateButton *)(ctrl_addr->control_template))->control_value = FALSE;
		ControlDrawControl(ctrl_id);
	}
	else
	{
		if ((UBYTE)in_char >= 'a' && (UBYTE)in_char <= 'z')
			in_char -= 32;
		
		if ((UBYTE)in_char >= 32 && (UBYTE)in_char <= 'C')
			FormSetControlGroupSelection(FORM_TEL_LIST, PUSHBUTTON_ABC);
		else if ((UBYTE)in_char >= 'D' && (UBYTE)in_char <= 'F')
			FormSetControlGroupSelection(FORM_TEL_LIST, PUSHBUTTON_DEF);				
		else if ((UBYTE)in_char >= 'G' && (UBYTE)in_char <= 'I')
			FormSetControlGroupSelection(FORM_TEL_LIST, PUSHBUTTON_GHI);				
		else if ((UBYTE)in_char >= 'J' && (UBYTE)in_char <= 'L')
			FormSetControlGroupSelection(FORM_TEL_LIST, PUSHBUTTON_JKL);				
		else if ((UBYTE)in_char >= 'M' && (UBYTE)in_char <= 'O')
			FormSetControlGroupSelection(FORM_TEL_LIST, PUSHBUTTON_MNO);				
		else if ((UBYTE)in_char >= 'P' && (UBYTE)in_char <= 'R')
			FormSetControlGroupSelection(FORM_TEL_LIST, PUSHBUTTON_PQR);				
		else if ((UBYTE)in_char >= 'S' && (UBYTE)in_char <= 'U')
			FormSetControlGroupSelection(FORM_TEL_LIST, PUSHBUTTON_STU);				
		else if ((UBYTE)in_char >= 'V' && (UBYTE)in_char <= 'X')
			FormSetControlGroupSelection(FORM_TEL_LIST, PUSHBUTTON_VWX);				
		else if ((UBYTE)in_char >= 'Y')
			FormSetControlGroupSelection(FORM_TEL_LIST, PUSHBUTTON_YZ);
	}
}

/********************************************************
* Function:    PhonebookChangeListFont
* Purpose: 	This function is called to change the font of the list
object 
* Scope:		application
* Input:		Event		
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void PhonebookChangeListFont(void)
{
	ObjectID 		active_form_id;
	List			*list_ptr, *list_ptr1;
	Scrollbar		*scroll_ptr;
    BYTE            object_type, *list_text;
#ifdef DEBUG
	BYTE		debug_msg[80];
#endif
	
	FormGetActiveFormID(&active_form_id);
	
	switch (active_form_id)
	{
	case FORM_EDIT_CATE:
		FormGetObjectPointer(LIST_CATE, &object_type, (void**)&list_ptr);
		FormGetObjectPointer(SCROLLBAR_CATE, &object_type, (void**)&scroll_ptr);
		if (list_ptr->list_text_font == SMALL_FONT)
		{
			font_size = MEDIUM_FONT;
			list_ptr->list_text_font = font_size;
			list_ptr->list_max_num_items_on_display = 9;
		}
		else
		{
			font_size = SMALL_FONT;
			list_ptr->list_text_font = font_size;
			//fix list_ptr->bounds.height
			list_ptr->list_max_num_items_on_display = 11;
		}
		
		if (list_ptr->list_total_num_items > list_ptr->list_max_num_items_on_display)
		{
			scroll_ptr->scrollbar_attr.scrollbar_visible = TRUE;
			
			if (list_ptr->list_highlighted_item > 0 && list_ptr->list_highlighted_item < list_ptr->list_top_item_num)
				list_ptr->list_top_item_num = list_ptr->list_highlighted_item;
			else if (list_ptr->list_highlighted_item >= (list_ptr->list_top_item_num + list_ptr->list_max_num_items_on_display))
				list_ptr->list_top_item_num = list_ptr->list_highlighted_item;
			
			if (list_ptr->list_top_item_num >= (list_ptr->list_total_num_items - list_ptr->list_max_num_items_on_display))
				list_ptr->list_top_item_num = (list_ptr->list_total_num_items - list_ptr->list_max_num_items_on_display);           
			
			scroll_ptr->scrollbar_value 	= list_ptr->list_top_item_num;
			scroll_ptr->scrollbar_min		= 0;
			scroll_ptr->scrollbar_pagesize  = list_ptr->list_max_num_items_on_display;
			scroll_ptr->scrollbar_draw_pagesize 	= scroll_ptr->scrollbar_pagesize;
			scroll_ptr->scrollbar_max		= list_ptr->list_total_num_items - scroll_ptr->scrollbar_pagesize;
			scroll_ptr->scrollbar_total_num_lines = list_ptr->list_total_num_items;      
		}
		else
		{
			scroll_ptr->scrollbar_attr.scrollbar_visible = FALSE;
			if (draw_scrollbar)
				ScrollbarEraseScrollbar(SCROLLBAR_CATE); 
			list_ptr->list_top_item_num = 0;
		}
		
		
		if (list_ptr->list_text_font == SMALL_FONT)							
		{
			MenuDeleteItem(MENU_EDIT_CATE, 0);
			MenuInsertItem(MENU_EDIT_CATE, 0, PBLFONT);
			ControlSetLabel(BUTTON_CATE_ZOOMIN, PBLFONT);
		}
		else
		{
			ControlSetLabel(BUTTON_CATE_ZOOMIN, PBSFONT);
			MenuDeleteItem(MENU_EDIT_CATE, 0);
			MenuInsertItem(MENU_EDIT_CATE, 0, PBSFONT);
		}
		
		FormPopupForm(FORM_EDIT_CATE);
		//			ControlDrawControl(BUTTON_CATE_ZOOMIN);
		//			ListDrawList(LIST_CATE);
		//			ScrollbarDrawScrollbar(SCROLLBAR_CATE);	
	case FORM_TEL_LIST:
		FormGetObjectPointer(LIST_NAME, &object_type, (void**)&list_ptr);
		FormGetObjectPointer(LIST_PHONENUM, &object_type, (void**)&list_ptr1);
		FormGetObjectPointer(SCROLLBAR_TEL_LIST, &object_type, (void**)&scroll_ptr);
		
		if (list_ptr->list_text_font == SMALL_FONT)
		{
			font_size = MEDIUM_FONT;
			list_ptr->list_text_font = MEDIUM_FONT;
			list_ptr1->list_text_font = MEDIUM_FONT;
		}
		else
		{
			font_size = SMALL_FONT;
			list_ptr->list_text_font = SMALL_FONT;
			list_ptr1->list_text_font = SMALL_FONT;
			if(letter_bar)
			{
				//do we need to adjust gTopNum?
				if(gTopNum > (list_tel_list.total_num_items - 10))
				{
					gTopNum = (gTopNum > 2) ? gTopNum - 2 : 0;
					list_tel_list.top_item_num = gTopNum;
				}
			}
			else
			{
				//do we need to adjust gTopNum?
				if(gTopNum > (list_tel_list.total_num_items - 12))
				{
					gTopNum = (gTopNum > 2) ? gTopNum - 2 : 0;
					list_tel_list.top_item_num = gTopNum;
				}
			}
			
		}
		
		list_tel_list.max_num_items_display = list_ptr->list_max_num_items_on_display;
		
		if (list_tel_list.total_num_items > list_ptr->list_max_num_items_on_display)
		{
			if (list_tel_list.top_item_num > (list_tel_list.total_num_items - list_ptr->list_max_num_items_on_display))
				list_tel_list.num_items_display = (list_tel_list.total_num_items - list_tel_list.top_item_num);
			else 
				list_tel_list.num_items_display = list_ptr->list_max_num_items_on_display;
		}
		else if (list_tel_list.total_num_items == list_ptr->list_max_num_items_on_display)
			list_tel_list.num_items_display = list_ptr->list_max_num_items_on_display;
		else 
			list_tel_list.num_items_display = list_tel_list.total_num_items;
		
		
		ListDisplayDraw(&list_tel_list);
		
		PhonebookTelListSetScrollbar();
		
		if (list_ptr->list_attr.list_visible == TRUE)
		{                                             
			ListDisplayGetText(&list_tel_list, list_tel_list.top_item_num, &list_text);
			PhonebookStartCharSetTab(list_text[0]);
			qfree(list_text);
		}
		
		if (list_ptr->list_text_font == SMALL_FONT)
		{
			MenuDeleteItem(MENU_TEL_LIST, 0);
			MenuInsertItem(MENU_TEL_LIST, 0, PBLFONT);
			ControlSetLabel(BUTTON_TEL_LIST_ZOOMIN, PBLFONT);
		}
		else
		{
			MenuDeleteItem(MENU_TEL_LIST, 0);
			MenuInsertItem(MENU_TEL_LIST, 0, PBSFONT);
			ControlSetLabel(BUTTON_TEL_LIST_ZOOMIN, PBSFONT);
		}
		
		if(active_form_id == FORM_TEL_LIST)
		{
			ControlDrawControl(BUTTON_TEL_LIST_ZOOMIN);
			ListDrawList(LIST_NAME);
			ListDrawList(LIST_PHONENUM);
		}
		break;
	case FORM_FIND_RESULT:
		FormGetObjectPointer(LIST_FIND_RESULT_NAME, &object_type, (void**)&list_ptr);
		FormGetObjectPointer(LIST_FIND_RESULT_PHONE, &object_type, (void**)&list_ptr1);
		FormGetObjectPointer(SCROLLBAR_FIND_RESULT, &object_type, (void**)&scroll_ptr);
		if (list_ptr->list_text_font == SMALL_FONT)
		{
			font_size = MEDIUM_FONT;
			list_ptr->list_text_font = font_size;
			list_ptr1->list_text_font = font_size;
			
		}
		else
		{
			font_size = SMALL_FONT;;
			list_ptr->list_text_font = font_size;
			list_ptr1->list_text_font = font_size;
		}
		
		list_find.max_num_items_display = list_ptr->list_max_num_items_on_display;
		
		if (list_find.total_num_items > list_ptr->list_max_num_items_on_display)
		{
			if (list_find.top_item_num > (list_find.total_num_items - list_ptr->list_max_num_items_on_display))
				list_find.num_items_display = (list_find.total_num_items - list_find.top_item_num);
			else list_find.num_items_display = list_ptr->list_max_num_items_on_display;
		}
		else if (list_find.total_num_items == list_ptr->list_max_num_items_on_display)
			list_find.num_items_display = list_ptr->list_max_num_items_on_display;
		else list_find.num_items_display = list_find.total_num_items;
		
		list_ptr->list_top_item_num = 0;
		list_ptr1->list_top_item_num = 0;				
		
		
		if (list_find.total_num_items > list_find.max_num_items_display)
		{
			scroll_ptr->scrollbar_attr.scrollbar_visible = TRUE;
			if (list_find.top_item_num >= (list_find.total_num_items - list_find.max_num_items_display))
				list_find.top_item_num = (list_find.total_num_items - list_find.max_num_items_display);           
			
			scroll_ptr->scrollbar_value 	= list_find.top_item_num;
			scroll_ptr->scrollbar_min		= 0;
			scroll_ptr->scrollbar_pagesize  = list_find.max_num_items_display;
			scroll_ptr->scrollbar_draw_pagesize = list_find.max_num_items_display;
			scroll_ptr->scrollbar_max		= list_find.total_num_items - list_find.max_num_items_display;
			scroll_ptr->scrollbar_total_num_lines = list_find.total_num_items;      
		}
		else
		{
			scroll_ptr->scrollbar_attr.scrollbar_visible = FALSE;
			if (draw_scrollbar)
				ScrollbarEraseScrollbar(SCROLLBAR_FIND_RESULT); 
			list_find.top_item_num = 0;
		}
		
		ListDisplayDraw(&list_find);
		
		if (list_ptr->list_text_font == SMALL_FONT)							
		{
			MenuDeleteItem(MENU_FIND_RESULT, 0);
			MenuInsertItem(MENU_FIND_RESULT, 0, PBLFONT);
			ControlSetLabel(BUTTON_FIND_RESULT_ZOOMIN, PBLFONT);
		}
		else
		{
			MenuDeleteItem(MENU_FIND_RESULT, 0);
			MenuInsertItem(MENU_FIND_RESULT, 0, PBSFONT);
			ControlSetLabel(BUTTON_FIND_RESULT_ZOOMIN, PBSFONT);
		}
		
		ControlDrawControl(BUTTON_FIND_RESULT_ZOOMIN);
		ListDrawList(LIST_FIND_RESULT_NAME);
		ListDrawList(LIST_FIND_RESULT_PHONE);
		ScrollbarDrawScrollbar(SCROLLBAR_FIND_RESULT);	
		break;
	default: break;
	}
}

/********************************************************
* Function:    PhonebookChangeFontSize
* Purpose:     This function is called to check and change the font size
* Scope:		application
* Input:		Event		
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void PhonebookChangeFontSize(ObjectID form_id, BYTE required_font_size)
{
	ObjectID 		active_form_id;
	List			*list_ptr, *list_ptr1;
	Scrollbar		*scroll_ptr;
    BYTE            object_type, *list_text;
    Field           *field_ptr;
    Table           *table_ptr;
    USHORT          count;
    SHORT           line_height;
    BYTE            original_font;
    WORD            acc_num_lines = 0;
    WORD            num_lines_displayed = 0;
	
    active_form_id = form_id;
    if (font_size != required_font_size)
    {
        if (required_font_size == SMALL_FONT)
            font_size = SMALL_FONT;
        else 
			font_size = MEDIUM_FONT;
    }
	
	switch (active_form_id)
	{
	case FORM_VIEW_EDIT:
		if (table_font_size == required_font_size)
			break;
		if (table_font_size == MEDIUM_FONT) table_font_size = SMALL_FONT;
		else table_font_size = MEDIUM_FONT;
		FormGetObjectPointer(TABLE_VIEW_EDIT, &object_type, (void**)&table_ptr);
		FormGetObjectPointer(SCROLLBAR_VIEW_EDIT, &object_type, (void**)&scroll_ptr);
		FieldGetFont(FIELD_ROW0, &original_font);
		line_height = SysGetFontHeight(table_font_size) + SPACE_LINE;
		
		switch (table_font_size)
		{
		case SMALL_FONT:
			ControlSetLabel(BUTTON_VIEW_ZOOMIN, PBLFONT);
			MenuDeleteItem(MENU_POPUP1, 4);
			MenuInsertItem(MENU_POPUP1, 4, PBLFONT);
			for (count = 0; count < (table_ptr->table_num_row); count++)
			{
				table_ptr->table_row_height[count] = SysGetFontHeight(SMALL_FONT) + SPACE_LINE;
				FormGetObjectPointer((ObjectID)(FIELD_ROW0 + count), &object_type, (void**)&field_ptr);
				field_ptr->bounds.height = table_ptr->table_row_height[count];
				field_ptr->field_font_id = SMALL_FONT;
				TableUpdateObjectScreenBounds(TABLE_VIEW_EDIT, (ObjectID)(FIELD_ROW0 + count));
				StrAnalyzeLine(field_ptr);
			}
			break;
		case MEDIUM_FONT:
			ControlSetLabel(BUTTON_VIEW_ZOOMIN, PBSFONT);
			MenuDeleteItem(MENU_POPUP1, 4);
			MenuInsertItem(MENU_POPUP1, 4, PBSFONT);
			for (count = 0; count < (table_ptr->table_num_row); count++)
			{
				table_ptr->table_row_height[count] = SysGetFontHeight(MEDIUM_FONT) + SPACE_LINE;
				FormGetObjectPointer((ObjectID)(FIELD_ROW0 + count), &object_type, (void**)&field_ptr);
				field_ptr->bounds.height = table_ptr->table_row_height[count];
				field_ptr->field_font_id = MEDIUM_FONT;
				TableUpdateObjectScreenBounds(TABLE_VIEW_EDIT, (ObjectID)(FIELD_ROW0 + count));
				StrAnalyzeLine(field_ptr);
			}
			break;
		default: return;
		}
		PhonebookSetViewEditTable(FORM_VIEW_EDIT, TABLE_VIEW_EDIT);
		PhonebookViewEditTableSetScrollbar(TABLE_VIEW_EDIT, SCROLLBAR_VIEW_EDIT);
		break;
		case FORM_TEL_LIST:
			FormGetObjectPointer(LIST_NAME, &object_type, (void**)&list_ptr);
			FormGetObjectPointer(LIST_PHONENUM, &object_type, (void**)&list_ptr1);
            FormGetObjectPointer(SCROLLBAR_TEL_LIST, &object_type, (void**)&scroll_ptr);
            if (list_ptr->list_text_font == required_font_size)
                break;
			
            if (list_ptr->list_text_font == SMALL_FONT)
			{
				list_ptr->list_text_font = MEDIUM_FONT;
				list_ptr1->list_text_font = MEDIUM_FONT;
			}
            else
			{
				list_ptr->list_text_font = SMALL_FONT;
				list_ptr1->list_text_font = SMALL_FONT;
			}
			
			
            list_tel_list.max_num_items_display = list_ptr->list_max_num_items_on_display;
			
            if (list_tel_list.total_num_items > list_ptr->list_max_num_items_on_display)
            {
                if (list_tel_list.top_item_num > (list_tel_list.total_num_items - list_ptr->list_max_num_items_on_display))
                    list_tel_list.num_items_display = (list_tel_list.total_num_items - list_tel_list.top_item_num);
                else list_tel_list.num_items_display = list_ptr->list_max_num_items_on_display;
            }
            else if (list_tel_list.total_num_items == list_ptr->list_max_num_items_on_display)
                list_tel_list.num_items_display = list_ptr->list_max_num_items_on_display;
            else list_tel_list.num_items_display = list_tel_list.total_num_items;
			
			
            ListDisplayDraw(&list_tel_list);
			
			PhonebookTelListSetScrollbar();
			
            if (list_ptr->list_attr.list_visible == TRUE)
            {                                             
                if(ListDisplayGetText(&list_tel_list, list_tel_list.top_item_num, &list_text))
					PhonebookStartCharSetTab(list_text[0]);
				else
					PhonebookStartCharSetTab(-1);
                qfree(list_text);
            }
			
			if (list_ptr->list_text_font == SMALL_FONT)
			{
				MenuDeleteItem(MENU_TEL_LIST, 0);
				MenuInsertItem(MENU_TEL_LIST, 0, PBLFONT);
                ControlSetLabel(BUTTON_TEL_LIST_ZOOMIN, PBLFONT);
			}
            else
			{
				MenuDeleteItem(MENU_TEL_LIST, 0);
                MenuInsertItem(MENU_TEL_LIST, 0, PBSFONT);
                ControlSetLabel(BUTTON_TEL_LIST_ZOOMIN, PBSFONT);
			}
            break;
		case FORM_FIND_RESULT:
			FormGetObjectPointer(LIST_FIND_RESULT_NAME, &object_type, (void**)&list_ptr);
			FormGetObjectPointer(LIST_FIND_RESULT_PHONE, &object_type, (void**)&list_ptr1);
			FormGetObjectPointer(SCROLLBAR_FIND_RESULT, &object_type, (void**)&scroll_ptr);
            if (list_ptr->list_text_font == required_font_size)
                break;
			
			if (list_ptr->list_text_font == SMALL_FONT)
			{
				list_ptr->list_text_font = MEDIUM_FONT;
				list_ptr1->list_text_font = MEDIUM_FONT;
			}
            else
			{
				list_ptr->list_text_font = SMALL_FONT;
				list_ptr1->list_text_font = SMALL_FONT;
			}
			ListRecalculateMaxNumItemsDisplay(LIST_FIND_RESULT_NAME);
			ListRecalculateMaxNumItemsDisplay(LIST_FIND_RESULT_PHONE);
			
            list_find.max_num_items_display = list_ptr->list_max_num_items_on_display;
            list_ptr1->list_top_item_num = list_ptr->list_top_item_num = 0;				
			
            if (list_find.total_num_items > list_ptr->list_max_num_items_on_display)
            {
                if (list_find.top_item_num > (list_find.total_num_items - list_ptr->list_max_num_items_on_display))
                    list_find.num_items_display = (list_find.total_num_items - list_find.top_item_num);
                else list_find.num_items_display = list_ptr->list_max_num_items_on_display;
            }
            else if (list_find.total_num_items == list_ptr->list_max_num_items_on_display)
                list_find.num_items_display = list_ptr->list_max_num_items_on_display;
            else list_find.num_items_display = list_find.total_num_items;
			
            if (list_find.total_num_items > list_find.max_num_items_display)
			{
				scroll_ptr->scrollbar_attr.scrollbar_visible = TRUE;
                if (list_find.top_item_num >= (list_find.total_num_items - list_find.max_num_items_display))
                    list_find.top_item_num = list_find.total_num_items - list_find.max_num_items_display;           
				
				scroll_ptr->scrollbar_value 	= list_find.top_item_num;
				scroll_ptr->scrollbar_min		= 0;
                scroll_ptr->scrollbar_pagesize  = list_find.max_num_items_display;
				scroll_ptr->scrollbar_draw_pagesize = scroll_ptr->scrollbar_pagesize;
				scroll_ptr->scrollbar_max		= list_find.total_num_items - scroll_ptr->scrollbar_pagesize;
				scroll_ptr->scrollbar_total_num_lines = list_find.total_num_items;    
			}
			else
			{
				scroll_ptr->scrollbar_attr.scrollbar_visible = FALSE;
                if (draw_scrollbar)
                    ScrollbarEraseScrollbar(SCROLLBAR_CATE); 
				list_find.top_item_num = 0;
			}
            
            ListDisplayDraw(&list_find);
			
			if (list_ptr->list_text_font == SMALL_FONT)							
			{
				MenuDeleteItem(MENU_FIND_RESULT, 0);
				MenuInsertItem(MENU_FIND_RESULT, 0, PBLFONT);
				ControlSetLabel(BUTTON_FIND_RESULT_ZOOMIN, PBLFONT);
			}
			else
			{
				MenuDeleteItem(MENU_FIND_RESULT, 0);
				MenuInsertItem(MENU_FIND_RESULT, 0, PBSFONT);
				ControlSetLabel(BUTTON_FIND_RESULT_ZOOMIN, PBSFONT);
			}
			
			break;
		case FORM_EDIT_CATE:
			FormGetObjectPointer(LIST_CATE, &object_type, (void**)&list_ptr);
			FormGetObjectPointer(SCROLLBAR_CATE, &object_type, (void**)&scroll_ptr);
			
            if (list_ptr->list_text_font == required_font_size)
                break;
			
			list_ptr->list_text_font = (list_ptr->list_text_font == SMALL_FONT) ? MEDIUM_FONT :  SMALL_FONT;
			
            if (list_ptr->list_total_num_items > list_ptr->list_max_num_items_on_display)
			{
				scroll_ptr->scrollbar_attr.scrollbar_visible = TRUE;
				
                if (list_ptr->list_highlighted_item > 0 && list_ptr->list_highlighted_item < list_ptr->list_top_item_num)
					list_ptr->list_top_item_num = list_ptr->list_highlighted_item;
                else if (list_ptr->list_highlighted_item >= (list_ptr->list_top_item_num + list_ptr->list_max_num_items_on_display))
                    list_ptr->list_top_item_num = list_ptr->list_highlighted_item;
				
                if (list_ptr->list_top_item_num >= (list_ptr->list_total_num_items - list_ptr->list_max_num_items_on_display))
                    list_ptr->list_top_item_num = (list_ptr->list_total_num_items - list_ptr->list_max_num_items_on_display);           
				
				scroll_ptr->scrollbar_value 	= list_ptr->list_top_item_num;
				scroll_ptr->scrollbar_min		= 0;
                scroll_ptr->scrollbar_pagesize  = list_ptr->list_max_num_items_on_display;
				scroll_ptr->scrollbar_draw_pagesize 	= scroll_ptr->scrollbar_pagesize;
				scroll_ptr->scrollbar_max		= list_ptr->list_total_num_items - scroll_ptr->scrollbar_pagesize;
				scroll_ptr->scrollbar_total_num_lines = list_ptr->list_total_num_items;      
			}
			else
			{
				scroll_ptr->scrollbar_attr.scrollbar_visible = FALSE;
                if (draw_scrollbar)
                    ScrollbarEraseScrollbar(SCROLLBAR_CATE); 
				list_ptr->list_top_item_num = 0;
			}
			
			
			if (list_ptr->list_text_font == SMALL_FONT)							
			{
				MenuDeleteItem(MENU_EDIT_CATE, 0);
				MenuInsertItem(MENU_EDIT_CATE, 0, PBLFONT);
				ControlSetLabel(BUTTON_CATE_ZOOMIN, PBLFONT);
			}
			else
			{
				ControlSetLabel(BUTTON_CATE_ZOOMIN, PBSFONT);
				MenuDeleteItem(MENU_EDIT_CATE, 0);
				MenuInsertItem(MENU_EDIT_CATE, 0, PBSFONT);
			}
			break;
		default: break;
	}
}