/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   comctrl.c
Author(s)   :   Kenny Ng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file - COM PORT control
Revision    :   1.2
Note        :   None
Revision History
Feb 14 2000     Modify PortWaitForLength() for better memory allocation
===========================================================================
*/              


#include "comctrl.h"
#include "pdasync.h"
#include "syncfx.h"
#include "uart.h"
#include "uartmgr.h"
#include "dm.h"

UBYTE wait_char[3];
BYTE *w_buffer;
BOOLEAN bcomtimeout;
static BOOLEAN com_wait_clear;
static WORD wait_len = 0;
void (*oldwaitcharfct) (UBYTE);
extern WORD hport;
extern WORD is_sync;
extern WORD rec_mode;

UWORD timeout_buftimer = 0;

void TmrBufTimeOut()
{
	SysEnableHotSyncButton();
	DisBufTmr();
	is_sync = 0;
}

void EnBufTimeOutTmr()
{
	if(timeout_buftimer == 0)
		timeout_buftimer = TmrIntEnable(10*1000,TmrBufTimeOut);
}

void DisBufTmr()
{
	if(timeout_buftimer != 0)
	{
		TmrIntDisable(timeout_buftimer);
		timeout_buftimer = 0;
	}
}


/* Send 1 byte to COM port through UartMgr */
void PortSendChar(UBYTE x)
{
    ComSendChar(hport, x);
}

/* Send a buffer to COM port through UartMgr */
BOOLEAN PortSendBuffer(UBYTE *Buffer, UWORD Length)
{
	return FALSE;
}


/* Wait for some specific data from COM port   */
/* input: data1, data2, data3  >> data to wait */
/* clear >> if TRUE, the waited data will remove from buffer */
BOOLEAN PortWaitForChar(UBYTE data1, UBYTE data2, UBYTE data3, BOOLEAN clear)
{
    wait_char[0] = data1;
    wait_char[1] = data2;
    wait_char[2] = data3;
    com_wait_clear = clear;
    bcomtimeout = TRUE;
    oldwaitcharfct = ComFctPtr;
    ComCapture(hport, COM_MODE_CHAR, 0, 0, NULL);
    SetComHandleEvent(PortWaitForChar1);
}

void PortWaitForChar1(UBYTE x)
{
    UWORD pos;
    SHORT i;
    
    for(i=0; i<3; i++)
    {
        if(x == wait_char[i])
			break;
    }
	
    if(i != 3)
    {
        bcomtimeout=FALSE;
        SetComHandleEvent(oldwaitcharfct);
        if(com_wait_clear)
        {
			pos = BufferFindChar(x);
			BufferRemove(pos+1);
        }
        (*WaitReturnFct)(x);
    }
    else
		ComCapture(hport, COM_MODE_CHAR, 0, 0, NULL);
}


/* Wait for a specific buffer length */
BOOLEAN PortWaitForLength(UWORD len)
{
	
	// this define is in <qmalloc.c> and <pmalloc.c>
#define BLOCK_RESERVE_SPACE             (sizeof(struct block_header) + sizeof(struct page_identifier))
	
    UWORD alloc_size;
    bcomtimeout = TRUE;
    if(BufferGetLength() >= len)
    {
		(*WaitReturnFct)(0);
		return TRUE;
    }
    wait_len = len - BufferGetLength();
	
    if(wait_len > 4096 - BLOCK_RESERVE_SPACE - sizeof(struct block_header))
        alloc_size = wait_len + 1;
	
    else alloc_size =  4096 - BLOCK_RESERVE_SPACE - sizeof(struct block_header) - 10;
	
    w_buffer = (BYTE*)qmalloc(alloc_size);
	
    SetBufferDoneFct(PortWaitForLength1);                    //V 2byte-Chk sum
    ComCapture(hport, COM_MODE_BUFFER, 1000, wait_len, w_buffer);
    rec_mode = 1;
    return TRUE;
}

void PortWaitForLength1(UBYTE x)
{
    UWORD i = wait_len;
	
    for(i=0;i<wait_len;i++)
		BufferAddChar(w_buffer[i]);
	
    qfree(w_buffer);
	
    bcomtimeout = FALSE;
    SetBufferDoneFct(NULL);
    rec_mode = 0;
    //ComCapture(hport, COM_MODE_CHAR, 0, 0, NULL);
    (*WaitReturnFct)(x);
}
