/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   pdasync.h
Author(s)   :   Kenny Ng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#ifndef __PDA_SYNC_H__
#define __PDA_SYNC_H__

#include "datatype.h"

#define EVT_SYNC_START 6000

extern void (*ComFctPtr) (UBYTE);
extern void (*WaitReturnFct) (UBYTE);
extern void (*TimeOutFct) (UBYTE);
extern void (*BufferDoneFct)(UBYTE);

void SyncSendOSVer();

void SetClock();
void SetClock2(UBYTE);

void SyncStart();
void SyncStart2(UBYTE);
void SyncDBGenInfo();
void SyncDBInfo();
void SyncDBInfo2(UBYTE);
void SyncDBInfo3(UBYTE);
void SyncReadRec();
void SyncReadRec2(UBYTE);
void SyncReadRec3(UBYTE);
void SyncReadRec4(UBYTE);
void SyncReadRec5(UBYTE);

void SyncRecInfoReq();
void SyncRecInfoReq2(UBYTE);
void SyncRecInfoReq3(UBYTE);
void SyncReadRecInf();
void SyncReadRecInf2(UBYTE);
void SyncReadRecInf3(UBYTE);
void SyncSchRecInfoReq();
void SyncSchRecInfoReq2(UBYTE);
void SyncSchRecInfoReq3(UBYTE);

void SyncSetMaxRecID();
void SyncSetMaxRecID2(UBYTE x);
void SyncSetMaxRecID3(UBYTE x);


void SyncRecArcInfoReq();
void SyncRecArcInfoReq2(UBYTE);
void SyncRecArcInfoReq3(UBYTE);

void SyncRecDel();
void SyncRecDel2(UBYTE);
void SyncRecDel3(UBYTE);

void SyncReadField();
void SyncReadField1(UBYTE x);
void SyncReadField2(UBYTE x);
void SyncReadField3(UBYTE x);
void SyncReadField4(UBYTE x);

void SyncRecAdd();
void SyncRecAdd2(UBYTE x);
void SyncRecAdd3(UBYTE x);
void SyncRecAdd4(UBYTE x);
void SyncRecAdd5(UBYTE x);
void SyncRecAdd6(UBYTE x);
void SyncRecAdd7(UBYTE x);

void SyncRecAdd();
void SyncRecAddLarge2(UBYTE x);
void SyncRecAddLarge3(UBYTE x);
void SyncRecAddLarge4(UBYTE x);
void SyncRecAddLarge5(UBYTE x);
void SyncRecAddLarge6(UBYTE x);

void SyncCatAdd();
void SyncCatAdd2(UBYTE x);
void SyncCatAdd3(UBYTE x);
void SyncCatAdd4(UBYTE x);
void SyncCatAdd5(UBYTE x);
void SyncCatAdd6(UBYTE x);
void SyncCatAdd7(UBYTE x);

void SyncReasignRecID();
void SyncReasignRecID2(UBYTE x);


void SetComHandleEvent( void (*fct));
void SetWaitReturnFct( void (*fct));
void SetTimeOutFct(void (*fct));
void SetBufferDoneFct(void (*fct));

void SyncStateDBEnq(UBYTE);
void SyncStateInit(UBYTE);
void SyncStateIdle(UBYTE);
void SyncStateDBUp(UBYTE);
void SyncStateNewApp(UBYTE);
void SyncStateTerm(UBYTE);

void SyncMsgLog(UBYTE);
void SyncGetLogMsg();
void SyncGetLogMsg2(UBYTE);
void SyncGetLogMsg3(UBYTE);
void SyncGetLogMsg4(UBYTE);

void SyncUserReq();

void SyncNewApp();
void SyncNewApp2(UBYTE);
void SyncNewApp3(UBYTE);
void SyncNewApp4(UBYTE);
void SyncNewApp5(UBYTE);
void SyncNewApp6(UBYTE);

void SyncChgSchApptNum();
void SyncChgSchApptNum2(UBYTE);
void SyncChgSchApptNum3(UBYTE);

//reg
void SyncDBNew();
void SyncDBNew2(UBYTE);
void SyncDBNew3(UBYTE);
void SyncDBNew4(UBYTE);
void SyncRecNew();
void SyncRecNew2(UBYTE);
void SyncRecNew3(UBYTE);
void SyncRecNew4(UBYTE);
void SyncRecNew5(UBYTE);
//reg

#endif
