#ifndef __SYNC_FX_
#define __SYNC_FX_

#include "mmu.h"

#define DatabaseID unsigned int
#define RecordID unsigned int
#define AppID	unsigned short

#define CSERR_RETRY	2	// tran retry when CS error
#define DBHEADER_SIZE	sizeof(DBHeader)
#define RECHEADER_SIZE	sizeof(RecordHeader)

#define TRAN_PACKET_SIZE        (2048)

extern MatInfoList *mat_info_ptr[TOTAL_SLOT];
//#define SBlockAddrS(sblock)      (mat_info_ptr[SBlockMat(sblock)]->base_addr + (((sblock & 0x0000FFFF) + 1) << 12))
/* for email */
#define TIME_INDEX_RECID	0x80001001

/*Email Box*/
#define INBOX			1
#define OUTBOX			2
#define SENT			3
#define DRAFT			4

#define ST_ACK          0x01
#define ST_FLG          0x03
#define ST_NAK          0x02
#define USER_REQ	0x04
#define ACK             0x05
#define USERWR_REQ	0x06
#define USER_ACK	0x07
#define NAK             0x08
#define CLK_REQ		0x09
#define CLK_ACK		0x0a
#define CLKSET_REQ	0x0b
#define CLKSET_ACK	0x0c
#define GENINF_REQ	0x0f
#define GENINF_ACK	0x10
#define DBINFO_REQ	0x11
#define DBINFO_ACK	0x12
#define DBID_REQ	0x13
#define DBINFO_DATA_ACK	0x014
#define RECINFO_REQ	0x15
#define RECINFO_ACK	0x16
#define RECINFO_SEQ	0x17
#define RECINFO_DATA_ACK	0x18
#define MODIREC_REQ	0x19
#define MODIREC_ACK	0x1a
#define RECDATA_REQ	0x1b
#define RECDATA_ACK	0x1c
#define REC_NAK		0x1d
#define REC_DATA	0x1e
#define APP_REQ		0x1f
#define APP_ACK		0x20
#define APP_SEQ		0x21
#define DELREC_REQ	0x22
#define DELREC_ACK	0x23
#define DELREC_SEQ	0x24
#define ADDREC_REQ	0x25
#define ADDREC_ACK	0x26
#define CLKSET_SEQ	0x27
#define REC_SIZE_NAK	0x28
#define ADDREC_ST	0x29
#define DELDB_REQ	0x2a
#define DELDB_ACK	0x2b
#define DELDB_SEQ	0x2c
#define NEWDB_REQ	0x2d
#define NEWDB_ACK	0x2e
#define NEWDB_SEQ	0x2f
//#define NEWDB_ST	0x30
#define NEWDB_NAK	0x30
#define NEWAPP_REQ	0x31
#define NEWAPP_ACK	0x32
#define NEWAPP_SEQ	0x33
#define NEWAPP_ST	0x34
#define SENDDB_REQ	0x35
#define SENDDB_ACK	0x36
#define SENDDB_SEQ	0x37
#define SENDEOR_ACK	0x38
#define END_FLG		0x39
#define IDLE_MODE_REQ	0x3a
#define IDLE_MODE_ACK	0x3b
#define NEWAPP_MODE_REQ	0x3c
#define NEWAPP_MODE_ACK	0x3d
#define RECDATA_SEQ		0x3e
#define REC_ACK			0x3f
#define END_ACK			0x40
#define ADDREC_SEQ		0x41
#define DBENQ_MODE_REQ  0x43
#define DBUP_MODE_REQ   0x44
#define SYSBK_MODE_REQ  0x45
#define TERM_MODE_REQ   0x46
#define DBENQ_MODE_ACK  0x47
#define DBUP_MODE_ACK   0x48
#define SYSBK_MODE_ACK  0x49
#define TERM_MODE_ACK   0x50
#define RECARCINFO_REQ  0x51
#define RECARCINFO_ACK  0x52
#define RECARCINFO_SEQ  0x53
#define RECARCINFO_DATA_ACK     0x54
#define RECARCDATA_REQ  0x55
#define RECARCDATA_ACK  0x56
#define RECARCDATA_SEQ  0x57
#define ADDREC_CON      0x58
#define MSG_SCRONLY     0x59
#define MSG_LOGONLY     0x5a
#define MSG_LOGSCR      0x5b
#define MSG_LOG_REQ     0x5c
#define MSG_LOG_ACK     0x5d
#define MSG_SEQ         0x5e
#define MSG_ACK         0x5f
#define SHOW_STATE_RDY  0x60
#define SHOW_STATE_1    0x61
#define SHOW_STATE_2    0x62
#define SHOW_STATE_3    0x63
#define LOG_MSG_EM      0x64
#define LOG_MSG_PB      0x65
#define LOG_MSG_SCH     0x66
#define LOG_MSG_VOX     0x67
#define LOG_MSG_TD      0x68
#define LOG_MSG_ANN     0x69
#define LOG_MSG_SK      0x6a
#define LOG_MSG_EXP     0x6b
#define LOG_MSG_MEMO    0x6c
#define LOG_MSG_SYS     0x6d
#define LOG_MSG_BACKUP  0x6e
#define LOG_MSG_SYNC    0x6f

#define LOG_MSG_EM_F    0x78
#define LOG_MSG_PB_F    0x79
#define LOG_MSG_SCH_F   0x7a
#define LOG_MSG_VOX_F   0x7b
#define LOG_MSG_TD_F    0x7c
#define LOG_MSG_ANN_F   0x7d
#define LOG_MSG_SK_F    0x7e
#define LOG_MSG_EXP_F   0x7f
#define LOG_MSG_MEMO_F  ((UBYTE)0x80)
#define LOG_MSG_SYS_F     ((UBYTE)0x81)
#define LOG_MSG_BACKUP_F  ((UBYTE)0x82)
#define LOG_MSG_SYNC_F    ((UBYTE)0x83)


#define LOG_CLR_MSG    ((UBYTE)0x8d)
#define LOG_MSG_DATE   ((UBYTE)0x8e)

#define UP_FIELD_REQ    ((UBYTE)0x8f)
#define UP_FIELD_ACK    ((UBYTE)0x9a)

#define RECFIELD_REQ   ((UBYTE)0x9b)
#define RECFIELD_ACK   ((UBYTE)0x9c)
#define RECFIELD_DATA  ((UBYTE)0x9d)

#define CRASH_ENQ      ((UBYTE)0x9e)
#define CRASH_YES      ((UBYTE)0x9f)
#define CRASH_NO       ((UBYTE)0xa0)

#define ADDAPP_ACK     ((UBYTE)0xa1)
#define ADDAPP_DATA_NAK ((UBYTE)0xa2)
#define ADDAPP_SPACE_NAK ((UBYTE)0xa3)
#define ADDAPP_EXIST_NAK ((UBYTE)0xa4)
#define ADDAPP_SEQ       ((UBYTE)0xa5)

#define SCHRECINFO_REQ   ((UBYTE)0xb0)
#define SCHRECINFO_ACK   ((UBYTE)0xb1)

#define ADDCAT_REQ       ((UBYTE)0xaa)
#define ADDCAT_ACK       ((UBYTE)0xab)

#define ADDREC_LARGE_REQ   ((UBYTE)0xac)

#define SET_TODO_ALM       ((UBYTE)0xad)
#define SET_ANN_ALM        ((UBYTE)0xae)
#define SET_SCH_ALM        ((UBYTE)0xaf)

#define MAX_RECID_REQ      ((UBYTE) 0xb2)
#define MAX_RECID_ACK      ((UBYTE) 0xb3)
#define REASIGN_RECID_REQ  ((UBYTE) 0xb4)
#define REASIGN_RECID_ACK  ((UBYTE) 0xb5)
#define CLEAR_CRASH        ((UBYTE) 0xb6)

#define SCH_ACK            ((UBYTE) 0xb7)
#define SCH_CHG_APPNUM_REQ ((UBYTE) 0xb8)
#define OS_VER_REQ         ((UBYTE) 0xb9)
#define UP_SYSTEM_CONFIRM  ((UBYTE)0xba)
#define OS_VER_ACK         ((UBYTE) 0xbb)

//reg
#define NEWDB_SIZE_NAK	   ((UBYTE) 0xbc)
#define NEWDB_EXIST_NAK	   ((UBYTE) 0xbd)
//reg

#define UP_SYSTEM         ((UBYTE)0xc0)

// 0xc1 for start flag

//reg
#define NEWREC_REQ		((UBYTE)0xc2)
#define NEWREC_ACK		((UBYTE)0xc3)
#define NEWREC_SEQ		((UBYTE)0xc4)
#define NEWREC_NAK		((UBYTE)0xc5)
#define NEWREC_INV_NAK		((UBYTE)0xc6)
#define NEWREC_SIZE_NAK		((UBYTE)0xc7)
//reg

#endif
