/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   appstart.s
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application start routine
Revision    :   1.1
Note        :   None
===========================================================================
*/              

#include "pr3910.h"
#include "pr31700s.h"

#define FLASH
	.text
	.globl appstart
appstart:
    li      t0, 0x9fd90000
	jalr	t0
	nop
    j       go_ahead01
    nop

    .align 4


/*  .data*/
# OS Version No
	.globl	OSVerNo
OSVerNo:
    .ascii   "1.3.02B010313"        /* AH: 991007  "1.3.02B010313"  */
    nop                             /* AH: 991007 */
    .align 4                        /* AH: 991007 */


go_ahead01:                 /* AH: 991007 */

#ifdef FLASH
	# clear bss
	la		v0, _fbss
	la		v1, ebss
1:	sw		$0, 0x0(v0)
	sw		$0, 0x4(v0)
	sw		$0, 0x8(v0)
	sw		$0, 0xc(v0)
	addu	v0, 16
	blt		v0, v1, 1b

	# copy .data to RAM
	# src=etext dst=_fdata stop=edata
	la	t0, etext
	la	t1, _fdata
	la	t2, edata
1:	lw	t3, 0(t0)
	sw	t3, 0(t1)
	addu	t0, 4
	addu	t1, 4
	blt	t1, t2, 1b
#endif

	# transfer to main program
	# reg indirect is necessary to switch segments
	la		t0, __main
    jal     t0

    .align 8


