/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   main.c
Author(s)   :   Thomas Cheng, Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              




#include "stdafx.h"
#include "resource.h"
#include "pi.h"
#include "kernel.h"
#include "resmgr.h"
#include "ui.h"
#include "uifunc.h"
#include "inlay.h"
#include "system.h"
#include "sysetup.h"
#include "dev_pwr.h"
#include "piplang.h"

extern AppID cal_id, pb_id, em_id;

/* ==================================================================== */
/* ========================= Function Prototypes ====================== */
/* ==================================================================== */
extern UWORD *sys_page, *app_page;
extern REGISTRY app_reg[];

/********************************************************
* Function:	main
* Purpose: 	main procedure of the application
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void __main()
{
    AppID main_id, cal_id, pb_id, em_id, pass_id, sch_id, exp_id, sys_id, alarm_id, todo_id, tetris_id, voice_id, ann_id, memo_id, jot_id, connect_id;
    UWORD *main_ptable, *cal_ptable, *pb_ptable, *em_ptable, *pass_table, *sys_table, *sch_table, *exp_table, *alarm_table, *todo_table, *tetris_table, *voice_table, *ann_table, *memo_table, *jot_table, *connect_table;
    EvtType event;
    RTM time;
    UWORD *addr;
	
    printf("\nStart PIP");
	addr = (UWORD *)0x80000020;
	if ((UWORD)*addr == 0xAAAAAAAA)
	{
        addr = (UWORD *)a_main;
        MemoryRegFlashProg(MAINMENU, (UWORD)addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2), 0, APP_RUN_37M, &main_id, &main_ptable);
        printf("\nInstall MainMenu %04x, %08x %08x %08x %08x", main_id, addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2));
		
        addr = (UWORD *)a_sysetup;
        MemoryRegFlashProg(SYSETUP, (UWORD)addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2), 0, APP_RUN_37M, &sys_id, &sys_table);
        printf("\nInstall SySetup %04x, %08x %08x %08x %08x", sys_id, addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2));
		
        addr = (UWORD *)a_alarmgr;
        MemoryRegFlashProg(ALARMGR, (UWORD)addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2), 0, APP_RUN_37M, &alarm_id, &alarm_table);
        printf("\nInstall Alarm Manager %04x, %08x %08x %08x %08x", alarm_id, addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2));
		
        addr = (UWORD *)a_pass;
        MemoryRegFlashProg(PASSWORD, (UWORD)addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2), 0, APP_RUN_37M, &pass_id, &pass_table);
        printf("\nInstall Password %04x, %08x %08x %08x %08x", pass_id, addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2));
		
        addr = (UWORD *)a_pcsync;
        MemoryRegFlashProg(PC_SYNC, (UWORD)addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2), 0, APP_RUN_37M, &sys_id, &sys_table);
        printf("\nInstall PC Sync %04x, %08x %08x %08x %08x", sys_id, addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2));
		
        addr = (UWORD *)a_pb;
        MemoryRegFlashProg(PHONEBOOK, (UWORD)addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2), BIT_FIND, APP_RUN_37M, &pb_id, &pb_ptable);
        printf("\nInstall Pb %04x, %08x %08x %08x %08x", pb_id, addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2));
		
        addr = (UWORD *)a_exp;
        MemoryRegFlashProg(EXPENSE, (UWORD)addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2), 0, APP_RUN_37M, &exp_id, &exp_table);
        printf("\nInstall Expenses %04x, %08x %08x %08x %08x", exp_id, addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2));
		
        addr = (UWORD *)a_sch;
        MemoryRegFlashProg(SCHEDULER, (UWORD)addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2), BIT_ALARM | BIT_FIND, APP_RUN_37M, &sch_id, &sch_table);
        printf("\nInstall Scheduler %04x, %08x %08x %08x %08x", sch_id, addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2));
		
        addr = (UWORD *)a_sketch;
        MemoryRegFlashProg(SKETCH, (UWORD)addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2), BIT_FIND, APP_RUN_37M, &memo_id, &memo_table);
        printf("\nInstall Sketch %04x, %08x %08x %08x %08x", sys_id, addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2));
		
        addr = (UWORD *)a_memo;
        MemoryRegFlashProg(MEMO, (UWORD)addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2), BIT_FIND, APP_RUN_37M, &memo_id, &memo_table);
        printf("\nInstall Memo %04x, %08x %08x %08x %08x", sys_id, addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2));
		
        addr = (UWORD *)a_dcal;
        MemoryRegFlashProg(CALCULATOR, (UWORD)addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2), 0, APP_RUN_37M, &cal_id, &cal_ptable);
        printf("\nInstall Calculator %04x, %08x %08x %08x %08x", cal_id, addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2));
		
        addr = (UWORD *)a_todo;
        MemoryRegFlashProg(TODOLIST, (UWORD)addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2), BIT_ALARM|BIT_FIND, APP_RUN_37M, &todo_id, &todo_table);
        printf("\nInstall ToDo %04x, %08x %08x %08x %08x", pb_id, addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2));
		
        addr = (UWORD *)a_ann;
        MemoryRegFlashProg(ANN, (UWORD)addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2), BIT_ALARM | BIT_FIND, APP_RUN_37M, &ann_id, &ann_table);
        printf("\nInstall Anniversaries %04x, %08x %08x %08x %08x", ann_id, addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2));
		
        addr = (UWORD *)a_em;
        MemoryRegFlashProg(EMAIL, (UWORD)addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2), BIT_FIND, APP_RUN_37M, &em_id, &em_ptable);
        printf("\nInstall Em %04x, %08x %08x %08x %08x", em_id, addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2));
		
        addr = (UWORD *)a_voxmemo;
        MemoryRegFlashProg(VOXMEMO, (UWORD)addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2), BIT_FIND, APP_RUN_37M, &voice_id, &voice_table);
        printf("\nInstall Voice Memo %04x, %08x %08x %08x %08x", sys_id, addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2));
		
        addr = (UWORD *)a_jot;
        MemoryRegFlashProg(JOT, (UWORD)addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2), 0, APP_RUN_37M, &jot_id, &jot_table);
        printf("\nInstall Jot %04x, %08x %08x %08x %08x", jot_id, addr, *(addr+1), *(addr+6), *(addr+5)-*(addr+2));
	}
	SysEventLoop();
}
