/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   app.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/


#include "stdafx.h"
#include "app.h"
#include "appfunc.h"
#ifdef PR31700
#include "dev_pwr.h"
#endif

//#define DEBUG
//#define DEBUG_KEY
//#define DEBUG_NO_MEM
//#define DEBUG_REPEAT
//#define DEBUG_VOICE_ALARM
//#define DEBUG_MICH


#ifdef PC_SIM
int CheckBatteryLow()
{
	return 0;
}
#endif

#define WITHSOUND
/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
AppID			app_id;
DatabaseID		sch_appmt_dbid;
DatabaseID		sch_voice_dbid;
DatabaseID		sch_repeat_dbid;
DatabaseID		sch_except_dbid;

VirtualTable	virtual_table;
USHORT			prev_row_num, prev_col_num;
BOOLEAN			repeat_appointment = FALSE;
BYTE			prev_status;

UWORD			alarm_count = 1000;
UWORD           time_count = 0;
ObjectID        low_battery_form_id;
UWORD			current_appmt_num = 1000;
UWORD			current_repeat_num = 1000;
extern	        ObjectID	prev_form_id;
// new at 29062000
extern			SHORT		current_month_num;

UWORD repeat_bmp[8] = { 
	0x00003f00, 0x0ff03f00, 0x0c0c3f00, 0x0c0c3f00, 0x0ff03f00, 0x0c0c3f00, 0x0c0c3f00, 0x00003f00};
	
	UWORD repeat_tone_bmp[8] = { 
		0x00003f00, 0x03fc3f00, 0x0cc33f00, 0x0cc33f00, 0x3ffc3f00, 0x30c33f00, 0x30c33f00, 0x00003f00};
		
		UWORD repeat_voice_bmp[8] = { 
			0x00003f00, 0x33fc3f00, 0x33c33f00, 0x33c33f00, 0x33fc3f00, 0x33c33f00, 0x0cc33f00, 0x00003f00};
			
			/*****************************************************************
			***************** Global Variables - FORM_SCH_DAY_VIEW ***********
			*****************************************************************/
			BOOLEAN new_appointment = FALSE;
			EvtType day_view_old_event = {0, 0, 0, 0, NULL};
			
			/*****************************************************************
			************ Global Variables - FORM_SCH_TIME_SETTINGS ***********
			*****************************************************************/
			TimeSettings 	time_settings;
			BYTE			hour_difference;
			BYTE			minute_difference;
			
			/*****************************************************************
			************ Global Variables - FORM_SCH_ALARM_SETTINGS ***********
			*****************************************************************/
			AlarmSettings alarm_settings;
			
			/*****************************************************************
			************ Global Variables - FORM_SCH_ALARM_SETTINGS ***********
			*****************************************************************/
			RepeatSettings repeat_settings;
			
			/*****************************************************************
			************ Global Variables - FORM_SCH_REC ********************
			*****************************************************************/
			ObjectID enter_form_id;
			DatabaseID voice_playing_dbid;
			RecordID   voice_playing_recid;
			UWORD play_pause_frame = 0;
			BOOLEAN play_stop = TRUE;
			BOOLEAN rec_stop = TRUE;
			BOOLEAN recorded = FALSE;
			RecordID rec_rec_id;
			
			/*****************************************************************
			* Function:	SchInitMainGlobal
			* Purpose: 	This function is used to initialize the global variables
			* Scope:		application/internal
			* Input:		None
			* Output:		None
			* Return:		None
			* Comment: 	None
			******************************************************************/
			void SchInitMainGlobal(void)
			{
				prev_row_num = 0;
				prev_col_num = 0;
				prev_form_id = FORM_SCH_DAY_VIEW;
				prev_status = -1;
				return;
			}
			
			/*****************************************************************
			***************** Application Event Handle Function **************
			*****************************************************************/
			/********************************************************
			* Function:	SchedulerDayView
			* Purpose: 	This function is the event handler for the FORM_SCH_DAY_VIEW
			page of the Scheduler application
			* Scope:		application/internal
			* Input:		Event		received event
			* Output:		None
			* Return:		TRUE if handled
			FALSE if not handled
			* Comment: 	None
			*********************************************************/
			BOOLEAN SchedulerDayView(EvtType* Event)
			{
				ObjectID active_object;
				USHORT row_to_be_drawn;
				BOOLEAN done = FALSE, outcome = FALSE;
				BYTE output;
				BOOLEAN start_deleted, end_deleted;
				USHORT start_row, end_row;
				USHORT expected_active;
				Control *control_ptr;
				Form *form_ptr;
				BYTE object_type;
				BYTE repeat_no[4];
				UBYTE date[4];
				USHORT count = 0;
				RecordID tdl_rec_id, ann_rec_id;
				BYTE tdl_alarm, ann_alarm, todo_hit, ann_hit;
				AppID appid;
				GotoRec *cmd_ptr;
				DatabaseID tdl_dbid, ann_dbid;
				Table   *table_ptr;
				Field   *field_ptr;
				BOOLEAN keyboard_up = FALSE;
				AlarmAttr *alarm_attr;
				UWORD byte_read;
				RecordID rec_id;
				BYTE *buffer;
				
				UWORD	total;
				USHORT	i;
				RecordID	record;
				RepeatAttr	*repeat_attr;
				
#ifdef DEBUG_KEY
				printf("\n Event = %08x %08x %08x %08x", Event->eventType, Event->eventID, Event->para1, Event->para2);
#endif
				
				if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
				{
					if ((Event->para2 & 0x00000200))
					{
#ifdef DEBUG_KEY
						printf("\n ALT para2 = %08x", Event->para2);
#endif
						
						if (Event->para1 == LLETTER_NEW || Event->para1 == SLETTER_NEW)
						{
							Event->eventType    = EVT_CONTROL_SELECT;
							Event->eventID      = BUTTON_SCH_DAY_VIEW_NEW;
							Event->evtPBP       = NULL;
						}
						else if (Event->para1 == LLETTER_ALARM || Event->para1 == SLETTER_ALARM)
						{
							Event->eventType    = EVT_CONTROL_SELECT;
							Event->eventID      = BUTTON_SCH_DAY_VIEW_ALARM;
							Event->evtPBP       = NULL;
						}
						else if (Event->para1 == LLETTER_GOTO || Event->para1 == SLETTER_GOTO)
						{
							Event->eventType    = EVT_CONTROL_SELECT;
							Event->eventID      = BUTTON_SCH_DAY_VIEW_GOTO;
							Event->evtPBP       = NULL;
						}
						else if (Event->para1 == LLETTER_DEL || Event->para1 == SLETTER_GOTO)
						{
							Event->eventType    = EVT_CONTROL_SELECT;
							Event->eventID      = BUTTON_SCH_DAY_VIEW_DEL;
							Event->evtPBP       = NULL;
						}
						else if (Event->para1 == LLETTER_APP_SELECT)
						{
#ifdef PR31700
							ControlPopupPopupTrigger(POPUP_TRIGGER_APP_SELECT);
#endif
							return TRUE;
						}
						else if (Event->para2 == 0x215 || Event->para2 == 0x21c)
						{
							ScrollbarHardButtonSetScrollbar(virtual_table.vt_scrollbar_id, SCROLLBAR_UP_ARROW);
							return TRUE;
						}
						else if (Event->para2 == 0x216 || Event->para2 == 0x21d)
						{
							ScrollbarHardButtonSetScrollbar(virtual_table.vt_scrollbar_id, SCROLLBAR_DOWN_ARROW);
							return TRUE;
						}
						else if (Event->para2 == 0x214 || Event->para2 == 0x21F)
						{
							Event->eventType    = EVT_BITMAP_SELECT;
							Event->eventID      = BITMAP_SCH_DAY_VIEW_LEFT;
							Event->evtPBP       = NULL;
						}
						else if (Event->para2 == 0x217 || Event->para2 == 0x21e)
						{
							Event->eventType    = EVT_BITMAP_SELECT;
							Event->eventID      = BITMAP_SCH_DAY_VIEW_RIGHT;
							Event->evtPBP       = NULL;
						}
					}
				}
				
				switch(Event->eventType)
				{
				case EVT_MENU_SELECT_ITEM:
					MenuItemSelectedAction((USHORT)(Event->para1));
					return TRUE;
				case EVT_BITMAP_SELECT:
					if (Event->eventID == BITMAP_SCH_DAY_VIEW_LEFT)
						SchedulerDayViewChangeDate(&virtual_table, TO_LEFT);
					else if (Event->eventID == BITMAP_SCH_DAY_VIEW_RIGHT)
						SchedulerDayViewChangeDate(&virtual_table, TO_RIGHT);
					else if (Event->eventID >= BITMAP_SCH_DAY_VIEW_0 &&
						Event->eventID <= BITMAP_SCH_DAY_VIEW_11)
					{
#ifdef DEBUG
						printf("\n ==== AFTER BITMAP SELECT ====");
#endif
						if (virtual_table.vt_items[(USHORT)(Event->eventID - BITMAP_SCH_DAY_VIEW_0 + virtual_table.vt_top_row_num)]->alarm == VOICE_ALARM ||
							virtual_table.vt_items[(USHORT)(Event->eventID - BITMAP_SCH_DAY_VIEW_0 + virtual_table.vt_top_row_num)]->alarm == VOICE_NOT_ALARM)
						{
							enter_form_id = FORM_SCH_DAY_VIEW;
							voice_playing_dbid = virtual_table.vt_items[(USHORT)(Event->eventID - BITMAP_SCH_DAY_VIEW_0 + virtual_table.vt_top_row_num)]->dbid;
							voice_playing_recid = virtual_table.vt_items[(USHORT)(Event->eventID - BITMAP_SCH_DAY_VIEW_0 + virtual_table.vt_top_row_num)]->recid;
#ifdef DEBUG
							printf("\n voice_playing_dbid = %ld", voice_playing_dbid);
							printf("\n voice_playing_recid = %ld", voice_playing_recid);
							printf("\n row num = %ld", (USHORT)(Event->eventID - BITMAP_SCH_DAY_VIEW_0 + virtual_table.vt_top_row_num));
#endif
							FormInitAllFormObjects(FORM_SCH_REPLAY);
							FormPopupForm(FORM_SCH_REPLAY);
							return TRUE;
						}
					}
					else if (Event->eventID == BITMAP_SCH_DAY_VIEW_TODO_ON)
					{
						SchedulerGetDayViewDate(date);
						ToDoAnnGetEventDate((SHORT)(date[0] + SYSETUP_YEAR_OFFSET), (SHORT)(date[1]), (SHORT)(date[2]), &tdl_rec_id, &ann_rec_id,
							&tdl_alarm, &ann_alarm, &todo_hit, &ann_hit);
						DataFindDB(TODODB, &tdl_dbid);
#ifdef PR31700
						SysGetAppID(TODO, &appid);
#endif
						cmd_ptr = (GotoRec*)pmalloc(sizeof(GotoRec));
						cmd_ptr->app_id = appid;
						cmd_ptr->dbid = tdl_dbid;
						cmd_ptr->rec_id = tdl_rec_id;
						cmd_ptr->field_num = 0;
						cmd_ptr->find_string = NULL;
#ifdef PR31700
						SysGetAppID(TODO, &appid);
						EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
						EvtAppendEvt(EVT_APP_LAUNCH, appid, LAUNCH_CMD_GOTO_REC, 0, (void*)cmd_ptr);
#endif
						return TRUE;
					}
					else if (Event->eventID == BITMAP_SCH_DAY_VIEW_ANN_ON)
					{
						SchedulerGetDayViewDate(date);
						ToDoAnnGetEventDate((SHORT)(date[0] + SYSETUP_YEAR_OFFSET), (SHORT)(date[1]), (SHORT)(date[2]), &tdl_rec_id, &ann_rec_id,
							&tdl_alarm, &ann_alarm, &todo_hit, &ann_hit);
						DataFindDB(ANNDB, &ann_dbid);
#ifdef PR31700
						SysGetAppID(ANN, &appid);
#endif
						cmd_ptr = (GotoRec*)pmalloc(sizeof(GotoRec));
						cmd_ptr->app_id = appid;
						cmd_ptr->dbid = ann_dbid;
						cmd_ptr->rec_id = ann_rec_id;
						cmd_ptr->field_num = 0;
						cmd_ptr->find_string = NULL;
						
						EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
						EvtAppendEvt(EVT_APP_LAUNCH, appid, LAUNCH_CMD_GOTO_REC, 0, (void*)cmd_ptr);
						return TRUE;
					}
					return TRUE;
				case EVT_CONTROL_POPUP_SELECT:
					SchedulerGetDayViewDate(date);
					SchedulerSaveAndSetAlarm();
					SchedulerGotoPopupForm(FORM_SCH_DAY_VIEW, FALSE);
					return TRUE;
				case EVT_DAY_VIEW_STRING_ENTER:
					SchedulerStringHandleEvent(Event);
					return TRUE;
				case EVT_DAY_VIEW_STRING_EXIT:
					SchedulerStringHandleEvent(Event);
					return TRUE;
				case EVT_DAY_VIEW_STRING_SELECT:
#ifdef PR31700
					SndPlaySndEffect(SNDRES5_BEEP);
#endif
					//31-Jan-2001 Bug fixed
					//Reset previous status
					prev_status = -1;
					SchedulerGetDayViewDate(date);
					SchedulerDayViewSaveAppmtData(&virtual_table, date);
					if (Event->para1 >= virtual_table.vt_num_rows)
						return TRUE;
					SchedulerDayViewSelectString(&virtual_table, (USHORT)(Event->para1));
					
					if (virtual_table.vt_items[Event->para1]->appointment == -1 && MemoryLow)
					{
						FormPopupForm(FORM_SCH_LOW_MEMORY);
						SchedulerDayViewNotHighlightString((ObjectID)(Event->para1 - virtual_table.vt_top_row_num + STRING_SCH_DAY_VIEW_0));
						StringDrawString((ObjectID)(Event->para1 - virtual_table.vt_top_row_num + STRING_SCH_DAY_VIEW_0));				
						return TRUE;
					}
					SchedulerTimeSettingsSetScreen();
					FormPopupForm(FORM_SCH_TIME_SETTINGS);
					return TRUE;
				case PEN_EVENT:
					SchedulerStringHandleEvent(Event);
					return TRUE;
				case EVT_CONTROL_SELECT:
					if (Event->eventID == BUTTON_SCH_DAY_VIEW_NEW)
					{
						prev_status = NEW_STATUS;
						if (MemoryLow)
						{
							FormPopupForm(FORM_SCH_LOW_MEMORY);
							return TRUE;
						}
						
						SchedulerGetDayViewDate(date);
						SchedulerDayViewSaveAppmtData(&virtual_table, date);
						if (virtual_table.vt_active_row != -1)
						{
							SchedulerDayViewNotHighlightString((ObjectID)(virtual_table.vt_active_row - 
								virtual_table.vt_top_row_num +
								STRING_SCH_DAY_VIEW_0));
							if ((virtual_table.vt_active_row > virtual_table.vt_top_row_num) &&
								(virtual_table.vt_active_row < (virtual_table.vt_top_row_num + virtual_table.vt_num_rows_displayed)))
								StringDrawString((ObjectID)(virtual_table.vt_active_row - virtual_table.vt_top_row_num + STRING_SCH_DAY_VIEW_0));
						}
						output = SchedulerDayViewNormal(&virtual_table, TABLE_SCH_DAY_VIEW, &start_row,
							&end_row, &start_deleted, &end_deleted);
						if (output == VT_TABLE_CHANGED)
						{
							virtual_table.vt_active_row = (Event->eventID - FIELD_SCH_DAY_VIEW_0) + virtual_table.vt_top_row_num;
							if (virtual_table.vt_active_row == virtual_table.vt_num_rows)
							{
								virtual_table.vt_active_row = -1;
								if (virtual_table.vt_top_row_num != 0)
									virtual_table.vt_top_row_num --;
								LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT);
								done = TRUE;
							}
							virtual_table.vt_active_row = -1;
							SchedulerDayViewSetScreen(&virtual_table);
							VTSetVirtualTableLayout(&virtual_table);
							VTVirtualTableSetScrollbar(&virtual_table);
							VTTransferAllToRT(&virtual_table, TABLE_SCH_DAY_VIEW);
							TableDrawTable(TABLE_SCH_DAY_VIEW);
							SchedulerDayViewDrawAppointmentColumn(&virtual_table, TABLE_SCH_DAY_VIEW);
						}
						else
							VTTransferFieldToVT(&virtual_table, TABLE_SCH_DAY_VIEW);
						LcdEnableInsertPt(FALSE,0 ,0, SMALL_FONT);
						time_settings.new_appointment = TRUE;
						time_settings.new_appointment_with_time = FALSE;
						SchedulerTimeSettingsSetScreen();
						if (virtual_table.vt_active_row != -1)
						{
							FieldSetInsertPointOff((ObjectID)(virtual_table.vt_active_row - virtual_table.vt_top_row_num +
								FIELD_SCH_DAY_VIEW_0));
						}
						new_appointment = FALSE;
						FormPopupForm(FORM_SCH_TIME_SETTINGS);
						return TRUE;
					}
					else if (Event->eventID == BUTTON_SCH_DAY_VIEW_ALARM)
					{
						if (MemoryLow)
						{
							FormPopupForm(FORM_SCH_LOW_MEMORY);
							return TRUE;
						}
						
						if (FormGetObjectPointer(FORM_SCH_ALARM, &object_type, (void**)&form_ptr) != TRUE)
							FormInitAllFormObjects(FORM_SCH_ALARM);
						
						if (virtual_table.vt_active_row == -1)
						{
							FormPopupForm(FORM_SCH_ALARM_SELECT);
							return TRUE;
						}
						SchedulerDayViewSelectString(&virtual_table, (USHORT)(virtual_table.vt_active_row));
						
						alarm_settings.change		= FALSE;
						alarm_settings.recorded		= FALSE;
						alarm_settings.dbid			= time_settings.dbid;
						alarm_settings.org_recid	= time_settings.recid;
						alarm_settings.temp_recid	= 0;
						alarm_settings.hour_start	= time_settings.hour_start;
						alarm_settings.minute_start	= time_settings.minute_end;
						alarm_settings.alarm		= time_settings.alarm;
						if (time_settings.alarm_time  <= 2)
							alarm_settings.alarm_time   = 2;
						else
							alarm_settings.alarm_time = time_settings.alarm_time;
						alarm_settings.alarm_num	= time_settings.alarm_num;
						alarm_settings.row_num		= time_settings.row_num;
						
						if (time_settings.alarm == NO_ALARM || time_settings.alarm == VOICE_NOT_ALARM)
						{
							FormSetControlGroupSelection(FORM_SCH_ALARM, PUSHBUTTON_SCH_ALARM_OFF);
							ControlPopupSetSelectedItem(POPUP_TRIGGER_SCH_ALARM_TIME, 0);
							FormSetControlGroupSelection(FORM_SCH_ALARM, PUSHBUTTON_SCH_ALARM_TONE);
							FormGetObjectPointer(PUSHBUTTON_SCH_ALARM_VOICE, &object_type, (void**)&control_ptr);
							control_ptr->control_attr.control_enable = FALSE;
							FormGetObjectPointer(PUSHBUTTON_SCH_ALARM_TONE, &object_type, (void**)&control_ptr);
							control_ptr->control_attr.control_enable = FALSE;
							FormGetObjectPointer(POPUP_TRIGGER_SCH_ALARM_TIME, &object_type, (void**)&control_ptr);
							control_ptr->control_attr.control_enable = FALSE;
						}
						else
						{
							FormSetControlGroupSelection(FORM_SCH_ALARM, PUSHBUTTON_SCH_ALARM_ON);
							FormGetObjectPointer(PUSHBUTTON_SCH_ALARM_VOICE, &object_type, (void**)&control_ptr);
							control_ptr->control_attr.control_enable = TRUE;
							FormGetObjectPointer(PUSHBUTTON_SCH_ALARM_TONE, &object_type, (void**)&control_ptr);
							control_ptr->control_attr.control_enable = TRUE;
							FormGetObjectPointer(POPUP_TRIGGER_SCH_ALARM_TIME, &object_type, (void**)&control_ptr);
							control_ptr->control_attr.control_enable = TRUE;
							if (time_settings.alarm == VOICE_ALARM)
								FormSetControlGroupSelection(FORM_SCH_ALARM, PUSHBUTTON_SCH_ALARM_VOICE);
							else FormSetControlGroupSelection(FORM_SCH_ALARM, PUSHBUTTON_SCH_ALARM_TONE);
							switch (time_settings.alarm_time)
							{
							case EXACT_TIME:
								ControlPopupSetSelectedItem(POPUP_TRIGGER_SCH_ALARM_TIME, 0);
								break;
							case MIN_15_BEFORE:
								ControlPopupSetSelectedItem(POPUP_TRIGGER_SCH_ALARM_TIME, 1);
								break;
							case MIN_30_BEFORE:
								ControlPopupSetSelectedItem(POPUP_TRIGGER_SCH_ALARM_TIME, 2);
								break;
							case MIN_60_BEFORE:
								ControlPopupSetSelectedItem(POPUP_TRIGGER_SCH_ALARM_TIME, 3);
								break;
							}
						}
						SchedulerGetDayViewDate(date);
						SchedulerDayViewSaveAppmtData(&virtual_table, date);
						FormPopupForm(FORM_SCH_ALARM);
						return TRUE;
					}
					else if (Event->eventID == BUTTON_SCH_DAY_VIEW_GOTO)
					{
						SchedulerGetDayViewDate(date);
						SchedulerDayViewSaveAppmtData(&virtual_table, date);
						prev_form_id = FORM_SCH_DAY_VIEW;
						FormInitAllFormObjects(FORM_SCH_DATE);
						FormPopupForm(FORM_SCH_DATE);
						return TRUE;
					}
					else if (Event->eventID == BUTTON_SCH_DAY_VIEW_DEL)
					{
						if (MemoryLow)
						{
							FormPopupForm(FORM_SCH_LOW_MEMORY);
							return TRUE;
						}
						
						if (virtual_table.vt_active_row == -1)
						{
							FormPopupForm(FORM_SCH_ALARM_SELECT);
							return TRUE;
						}
						if (virtual_table.vt_items[virtual_table.vt_active_row]->repeat)
						{
							prev_status = DELETE_STATUS;
							FormPopupForm(FORM_REPEAT_APPLY_ALL);
							return TRUE;
						}
						SchedulerGetDayViewDate(date);
						SchedulerDayViewSaveAppmtData(&virtual_table, date);
						if (SchedulerDayViewDelAppointment(&virtual_table) == TRUE)
						{
							SchedulerTimeSettingsDeleteAllEmptyAppmts(&virtual_table);
							SchedulerTimeSettingsAddAppmts(&virtual_table);
							VTSetVirtualTableLayout(&virtual_table);
							VTVirtualTableSetScrollbar(&virtual_table);
							VTTransferAllToRT(&virtual_table, TABLE_SCH_DAY_VIEW);
							TableDrawTable(TABLE_SCH_DAY_VIEW);
							SchedulerDayViewDrawAppointmentColumn(&virtual_table, TABLE_SCH_DAY_VIEW);
							SchedulerSaveAndSetAlarm();
						}
						return TRUE;
					}
					else if (Event->eventID == CHECKBOX_SCH_DAY_VIEW)
					{
						SchedulerGetDayViewDate(date);
						SchedulerSaveAndSetAlarm();
						ControlPopupSetSelectedItem(POPUP_TRIGGER_APP_SELECT, 1);
						SchedulerGotoPopupForm(FORM_SCH_DAY_VIEW, FALSE);
						return TRUE;
					}
					else if (Event->eventID == CHECKBOX_SCH_WEEK_VIEW)
					{
						SchedulerGetDayViewDate(date);
						SchedulerSaveAndSetAlarm();
						ControlPopupSetSelectedItem(POPUP_TRIGGER_APP_SELECT, 2);
						SchedulerGotoPopupForm(FORM_SCH_DAY_VIEW, FALSE);
						return TRUE;
					}
					else if (Event->eventID == CHECKBOX_SCH_MONTH_VIEW)
					{
						SchedulerGetDayViewDate(date);
						SchedulerSaveAndSetAlarm();
						ControlPopupSetSelectedItem(POPUP_TRIGGER_APP_SELECT, 3);
						SchedulerGotoPopupForm(FORM_SCH_DAY_VIEW, FALSE);
						return TRUE;
					}
					break;
		case EVT_KEYBOARD_STATUS:
			SchedulerDayViewSetScreen(&virtual_table);
			VTSetVirtualTableLayout(&virtual_table);
			VTVirtualTableSetScrollbar(&virtual_table);
			VTTransferAllToRT(&virtual_table, TABLE_SCH_DAY_VIEW);
			TableDrawTable(TABLE_SCH_DAY_VIEW);
			SchedulerDayViewDrawAppointmentColumn(&virtual_table, TABLE_SCH_DAY_VIEW);
			return TRUE;
		case EVT_KEY:	
			if (virtual_table.vt_active_row == -1)
				return TRUE;
			if (Event->eventID == SOFT_KEY && (Event->para2 & 0x300) == 0)
			{
				FormGetActiveObject(FORM_SCH_DAY_VIEW, &active_object);
				if (active_object >= FIELD_SCH_DAY_VIEW_0 && active_object <= FIELD_SCH_DAY_VIEW_11)
				{
					if (virtual_table.vt_active_row >= 0)
					{
						if (MemoryLow && virtual_table.vt_items[virtual_table.vt_active_row]->appointment != -1)
						{
							FormPopupForm(FORM_SCH_LOW_MEMORY);
							return TRUE;
						}
					}
					// HENRY 001228 li problem
					//VTSetVirtualTableLayout(&virtual_table);
					//VTVirtualTableSetScrollbar(&virtual_table);
					//VTTransferAllToRT(&virtual_table, TABLE_SCH_DAY_VIEW);
					//TableDrawTable(TABLE_SCH_DAY_VIEW);
					FieldAddKeyInChar(active_object, (BYTE)(Event->para1));
					if (new_appointment)
					{
						virtual_table.vt_items[virtual_table.vt_active_row]->appmt_num = current_appmt_num|0x80000000;
						current_appmt_num ++;
					}
					new_appointment = FALSE;
					virtual_table.vt_items[virtual_table.vt_active_row]->appmt_num |= 0x80000000;
					return TRUE;
				}
			}
			return FALSE;
		case EVT_FIELD_SELECT:
			if (FormGetObjectPointer((ObjectID)Event->eventID, &object_type, (void**)&field_ptr) != TRUE)
				return FALSE;
			if (object_type != FIELD)
				return FALSE;
			
			if (field_ptr->field_attr.field_highlight)
				virtual_table.vt_active_row = (Event->eventID - FIELD_SCH_DAY_VIEW_0) + virtual_table.vt_top_row_num;
			
			if (virtual_table.vt_active_row != -1)
			{
				if ((virtual_table.vt_items[virtual_table.vt_active_row]->ptr->field_string[0] == 0)
					&& virtual_table.vt_items[virtual_table.vt_active_row]->repeat)
				{
					*(UWORD*)repeat_no = virtual_table.vt_items[virtual_table.vt_active_row]->repeat_num;
					repeat_no[4] = 0;
					DataFindBinRecord(sch_repeat_dbid, F_REPEAT_NUM, 0, repeat_no, 4, &rec_id);
					DataDeleteRecord(sch_repeat_dbid, rec_id, FALSE);
					virtual_table.vt_items[virtual_table.vt_active_row]->repeat = FALSE;
					virtual_table.vt_items[virtual_table.vt_active_row]->repeat_num = 0;
				}
			}
			
			done = FALSE;
			expected_active = (Event->eventID - FIELD_SCH_DAY_VIEW_0) + virtual_table.vt_top_row_num;
			if (virtual_table.vt_active_row != -1 && 
				(virtual_table.vt_active_row < virtual_table.vt_top_row_num + virtual_table.vt_num_rows_displayed) &&
				(virtual_table.vt_active_row >= virtual_table.vt_top_row_num))
			{
				SchedulerDayViewNotHighlightString((ObjectID)(virtual_table.vt_active_row - 
					virtual_table.vt_top_row_num + STRING_SCH_DAY_VIEW_0));
				StringDrawString((ObjectID)(virtual_table.vt_active_row - 
					virtual_table.vt_top_row_num +
					STRING_SCH_DAY_VIEW_0));
			}
			output = SchedulerDayViewNormal(&virtual_table, TABLE_SCH_DAY_VIEW, &start_row,
				&end_row, &start_deleted, &end_deleted);
			
			SchedulerDayViewDrawAppointmentColumn(&virtual_table, TABLE_SCH_DAY_VIEW);
			if (output == VT_TABLE_CHANGED)
			{
				if (end_deleted == TRUE && end_row < expected_active)
					expected_active --;
				if (start_deleted == TRUE && start_row < expected_active)
					expected_active --;
				
				if (virtual_table.vt_active_row >= 0)
				{
					if (MemoryLow && virtual_table.vt_items[virtual_table.vt_active_row]->appointment == -1)
						virtual_table.vt_active_row = -1;
					else virtual_table.vt_active_row = expected_active;
				}
				
				if (virtual_table.vt_active_row == virtual_table.vt_num_rows)
				{
					virtual_table.vt_active_row = -1;
					if (virtual_table.vt_top_row_num != 0)
						virtual_table.vt_top_row_num --;
					LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT);
					done = TRUE;
				}
				
				if (done == FALSE && virtual_table.vt_active_row >= 0)
				{
					SchedulerDayViewHighlightString((ObjectID)(virtual_table.vt_active_row - 
						virtual_table.vt_top_row_num +
						STRING_SCH_DAY_VIEW_0));
					StringDrawString((ObjectID)(virtual_table.vt_active_row - 
						virtual_table.vt_top_row_num + STRING_SCH_DAY_VIEW_0));
				}
				SchedulerDayViewSetScreen(&virtual_table);
				VTSetVirtualTableLayout(&virtual_table);
				VTVirtualTableSetScrollbar(&virtual_table);
				VTTransferAllToRT(&virtual_table, TABLE_SCH_DAY_VIEW);
				if (virtual_table.vt_active_row >= 0)
					if (MemoryLow && virtual_table.vt_items[virtual_table.vt_active_row]->appointment == -1)
					{
						virtual_table.vt_active_row = -1;
						LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT);
					}
			}
			else
			{
				if (virtual_table.vt_active_row != -1 && new_appointment == TRUE)
				{
					new_appointment = FALSE;
					virtual_table.vt_items[virtual_table.vt_active_row]->appointment = -1;
				}
				
#ifdef DEBUG
                if (virtual_table.vt_active_row >= 0)
					if (MemoryLow && virtual_table.vt_items[virtual_table.vt_active_row]->appointment == -1)
						printf("\n FIELD_SELECT 2");
#endif
					
					if (virtual_table.vt_active_row >= 0)
					{
						if (MemoryLow && virtual_table.vt_items[virtual_table.vt_active_row]->appointment == -1)
							virtual_table.vt_active_row = -1;
						else virtual_table.vt_active_row = (Event->eventID - FIELD_SCH_DAY_VIEW_0) + virtual_table.vt_top_row_num;
					}
					if (virtual_table.vt_active_row >= 0)
					{
						SchedulerDayViewHighlightString((ObjectID)(virtual_table.vt_active_row - virtual_table.vt_top_row_num + STRING_SCH_DAY_VIEW_0));
						StringDrawString((ObjectID)(virtual_table.vt_active_row - virtual_table.vt_top_row_num + STRING_SCH_DAY_VIEW_0));
					}
					
					VTTransferFieldToVT(&virtual_table, TABLE_SCH_DAY_VIEW);
					if (virtual_table.vt_active_row >= 0)
						if (MemoryLow && virtual_table.vt_items[virtual_table.vt_active_row]->appointment == -1)
						{
							virtual_table.vt_active_row = -1;
							LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT);
						}
			}
			if (done == FALSE)
				outcome = SchedulerDayViewTapFieldNewAppointment(&virtual_table, TABLE_SCH_DAY_VIEW);
			if (outcome == FALSE && output == VT_TABLE_CHANGED)
			{
				SchedulerTimeSettingsDeleteAllEmptyAppmts(&virtual_table);
				SchedulerTimeSettingsAddAppmts(&virtual_table);
				VTSetVirtualTableLayout(&virtual_table);
				VTVirtualTableSetScrollbar(&virtual_table);
				VTTransferAllToRT(&virtual_table, TABLE_SCH_DAY_VIEW);
				TableDrawTable(TABLE_SCH_DAY_VIEW);
				SchedulerDayViewDrawAppointmentColumn(&virtual_table, TABLE_SCH_DAY_VIEW);
			}
			SchedulerSaveAndSetAlarm();
			if (MemoryLow && virtual_table.vt_active_row == -1)
				FormPopupForm(FORM_SCH_LOW_MEMORY);
			
			return TRUE;
		case EVT_FIELD_MODIFIED:
			if (virtual_table.vt_active_row == -1)
				return FALSE;
			if (virtual_table.vt_items[virtual_table.vt_active_row]->repeat)
			{
				SchedulerSaveRepeatSettings(TRUE, TRUE);
				return TRUE;
			}
			if (new_appointment)
			{
				virtual_table.vt_items[virtual_table.vt_active_row]->appmt_num = current_appmt_num|0x80000000;
				current_appmt_num ++;
			}
			new_appointment = FALSE;
			virtual_table.vt_items[virtual_table.vt_active_row]->appmt_num |= 0x80000000;
			return TRUE;
		case EVT_FIELD_CHANGED:
			SchedulerDayViewSetScreen(&virtual_table);
			VTTransferFieldToVT(&virtual_table, TABLE_SCH_DAY_VIEW);
			if (VTKeyInChangeVirtualTable(&virtual_table) == TRUE)
			{
				VTTransferAllToRT(&virtual_table, TABLE_SCH_DAY_VIEW);
				TableDrawTable(TABLE_SCH_DAY_VIEW);
				SchedulerDayViewDrawAppointmentColumn(&virtual_table, TABLE_SCH_DAY_VIEW);
				if (virtual_table.vt_active_row != -1)
					FormSetFormActiveObject(FORM_SCH_DAY_VIEW, (ObjectID)(virtual_table.vt_active_row - virtual_table.vt_top_row_num + FIELD_SCH_DAY_VIEW_0));
			}
			return TRUE;
#ifdef PR31700
		case EVT_IO_KEY_CTRL:
			if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
			{
				if (Event->para2 == IO_UP_ARROW)
					ScrollbarHardButtonSetScrollbar(virtual_table.vt_scrollbar_id, SCROLLBAR_UP_ARROW);
				else if (Event->para2 == IO_DOWN_ARROW)
                    ScrollbarHardButtonSetScrollbar(virtual_table.vt_scrollbar_id, SCROLLBAR_DOWN_ARROW);
				return TRUE;
			}
			return FALSE;
#endif
		case EVT_SCROLLBAR_SELECT:
			ScrollbarDrawScrollbar(SCROLLBAR_SCH_DAY_VIEW);
			break;
		case EVT_SCROLLBAR_REPEAT:
			SchedulerDayViewSetScreen(&virtual_table);
			output = VTScrollbarSetVirtualTable(&virtual_table, Event, &row_to_be_drawn);
			if (output == VT_TABLE_CHANGED)
			{
				if (Event->eventType == EVT_SCROLLBAR_SELECT ||
					(Event->eventType == EVT_SCROLLBAR_REPEAT && (Event->para1 != Event->para2)))
				{
					VTTransferAllToRT(&virtual_table, TABLE_SCH_DAY_VIEW);
					TableDrawTable(TABLE_SCH_DAY_VIEW);
					SchedulerDayViewDrawAppointmentColumn(&virtual_table, TABLE_SCH_DAY_VIEW);
				}
				return TRUE;
			}
			else if (output == VT_FIELD_CHANGED)
			{
				VTTransferFieldToRT(&virtual_table, TABLE_SCH_DAY_VIEW);
				FieldDrawField((ObjectID)(row_to_be_drawn - virtual_table.vt_top_row_num + FIELD_SCH_DAY_VIEW_0));
				FormGetObjectPointer(TABLE_SCH_DAY_VIEW, &object_type, (void**)&table_ptr);
				for (row_to_be_drawn = 0; row_to_be_drawn < table_ptr->table_num_row_display; row_to_be_drawn++)
				{
					FormGetObjectPointer((ObjectID)(row_to_be_drawn + FIELD_SCH_DAY_VIEW_0), &object_type, (void**)&field_ptr);
					field_ptr->field_attr.field_drawn = TRUE;
				}
				return TRUE;
			}
			break;
		case EVT_FORM_OPEN:
#ifdef DEBUG
			printf("\n in scheduler day view event form open point1");
#endif
			
#ifdef PR31700
			InlaySetEnableStatus(TRUE);
			AlarmMgrEnable(TRUE);
			SystemSetMappedHardwareKeyStatus(TRUE);
			BatteryWarningSetEnableStatus(TRUE);
			SchedulerDayViewSetScreen(&virtual_table);
#endif
			for (count = 0; count < virtual_table.vt_num_rows; count++)
			{
				virtual_table.vt_items[count]->ptr->bounds.height = 9;
				virtual_table.vt_items[count]->ptr->screen_bounds.height = 9;
				virtual_table.vt_row_height[count] = 9; 
			}
			VTSetVirtualTableLayout(&virtual_table);
			VTVirtualTableSetScrollbar(&virtual_table);
			VTTransferAllToRT(&virtual_table, TABLE_SCH_DAY_VIEW);
			SchedulerGetDayViewDate(date);
			SchedulerDayViewSetToDoAnn(date);
			FormDrawForm(FORM_SCH_DAY_VIEW);
			SchedulerDayViewDrawAppointmentColumn(&virtual_table, TABLE_SCH_DAY_VIEW);
			SchedulerSaveAndSetAlarm();
#ifdef DEBUG_MICH
			printf("\nScheduler day view event form open point 2");
			DataTotalRecord(sch_repeat_dbid, &total);
			for(i = 0; i < total; i++)
			{
				printf("\n\ni = %ld", i);
				DataOpenRecord(sch_repeat_dbid, i, &record, NULL);
				printf("\nrecord = %ld", record);
				DataGetField(sch_repeat_dbid, record, F_REPEAT_ATTR, (BYTE**)&repeat_attr, &byte_read);
				printf("\nrepeat method = %ld", repeat_attr->method);
				printf("\nrepeat times = %ld", repeat_attr->every_info);
				printf("\nrepeat data = %ld", repeat_attr->every_data);
				printf("\nrepeat n_week = %ld", repeat_attr->n_week);
				qfree(repeat_attr);
				DataCloseRecord(sch_repeat_dbid, record);
			}
#endif
			return TRUE;
		case EVT_INLAY_SELECT:
			if ((Event->para1 == INLAY_OK && virtual_table.vt_active_row == -1) || Event->para1 == INLAY_EXIT)
			{
				SysGetAppID(MAINMENU, &appid);
				EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
				EvtAppendEvt(EVT_APP_LAUNCH, appid, 0, 0, NULL);
			}
			else if (Event->para1 == INLAY_OK && virtual_table.vt_active_row != -1)
			{
				FormSetFormActiveObject(FORM_SCH_DAY_VIEW, BUTTON_SCH_DAY_VIEW_NEW);
				LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT);
				FieldSetInsertPointOff((ObjectID)(virtual_table.vt_active_row - virtual_table.vt_top_row_num + FIELD_SCH_DAY_VIEW_0));
				if (virtual_table.vt_active_row != -1 && 
					(virtual_table.vt_active_row < virtual_table.vt_top_row_num + virtual_table.vt_num_rows_displayed) &&
					(virtual_table.vt_active_row >= virtual_table.vt_top_row_num))
				{
					SchedulerDayViewNotHighlightString((ObjectID)(virtual_table.vt_active_row - 
						virtual_table.vt_top_row_num +
						STRING_SCH_DAY_VIEW_0));
					StringDrawString((ObjectID)(virtual_table.vt_active_row - 
						virtual_table.vt_top_row_num + STRING_SCH_DAY_VIEW_0));
				}
				output = SchedulerDayViewNormal(&virtual_table, TABLE_SCH_DAY_VIEW, &start_row,
					&end_row, &start_deleted, &end_deleted);
				
				if (virtual_table.vt_active_row != -1 && new_appointment == TRUE)
				{
					new_appointment = FALSE;
					virtual_table.vt_items[virtual_table.vt_active_row]->appointment = -1;
				}
				virtual_table.vt_active_row = -1;
				if (KeyboardCheckKeyboardStatus())
				{
					keyboard_up = TRUE;
					KeyboardSetKeyboardStatus(FALSE);
					SchedulerDayViewSetScreen(&virtual_table);
				}
				SchedulerTimeSettingsDeleteAllEmptyAppmts(&virtual_table);
				SchedulerTimeSettingsAddAppmts(&virtual_table);
				VTSetVirtualTableLayout(&virtual_table);
				VTVirtualTableSetScrollbar(&virtual_table);
				VTTransferAllToRT(&virtual_table, TABLE_SCH_DAY_VIEW);
				
				if (keyboard_up)
					FormDrawForm(FORM_SCH_DAY_VIEW);
				else TableDrawTable(TABLE_SCH_DAY_VIEW);
				SchedulerDayViewDrawAppointmentColumn(&virtual_table, TABLE_SCH_DAY_VIEW);
				SchedulerSaveAndSetAlarm();
				return TRUE;
			}
			return TRUE;
		default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	SchedulerAlarmSettings
* Purpose: 	This function is the event handler for the FORM_SCH_ALARM
page of the Scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerAlarmSettings(EvtType* Event)
{
	ObjectID control_id;
	Control *control_ptr;
	BYTE object_type;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_ALARM_ON || Event->para1 == SLETTER_ALARM_ON)
			{
				FormSetControlGroupSelection(FORM_SCH_ALARM, PUSHBUTTON_SCH_ALARM_ON);
				Event->eventType    = EVT_CONTROL_SELECT;
				Event->eventID      = PUSHBUTTON_SCH_ALARM_ON;
				Event->evtPBP       = NULL;
			}
			else if (Event->para1 == LLETTER_ALARM_OFF || Event->para1 == SLETTER_ALARM_OFF)
			{
				FormSetControlGroupSelection(FORM_SCH_ALARM, PUSHBUTTON_SCH_ALARM_OFF);
				Event->eventType    = EVT_CONTROL_SELECT;
				Event->eventID      = PUSHBUTTON_SCH_ALARM_OFF;
				Event->evtPBP       = NULL;
			}            	            
			else if (Event->para1 == LLETTER_ALARM_VOICE || Event->para1 == LLETTER_ALARM_VOICE)
			{
				if (FormGetObjectPointer(PUSHBUTTON_SCH_ALARM_VOICE, &object_type, (void**)&control_ptr) == TRUE)
				{
					if (control_ptr->control_attr.control_enable)
					{   
						FormSetControlGroupSelection(FORM_SCH_ALARM, PUSHBUTTON_SCH_ALARM_VOICE);
						Event->eventType    = EVT_CONTROL_SELECT;
						Event->eventID      = PUSHBUTTON_SCH_ALARM_VOICE;
						Event->evtPBP       = NULL;
					}
				}
			}
			else if (Event->para1 == LLETTER_ALARM_TONE || Event->para1 == LLETTER_ALARM_TONE)
			{
				if (FormGetObjectPointer(PUSHBUTTON_SCH_ALARM_TONE, &object_type, (void**)&control_ptr) == TRUE)
				{
					if (control_ptr->control_attr.control_enable)
					{
						FormSetControlGroupSelection(FORM_SCH_ALARM, PUSHBUTTON_SCH_ALARM_TONE);
						Event->eventType    = EVT_CONTROL_SELECT;
						Event->eventID      = PUSHBUTTON_SCH_ALARM_TONE;
						Event->evtPBP       = NULL;
					}
				}
			}
			else if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
				Event->eventID      = BITMAP_SCH_ALARM_X;
				Event->evtPBP       = NULL;
			}
			else if (Event->para1 == LLETTER_ALARM_TIME)
			{
#ifdef PR31700
                ControlPopupPopupTrigger(POPUP_TRIGGER_SCH_ALARM_TIME);
#endif
				return TRUE;
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_CONTROL_POPUP_SELECT:
		alarm_settings.change = TRUE;
		alarm_settings.alarm_time = (BYTE)(Event->para1) + 2;
		return TRUE;
	case EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{
		case PUSHBUTTON_SCH_ALARM_VOICE:
		/*
		if (virtual_table.vt_items[virtual_table.vt_active_row]->repeat)
		{
		FormPopupForm(FORM_REPEAT_NO_VOICE);
		return TRUE;
		}
			*/
			if ((alarm_settings.change == TRUE && alarm_settings.recorded == TRUE &&
				DataRecordInfo(sch_voice_dbid, alarm_settings.temp_recid, NULL, NULL, NULL, NULL, NULL)) ||
				(alarm_settings.change == FALSE && time_settings.alarm == VOICE_ALARM &&
				DataRecordInfo(time_settings.dbid, time_settings.recid, NULL, NULL, NULL, NULL, NULL)) ||
				(alarm_settings.change == FALSE && time_settings.alarm == VOICE_NOT_ALARM &&
				DataRecordInfo(time_settings.dbid, time_settings.recid, NULL, NULL, NULL, NULL, NULL)))
				FormPopupForm(FORM_SCH_VOICE_EXISTS);
			else 
			{
				FormInitAllFormObjects(FORM_SCH_REC);
				FormPopupForm(FORM_SCH_REC);
				recorded = FALSE;
			}
			SchedulerSaveAndSetAlarm();
			return TRUE;	
		case PUSHBUTTON_SCH_ALARM_TONE:
			alarm_settings.change = TRUE;
			alarm_settings.alarm = TONE_ALARM;
			return TRUE;	
		case PUSHBUTTON_SCH_ALARM_ON:
			alarm_settings.change = TRUE;
			ControlGetPushedPushButton(FORM_SCH_ALARM, 1, &control_id);
			if (control_id == PUSHBUTTON_SCH_ALARM_VOICE)
				alarm_settings.alarm = VOICE_ALARM;
			else alarm_settings.alarm = TONE_ALARM;
			FormGetObjectPointer(PUSHBUTTON_SCH_ALARM_VOICE, &object_type, (void**)&control_ptr);
			control_ptr->control_attr.control_enable = TRUE;
			FormGetObjectPointer(PUSHBUTTON_SCH_ALARM_TONE, &object_type, (void**)&control_ptr);
			control_ptr->control_attr.control_enable = TRUE;
			FormGetObjectPointer(POPUP_TRIGGER_SCH_ALARM_TIME, &object_type, (void**)&control_ptr);
			control_ptr->control_attr.control_enable = TRUE;
			return TRUE;
		case PUSHBUTTON_SCH_ALARM_OFF:
			alarm_settings.change = TRUE;
			alarm_settings.alarm = NO_ALARM;
			FormGetObjectPointer(PUSHBUTTON_SCH_ALARM_VOICE, &object_type, (void**)&control_ptr);
			control_ptr->control_attr.control_enable = FALSE;
			FormGetObjectPointer(PUSHBUTTON_SCH_ALARM_TONE, &object_type, (void**)&control_ptr);
			control_ptr->control_attr.control_enable = FALSE;
			FormGetObjectPointer(POPUP_TRIGGER_SCH_ALARM_TIME, &object_type, (void**)&control_ptr);
			control_ptr->control_attr.control_enable = FALSE;
			return TRUE;
		default: return FALSE;
		}
		return FALSE;
		case EVT_FORM_OPEN:
			ControlGetPushedPushButton(FORM_SCH_ALARM, 1, &control_id);
			if (alarm_settings.change == TRUE && alarm_settings.recorded == FALSE &&
				control_id == PUSHBUTTON_SCH_ALARM_VOICE && alarm_settings.alarm != VOICE_ALARM)
			{
				FormSetControlGroupSelection(FORM_SCH_ALARM, PUSHBUTTON_SCH_ALARM_TONE);
				alarm_settings.change = TRUE;
				alarm_settings.alarm = TONE_ALARM;
			}
			FormDrawForm(FORM_SCH_ALARM);
#ifdef DEBUG_REPEAT
			printf("\n alarm count initial = %ld", alarm_count);
#endif
			return TRUE;
		case EVT_BITMAP_SELECT:
			if (alarm_settings.change == TRUE)
			{
				if (virtual_table.vt_items[virtual_table.vt_active_row]->repeat && alarm_settings.change)
				{
					if (virtual_table.vt_items[virtual_table.vt_active_row]->alarm)
					{
						prev_status = ALARM_CHANGE_STATUS;
					}
					else
					{
						prev_status = ALARM_SET_STATUS;
					}
					
					repeat_settings.alarm = alarm_settings.alarm;
					repeat_settings.alarm_time = alarm_settings.alarm_time;
					
					if (virtual_table.vt_items[virtual_table.vt_active_row]->recid == 0)
					{
						if (repeat_settings.alarm == VOICE_ALARM)
							repeat_settings.voice_recid = alarm_settings.temp_recid;
						else repeat_settings.voice_recid = 0;
					}
					repeat_settings.alarm_num = time_settings.alarm_num;
					FormPopupForm(FORM_REPEAT_APPLY_ALL);
					return TRUE;
				}
				FormPopupForm(FORM_SCH_ALARM_SAVE_CHANGES);
			}
			else FormPopupForm(FORM_SCH_DAY_VIEW);
			return TRUE;
		case EVT_INLAY_SELECT:
			if (Event->para1 == INLAY_OK)
			{
				// Check whether repeat flag is set before alaram is set
				//------------------------------------------------------------------------------
				//----------------- modified at 17052000 ---------------------------------------
				//				if (virtual_table.vt_items[virtual_table.vt_active_row]->repeat)
				if (virtual_table.vt_items[virtual_table.vt_active_row]->repeat && alarm_settings.change)
					//------------------------------------------------------------------------------
				{
					
					if (virtual_table.vt_items[virtual_table.vt_active_row]->alarm)
					{
						prev_status = ALARM_CHANGE_STATUS;
					}
					else
					{
						prev_status = ALARM_SET_STATUS;
					}
					
					//					prev_status = ALARM_STATUS;
					repeat_settings.alarm = alarm_settings.alarm;
					repeat_settings.alarm_time = alarm_settings.alarm_time;
					
					
#ifdef DEBUG_VOICE_ALARM
					printf("\n repeat_settings.alarm = %ld", repeat_settings.alarm);
					printf("\n repeat_settings.alarm_time = %ld", repeat_settings.alarm_time);
#endif
					//---------------------------------------------------------------------------------------------
					//------------------------ modified at 17052000 -----------------------------------------------
					if (virtual_table.vt_items[virtual_table.vt_active_row]->recid == 0)
					{
						if (repeat_settings.alarm == VOICE_ALARM)
							repeat_settings.voice_recid = alarm_settings.temp_recid;
						else repeat_settings.voice_recid = 0;
					}
					repeat_settings.alarm_num = time_settings.alarm_num;
					//---------------------------------------------------------------------------------------------
					
#ifdef DEBUG_VOICE_ALARM
					printf("\n ========= AlarmSettings =========");
					printf("\n repeat_settings.voice_recid = %ld", repeat_settings.voice_recid);
#endif
					FormPopupForm(FORM_REPEAT_APPLY_ALL);
					return TRUE;
				}
				SchedulerAlarmSave();
				FormPopupForm(FORM_SCH_DAY_VIEW);
			}
			else if (Event->para1 == INLAY_EXIT && alarm_settings.change == TRUE)
				FormPopupForm(FORM_SCH_ALARM_SAVE_CHANGES);
			else FormPopupForm(FORM_SCH_DAY_VIEW);
			return TRUE;
		default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	SchedulerAlarmSaveChanges
* Purpose: 	This function is the event handler for the FORM_SCH_ALARM_SAVE_CHANGES
page of the Scheduler application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerAlarmSaveChanges(EvtType* Event)
{
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
				Event->eventID      = BUTTON_SCH_ALARM_SAVE_CHANGES_YES;
				Event->evtPBP       = NULL;
            }
            else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
            {
				Event->eventType    = EVT_CONTROL_SELECT;
				Event->eventID      = BUTTON_SCH_ALARM_SAVE_CHANGES_NO;
				Event->evtPBP       = NULL;
            }
			else if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
				Event->eventID      = BITMAP_SCH_ALARM_SAVE_CHANGES_X;
				Event->evtPBP       = NULL;
			}
       	}
    }
	
	switch (Event->eventType)
	{
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_SCH_ALARM_SAVE_CHANGES_YES)
		{
			if (virtual_table.vt_items[virtual_table.vt_active_row]->repeat && alarm_settings.change)
			{
				if (virtual_table.vt_items[virtual_table.vt_active_row]->alarm)
					prev_status = ALARM_CHANGE_STATUS;
				else
					prev_status = ALARM_SET_STATUS;
				
				repeat_settings.alarm = alarm_settings.alarm;
				repeat_settings.alarm_time = alarm_settings.alarm_time;
				
				if (virtual_table.vt_items[virtual_table.vt_active_row]->recid == 0)
				{
					if (repeat_settings.alarm == VOICE_ALARM)
						repeat_settings.voice_recid = alarm_settings.temp_recid;
					else repeat_settings.voice_recid = 0;
				}
				repeat_settings.alarm_num = time_settings.alarm_num;
				FormPopupForm(FORM_REPEAT_APPLY_ALL);
				return TRUE;
			}
			SchedulerAlarmSave();
			FormPopupForm(FORM_SCH_DAY_VIEW);
		}
		else FormPopupForm(FORM_SCH_DAY_VIEW);
		return TRUE;
	case EVT_BITMAP_SELECT:
		FormPopupForm(FORM_SCH_ALARM);
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SCH_ALARM_SAVE_CHANGES);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	SchedulerAlarmAppmtSelectFirst
* Purpose: 	This function is the event handler for the FORM_SCH_ALARM_SELECT
page of the Scheduler application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerAlarmAppmtSelectFirst(EvtType *Event)
{
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
				Event->eventID      = BITMAP_SCH_ALARM_SELECT_X;
				Event->evtPBP       = NULL;
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_BITMAP_SELECT:
		FormPopupForm(FORM_SCH_DAY_VIEW);
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			FormPopupForm(FORM_SCH_DAY_VIEW);
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SCH_ALARM_SELECT);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	SchedulerTimeSettings
* Purpose: 	This function is the event handler for the FORM_SCH_TIME_SETTINGS
page of the Scheduler application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerTimeSettings(EvtType* Event)
{
	WORD active_row;
	BYTE repeat_no[5], *start, *end, *time_start, *time_end;
	UWORD byte_read, rec_num;
	RecordID rec_id;
	BYTE start_hr, start_min, start_format;
	BYTE end_hr, end_min, end_format;
	
	//Bug Fixed 5-Feb-2001
	//Delete all the codes added in "Bug Fixed 1-Feb-2001 "
	switch (Event->eventType)
	{
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK)
		{
			if (prev_status != NEW_STATUS)
			{
				StringGetText(STRING_SCH_TIME_1, &time_start);
				StringGetText(STRING_SCH_TIME_3, &time_end);
				SchedulerTimeSettingsStringToHourMinute(time_start, &start_hr, &start_min, &start_format);
				SchedulerTimeSettingsStringToHourMinute(time_end, &end_hr, &end_min, &end_format);
				active_row = time_settings.row_num;
				if (active_row >= 0 && active_row <= virtual_table.vt_num_rows)
				{
					if (virtual_table.vt_items[active_row]->repeat)
					{
						*(UWORD*)repeat_no = virtual_table.vt_items[active_row]->repeat_num;
						repeat_no[4] = 0;
						DataFindBinRecord(sch_repeat_dbid, F_REPEAT_NUM, 0, repeat_no, 4, &rec_id);
						DataRecIDtoNum(sch_repeat_dbid, rec_id, &rec_num);
						DataOpenRecord(sch_repeat_dbid, rec_num, &rec_id, NULL);
						DataGetField(sch_repeat_dbid, rec_id, F_START_TIME, &start, &byte_read);
						DataGetField(sch_repeat_dbid, rec_id, F_END_TIME, &end, &byte_read);
						if (start_hr == start[3] && start_min == start[4] && end_hr == end[3] && end_min == end[4])
						{
							qfree(start);
							qfree(end);
							DataCloseRecord(sch_repeat_dbid, rec_id);
						}
						else
						{
							qfree(start);
							qfree(end);
							DataCloseRecord(sch_repeat_dbid, rec_id);
							repeat_settings.alarm = virtual_table.vt_items[active_row]->alarm;
							repeat_settings.alarm_time = virtual_table.vt_items[active_row]->alarm_time;
							repeat_settings.alarm_num = virtual_table.vt_items[active_row]->alarm_num;
							//Michelle 310100
							repeat_settings.voice_recid = virtual_table.vt_items[active_row]->recid;
							//end 310100
							repeat_settings.repeat_num = virtual_table.vt_items[active_row]->repeat_num;
							repeat_settings.every_data = virtual_table.vt_items[active_row]->repeat_every_data;
							repeat_settings.every_info = virtual_table.vt_items[active_row]->repeat_every_info;
							repeat_settings.method = virtual_table.vt_items[active_row]->repeat_method;
							FormDrawForm(FORM_SCH_DAY_VIEW);
							prev_status = TIME_STATUS;
							FormPopupForm(FORM_REPEAT_APPLY_ALL);
							return TRUE;
						}
					}
				}
			}
			SchedulerTimeSettingsOK(&virtual_table);
		}
		else if (Event->para1 == INLAY_EXIT)
			SchedulerTimeSettingsExit(&virtual_table);
		return TRUE;
	case PEN_EVENT:
		SchedulerPenDownOnString(Event);
		return TRUE;
	case EVT_LIST_SELECT:
		SchedulerListSelectToTimeSettingsScreen(Event);
		break;
	case EVT_FORM_OPEN:
		if (time_settings.new_appointment && !time_settings.new_appointment_with_time)
		{
			hour_difference = 1;
			minute_difference = 0;
		}
		else
		{
			hour_difference = time_settings.hour_end - time_settings.hour_start;
			minute_difference = time_settings.minute_end - time_settings.minute_start;		
			if (minute_difference < 0)
			{
                minute_difference = 60 + minute_difference;
				hour_difference --;
			}			
		}					
		FormDrawForm(FORM_SCH_TIME_SETTINGS);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	SchedulerRecordVoice
* Purpose: 	This function is the event handler for the FORM_SCH_REC
page of the Scheduler application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerRecordVoice(EvtType* Event)
{
	BYTE        object_type;
	Bitmap      *bitmap_ptr;
	UWORD       field_size;
	Err         Error;
	UWORD	    count = 1;
	Scrollbar   *scroll_ptr;
	
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
            if (Event->para1 == LLETTER_REC || Event->para1 == SLETTER_REC)
            {
                if (FormGetObjectPointer(BITMAP_SCH_REC_RECORD, &object_type, (void**)&bitmap_ptr) == TRUE)
                {
                    if (bitmap_ptr->bitmap_attr.bitmap_visible)
                    {
						Event->eventType    = EVT_BITMAP_SELECT;
                        Event->eventID      = BITMAP_SCH_REC_RECORD;
                        Event->evtPBP       = NULL;
                    }
                }
            }
            else if (Event->para1 == LLETTER_PAUSE || Event->para1 == SLETTER_PAUSE)
            {
                if (FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr) == TRUE)
                {
                    if (bitmap_ptr->bitmap_attr.bitmap_visible)
                    {
						Event->eventType    = EVT_BITMAP_SELECT;
                        Event->eventID      = BITMAP_SCH_REC_PAUSE;
                        Event->evtPBP       = NULL;
                    }
                }
            }
            else if (Event->para1 == LLETTER_STOP || Event->para1 == SLETTER_STOP)
            {
                if (FormGetObjectPointer(BITMAP_SCH_REC_STOP, &object_type, (void**)&bitmap_ptr) == TRUE)
                {
                    if (bitmap_ptr->bitmap_attr.bitmap_visible)
                    {
						Event->eventType    = EVT_BITMAP_SELECT;
                        Event->eventID      = BITMAP_SCH_REC_STOP;
                        Event->evtPBP       = NULL;
                    }
                }
            }
        }
    }
	
	
	switch (Event->eventType)
	{
#ifdef PR31700
	case EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS)
		{
			if (Event->para2 == IO_SOUND_RECORD)
			{
				FormGetObjectPointer(BITMAP_SCH_REC_RECORD, &object_type, (void**)&bitmap_ptr);
				if (bitmap_ptr->bitmap_attr.bitmap_visible == TRUE)
				{
					if (CheckBatteryLow() == 1)
					{
						rec_stop = TRUE;
						FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
						bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
						bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
						FormGetObjectPointer(BITMAP_SCH_REC_RECORD, &object_type, (void**)&bitmap_ptr);
						bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
						BitmapDrawBitmap(BITMAP_SCH_REC_RECORD);
#ifdef PR31700
						SndStop();
#endif
						DataCloseRecord(sch_voice_dbid, rec_rec_id);
#ifdef PR31700
						InlaySetEnableStatus(TRUE);
						AlarmMgrEnable(TRUE);
						SystemSetMappedHardwareKeyStatus(TRUE);
						BatteryWarningSetEnableStatus(TRUE);
#endif
						time_count = 0;
						FormPopupForm(FORM_SCH_VOICE_LOW_BATTERY);
						low_battery_form_id = FORM_SCH_REC;
						return TRUE;
					}
					FormGetObjectPointer(BITMAP_SCH_REC_RECORD, &object_type, (void**)&bitmap_ptr);
					bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
					bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
					FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
					bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
					BitmapDrawBitmap(BITMAP_SCH_REC_PAUSE);
					
					if (rec_stop == TRUE)
					{
#ifdef PR31700
						InlaySetEnableStatus(FALSE);
						AlarmMgrEnable(FALSE);
						SystemSetMappedHardwareKeyStatus(FALSE);
						BatteryWarningSetEnableStatus(FALSE);
#endif
						if (recorded)
							DataDeleteRecord(sch_voice_dbid, rec_rec_id, FALSE);
						
						Error = DataNewRecord(sch_voice_dbid, 0, 3, &rec_rec_id);
						count = 1;
						DataWriteField(sch_voice_dbid, rec_rec_id, 2, sizeof(UWORD), (BYTE*)&count);
						rec_stop = FALSE;
#ifdef WITHSOUND
#ifdef PR31700
						SndRec(sch_voice_dbid, rec_rec_id, 0);
#endif
#endif
						time_count = 0;
					}
					else
#ifdef WITHSOUND
#ifdef PR31700
						SndRERec(sch_voice_dbid, rec_rec_id, 0);
#endif
#endif
					recorded = TRUE;
					return TRUE;
					
				}
				else
				{
					FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
					bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
					bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
					FormGetObjectPointer(BITMAP_SCH_REC_RECORD, &object_type, (void**)&bitmap_ptr);
					bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
					BitmapDrawBitmap(BITMAP_SCH_REC_RECORD);
#ifdef WITHSOUND
#ifdef PR31700
					SndPause();
#endif
#endif
					return TRUE;
				}
			}
			else if (Event->para2 == IO_SOUND_STOP)
			{
				if (rec_stop) return FALSE;
				rec_stop = TRUE;
				FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_SCH_REC_RECORD, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_SCH_REC_RECORD);
#ifdef PR31700
				SndStop();
#endif
				DataCloseRecord(sch_voice_dbid, rec_rec_id);
#ifdef PR31700
				InlaySetEnableStatus(TRUE);
				AlarmMgrEnable(TRUE);
				SystemSetMappedHardwareKeyStatus(TRUE);
				BatteryWarningSetEnableStatus(TRUE);
#endif
				time_count = 0;
				return TRUE;
			}
			 }
			 return FALSE;
#endif
#ifdef WITHSOUND
#ifdef PR31700
        case POWER_EVENT:
            if (Event->eventID == BAT_MAIN_LOW)
            {
                if (rec_stop) return FALSE;
#ifdef PR31700
				SndStop();
#endif
				rec_stop = TRUE;
				FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_SCH_REC_RECORD, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_SCH_REC_RECORD);
				DataCloseRecord(sch_voice_dbid, rec_rec_id);
#ifdef PR31700
                InlaySetEnableStatus(TRUE);
                AlarmMgrEnable(TRUE);
                SystemSetMappedHardwareKeyStatus(TRUE);
                BatteryWarningSetEnableStatus(TRUE);
#endif
				return TRUE;
            }
            return FALSE;
        case SND_MGR_EVT:
            if (Event->eventID == LOW_MEM)
			{
				rec_stop = TRUE;
				FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_SCH_REC_RECORD, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_SCH_REC_RECORD);
				SndStop();
#ifdef DEBUG_NO_MEM
                printf("\n recorded = %ld", recorded);
#endif
				
				if (recorded)
                    DataFieldSize(sch_voice_dbid, rec_rec_id, 0, &field_size);
				
#ifdef DEBUG_NO_MEM
                printf("\n field_size = %ld", field_size);
#endif
				
				
                if (field_size <= 0 && recorded)
				{
					DataDeleteRecord(sch_voice_dbid, rec_rec_id, FALSE);
					recorded = FALSE;
				}
				
				DataCloseRecord(sch_voice_dbid, rec_rec_id);
                time_count = 0;
				printf("\n Point 1");
				FormPopupForm(FORM_SCH_LOW_MEMORY);
#ifdef DEBUG_NO_MEM
                SysDisableDebug();
#endif
				return TRUE;
				
			}
            else if (Event->eventID == REC_TIME && Event->para1)
            {
#ifdef DEBUG
                printf("\n =========== REC_TIME ===========");
#endif
                time_count++;
#ifdef DEBUG
                printf("\n time_count = %ld", time_count);
                printf("\n Scrollbar Settings = %ld", time_count%15);
#endif
                ScrollbarSetScrollbar(SCROLLBAR_SCH_REC, time_count%15, 14, 0, 1, 15);
                ScrollbarDrawScrollbar(SCROLLBAR_SCH_REC);
                return TRUE;
            }
			return FALSE;
#endif
#endif
		case EVT_INLAY_SELECT:
			if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			{
				rec_stop = TRUE;
#ifdef PR31700
                SndStop();
#endif
				
				if (recorded)
				{
                    if (alarm_settings.change == TRUE &&
                        alarm_settings.recorded == TRUE)
                        DataDeleteRecord(sch_voice_dbid, alarm_settings.temp_recid, FALSE);
					alarm_settings.alarm = VOICE_ALARM;
					alarm_settings.change = TRUE;
                    alarm_settings.temp_recid = rec_rec_id;
					alarm_settings.recorded = TRUE;
				}
				DataCloseRecord(sch_voice_dbid, rec_rec_id);
				recorded = FALSE;
				FormPopupForm(FORM_SCH_ALARM);
#ifdef PR31700
                InlaySetEnableStatus(TRUE);
                AlarmMgrEnable(TRUE);
                SystemSetMappedHardwareKeyStatus(TRUE);
                BatteryWarningSetEnableStatus(TRUE);
#endif
                time_count = 0;
				return TRUE;
			}
			return TRUE;
		case EVT_BITMAP_SELECT:
			if (Event->eventID == BITMAP_SCH_REC_RECORD)
			{
                if (CheckBatteryLow() == 1)
                {
                    rec_stop = TRUE;
                    FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
                    bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
                    bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
                    FormGetObjectPointer(BITMAP_SCH_REC_RECORD, &object_type, (void**)&bitmap_ptr);
                    bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
                    BitmapDrawBitmap(BITMAP_SCH_REC_RECORD);
#ifdef PR31700
                    SndStop();
#endif
                    DataCloseRecord(sch_voice_dbid, rec_rec_id);
#ifdef PR31700
                    InlaySetEnableStatus(TRUE);
                    AlarmMgrEnable(TRUE);
                    SystemSetMappedHardwareKeyStatus(TRUE);
                    BatteryWarningSetEnableStatus(TRUE);
#endif
                    time_count = 0;
                    FormPopupForm(FORM_SCH_VOICE_LOW_BATTERY);
                    low_battery_form_id = FORM_SCH_REC;
                    return TRUE;
                }
				FormGetObjectPointer(BITMAP_SCH_REC_RECORD, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_SCH_REC_PAUSE);
				
				if (rec_stop == TRUE)
				{
#ifdef PR31700
                    InlaySetEnableStatus(FALSE);
                    AlarmMgrEnable(FALSE);
                    SystemSetMappedHardwareKeyStatus(FALSE);
                    BatteryWarningSetEnableStatus(FALSE);
#endif
					if (recorded)
						DataDeleteRecord(sch_voice_dbid, rec_rec_id, FALSE);
					
                    Error = DataNewRecord(sch_voice_dbid, 0, 3, &rec_rec_id);
                    
#ifdef DEBUG_NO_MEM
                    printf("\n New record error = %ld", Error);
#endif
                    
					count = 1;
					Error = DataWriteField(sch_voice_dbid, rec_rec_id, 2, sizeof(UWORD), (BYTE*)&count);
#ifdef DEBUG_NO_MEM
                    printf("\n Write field Error = %ld", Error);
#endif
					
					
					rec_stop = FALSE;
#ifdef WITHSOUND
#ifdef PR31700
                    SndRec(sch_voice_dbid, rec_rec_id, 0);
#endif
#endif
                    time_count = 0;
				}
				else
#ifdef WITHSOUND
#ifdef PR31700
					SndRERec(sch_voice_dbid, rec_rec_id, 0);
#endif
#endif
				recorded = TRUE;
				return TRUE;
			}
			else if (Event->eventID == BITMAP_SCH_REC_PAUSE)
			{
				FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_SCH_REC_RECORD, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_SCH_REC_RECORD);
#ifdef WITHSOUND
#ifdef PR31700
				SndPause();
#endif
#endif
				return TRUE;
			}
			else if (Event->eventID == BITMAP_SCH_REC_STOP)
			{
                if (rec_stop) return FALSE;
				rec_stop = TRUE;
				FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_SCH_REC_RECORD, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_SCH_REC_RECORD);
#ifdef PR31700
				SndStop();
#endif
				DataCloseRecord(sch_voice_dbid, rec_rec_id);
#ifdef PR31700
                InlaySetEnableStatus(TRUE);
                AlarmMgrEnable(TRUE);
                SystemSetMappedHardwareKeyStatus(TRUE);
                BatteryWarningSetEnableStatus(TRUE);
#endif
                time_count = 0;
				return TRUE;
			}
			break;
		case EVT_FORM_OPEN:
#ifdef PR31700
			InlaySetEnableStatus(TRUE);
			AlarmMgrEnable(TRUE);
			SystemSetMappedHardwareKeyStatus(TRUE);
			BatteryWarningSetEnableStatus(TRUE);
#endif
			rec_stop = TRUE;
			FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bounds.ycoord = SCH_YCOORD1;
			FormGetObjectPointer(BITMAP_SCH_REC_STOP, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bounds.ycoord = SCH_YCOORD2;
			FormGetObjectPointer(BITMAP_SCH_REC_RECORD, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bounds.ycoord = SCH_YCOORD3;
			FormGetObjectPointer(SCROLLBAR_SCH_REC, &object_type, (void**)&scroll_ptr);
            scroll_ptr->bounds.ycoord = SCH_YCOORD4;
            scroll_ptr->scrollbar_attr.scrollbar_enable = FALSE;
            time_count = 0;
			FormDrawForm(FORM_SCH_REC);
			return TRUE;
		default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	SchedulerReplayVoice
* Purpose: 	This function is the event handler for the FORM_SCH_REPLAY
page of the Scheduler application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerReplayVoice(EvtType* Event)
{
	BYTE object_type;
	Bitmap *bitmap_ptr;
	SoundSettings sound;
	Scrollbar *scroll_ptr;
	UWORD rec_num;
	RecordID rec_id;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
            if (Event->para1 == LLETTER_PAUSE || Event->para1 == SLETTER_PAUSE)
            {
                if (FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr) == TRUE)
                {
                    if (bitmap_ptr->bitmap_attr.bitmap_visible)
                    {
						Event->eventType    = EVT_BITMAP_SELECT;
                        Event->eventID      = BITMAP_SCH_REC_PAUSE;
                        Event->evtPBP       = NULL;
                    }
                }
                if (FormGetObjectPointer(BITMAP_SCH_REPLAY_PLAY, &object_type, (void**)&bitmap_ptr) == TRUE)
                {
                    if (bitmap_ptr->bitmap_attr.bitmap_visible)
                    {
						Event->eventType    = EVT_BITMAP_SELECT;
                        Event->eventID      = BITMAP_SCH_REPLAY_PLAY;
                        Event->evtPBP       = NULL;
                    }
                }
            }
            else if (Event->para1 == LLETTER_STOP || Event->para1 == SLETTER_STOP)
            {
                if (FormGetObjectPointer(BITMAP_SCH_REC_STOP, &object_type, (void**)&bitmap_ptr) == TRUE)
                {
                    if (bitmap_ptr->bitmap_attr.bitmap_visible)
                    {
						Event->eventType    = EVT_BITMAP_SELECT;
                        Event->eventID      = BITMAP_SCH_REC_STOP;
                        Event->evtPBP       = NULL;
                    }
                }
            }
            else if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
            {
                if (FormGetObjectPointer(BITMAP_SCH_REC_X, &object_type, (void**)&bitmap_ptr) == TRUE)
                {
                    if (bitmap_ptr->bitmap_attr.bitmap_visible)
                    {
						Event->eventType    = EVT_BITMAP_SELECT;
                        Event->eventID      = BITMAP_SCH_REC_X;
                        Event->evtPBP       = NULL;
                    }
                }
            }
            else if (Event->para2 == 0x214 || Event->para2 == 0x21F)
            {
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_SCH_REC, SCROLLBAR_UP_ARROW);
                return TRUE;
            }
            else if (Event->para2 == 0x217 || Event->para2 == 0x21e)
            {           
                ScrollbarHardButtonSetScrollbar(SCROLLBAR_SCH_REC, SCROLLBAR_DOWN_ARROW);
                return TRUE;
            }
        }
    }
	
	
	switch (Event->eventType)
	{
#ifdef PR31700
	case EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS && Event->para2 == IO_SOUND_PLAY)
		{
			FormGetObjectPointer(BITMAP_SCH_REPLAY_PLAY, &object_type, (void**)&bitmap_ptr);
			if (bitmap_ptr->bitmap_attr.bitmap_visible == TRUE)
			{
				InlaySetEnableStatus(FALSE);
				AlarmMgrEnable(FALSE);
				SystemSetMappedHardwareKeyStatus(FALSE);
				BatteryWarningSetEnableStatus(FALSE);
				//  #endif
				if (CheckBatteryLow() == 1)
				{
					FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
					bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
					bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
					FormGetObjectPointer(BITMAP_SCH_REPLAY_PLAY, &object_type, (void**)&bitmap_ptr);
					bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
					BitmapDrawBitmap(BITMAP_SCH_REPLAY_PLAY);
#ifdef WITHSOUND
#ifdef PR31700
					SndStop();
					InlaySetEnableStatus(TRUE);
					AlarmMgrEnable(TRUE);
					SystemSetMappedHardwareKeyStatus(TRUE);
					BatteryWarningSetEnableStatus(TRUE);
#endif
#endif 
					play_pause_frame = 0;
					play_stop = TRUE;
					FormPopupForm(FORM_SCH_VOICE_LOW_BATTERY);
					low_battery_form_id = FORM_SCH_REPLAY;
					return TRUE;
				} 
				
				FormGetObjectPointer(BITMAP_SCH_REPLAY_PLAY, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_SCH_REC_PAUSE);
#ifdef WITHSOUND
#ifdef PR31700
				if (play_stop == TRUE)
					SndPlay(play_pause_frame, voice_playing_dbid, voice_playing_recid, 0);
				else SndREPlay(play_pause_frame, voice_playing_dbid, voice_playing_recid, 0);
#endif
#endif
				play_stop = FALSE;
				return TRUE;
			}
			else
			{
				FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_SCH_REPLAY_PLAY, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_SCH_REPLAY_PLAY);
#ifdef WITHSOUND
#ifdef PR31700
				play_pause_frame = SndPause();
#endif
#endif
				return TRUE;
			}
		}
		else if (Event->eventID == EVT_IO_KEY_PRESS && Event->para2 == IO_SOUND_STOP)
		{
			FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
			bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
			FormGetObjectPointer(BITMAP_SCH_REPLAY_PLAY, &object_type, (void**)&bitmap_ptr);
			bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
			BitmapDrawBitmap(BITMAP_SCH_REPLAY_PLAY);
#ifdef WITHSOUND
#ifdef PR31700
			SndStop();
			InlaySetEnableStatus(TRUE);
			AlarmMgrEnable(TRUE);
			SystemSetMappedHardwareKeyStatus(TRUE);
			BatteryWarningSetEnableStatus(TRUE);
#endif
#endif 
			play_pause_frame = 0;
			play_stop = TRUE;
			return TRUE;
		}
		else if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_SCH_REC, SCROLLBAR_DOWN_ARROW);
			//					ScrollbarHardButtonSetScrollbar(SCROLLBAR_SCH_REC, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_SCH_REC, SCROLLBAR_UP_ARROW);
			//					ScrollbarHardButtonSetScrollbar(SCROLLBAR_SCH_REC, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
#endif
#ifdef WITHSOUND
#ifdef PR31700
        case POWER_EVENT:
            if (Event->eventID == BAT_MAIN_LOW)
            {                
                if (play_stop) return FALSE;
				FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_SCH_REPLAY_PLAY, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_SCH_REPLAY_PLAY);
#ifdef WITHSOUND
#ifdef PR31700
				SndStop();
                InlaySetEnableStatus(TRUE);
                AlarmMgrEnable(TRUE);
                SystemSetMappedHardwareKeyStatus(TRUE);
                BatteryWarningSetEnableStatus(TRUE);
#endif
#endif 
				play_pause_frame = 0;
				return TRUE;
            }
            return FALSE;
        case SND_MGR_EVT:
            if (Event->eventID == REC_END)
			{
				FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_SCH_REPLAY_PLAY, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_SCH_REPLAY_PLAY);
				SndStop();
				play_pause_frame = 0;
				play_stop = TRUE;
				return TRUE;
			}
			return FALSE;
#endif
#endif
		case EVT_INLAY_SELECT:
			if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			{
				play_stop = TRUE;
				play_pause_frame = 0;
#ifdef WITHSOUND
#ifdef PR31700
				SndStop();
				
                InlaySetEnableStatus(TRUE);
                AlarmMgrEnable(TRUE);
                SystemSetMappedHardwareKeyStatus(TRUE);
                BatteryWarningSetEnableStatus(TRUE);
#endif
#endif
				DataCloseRecord(voice_playing_dbid, voice_playing_recid);
				FormPopupForm(enter_form_id);
			}
			return TRUE;
		case EVT_BITMAP_SELECT:
			if (Event->eventID == BITMAP_SCH_REC_PAUSE)
			{
				FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_SCH_REPLAY_PLAY, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_SCH_REPLAY_PLAY);
#ifdef WITHSOUND
#ifdef PR31700
				play_pause_frame = SndPause();
#endif
#endif
				return TRUE;
			}
			else if (Event->eventID == BITMAP_SCH_REPLAY_PLAY)
			{
#ifdef PR31700
                InlaySetEnableStatus(FALSE);
                AlarmMgrEnable(FALSE);
                SystemSetMappedHardwareKeyStatus(FALSE);
                BatteryWarningSetEnableStatus(FALSE);
#endif
                if (CheckBatteryLow() == 1)
                {
                    FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
                    bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
                    bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
                    FormGetObjectPointer(BITMAP_SCH_REPLAY_PLAY, &object_type, (void**)&bitmap_ptr);
                    bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
                    BitmapDrawBitmap(BITMAP_SCH_REPLAY_PLAY);
#ifdef WITHSOUND
#ifdef PR31700
                    SndStop();
                    InlaySetEnableStatus(TRUE);
                    AlarmMgrEnable(TRUE);
                    SystemSetMappedHardwareKeyStatus(TRUE);
                    BatteryWarningSetEnableStatus(TRUE);
#endif
#endif 
                    play_pause_frame = 0;
                    play_stop = TRUE;
                    FormPopupForm(FORM_SCH_VOICE_LOW_BATTERY);
                    low_battery_form_id = FORM_SCH_REPLAY;
                    return TRUE;
                }
				
				
				FormGetObjectPointer(BITMAP_SCH_REPLAY_PLAY, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_SCH_REC_PAUSE);
#ifdef WITHSOUND
#ifdef PR31700
				if (play_stop == TRUE)
				{
#ifdef DEBUG
					printf("\n === replay voice ===");
					printf("\n voice db = %ld", sch_voice_dbid);
					printf("\n voice_playing_dbid = %ld", voice_playing_dbid);
					printf("\n voice_playing_recid = %ld", voice_playing_recid);
#endif
                    SndPlay(play_pause_frame, voice_playing_dbid, voice_playing_recid, 0);
                }
                else SndREPlay(play_pause_frame, voice_playing_dbid, voice_playing_recid, 0);
#endif
#endif
                play_stop = FALSE;
				return TRUE;
			}
			else if (Event->eventID == BITMAP_SCH_REC_STOP)
			{
				FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
				bitmap_ptr->bitmap_attr.bitmap_drawn = FALSE;
				FormGetObjectPointer(BITMAP_SCH_REPLAY_PLAY, &object_type, (void**)&bitmap_ptr);
				bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
				BitmapDrawBitmap(BITMAP_SCH_REPLAY_PLAY);
#ifdef WITHSOUND
#ifdef PR31700
				SndStop();
                InlaySetEnableStatus(TRUE);
                AlarmMgrEnable(TRUE);
                SystemSetMappedHardwareKeyStatus(TRUE);
                BatteryWarningSetEnableStatus(TRUE);
#endif
#endif 
				play_pause_frame = 0;
				play_stop = TRUE;
				return TRUE;
			}
			else
			{
#ifdef PR31700
                InlaySetEnableStatus(TRUE);
                AlarmMgrEnable(TRUE);
                SystemSetMappedHardwareKeyStatus(TRUE);
                BatteryWarningSetEnableStatus(TRUE);
#endif
				
				play_stop = TRUE;
				play_pause_frame = 0;
#ifdef WITHSOUND
#ifdef PR31700
				SndStop();
#endif
#endif
				DataCloseRecord(voice_playing_dbid, voice_playing_recid);
				FormPopupForm(enter_form_id);
				return TRUE;
			}
			break;
		case	EVT_SCROLLBAR_SELECT:
			SchedulerReplayScrollbarSetVolume(Event);
			return TRUE;
		case	EVT_SCROLLBAR_REPEAT:
			ScrollbarDrawScrollbar(SCROLLBAR_SCH_REC);
			return TRUE;
		case EVT_FORM_OPEN:
			play_stop = TRUE;
			play_pause_frame = 0;
#ifdef DEBUG
			printf("\n === replay form open ==== ");
			printf("\n voice_playing_dbid = %ld", voice_playing_dbid);
			printf("\n voice_playing_recid = %ld", voice_playing_recid);
#endif
            DataRecIDtoNum(voice_playing_dbid, voice_playing_recid, &rec_num);
            DataOpenRecord(voice_playing_dbid, rec_num, &rec_id, NULL);
			
            FormGetObjectPointer(BITMAP_SCH_REC_PAUSE, &object_type, (void**)&bitmap_ptr);
            bitmap_ptr->bounds.ycoord = SCH_YCOORD5;
            bitmap_ptr->bitmap_attr.bitmap_visible = FALSE;
            FormGetObjectPointer(BITMAP_SCH_REPLAY_PLAY, &object_type, (void**)&bitmap_ptr);
            bitmap_ptr->bounds.ycoord = SCH_YCOORD6;
            bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
            FormGetObjectPointer(BITMAP_SCH_REC_STOP, &object_type, (void**)&bitmap_ptr);
            bitmap_ptr->bitmap_attr.bitmap_visible = TRUE;
            bitmap_ptr->bounds.ycoord = SCH_YCOORD7;
            SySetupGetSoundSettings(&sound);
            FormGetObjectPointer(SCROLLBAR_SCH_REC, &object_type, (void**)&scroll_ptr);
            scroll_ptr->bounds.ycoord = SCH_YCOORD8;
            scroll_ptr->scrollbar_min = sound.vol_min;
            scroll_ptr->scrollbar_total_num_lines = sound.vol_max;
            scroll_ptr->scrollbar_max = sound.vol_max - 1;
            scroll_ptr->scrollbar_value = sound.vol_curr;
            scroll_ptr->scrollbar_attr.scrollbar_enable = TRUE;
            FormDrawForm(FORM_SCH_REPLAY);
			return TRUE;
		default: return FALSE;
	}
}

/********************************************************
* Function:	SchedulerAlarmVoiceMemoExists
* Purpose: 	This function is the event handler for the FORM_SCH_VOICE_EXISTS
page of the Scheduler application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerAlarmVoiceMemoExists(EvtType *Event)
{
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_VOICE_EXISTS_PLAY || Event->para1 == SLETTER_VOICE_EXISTS_PLAY)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
				Event->eventID      = BUTTON_SCH_VOICE_EXISTS_PLAY;
				Event->evtPBP       = NULL;
			}
			else if (Event->para1 == LLETTER_VOICE_EXISTS_REPLACE || Event->para1 == SLETTER_VOICE_EXISTS_REPLACE)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
				Event->eventID      = BUTTON_SCH_VOICE_EXISTS_REPLACE;
				Event->evtPBP       = NULL;
			}
			else if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
				Event->eventID      = BITMAP_SCH_VOICE_EXISTS_X;
				Event->evtPBP       = NULL;
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_SCH_VOICE_EXISTS_PLAY)
		{
			if (alarm_settings.change == TRUE && alarm_settings.recorded == TRUE)
			{
				enter_form_id = FORM_SCH_VOICE_EXISTS;
				voice_playing_dbid = sch_voice_dbid;
				voice_playing_recid = alarm_settings.temp_recid;
				FormInitAllFormObjects(FORM_SCH_REPLAY);
				FormPopupForm(FORM_SCH_REPLAY);
			}
			else if (alarm_settings.change == FALSE)
			{
				enter_form_id = FORM_SCH_VOICE_EXISTS;
				voice_playing_dbid = time_settings.dbid;
				voice_playing_recid = time_settings.recid;
				FormInitAllFormObjects(FORM_SCH_REPLAY);
				FormPopupForm(FORM_SCH_REPLAY);
			}
		}
		else
		{
			FormInitAllFormObjects(FORM_SCH_REC);
			FormPopupForm(FORM_SCH_REC);
			recorded = FALSE;
		}
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
			FormPopupForm(FORM_SCH_ALARM);
		return TRUE;
	case EVT_BITMAP_SELECT:
		FormPopupForm(FORM_SCH_ALARM);
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SCH_VOICE_EXISTS);
		InlaySetEnableStatus(TRUE);
#ifdef PR31700
		AlarmMgrEnable(TRUE);
		SystemSetMappedHardwareKeyStatus(TRUE);
		BatteryWarningSetEnableStatus(TRUE);
#endif
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	SchedulerPurge
* Purpose: 	This function is called to handle the event for the form
FORM_SCH_PURGE
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerPurge(EvtType *Event)
{
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_PROCEED || Event->para1 == SLETTER_PROCEED)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
				Event->eventID      = BUTTON_SCH_PURGE_PROCEED;
				Event->evtPBP       = NULL;
			}
			else if (Event->para1 == LLETTER_CANCEL || Event->para1 == SLETTER_CANCEL)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
				Event->eventID      = BUTTON_SCH_PURGE_CANCEL;
				Event->evtPBP       = NULL;
			}
			else if (Event->para1 == LLETTER_PURGE_POPUP)
			{
#ifdef PR31700
				ControlPopupPopupTrigger(POPUP_TRIGGER_SCH_PURGE);
#endif
				return TRUE;
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_SCH_PURGE_PROCEED)
		{	
			SchedulerDayViewPurge(&virtual_table);
			FormPopupForm(FORM_SCH_DAY_VIEW);
		}
		else if (Event->eventID == BUTTON_SCH_PURGE_CANCEL)
			FormPopupForm(FORM_SCH_DAY_VIEW);
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK)
		{
			SchedulerDayViewPurge(&virtual_table);
			FormPopupForm(FORM_SCH_DAY_VIEW);
			FormSetFormActiveObject(FORM_SCH_DAY_VIEW, BUTTON_SCH_DAY_VIEW_NEW);
		}
		else if (Event->para1 == INLAY_EXIT)
		{
			SchedulerGotoPopupForm(FORM_SCH_DAY_VIEW, FALSE);
			FormSetFormActiveObject(FORM_SCH_DAY_VIEW, BUTTON_SCH_DAY_VIEW_NEW);
		}
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SCH_PURGE);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/*****************************************************************
* Function:	SchedulerDateSettings
* Purpose: 	This function is the event handler for the date
*				settings page of the Scheduler application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SchedulerDateSettings(EvtType *Event)
{
	
	BYTE *list_string, day_text[3] = {0}, text[60];
	SHORT year, month, day, wday, week_no;
	UBYTE temp_date[4];
	static BYTE today_key_press = 0;
	CountrySettings country;
	ObjectID pushed_button;
	SHORT i;
	BYTE buffer[20];
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_TODAY || Event->para1 == SLETTER_TODAY)
			{
				Event->eventType    = EVT_CONTROL_SELECT;
				Event->eventID      = BUTTON_SCH_DATE_TODAY;
				Event->evtPBP       = NULL;
			}                            
			else if (Event->para2 == 0x214 || Event->para2 == 0x21F)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
				Event->eventID      = BITMAP_SCH_DATE_LEFT;
				Event->evtPBP       = NULL;
			}
			else if (Event->para2 == 0x217 || Event->para2 == 0x21E)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
				Event->eventID      = BITMAP_SCH_DATE_RIGHT;
				Event->evtPBP       = NULL;
			}
			else if (Event->para1 == 9)
			{
				ControlGetPushedPushButton(FORM_SCH_DATE, 2, &pushed_button);
				pushed_button ++;
				if (pushed_button == 86)
					pushed_button = 74;
				FormSetControlGroupSelection(FORM_SCH_DATE, pushed_button);
				Event->eventType    = EVT_CONTROL_SELECT;
				Event->eventID      = pushed_button;
			}
		}
	}
	
#ifdef PR31700
	if (Event->eventType == EVT_IO_KEY_CTRL)
	{
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
			{
				ControlGetPushedPushButton(FORM_SCH_DATE, 2, &pushed_button);
				pushed_button ++;
				if (pushed_button == 86)
					pushed_button = 74;
				FormSetControlGroupSelection(FORM_SCH_DATE, pushed_button);
				Event->eventType    = EVT_CONTROL_SELECT;
				Event->eventID      = pushed_button;
				ScrollbarHardButtonSetScrollbar(virtual_table.vt_scrollbar_id, SCROLLBAR_UP_ARROW);
			}
			else if (Event->para2 == IO_DOWN_ARROW)
			{
				ControlGetPushedPushButton(FORM_SCH_DATE, 2, &pushed_button);
				pushed_button --;
				if (pushed_button == 73)
					pushed_button = 85;
				FormSetControlGroupSelection(FORM_SCH_DATE, pushed_button);
				Event->eventType    = EVT_CONTROL_SELECT;
				Event->eventID      = pushed_button;
				ScrollbarHardButtonSetScrollbar(virtual_table.vt_scrollbar_id, SCROLLBAR_DOWN_ARROW);
			}
		}
	}
#endif
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		SySetupGetCountrySettings(&country);
		switch(country.start_of_week)
		{
		case SYSETUP_SUN:
			strcpy(text, SCHSTR5);
			break;
		case SYSETUP_MON:
			strcpy(text, SCHSTR6);
			break;
		default:	return FALSE;
		}
		StringSetText(STRING_SCH_DATE_WDAY, text);
		if (today_key_press)
		{
			SySetupRestoreDateSettings(FORM_SCH_DATE, TABLE_SCH_DATE, PUSH_SCH_DATE_Y1, 
				PUSH_SCH_DATE_JAN, &prev_row_num, &prev_col_num);
			today_key_press = 0;
		}
		else
			SchedulerRestoreDateSettings(FORM_SCH_DATE, TABLE_SCH_DATE, PUSH_SCH_DATE_Y1, 
			PUSH_SCH_DATE_JAN, &prev_row_num, &prev_col_num);
		FormDrawForm(FORM_SCH_DATE);
		ControlDrawControl(BUTTON_SCH_DATE_DISABLE_BKGRD);
		ControlDrawControl(PUSH_SCH_DATE_Y1);
		ControlDrawControl(PUSH_SCH_DATE_Y2);
		ControlDrawControl(PUSH_SCH_DATE_Y3);
		ControlDrawControl(PUSH_SCH_DATE_Y4);
		ControlDrawControl(PUSH_SCH_DATE_Y5);
		return TRUE;
		case EVT_BITMAP_SELECT:
			SySetupGetCountrySettings(&country);
			switch (Event->eventID)
			{
			case BITMAP_SCH_DATE_LEFT:
				SySetupDateUpdateYearBar(PUSH_SCH_DATE_Y1, BUTTON_SCH_DATE_DISABLE_BKGRD, SYSETUP_YEAR_LEFT);
				SySetupGetDateSettings(FORM_SCH_DATE, TABLE_SCH_DATE, PUSH_SCH_DATE_JAN, GROUP_ID_SCH_DATE_YEAR,
					GROUP_ID_SCH_DATE_MONTH, prev_row_num, prev_col_num, &year, &month, &day);
				SySetupDateUpdateTable(TABLE_SCH_DATE, year, month, day, (SHORT)country.start_of_week, &prev_row_num, &prev_col_num);
				TableEraseTable(TABLE_SCH_DATE);
				TableDrawTable(TABLE_SCH_DATE);
				return TRUE;
			case BITMAP_SCH_DATE_RIGHT:
				SySetupDateUpdateYearBar(PUSH_SCH_DATE_Y1, BUTTON_SCH_DATE_DISABLE_BKGRD, SYSETUP_YEAR_RIGHT);
				SySetupGetDateSettings(FORM_SCH_DATE, TABLE_SCH_DATE, PUSH_SCH_DATE_JAN, GROUP_ID_SCH_DATE_YEAR,
					GROUP_ID_SCH_DATE_MONTH, prev_row_num, prev_col_num, &year, &month, &day);
				SySetupDateUpdateTable(TABLE_SCH_DATE, year, month, day, (SHORT)country.start_of_week, &prev_row_num, &prev_col_num);
				TableEraseTable(TABLE_SCH_DATE);
				TableDrawTable(TABLE_SCH_DATE);
				return TRUE;
			default:	return FALSE;
			}
			case EVT_CONTROL_SELECT:
				switch(Event->eventID)
				{	
				case BUTTON_SCH_DATE_TODAY:
					today_key_press = 1;
					FormPopupForm(FORM_SCH_DATE);
					return TRUE;
				default:
					SySetupGetCountrySettings(&country);
					SySetupGetDateSettings(FORM_SCH_DATE, TABLE_SCH_DATE, PUSH_SCH_DATE_JAN, GROUP_ID_SCH_DATE_YEAR,
						GROUP_ID_SCH_DATE_MONTH, prev_row_num, prev_col_num, &year, &month, &day);
					SySetupDateUpdateTable(TABLE_SCH_DATE, year, month, day, (SHORT)country.start_of_week, &prev_row_num, &prev_col_num);
					TableEraseTable(TABLE_SCH_DATE);
					TableDrawTable(TABLE_SCH_DATE);
					return TRUE;
				}
				case EVT_TABLE_SELECT:
					TableGetItemText(TABLE_SCH_DATE, (USHORT)Event->para1, (USHORT)Event->para2, &list_string);
					if (list_string[0] != 0)
					{
						if ((prev_row_num == (USHORT)Event->para1) && (prev_col_num == (USHORT)Event->para2))
							TableSetHighlightCell(TABLE_SCH_DATE, prev_row_num, prev_col_num, TRUE);
						else
						{
							TableSetHighlightCell(TABLE_SCH_DATE, prev_row_num, prev_col_num, FALSE);
							prev_row_num = (USHORT)Event->para1;
							prev_col_num = (USHORT)Event->para2;
						}
						TableDrawTable(TABLE_SCH_DATE);
					}
					return TRUE;
				case EVT_INLAY_SELECT:
					switch(Event->para1)
					{	
					case INLAY_OK:
						SySetupGetDateSettings(FORM_SCH_DATE, TABLE_SCH_DATE, PUSH_SCH_DATE_JAN, GROUP_ID_SCH_DATE_YEAR,
							GROUP_ID_SCH_DATE_MONTH, prev_row_num, prev_col_num, &year, &month, &day);
						if (prev_form_id == FORM_SCH_WEEK)
						{           
							SchedulerSetDayViewDate(year, month+1, day, prev_col_num);
							SchedulerGetDayViewDate(temp_date);
							SchedulerGotoPopupForm(FORM_SCH_WEEK, TRUE);
						}
						else if (prev_form_id == FORM_SCH_REPEAT)
						{
							FormDrawForm(FORM_SCH_DAY_VIEW);
							if ((BYTE)(year - SYSETUP_YEAR_OFFSET) != temp_date[0] ||
								(BYTE)(month + 1) != temp_date[1] ||
								(BYTE)(day) != temp_date[2])
							{
								temp_date[0] = (BYTE)(year - SYSETUP_YEAR_OFFSET);
								temp_date[1] = (BYTE)(month + 1);
								temp_date[2] = (BYTE)(day);
								i = 2;
								do
								{
									repeat_settings.end_date[i] = temp_date[i];
									i--;
								}while(i >= 0);
							}
							ToDoPackDueDate(buffer, (temp_date[0] + SYSETUP_YEAR_OFFSET), temp_date[1], temp_date[2]);
							ControlSetLabel(POPUP_TRIGGER_REPEAT_END_SELECT, buffer);
							FormEraseForm(FORM_SCH_DATE);
							FormDrawForm(FORM_SCH_DAY_VIEW);
							repeat_settings.change = TRUE;
							FormPopupForm(FORM_SCH_REPEAT);
						}
						else
						{
							SchedulerSetDayViewDate(year, month+1, day, prev_col_num);
							SchedulerGetDayViewDate(temp_date);
							SchedulerDayViewLoadAppmtDataToScreen(&virtual_table, temp_date);
							SchedulerGotoPopupForm(FORM_SCH_DATE, TRUE);
						}
						return TRUE;
					case INLAY_EXIT:
						SchedulerGotoPopupForm(FORM_SCH_DATE, TRUE);
						return TRUE;
					default: return FALSE;
					}
	}
	return FALSE;
}


/*****************************************************************
* Function:	SchedulerMonthView
* Purpose: 	This function is the event handler for the month
*				view page of the Scheduler application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SchedulerMonthView(EvtType *Event)
{
	RTM	timer;
	BYTE	text[2] = {0}, *item_text;
	UBYTE	temp_date[4];
	SHORT	year, month, day;
	USHORT	month_row_num = prev_row_num, month_col_num = prev_col_num;
	CountrySettings country;
	AppID   appid;
	
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
            if (Event->para1 == 'T' || Event->para1 == 't')
            {
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_SCH_DATE_TODAY;
                Event->evtPBP       = NULL;
            }
            else if (Event->para2 == 0x214 || Event->para2 == 0x21F)
            {
                Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = BITMAP_SCH_DATE_LEFT;
                Event->evtPBP       = NULL;
            }
            else if (Event->para2 == 0x217 || Event->para2 == 0x21E)
            {
                Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = BITMAP_SCH_DATE_RIGHT;
                Event->evtPBP       = NULL;
            }
            else if (Event->para2 == 0x215 || Event->para2 == 0x21C)
            {
                Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = BITMAP_SCH_MONTH_LEFT;
                Event->evtPBP       = NULL;
            }
            else if (Event->para2 == 0x216 || Event->para2 == 0x21D)
            {
                Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = BITMAP_SCH_MONTH_RIGHT;
                Event->evtPBP       = NULL;
            }
            else if (Event->para1 == '0')
            {
#ifdef PR31700
                ControlPopupPopupTrigger(POPUP_TRIGGER_APP_SELECT);
#endif
                return TRUE;
            }             
        }
    }
	
#ifdef PR31700
    if (Event->eventType == EVT_IO_KEY_CTRL)
    {
        if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
        {
            if (Event->para2 == IO_UP_ARROW)
            {
                Event->eventType= EVT_BITMAP_SELECT;
                Event->eventID  = BITMAP_SCH_MONTH_RIGHT;
            }
            else if (Event->para2 == IO_DOWN_ARROW)
            {
                Event->eventType= EVT_BITMAP_SELECT;
                Event->eventID  = BITMAP_SCH_MONTH_LEFT;
            }
        }
    }
#endif
	
	
	
    switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		SySetupGetCountrySettings(&country);
		switch(country.start_of_week)
		{
		case SYSETUP_SUN:
			text[0] = SCHSUN3;
			StringSetText(STRING_SCH_MONTH_WDAY1, text);
			text[0] = SCHMON3;
			StringSetText(STRING_SCH_MONTH_WDAY2, text);
			text[0] = SCHTUE3;
			StringSetText(STRING_SCH_MONTH_WDAY3, text);
			text[0] = SCHWED3;
			StringSetText(STRING_SCH_MONTH_WDAY4, text);
			text[0] = SCHTHU3;
			StringSetText(STRING_SCH_MONTH_WDAY5, text);
			text[0] = SCHFRI3;
			StringSetText(STRING_SCH_MONTH_WDAY6, text);
			text[0] = SCHSAT3;
			StringSetText(STRING_SCH_MONTH_WDAY7, text);
			break;
		case SYSETUP_MON:
			text[0] = SCHMON3;
			StringSetText(STRING_SCH_MONTH_WDAY1, text);
			text[0] = SCHTUE3;
			StringSetText(STRING_SCH_MONTH_WDAY2, text);
			text[0] = SCHWED3;
			StringSetText(STRING_SCH_MONTH_WDAY3, text);
			text[0] = SCHTHU3;
			StringSetText(STRING_SCH_MONTH_WDAY4, text);
			text[0] = SCHFRI3;
			StringSetText(STRING_SCH_MONTH_WDAY5, text);
			text[0] = SCHSAT3;
			StringSetText(STRING_SCH_MONTH_WDAY6, text);
			text[0] = SCHSUN3;
			StringSetText(STRING_SCH_MONTH_WDAY7, text);
			break;
		default:	return FALSE;
		}
		
		SchedulerGetDayViewDate(temp_date);
		timer.year = SYSETUP_YEAR_OFFSET + (SHORT)temp_date[0];
		timer.mon = (SHORT)temp_date[1] - 1;
		timer.mday = (SHORT)temp_date[2];
		if (!SchedulerRestoreMonthView(FORM_SCH_MONTH, TABLE_SCH_MONTH, PUSH_SCH_DATE_Y1, 
			&prev_row_num, &prev_col_num, timer))
			return FALSE;
		FormDrawForm(FORM_SCH_MONTH);
		ControlDrawControl(BUTTON_SCH_DATE_DISABLE_BKGRD);
		ControlDrawControl(PUSH_SCH_DATE_Y1);
		ControlDrawControl(PUSH_SCH_DATE_Y2);
		ControlDrawControl(PUSH_SCH_DATE_Y3);
		ControlDrawControl(PUSH_SCH_DATE_Y4);
		ControlDrawControl(PUSH_SCH_DATE_Y5);
		return TRUE;
		case EVT_CONTROL_POPUP_SELECT:
			switch(Event->eventID)
			{
			case POPUP_TRIGGER_APP_SELECT:
				SchedulerGotoPopupForm(FORM_SCH_MONTH, FALSE);
				return TRUE;
				
			default: return FALSE;
			}
			case EVT_BITMAP_SELECT:
				SySetupGetCountrySettings(&country);
				switch (Event->eventID)
				{
				case BITMAP_SCH_DATE_LEFT:
					if (!SySetupDateUpdateYearBar(PUSH_SCH_DATE_Y1, BUTTON_SCH_DATE_DISABLE_BKGRD, SYSETUP_YEAR_LEFT))
						return FALSE;
					SchedulerGetMonthViewDate(prev_row_num, prev_col_num, &year, &month, &day);
					if (!SchedulerDateUpdateMonthTable(TABLE_SCH_MONTH, year, month, country.start_of_week))
						return FALSE;
					TableEraseTable(TABLE_SCH_MONTH);
					TableDrawTable(TABLE_SCH_MONTH);
					BitmapDrawBitmap(BITMAP_SCH_MONTH_LEFT);
					BitmapDrawBitmap(BITMAP_SCH_MONTH_RIGHT);
					ControlDrawControl(BUTTON_SCH_DATE_DISABLE_BKGRD);
					ControlDrawControl(PUSH_SCH_DATE_Y1);
					ControlDrawControl(PUSH_SCH_DATE_Y2);
					ControlDrawControl(PUSH_SCH_DATE_Y3);
					ControlDrawControl(PUSH_SCH_DATE_Y4);
					ControlDrawControl(PUSH_SCH_DATE_Y5);
					return TRUE;
				case BITMAP_SCH_DATE_RIGHT:
					if (!SySetupDateUpdateYearBar(PUSH_SCH_DATE_Y1, BUTTON_SCH_DATE_DISABLE_BKGRD, SYSETUP_YEAR_RIGHT))
						return FALSE;
					SchedulerGetMonthViewDate(prev_row_num, prev_col_num, &year, &month, &day);
					if (!SchedulerDateUpdateMonthTable(TABLE_SCH_MONTH, year, month, country.start_of_week))
						return FALSE;
					TableEraseTable(TABLE_SCH_MONTH);
					TableDrawTable(TABLE_SCH_MONTH);
					BitmapDrawBitmap(BITMAP_SCH_MONTH_LEFT);
					BitmapDrawBitmap(BITMAP_SCH_MONTH_RIGHT);
					ControlDrawControl(BUTTON_SCH_DATE_DISABLE_BKGRD);
					ControlDrawControl(PUSH_SCH_DATE_Y1);
					ControlDrawControl(PUSH_SCH_DATE_Y2);
					ControlDrawControl(PUSH_SCH_DATE_Y3);
					ControlDrawControl(PUSH_SCH_DATE_Y4);
					ControlDrawControl(PUSH_SCH_DATE_Y5);
					return TRUE;
				case BITMAP_SCH_MONTH_LEFT:
					if (!SchedulerMonthUpdateMonthView(SCH_MONTH_LEFT, &month_row_num, &month_col_num))
						return FALSE;
					return TRUE;
				case BITMAP_SCH_MONTH_RIGHT:
					if (!SchedulerMonthUpdateMonthView(SCH_MONTH_RIGHT, &month_row_num, &month_col_num))
						return FALSE;
					return TRUE;
				default:	return FALSE;
				}
				case EVT_CONTROL_SELECT:
					switch(Event->eventID)
					{	
					case BUTTON_SCH_DATE_TODAY:
						RtcGetTime(&timer);
						if (!SchedulerRestoreMonthView(FORM_SCH_MONTH, TABLE_SCH_MONTH, PUSH_SCH_DATE_Y1, 
							&prev_row_num, &prev_col_num, timer))
							return FALSE;
						TableEraseTable(TABLE_SCH_MONTH);
						TableDrawTable(TABLE_SCH_MONTH);
						BitmapDrawBitmap(BITMAP_SCH_MONTH_LEFT);
						BitmapDrawBitmap(BITMAP_SCH_MONTH_RIGHT);
						StringDrawString(STRING_SCH_MONTH_MONTH);
						ControlDrawControl(BUTTON_SCH_DATE_DISABLE_BKGRD);
						ControlDrawControl(PUSH_SCH_DATE_Y1);
						ControlDrawControl(PUSH_SCH_DATE_Y2);
						ControlDrawControl(PUSH_SCH_DATE_Y3);
						ControlDrawControl(PUSH_SCH_DATE_Y4);
						ControlDrawControl(PUSH_SCH_DATE_Y5);
						return TRUE;
						// -------------------------------- modified at 270300 ----------------------------------
					case CHECKBOX_SCH_DAY_VIEW:
						ControlPopupSetSelectedItem(POPUP_TRIGGER_APP_SELECT, 1);
						SchedulerGotoPopupForm(FORM_SCH_MONTH, FALSE);
						//FormPopupForm(FORM_SCH_DAY_VIEW);
						return TRUE;
					case CHECKBOX_SCH_WEEK_VIEW:
						ControlPopupSetSelectedItem(POPUP_TRIGGER_APP_SELECT, 2);
						SchedulerGotoPopupForm(FORM_SCH_MONTH, FALSE);
						//FormPopupForm(FORM_SCH_WEEK);
						return TRUE;
					case CHECKBOX_SCH_MONTH_VIEW:
						return TRUE;
						// --------------------------------------------------------------------------------------
					default:
						SySetupGetCountrySettings(&country);
						SchedulerGetMonthViewDate(prev_row_num, prev_col_num, &year, &month, &day);
						if (!SchedulerDateUpdateMonthTable(TABLE_SCH_MONTH, year, month, country.start_of_week))
							return FALSE;
						TableEraseTable(TABLE_SCH_MONTH);
						TableDrawTable(TABLE_SCH_MONTH);
						return TRUE;
					}
					case EVT_TABLE_SELECT:
						TableGetItemText(TABLE_SCH_MONTH, (USHORT)Event->para1, (USHORT)Event->para2, &item_text);
						if (item_text[0] == 0)
						{
							TableSetHighlightCell(TABLE_SCH_MONTH, prev_row_num, prev_col_num, FALSE);
							return TRUE;
						}
						SchedulerGetMonthViewDate((USHORT)Event->para1, (USHORT)Event->para2, &year, &month, &day);
						SchedulerSetDayViewDate(year, month+1, day, (USHORT)Event->para2);
						SchedulerGetDayViewDate(temp_date);
						SchedulerDayViewLoadAppmtDataToScreen(&virtual_table, temp_date);
						prev_form_id = FORM_SCH_MONTH;
						ControlPopupSetSelectedItem(POPUP_TRIGGER_APP_SELECT, 1);
						// ----------------------------------------------------------------------------
						// modified at 210400
						FormSetControlGroupSelection(FORM_SCH_DAY_VIEW, CHECKBOX_SCH_DAY_VIEW);
						// ----------------------------------------------------------------------------
						FormPopupForm(FORM_SCH_DAY_VIEW);
						return TRUE;
					case EVT_INLAY_SELECT:
						switch(Event->para1)
						{	
						case INLAY_OK:
							SysGetAppID(MAINMENU, &appid);
							EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
							EvtAppendEvt(EVT_APP_LAUNCH, appid, 0, 0, NULL);
							return TRUE;
						case INLAY_EXIT:
							SysGetAppID(MAINMENU, &appid);
							EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
							EvtAppendEvt(EVT_APP_LAUNCH, appid, 0, 0, NULL);
							return TRUE;
						default: return FALSE;
						}
	}
	return FALSE;
}

/*****************************************************************
* Function:	SchedulerWeekView
* Purpose: 	This function is the event handler for the week
*		view page of the Scheduler application
* Scope:	application/internal
* Input:	Event			received event
* Output:	None
* Return:	TRUE if handled
*		FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SchedulerWeekView(EvtType *Event)
{
	SHORT	week_no, mon, mday, wday, total_week_no, dummy, d_day;
	UBYTE	temp_date[4];
	static	SHORT	week_view_year;
	AppID 	appid;
	CountrySettings	country;
	RTM	pDate;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
            if (Event->para1 == LLETTER_GOTO || Event->para1 == SLETTER_GOTO)
            {
                Event->eventType    = EVT_CONTROL_SELECT;
                Event->eventID      = BUTTON_SCH_MONTH_GOTO;
                Event->evtPBP       = NULL;
            }
            else if (Event->para2 == 0x214 || Event->para2 == 0x21F)
            {
                Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = BITMAP_SCH_WEEK_LEFT;
                Event->evtPBP       = NULL;
            }
            else if (Event->para2 == 0x217 || Event->para2 == 0x21E)
            {
                Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = BITMAP_SCH_WEEK_RIGHT;
                Event->evtPBP       = NULL;
            }
        }
    }
	
#ifdef PR31700
    if (Event->eventType == EVT_IO_KEY_CTRL)
    {
        if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
        {
            if (Event->para2 == IO_UP_ARROW)
            {
                Event->eventType= EVT_BITMAP_SELECT;
                Event->eventID  = BITMAP_SCH_WEEK_RIGHT;
            }
            else if (Event->para2 == IO_DOWN_ARROW)
            {
                Event->eventType= EVT_BITMAP_SELECT;
                Event->eventID  = BITMAP_SCH_WEEK_LEFT;
            }
        }
    }
#endif
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		if (prev_form_id == FORM_SCH_DATE)
		{
			SySetupGetDateSettings(FORM_SCH_DATE, TABLE_SCH_DATE, PUSH_SCH_DATE_JAN, GROUP_ID_SCH_DATE_YEAR, GROUP_ID_SCH_DATE_MONTH, prev_row_num, prev_col_num, &week_view_year, &mon, &mday);
			SchedulerGetWeekViewWeekNum(0, &week_view_year, &week_no);
			SchedulerUpdateWeekViewTable(week_view_year, week_no);
		}
		else
		{	
			if (!SySetupGetCountrySettings(&country))
				return FALSE;
			SchedulerGetDayViewDate(temp_date);
			week_view_year = SYSETUP_YEAR_OFFSET + (SHORT)(temp_date[0]);
			//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
			//RtcYMDToWday4(week_view_year, (SHORT)temp_date[1]-1, (SHORT)temp_date[2], &wday, &week_no);
			
			wday = Dt_Date_WDay(week_view_year, (SHORT)temp_date[1]-1, (SHORT)temp_date[2]);
			week_no = Dt_Date_YWeek(week_view_year, (SHORT)temp_date[1]-1, (SHORT)temp_date[2], country.start_of_week, &dummy);
			week_view_year = dummy;
			
			//if (week_no == 0)
			//week_no = Dt_Date_YWeek(--week_view_year, 11, 31, country.start_of_week);
			
			//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
			
			if (country.start_of_week == SYSETUP_MON && wday == 0)
			{
				/////////////////////////////////////////////////////////////////////////////////////////////////
				/*
				if (week_no > 1)
				week_no--;
				else
				RtcYMDToWday3(--week_view_year, 11, 31, &wday, &week_no);
				*/
				/////////////////////////////////////////////////////////////////////////////////////////////////
				if (wday == 0)
				{
					if (week_no == 0)
					{
						if (week_view_year > 1905)
						{
							week_view_year--;
							//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
							//RtcYMDToWday3(week_view_year, 11, 31, &wday, &week_no);
							week_no = Dt_Date_Y7day(week_view_year, 11, 31);
							//kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
						}
						}/*
						 else
					week_no--;*/
				}
			}
			SchedulerUpdateWeekViewTable(week_view_year, week_no);
			
			
			
		}
		
		return TRUE;
		
	case EVT_CONTROL_POPUP_SELECT:
		switch(Event->eventID)
		{
		case POPUP_TRIGGER_APP_SELECT:
			SchedulerGotoPopupForm(FORM_SCH_WEEK, FALSE);
			return TRUE;
			
		default:	return FALSE;
		}
		
		
		case EVT_CONTROL_SELECT:
			switch(Event->eventID)
			{	
			case BUTTON_SCH_MONTH_GOTO:
				prev_form_id = FORM_SCH_WEEK;
				FormInitAllFormObjects(FORM_SCH_DATE);
				FormPopupForm(FORM_SCH_DATE);
				return TRUE;
				// -------------------------------- modified at 270300 ----------------------------------
			case CHECKBOX_SCH_DAY_VIEW:
				ControlPopupSetSelectedItem(POPUP_TRIGGER_APP_SELECT, 1);
				SchedulerGotoPopupForm(FORM_SCH_WEEK, FALSE);
				//FormPopupForm(FORM_SCH_DAY_VIEW);
				return TRUE;
			case CHECKBOX_SCH_WEEK_VIEW:
				return TRUE;
			case CHECKBOX_SCH_MONTH_VIEW:
				ControlPopupSetSelectedItem(POPUP_TRIGGER_APP_SELECT, 3);
				SchedulerGotoPopupForm(FORM_SCH_WEEK, FALSE);
				//FormPopupForm(FORM_SCH_MONTH);
				return TRUE;
				// ---------------------------------------------------------------------------------------
			default:	return FALSE;
			}
			
			case EVT_BITMAP_SELECT:
				switch (Event->eventID)
				{
				case BITMAP_SCH_WEEK_LEFT:
					SchedulerGetWeekViewWeekNum(-1, &week_view_year, &week_no);
					SySetupGetCountrySettings(&country);
					if (country.start_of_week == SYSETUP_MON)
					{
						if (week_view_year >= 1904 && week_view_year <= 2099)
						{
							if (week_view_year == 1904 && week_no < 52)
								return TRUE;
							SchedulerUpdateWeekViewTable(week_view_year, week_no);
						}
					}
					else
					{
						if (week_view_year >= 1905 && week_view_year <= 2099)
							SchedulerUpdateWeekViewTable(week_view_year, week_no);
					}
					return TRUE;
					
				case BITMAP_SCH_WEEK_RIGHT:
					SchedulerGetWeekViewWeekNum(1, &week_view_year, &week_no);
					if (week_view_year >= 1904 && week_view_year <= 2099)
						SchedulerUpdateWeekViewTable(week_view_year, week_no);
					return TRUE;
				default:	return FALSE;
				}
				case EVT_SCHLINE_SELECT:
					if (Event->para1 < 1 || Event->para1 > 7)
						return TRUE;
					SySetupGetCountrySettings(&country);
					SchedulerGetWeekViewWeekNum(0, &week_view_year, &week_no);
					d_day = 31;
					do
					{
						total_week_no = Dt_Date_YWeek(week_view_year, 11, d_day, country.start_of_week, &dummy);
						d_day--;
					}while(total_week_no == 1);
					
					if (country.start_of_week == SYSETUP_MON)
					{
						if (Event->para1 == 7)
						{
							Event->para1 = 1;
						}
						else
							Event->para1++;
					}
					
					Dt_YWeek_Date(week_view_year, week_no, Event->para1-1, country.start_of_week, &pDate);
					mon = pDate.mon;
					mday = pDate.mday;
					if (pDate.year < 1905)
					{
						if (week_no == total_week_no)
							week_view_year = 1904;
						else
							week_view_year = 1905;
						mon = 0;
						mday = 1;
					}
					if (pDate.year > 2099)
					{
						week_view_year = 2099;
						mon = 11;
						mday = 31;
					}
					
					if (country.start_of_week == SYSETUP_MON)
					{
						if ((week_no == 1) && (mday > 7))
							SchedulerSetDayViewDate(week_view_year-1, mon+1, mday, Event->para1-2);
						else if((week_no == total_week_no) && mday < 8)
							SchedulerSetDayViewDate(week_view_year+1, mon+1, mday, Event->para1-2);
						else
							SchedulerSetDayViewDate(week_view_year, mon+1, mday, Event->para1-2);
					}
					else
					{
						if ((week_no == 1) && (mday > 7))
							SchedulerSetDayViewDate(week_view_year-1, mon+1, mday, Event->para1-1);
						else if((week_no == total_week_no) && mday < 8)
							SchedulerSetDayViewDate(week_view_year+1, mon+1, mday, Event->para1-1);
						else
							SchedulerSetDayViewDate(week_view_year, mon+1, mday, Event->para1-1);
					}
					
					SchedulerGetDayViewDate(temp_date);
					SchedulerDayViewLoadAppmtDataToScreen(&virtual_table, temp_date);
					prev_form_id = FORM_SCH_WEEK;
					ControlPopupSetSelectedItem(POPUP_TRIGGER_APP_SELECT, 1);
					FormSetControlGroupSelection(FORM_SCH_DAY_VIEW, CHECKBOX_SCH_DAY_VIEW);
					FormPopupForm(FORM_SCH_DAY_VIEW);
					return TRUE;
					
				case EVT_INLAY_SELECT:
					switch(Event->para1)
					{
					case INLAY_OK:
						SysGetAppID(MAINMENU, &appid);
						EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
						EvtAppendEvt(EVT_APP_LAUNCH, appid, 0, 0, NULL);
						return TRUE;
						
					case INLAY_EXIT:
						SysGetAppID(MAINMENU, &appid);
						EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
						EvtAppendEvt(EVT_APP_LAUNCH, appid, 0, 0, NULL);
						return TRUE;
					default:	return FALSE;
					}
					
	}
	
	return FALSE;
}

/********************************************************
* Function:    SchedulerNoMem
* Purpose: 	This function is called to handle the event for the form
FORM_SCH_NO_MEM
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerNoMem(EvtType *Event)
{
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
            if (Event->para2 == 'X' || Event->para2 == 'x')
            {
                Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }
        }
    }
	
	switch (Event->eventType)
	{
	case EVT_BITMAP_SELECT:
		if (!recorded)
			FormPopupForm(FORM_SCH_ALARM);
		else
		{
			FormDrawForm(FORM_SCH_ALARM);
			FormPopupForm(FORM_SCH_REC);
		}
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			if (!recorded)
				FormPopupForm(FORM_SCH_ALARM);
			else
			{
				FormDrawForm(FORM_SCH_ALARM);
				FormPopupForm(FORM_SCH_REC);
			}
		}
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SCH_LOW_MEMORY);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}
/********************************************************
* Function:    SchedulerLowBattery
* Purpose:     This function is called to handle the event to FORM_SCH_VOICE_LOW_BATTERY
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerLowBattery(EvtType* Event)
{
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
        if ((Event->para2 & 0x00000200))
		{
            if (Event->para2 == 'X' || Event->para2 == 'x')
            {
                Event->eventType    = EVT_BITMAP_SELECT;
                Event->eventID      = 0;
                Event->evtPBP       = NULL;
            }
        }
    }
	
    switch (Event->eventType)
    {
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SCH_VOICE_LOW_BATTERY);
		return TRUE;
	case EVT_BITMAP_SELECT:
		FormPopupForm(low_battery_form_id);
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			FormPopupForm(low_battery_form_id);
			return TRUE;
		}
		break;
	default:
		return FALSE;
    }
}

/********************************************************
* Function:	SchedulerLowMemoryHandle
* Purpose: 	This function is the event handler for the FORM_PB_LOW_MEMORY
page of the Phonebook application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerLowMemoryHandle(EvtType* Event)
{
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if ((Event->para2 & 0x00000200))
		{
			if (Event->para2 == LLETTER_X || Event->para2 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
				Event->eventID      = 0;
				Event->evtPBP       = NULL;
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_BITMAP_SELECT:	
		FormPopupForm(FORM_SCH_DAY_VIEW);
		break;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para2 == INLAY_EXIT)
			FormPopupForm(FORM_SCH_DAY_VIEW);
		break;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SCH_LOW_MEMORY);
		break;
	default:
		break;
	}
	return TRUE;
}

// Michelle new add funciton
/********************************************************
* Function:	SchedulerRepeatSettings
* Purpose: 	This function is the event handler for the FORM_SCH_REPEAT
page of the Scheduler application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerRepeatSettings(EvtType* Event)
{
	ObjectID control_id;
	Control *control_ptr;
	BYTE object_type;
	BYTE *every_info_string;
	void * addr;
	UBYTE date[4];
	SHORT item_num;
	SHORT i, year, month, day, wday, n_week;
	SHORT num_string;
	SHORT status;
	CountrySettings country;
	BOOLEAN weekday_flag = FALSE;
	BOOLEAN found;
	// =====================================================================================
	// modified at 27072000
	BOOLEAN	new_repeat_appointment = TRUE;
	// ====================================================================================
	
	SySetupGetCountrySettings(&country);
	if (country.start_of_week == SYSETUP_SUN) weekday_flag = TRUE;
	else weekday_flag = FALSE;
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == 'N' || Event->para1 == 'n')
			{
			}
			else if (Event->para1 == 'F' || Event->para1 == 'f')
			{
			}
			else if (Event->para1 == 'V' || Event->para1 == 'v')
			{
			}
			else if (Event->para1 == 'T' || Event->para1 == 't')
			{
			}
			else if (Event->para1 == 'X' || Event->para1 == 'x')
			{
			}
			else if (Event->para1 == '0')
			{
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_KEY:
		if (Event->eventID == SOFT_KEY)
		{
			if (Event->para1 >= 48 && Event->para1 <= 58)
			{
				TextboxAddKeyInChar(TEXTBOX_SCH_REPEAT_VALUE, Event->para1);
				return TRUE;
			}
		}
		return FALSE;
	case EVT_CONTROL_POPUP_SELECT:
		switch(Event->eventID)
		{
		case POPUP_TRIGGER_REPEAT_END_SELECT:
			ControlPopupGetSelectedItem(POPUP_TRIGGER_REPEAT_END_SELECT, &item_num);
			if (item_num == 1)
			{
				prev_form_id = FORM_SCH_REPEAT;
				FormInitAllFormObjects(FORM_SCH_DATE);
				FormPopupForm(FORM_SCH_DATE);
			}
			else
			{
				i = 6;
				do
				{
					repeat_settings.end_date[i] = 0xFF;
					i--;
				}while(i >= 0);
			}
			// new add 07072000
			repeat_settings.change = TRUE;
			return TRUE;
		}
		return FALSE;
		case EVT_CONTROL_SELECT:
			FormGetObjectPointer(Event->eventID, &object_type, (void**)&addr);
			switch (Event->eventID)
			{
			case PUSHBUTTON_SCH_REPEAT_NONE:
				if (repeat_settings.default_method == REPEAT_NONE)
					repeat_settings.new_repeat = FALSE;
				else repeat_settings.new_repeat = TRUE;
				SchedulerRepeatSetUpScreen(NONE);
				repeat_settings.change = TRUE;
				return TRUE;
			case PUSHBUTTON_SCH_REPEAT_DAY:
				if (repeat_settings.default_method == REPEAT_DAILY)
					repeat_settings.new_repeat = FALSE;
				else repeat_settings.new_repeat = TRUE;
				SchedulerRepeatSetUpScreen(DAY);
				repeat_settings.change = TRUE;
				repeat_settings.method = REPEAT_DAILY;
				repeat_settings.every_info = 1;
				return TRUE;
			case PUSHBUTTON_SCH_REPEAT_WEEK:
				if (repeat_settings.default_method == REPEAT_WEEKLY)
					repeat_settings.new_repeat = FALSE;
				else repeat_settings.new_repeat = TRUE;
				SchedulerRepeatSetUpScreen(WEEK);
				repeat_settings.change = TRUE;
				repeat_settings.method = REPEAT_WEEKLY;
				repeat_settings.every_info = 1;
				return TRUE;
			case PUSHBUTTON_SCH_REPEAT_MONTH:
				if ((repeat_settings.default_method == REPEAT_MONTHLY_DATE)
					|| (repeat_settings.default_method == REPEAT_MONTHLY_DAY))
					repeat_settings.new_repeat = FALSE;
				else repeat_settings.new_repeat = TRUE;
				SchedulerRepeatSetUpScreen(MONTH);
				repeat_settings.change = TRUE;
				repeat_settings.method = REPEAT_MONTHLY_DATE;
				repeat_settings.every_info = 1;
				return TRUE;
			case PUSHBUTTON_SCH_REPEAT_YEAR:
				if (repeat_settings.default_method == REPEAT_YEARLY)
					repeat_settings.new_repeat = FALSE;
				else repeat_settings.new_repeat = TRUE;
				SchedulerRepeatSetUpScreen(YEAR);
				repeat_settings.change = TRUE;
				repeat_settings.method = REPEAT_YEARLY;
				repeat_settings.every_info = 1;
				return TRUE;
			case PUSHBUTTON_SCH_REPEAT_SUN:
				if (SchedulerRepeatCheckPushbutton(PUSHBUTTON_SCH_REPEAT_SUN))
				{
					if (((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value)
						repeat_settings.every_data += 64;
					else repeat_settings.every_data -= 64;
				}
				repeat_settings.change = TRUE;
				return TRUE;
			case PUSHBUTTON_SCH_REPEAT_MON:
				if (SchedulerRepeatCheckPushbutton(PUSHBUTTON_SCH_REPEAT_MON))
				{
					if (((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value)
						repeat_settings.every_data += 32;
					else repeat_settings.every_data -= 32;
				}
				repeat_settings.change = TRUE;
				return TRUE;
			case PUSHBUTTON_SCH_REPEAT_TUE:
				if (SchedulerRepeatCheckPushbutton(PUSHBUTTON_SCH_REPEAT_TUE))
				{
					if (((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value)
						repeat_settings.every_data += 16;
					else repeat_settings.every_data -= 16;
				}
				repeat_settings.change = TRUE;
				return TRUE;
			case PUSHBUTTON_SCH_REPEAT_WED:
				if (SchedulerRepeatCheckPushbutton(PUSHBUTTON_SCH_REPEAT_WED))
				{
					if (((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value)
						repeat_settings.every_data += 8;
					else repeat_settings.every_data -= 8;
				}
				repeat_settings.change = TRUE;
				return TRUE;
			case PUSHBUTTON_SCH_REPEAT_THU:
				if (SchedulerRepeatCheckPushbutton(PUSHBUTTON_SCH_REPEAT_THU))
				{
					if (((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value)
						repeat_settings.every_data += 4;
					else repeat_settings.every_data -= 4;
				}
				repeat_settings.change = TRUE;
				return TRUE;
			case PUSHBUTTON_SCH_REPEAT_FRI:
				if (SchedulerRepeatCheckPushbutton(PUSHBUTTON_SCH_REPEAT_FRI))
				{
					if (((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value)
						repeat_settings.every_data += 2;
					else repeat_settings.every_data -= 2;
				}
				repeat_settings.change = TRUE;
				return TRUE;
			case PUSHBUTTON_SCH_REPEAT_SAT:
				if (SchedulerRepeatCheckPushbutton(PUSHBUTTON_SCH_REPEAT_SAT))
				{
					if (((ControlTemplatePushButton*)(((Control*)addr)->control_template))->control_value)
						repeat_settings.every_data += 1;
					else repeat_settings.every_data -= 1;
				}
				repeat_settings.change = TRUE;
				return TRUE;
			case PUSHBUTTON_SCH_REPEAT_MONTH_DATE:
				repeat_settings.method = REPEAT_MONTHLY_DATE;
				repeat_settings.change = TRUE;
				return TRUE;
			case PUSHBUTTON_SCH_REPEAT_MONTH_DAY:
				repeat_settings.method = REPEAT_MONTHLY_DAY;
				repeat_settings.change = TRUE;
			default: return FALSE;
		}
		return FALSE;
	case EVT_FORM_OPEN:
		if (!repeat_settings.change)
		{
			if (SchedulerRestoreRepeatSettings(&status, 0)) repeat_settings.new_repeat = TRUE;
			else repeat_settings.new_repeat = FALSE;
		}
		else
		{
			status = repeat_settings.method;
			if ((status == REPEAT_MONTHLY_DATE) || (status == REPEAT_MONTHLY_DAY))
				status = MONTH;
			if (status == REPEAT_YEARLY)
				status = YEAR;
			repeat_settings.new_repeat = FALSE;
		}
		SchedulerRepeatSetUpScreen(status);
		FormDrawForm(FORM_SCH_REPEAT);
		return TRUE;
	case EVT_BITMAP_SELECT:
		//Michelle 020200
		if (repeat_settings.every_info == 0 && repeat_settings.method != REPEAT_NONE)
		{
			FormPopupForm(FORM_REPEAT_INVALID_INPUT);
			return TRUE;
		}
		//020200
		if (repeat_settings.change == TRUE)
			FormPopupForm(FORM_REPEAT_SAVE_CHANGES);
		else
			FormPopupForm(FORM_SCH_DAY_VIEW);
		return TRUE;
	case EVT_TEXTBOX_MODIFIED:
		FormGetObjectPointer(TEXTBOX_SCH_REPEAT_VALUE, &object_type, (void**)&addr);
		repeat_settings.every_info = atol((const char*)((Textbox*)addr)->textbox_string);
		repeat_settings.change = TRUE;
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK)
		{
			if (repeat_settings.every_info == 0 && repeat_settings.method != REPEAT_NONE)
			{
				FormPopupForm(FORM_REPEAT_INVALID_INPUT);
				return TRUE;
			}
			if (repeat_settings.method != NONE && repeat_settings.change)
			{
				if (!virtual_table.vt_items[virtual_table.vt_active_row]->repeat)
				{
					repeat_settings.repeat_num = current_repeat_num;
					current_repeat_num++;
				}
				else
				{
					repeat_settings.repeat_num = virtual_table.vt_items[virtual_table.vt_active_row]->repeat_num;
					new_repeat_appointment = FALSE;
					if (virtual_table.vt_items[virtual_table.vt_active_row]->alarm != NO_ALARM)
					{
						repeat_settings.alarm = virtual_table.vt_items[virtual_table.vt_active_row]->alarm;
						repeat_settings.alarm_num = virtual_table.vt_items[virtual_table.vt_active_row]->alarm_num;
						repeat_settings.alarm_time = virtual_table.vt_items[virtual_table.vt_active_row]->alarm_time;
					}
				}
				if (repeat_settings.method == REPEAT_MONTHLY_DAY)
				{
					if (SchedulerCheckLastWday())
						return TRUE;
				}
				FormGetObjectPointer(TEXTBOX_SCH_REPEAT_VALUE, &object_type, (void**)&addr);
				num_string = strlen(((Textbox*)addr)->textbox_string);
				every_info_string = (BYTE*)qmalloc(num_string*sizeof(BYTE));
				strcpy(every_info_string, ((Textbox*)addr)->textbox_string);
				repeat_settings.every_info = atol((const char*)every_info_string);
				//Bug Fixed 14-Feb-2001
				//				SchedulerSaveRepeatSettings(FALSE, TRUE);
				if (!new_repeat_appointment)
				{
					FormSetFormActiveObject(FORM_SCH_DAY_VIEW, BUTTON_SCH_DAY_VIEW_NEW);
					SchedulerSaveRepeatSettings(FALSE, FALSE);
				}
				else
				{
					FormSetFormActiveObject(FORM_SCH_DAY_VIEW, BUTTON_SCH_DAY_VIEW_NEW);
					SchedulerSaveRepeatSettings(FALSE, TRUE);
				}
				
				// Prevent show incorrect record in day view
				if (repeat_settings.method == REPEAT_WEEKLY)
				{
					SchedulerGetDayViewDate(date);
					SchedulerDayViewSaveAppmtData(&virtual_table, date);
					year = (SHORT)(date[0] + SYSETUP_YEAR_OFFSET);
					month = (SHORT)date[1];
					day = (SHORT)date[2];
					wday = Dt_Date_WDay(year, month - 1, day);
					
					found = SchedulerCalculatePopupDate(date, wday);
					if (found == TRUE)
					{
						SchedulerSaveRepeatSettings(FALSE, TRUE);
						strcpy(virtual_table.vt_items[virtual_table.vt_active_row]->ptr->field_string, "");
						virtual_table.vt_items[virtual_table.vt_active_row]->appointment = -1;
						virtual_table.vt_active_row = -1;
					}
					//Bug Fixed 14-Feb-2001
					//Dont save all the appointments again
					//------------------------------------------------------- Modifying Codes
					SchedulerGetDayViewDate(date);
					SchedulerDayViewLoadAppmtDataToScreen(&virtual_table, date);
				}
				else
				{
					SchedulerGetDayViewDate(date);
					SchedulerDayViewSaveAppmtData(&virtual_table, date);
					SchedulerDayViewLoadAppmtDataToScreen(&virtual_table, date);
				}
				FormPopupForm(FORM_SCH_DAY_VIEW);
				//------------------------------------------------------- Modifying Codes
			}
			else
			{
				if (repeat_settings.method == REPEAT_NONE && repeat_settings.new_repeat && repeat_settings.change)
				{
					SchedulerDeleteRepeatDB(repeat_settings.repeat_num, FALSE);
					SchedulerSaveAndSetAlarm();
					FormPopupForm(FORM_SCH_DAY_VIEW);
				}
				else FormPopupForm(FORM_SCH_DAY_VIEW);
			}
		}
		else if (Event->para1 == INLAY_EXIT)
		{
			//Michelle 020200
			if (repeat_settings.every_info == 0 && repeat_settings.method != REPEAT_NONE)
			{
				FormPopupForm(FORM_REPEAT_INVALID_INPUT);
				return TRUE;
			}
			//020200
			if (repeat_settings.change == TRUE)
				FormPopupForm(FORM_REPEAT_SAVE_CHANGES);
			else FormPopupForm(FORM_SCH_DAY_VIEW);
		}
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	SchedulerRepeatSaveChanges
* Purpose: 	This function is the event handler for the
*				FORM_REPEAT_SAVE_CHANGES page of the
*				Scheduler application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE - if handled
FALSE - if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerRepeatSaveChanges(EvtType* Event)
{
	SHORT num_string;
	BYTE object_type;
	BYTE *every_info_string;
	void *addr;
	UWORD i, rec_id, total_rec;
	BYTE repeat_no[5];
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_REPEAT_SAVE_CHANGES_YES;
				Event->evtPBP = NULL;
			}
			else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_REPEAT_SAVE_CHANGES_NO;
				Event->evtPBP = NULL;
			}
			else if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_REPEAT_SAVE_CHANGES_X;
				Event->evtPBP = NULL;
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_REPEAT_SAVE_CHANGES_YES)
		{
			if (repeat_settings.method != NONE && repeat_settings.change)
			{
				if (!virtual_table.vt_items[virtual_table.vt_active_row]->repeat)
				{
					repeat_settings.repeat_num = current_repeat_num;
					current_repeat_num++;
				}
				else
				{
					repeat_settings.repeat_num = virtual_table.vt_items[virtual_table.vt_active_row]->repeat_num;
					//	FormPopupForm(FORM_REPEAT_APPLY_ALL);
					//	return TRUE;
				}
				FormGetObjectPointer(TEXTBOX_SCH_REPEAT_VALUE, &object_type, (void**)&addr);
				num_string = strlen(((Textbox*)addr)->textbox_string);
				every_info_string = (BYTE*)qmalloc(num_string*sizeof(BYTE));
				strcpy(every_info_string, ((Textbox*)addr)->textbox_string);
				repeat_settings.every_info = atol((const char*)every_info_string);
				SchedulerSaveRepeatSettings(FALSE, TRUE);
			}
			else if (repeat_settings.method == NONE)
			{
				SchedulerDeleteRepeatDB(repeat_settings.repeat_num, FALSE);
				SchedulerSaveAndSetAlarm();
			}
			FormPopupForm(FORM_SCH_DAY_VIEW);
		}
		else FormPopupForm(FORM_SCH_DAY_VIEW);
		return TRUE;
	case EVT_BITMAP_SELECT:
		FormPopupForm(FORM_SCH_REPEAT);
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_REPEAT_SAVE_CHANGES);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	SchedulerRepeatApplyAll
* Purpose: 	This function is the event handler for the
*				FORM_REPEAT_APPLY_ALL page of the
*				Scheduler application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE - if handled
FALSE - if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerRepeatApplyAll(EvtType* Event)
{
	RecordID	rec_id, voice_rec_id;
	UWORD		rec_num, bye_read, voice_count, voice_rec_num, byte_read;
	UBYTE		appmt_alarm_date[4], date[4];
	BYTE		repeat_no[5];
	BYTE		buffer[6], *temp;
	SHORT		j;
	AlarmAttr	alarm_attr;
	AlarmAttr	*temp_attr;
	BYTE		alarm;
	UWORD		total;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == 'Y' || Event->para1 == 'y')
			{
			}
			else if (Event->para1 == 'N' || Event->para1 == 'n')
			{
			}
			else if (Event->para1 == 'X' || Event->para1 == 'x')
			{
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_CONTROL_SELECT:
		switch(Event->eventID)
		{
		case BUTTON_REPEAT_CURRENT:
			if (prev_status == ALARM_SET_STATUS)
			{
				virtual_table.vt_items[virtual_table.vt_active_row]->alarm = repeat_settings.alarm;
				virtual_table.vt_items[virtual_table.vt_active_row]->alarm_time = repeat_settings.alarm_time;
				virtual_table.vt_items[virtual_table.vt_active_row]->alarm_num = repeat_settings.alarm_num;
				virtual_table.vt_items[virtual_table.vt_active_row]->dbid = sch_voice_dbid;
				virtual_table.vt_items[virtual_table.vt_active_row]->recid = repeat_settings.voice_recid;
				//Bug Fixed 20-Feb-2001
				//Mark the appmt_num as modified
				virtual_table.vt_items[virtual_table.vt_active_row]->appmt_num = current_appmt_num|0x80000000;
				current_appmt_num++;
				SchedulerSaveAndSetAlarm();
			}
			else if (prev_status == ALARM_CHANGE_STATUS)
			{
				if (repeat_settings.alarm == VOICE_ALARM)
				{
					DataRecIDtoNum(sch_voice_dbid, time_settings.dbid, &voice_rec_num);
					DataOpenRecord(sch_voice_dbid, voice_rec_num, &voice_rec_id, NULL);
					DataGetField(sch_voice_dbid, voice_rec_id, 2, &temp, &byte_read);
					voice_count = *((UWORD*)temp);
					qfree(temp);
					voice_count++;
					DataWriteField(sch_voice_dbid, voice_rec_id, 2, sizeof(UWORD), (BYTE*)&voice_count);
					DataCloseRecord(sch_voice_dbid, voice_rec_id);
				}
				virtual_table.vt_items[virtual_table.vt_active_row]->alarm = repeat_settings.alarm;
				virtual_table.vt_items[virtual_table.vt_active_row]->alarm_time = repeat_settings.alarm_time;
				virtual_table.vt_items[virtual_table.vt_active_row]->alarm_num = repeat_settings.alarm_num;
				virtual_table.vt_items[virtual_table.vt_active_row]->dbid = sch_voice_dbid;
				virtual_table.vt_items[virtual_table.vt_active_row]->recid = repeat_settings.voice_recid;
				//Bug Fixed 20-Feb-2001
				//Mark the appmt_num as modified
				virtual_table.vt_items[virtual_table.vt_active_row]->appmt_num = current_appmt_num|0x80000000;
				current_appmt_num++;
				SchedulerSaveAndSetAlarm();
			}
			else if (prev_status == TIME_STATUS)
			{
				if (virtual_table.vt_items[time_settings.row_num]->repeat)
				{
					if (virtual_table.vt_items[time_settings.row_num]->alarm == VOICE_ALARM)
					{
						virtual_table.vt_items[time_settings.row_num]->dbid = sch_voice_dbid;
						DataRecIDtoNum(sch_voice_dbid, time_settings.dbid, &voice_rec_num);
						DataOpenRecord(sch_voice_dbid, voice_rec_num, &voice_rec_id, NULL);
						DataGetField(sch_voice_dbid, voice_rec_id, 2, &temp, &byte_read);
						voice_count = *((UWORD*)temp);
						qfree(temp);
						voice_count++;
						DataWriteField(sch_voice_dbid, voice_rec_id, 2, sizeof(UWORD), (BYTE*)&voice_count);
						DataCloseRecord(sch_voice_dbid, voice_rec_id);
					}
					repeat_settings.repeat_num = virtual_table.vt_items[time_settings.row_num]->repeat_num;
					SchedulerTimeSettingsOK(&virtual_table);
				}
			}
			SchedulerSaveException();
			SchedulerTimeSettingsDeleteAllEmptyAppmts(&virtual_table);
			SchedulerTimeSettingsAddAppmts(&virtual_table);
			VTSetVirtualTableLayout(&virtual_table);
			VTVirtualTableSetScrollbar(&virtual_table);
			VTTransferAllToRT(&virtual_table, TABLE_SCH_DAY_VIEW);
			TableDrawTable(TABLE_SCH_DAY_VIEW);
			SchedulerDayViewDrawAppointmentColumn(&virtual_table, TABLE_SCH_DAY_VIEW);
			repeat_settings.alarm = 0;
			repeat_settings.alarm_time = 0;
			repeat_settings.alarm_num = 0;
			repeat_settings.voice_recid = 0;
			SchedulerSaveAndSetAlarm();
			FormPopupForm(FORM_SCH_DAY_VIEW);
			return TRUE;
		case BUTTON_REPEAT_ALL:
			if (prev_status == DELETE_STATUS)
			{
				if (SchedulerDeleteRepeatDB(virtual_table.vt_items[virtual_table.vt_active_row]->repeat_num, TRUE) == TRUE)
				{
					SchedulerTimeSettingsDeleteAllEmptyAppmts(&virtual_table);
					SchedulerTimeSettingsAddAppmts(&virtual_table);
					VTSetVirtualTableLayout(&virtual_table);
					VTVirtualTableSetScrollbar(&virtual_table);
					VTTransferAllToRT(&virtual_table, TABLE_SCH_DAY_VIEW);
					TableDrawTable(TABLE_SCH_DAY_VIEW);
					SchedulerDayViewDrawAppointmentColumn(&virtual_table, TABLE_SCH_DAY_VIEW);
					SchedulerGetDayViewDate(date);
					if (SchedulerFindNextAppmtAlarmDate(date, appmt_alarm_date))
					{
						if (SchedulerCompareDate(date, appmt_alarm_date) <= 1)
							SchedulerSetAppmtWholeDayAlarm(appmt_alarm_date);
					}
					SchedulerSetAppmtWholeDayAlarm(date);
				}
				FormPopupForm(FORM_SCH_DAY_VIEW);
			}
			else if (prev_status == ALARM_SET_STATUS || prev_status == ALARM_CHANGE_STATUS)
			{
				alarm = 1;
				SchedulerAlarmSave();
				repeat_settings.alarm_num = time_settings.alarm_num;
				*(UWORD*)repeat_no = virtual_table.vt_items[virtual_table.vt_active_row]->repeat_num;
				repeat_no[4] = 0;
				DataFindBinRecord(sch_repeat_dbid, F_REPEAT_NUM, 0, repeat_no, 4, &rec_id);
				DataRecIDtoNum(sch_repeat_dbid, rec_id, &rec_num);
				DataOpenRecord(sch_repeat_dbid, rec_num, &rec_id, NULL);
				DataWriteField(sch_repeat_dbid, rec_id, F_ALARM_FLAG, 1, (BYTE*)&alarm);
				alarm_attr.time = repeat_settings.alarm_time;
				alarm_attr.type = repeat_settings.alarm;
				alarm_attr.num = repeat_settings.alarm_num;
				DataWriteField(sch_repeat_dbid, rec_id, F_ALARM_SETTINGS, sizeof(AlarmAttr), (BYTE*)&alarm_attr);
#ifdef DEBUG_VOICE_ALARM
				printf("\n ====== Repeat Apply All =====");
				printf("\n repeat_settings.repeat_num = %ld", repeat_settings.repeat_num);
				printf("\n repeat record id = %ld", rec_id);
				printf("\n repeat_settings.voice_recid = %ld", repeat_settings.voice_recid);
				printf("\n repeat_settings.alarm_num = %ld", repeat_settings.alarm_num);
#endif
				DataWriteField(sch_repeat_dbid, rec_id, F_VOICE_RECID, sizeof(UWORD), (BYTE*)&repeat_settings.voice_recid);
				DataCloseRecord(sch_repeat_dbid, rec_id);
				virtual_table.vt_items[virtual_table.vt_active_row]->alarm = repeat_settings.alarm;
				virtual_table.vt_items[virtual_table.vt_active_row]->alarm_time = repeat_settings.alarm_time;
				virtual_table.vt_items[virtual_table.vt_active_row]->alarm_num = repeat_settings.alarm_num;
				virtual_table.vt_items[virtual_table.vt_active_row]->dbid = sch_voice_dbid;
				virtual_table.vt_items[virtual_table.vt_active_row]->recid = repeat_settings.voice_recid;
				repeat_settings.alarm = 0;
				repeat_settings.alarm_time = 0;
				repeat_settings.alarm_num = 0;
				repeat_settings.voice_recid = 0;
				SchedulerSaveAndSetAlarm();
				FormPopupForm(FORM_SCH_DAY_VIEW);
			}
			else if (prev_status == TIME_STATUS)
			{
				SchedulerTimeSettingsOK(&virtual_table);
				if (virtual_table.vt_active_row != -1)
				{
					virtual_table.vt_items[virtual_table.vt_active_row]->alarm = repeat_settings.alarm;
					virtual_table.vt_items[virtual_table.vt_active_row]->alarm_time = repeat_settings.alarm_time;
					virtual_table.vt_items[virtual_table.vt_active_row]->alarm_num = repeat_settings.alarm_num;
					virtual_table.vt_items[virtual_table.vt_active_row]->dbid = sch_voice_dbid;
					virtual_table.vt_items[virtual_table.vt_active_row]->recid = repeat_settings.voice_recid;
				}
				SchedulerSaveRepeatSettings(FALSE, FALSE);
				SchedulerSaveAndSetAlarm();
				FormPopupForm(FORM_SCH_DAY_VIEW);
				prev_status = -1;
			}
			return TRUE;
		default: return FALSE;
		}
		return TRUE;
	case EVT_BITMAP_SELECT:
		FormPopupForm(FORM_SCH_DAY_VIEW);
		return TRUE;
	case EVT_FORM_OPEN:
		repeat_appointment = TRUE;
		FormDrawForm(FORM_REPEAT_APPLY_ALL);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}

/********************************************************
* Function:	ShedulerChooseMonthlyDayRepeat
* Purpose: 	This function is the event handler for the
*				FORM_CHOOSE_MONTHLY_DAY_REPEAT page of the
*				Scheduler application
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE - if handled
FALSE - if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerChooseMonthlyDayRepeat(EvtType *Event)
{
	BYTE object_type;
	void *addr;
	BYTE *every_info_string;
	SHORT num_string;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == 'Y' || Event->para1 == 'y')
			{
			}
			else if (Event->para1 == 'N' || Event->para1 == 'n')
			{
			}
			else if (Event->para1 == 'X' || Event->para1 == 'x')
			{
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_CHOOSE_MONTHLY_DAY_REPEAT);
		repeat_settings.n_week = 4;
		return TRUE;
	case EVT_CONTROL_SELECT:
		switch(Event->eventID)
		{
		case PUSHBUTTON_MONTHLY_DAY_REPEAT_4TH:
			repeat_settings.n_week = 4;
			break;
		case PUSHBUTTON_MONTHLY_DAY_REPEAT_LAST:
			repeat_settings.n_week = 5;
			break;
		}
		return TRUE;
		case EVT_BITMAP_SELECT:
			FormPopupForm(FORM_SCH_REPEAT);
			return TRUE;
		case EVT_INLAY_SELECT:
			if (Event->para1 == INLAY_OK)
			{
				FormGetObjectPointer(TEXTBOX_SCH_REPEAT_VALUE, &object_type, (void**)&addr);
				num_string = strlen(((Textbox*)addr)->textbox_string);
				every_info_string = (BYTE*)qmalloc(num_string*sizeof(BYTE));
				strcpy(every_info_string, ((Textbox*)addr)->textbox_string);
				repeat_settings.every_info = atol((const char*)every_info_string);
#ifdef DEBUG
				printf("\n &&&&& INSIDE CHOOSE WEEK NO &&&&&&");
				printf("\n &&&&& BEFORE SAVE REPEAT SETTINGS &&&&&&");
				printf("\n repeat_settings.every_data = %ld", repeat_settings.every_data);
				printf("\n repeat_settings.n_week = %ld", repeat_settings.n_week);
#endif
				SchedulerSaveRepeatSettings(FALSE, TRUE);
				FormPopupForm(FORM_SCH_DAY_VIEW);
				return TRUE;
			}
			else if (Event->para1 == INLAY_EXIT)
			{
				repeat_settings.n_week = 0;
				FormPopupForm(FORM_SCH_REPEAT);
				return TRUE;
			}
	}
	return FALSE;
}

/********************************************************
* Function:	ShedulerRepeatInvalidInput
* Purpose: 	This function is the event handler for the
*		FORM_REPEAT_INVALID_INPUT page of the
*		Scheduler application
* Scope:	application/internal
* Input:	Event		received event
* Output:	None
* Return:	TRUE - if handled
FALSE - if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerRepeatInvalidInput(EvtType *Event)
{
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if ((Event->para2 & 0x00000200))
		{
			if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType    = EVT_BITMAP_SELECT;
				Event->eventID      = BITMAP_REPEAT_INVALID_INPUT_X;
				Event->evtPBP       = NULL;
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_BITMAP_SELECT:
		FormEraseForm(FORM_REPEAT_INVALID_INPUT);
		FormDrawForm(FORM_SCH_DAY_VIEW);
		FormPopupForm(FORM_SCH_REPEAT);
		return TRUE;
	case EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			FormEraseForm(FORM_REPEAT_INVALID_INPUT);
			FormDrawForm(FORM_SCH_DAY_VIEW);
			FormPopupForm(FORM_SCH_REPEAT);
		}
		return TRUE;
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_REPEAT_INVALID_INPUT);
		return TRUE;
	default: return FALSE;
	}
	return FALSE;
}
