/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   app.h
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef __APP_H_
#define __APP_H_

#include "schsize.h"
#include "schlang.h"
#include "tdlann.h"
#include "system.h"
#include "SySetup.h"
#include "virtable.h"
#include "new_time.h"

/*****************************************************************
************************** Defines ********************************
******************************************************************/
#define EVT_DAY_VIEW_STRING_ENTER		17000
#define EVT_DAY_VIEW_STRING_EXIT		17001
#define EVT_DAY_VIEW_STRING_SELECT		17002

#define VT_TABLE_CHANGED			0
#define VT_TABLE_NOT_CHANGED			1
#define VT_FIELD_CHANGED			2

#define TO_LEFT					0
#define TO_RIGHT				1

#define MemoryLow				MemoryCheckMemLow()
#define MemoryNormal				!MemoryCheckMemLow()

#define SetAppmtNumHighBit(a)			a|0x80000000

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
extern AppID		app_id;
extern DatabaseID	sch_appmt_dbid;
extern DatabaseID	sch_voice_dbid;
extern DatabaseID	sch_repeat_dbid;
extern DatabaseID	sch_except_dbid;
extern VirtualTable	virtual_table;
extern RecordID		rec_rec_id;
extern BOOLEAN		recorded;
extern UWORD		alarm_count;
extern UWORD		current_appmt_num;
extern UWORD		current_repeat_num;
extern UWORD		repeat_bmp[8];
extern UWORD		repeat_tone_bmp[8];
extern UWORD		repeat_voice_bmp[8];
extern BYTE		prev_status;

//======================= Scheduler Database ========================
#define SCH_STATUS      0x80001000
#define SCH_DAY_VIEW	0x80001001

//======================= Scheduler Status Define (Close Application) ========================
//Field 0
#define RESTART			0
#define DAY_VIEW		1
#define WEEK_VIEW		2
#define MONTH_VIEW		3

//Field 1   -------------------------   font_size (1 byte)
//Field 2   -------------------------	alarm_count (UWORD)


//======================= Scheduler Day View Information ========================
//Field	0	-------------------------	editing date (3 bytes)

/*==================== Menu Item ===========================*/
// Michelle modify 021299
#define MENU_ITEM_COPY			0
#define MENU_ITEM_CUT			1
#define MENU_ITEM_REP			2
#define MENU_ITEM_PASTE 	        3
#define MENU_ITEM_UNDO          	4
#define MENU_ITEM_PURGE			5
#define MENU_ITEM_ZOOM          	6
// modify end 021299

//======================== Scheduler Repeat Status Define =====================
#define NONE	0
#define DAY	1
#define WEEK	2
#define MONTH	3
#define YEAR	4
#define OTHER	5

#define REPEAT_NONE		0
#define REPEAT_DAILY		1
#define REPEAT_WEEKLY		2
#define REPEAT_MONTHLY_DATE	3
#define REPEAT_MONTHLY_DAY	4
#define REPEAT_YEARLY		5

//======================= Scheduler Previous Status ========================
#define DELETE_STATUS		0
#define ALARM_CHANGE_STATUS	1
#define ALARM_SET_STATUS	2
#define TIME_STATUS			3
#define NEW_STATUS			4


/*****************************************************************
***************** Global Variables - FORM_SCH_DAY_VIEW ***********
*****************************************************************/
extern BOOLEAN new_appointment;
extern BOOLEAN repeat_appointment;
extern EvtType day_view_old_event;

/*****************************************************************
************ Global Variables - Database Structure ***********
*****************************************************************/
/* Scheduler Appointment Database Structure */
typedef struct _APPOINTMENT_DB
{
	BYTE			hour;
	BYTE			minute;
	BYTE			alarm;
	BYTE			alarm_time;
	UWORD			alarm_num;
	WORD			appointment;
	UWORD			appmt_num;
	DatabaseID		dbid;
	RecordID		recid;
}AppointmentDB;

#define F_DATE			0
#define F_DATA			1
#define F_STRING		2
#define F_ALARM			3
//#define F_APPMT_NUM		4


//Field 0 ------------------------- (BYTE)hour, (BYTE)minute, (BYTE)alarm, (BYTE)alarm_time, (WORD)appointment
//Field 1 ------------------------- AppointmentDB
//Field 2 ------------------------- string, .........
//Field 3 ------------------------- whether there is 1 or more alarm set in the date

// Michelle add 071299
/* Scheduler Repeat Database Structure */
typedef struct _REPEAT_ATTR
{
	BYTE method;
	BYTE every_info;
	BYTE every_data;
	BYTE n_week;
}RepeatAttr;

typedef struct _ALARM_ATTR
{
	BYTE time;
	BYTE type;
	UWORD num;
}AlarmAttr;

#define F_REPEAT_NUM		0
#define F_EXCEPT_FLAG		1
#define F_START_TIME		2
#define F_END_TIME		3
#define F_REPEAT_ATTR		4
#define F_ALARM_FLAG		5
#define F_ALARM_SETTINGS	6
#define F_VOICE_RECID              7
#define F_CONTENTS		8
#define F_ALARM_DATE            9

//Field 0 ------ (UWORD)Repeat number
//Field 1 ------ (BYTE)Exception flag
//Field 2 ------ (BYTE)yr_offset, (BYTE)month, (BYTE)day, (BYTE)hr, (BYTE)min, (BYTE)day_in_yr
//Field 3 ------ (BYTE)yr_offset, (BYTE)month, (BYTE)day, (BYTE)hr, (BYTE)min, (BYTE)day_in_yr
//Field 4 ------ (RepeatAttr)Repeat attribute
//Field 5 ------ (BYTE)Alarm flag
//Field 6 ------ (AlarmAttr)Alarm attribute
//Field 7 ------ (UWORD)Voice DB ID
//Field 8 ------ (BYTE*)Strings of content
//Field 9 ------ (BYTE)yr_offset, (BYTE)month, (BYTE)day

#define F_EXCEPT_DATE		1

//Field 0 ------ (UWORD)Repeat number: using define in repeat database
/*Field 1 ------ All the exception dates in the following format
				 (BYTE)yr_offset, (BYTE)month, (BYTE)day */

/*****************************************************************
************ Global Variables - FORM_SCH_TIME_SETTINGS ***********
*****************************************************************/
/*==================== TIME_SETTINGS =====================*/
typedef struct _TIME_SETTINGS
{
	BOOLEAN			new_appointment;
	BOOLEAN			new_appointment_with_time;
	BYTE			hour_start;
	BYTE			hour_end;
	BYTE			minute_start;
	BYTE			minute_end;
	BYTE			alarm;
	BYTE			alarm_time;
	UWORD			alarm_num;
	DatabaseID		dbid;
	RecordID		recid;
	WORD			row_num;
}TimeSettings;
extern TimeSettings time_settings;

/*****************************************************************
************ Global Variables - FORM_SCH_ALARM_SETTINGS ***********
*****************************************************************/
/*==================== ALARM_SETTINGS =====================*/
typedef struct _ALARM_SETTINGS
{
	BOOLEAN			change;
	BOOLEAN			recorded;
	DatabaseID		dbid;
	RecordID		org_recid;
	RecordID		temp_recid;
	BYTE			hour_start;
	BYTE			minute_start;
	BYTE			alarm;
	BYTE			alarm_time;
	UWORD			alarm_num;
	WORD			row_num;
}AlarmSettings;
extern AlarmSettings alarm_settings;

/*****************************************************************
************ Global Variables - FORM_SCH_REPEAT_SETTINGS *********
******************************************************************/
/*======================== REPEAT_SETTINGS ======================*/
typedef struct _REPEAT_SETTINGS
{
	UWORD repeat_num;
	BOOLEAN change;
	BOOLEAN new_repeat;
	BYTE exception;
	UBYTE start_date[7];
	UBYTE end_date[7];
	BYTE method;
	BYTE default_method;
	BYTE every_info;
	BYTE every_data;
	BYTE n_week;
	BYTE alarm;
	BYTE alarm_time;
	UWORD alarm_num;
	//Michelle add 310100
	UWORD voice_recid;
	//end add 310100
} RepeatSettings;
extern RepeatSettings repeat_settings;

typedef struct _ARRANGE_RECORD
{
	AppointmentDB record;
	USHORT row_num;
	RecordID appmt_recid;
	BOOLEAN repeat_flag;
}ArrangeRecord;

/*****************************************************************
************ Global Variables - FORM_SCH_REC ***********
*****************************************************************/
extern BOOLEAN		rec_stop;

/*****************************************************************
************ Global Variables - FORM_SCH_REPLAY ***********
*****************************************************************/
extern ObjectID		enter_form_id;
extern DatabaseID	voice_playing_dbid;
extern RecordID		voice_playing_recid;
extern UWORD		play_pause_frame;
extern BOOLEAN		play_stop;

/*****************************************************************
********************** OBJECT ID Defines **************************
*****************************************************************/
//==================== FORM_EMAIL_NAME_LIST ===================================
#define FORM_SCH_DAY_VIEW			0
#define POPUP_TRIGGER_APP_SELECT        	1
#define STRING_SCH_STATUS               	2
#define BITMAP_SCH_DAY_VIEW_ANN_ON		3
#define BITMAP_SCH_DAY_VIEW_TODO_ON		4
#define BITMAP_SCH_DAY_VIEW_ANN_OFF		152	
#define BITMAP_SCH_DAY_VIEW_TODO_OFF		153
#define BITMAP_SCH_DAY_VIEW_LEFT		5
#define BITMAP_SCH_DAY_VIEW_RIGHT		6
#define STRING_SCH_DAY_VIEW_DATE		7		
#define BUTTON_SCH_DAY_VIEW_NEW			8
#define BUTTON_SCH_DAY_VIEW_GOTO		9
#define TABLE_SCH_DAY_VIEW			10
#define STRING_SCH_DAY_VIEW_0			11
#define STRING_SCH_DAY_VIEW_1			12
#define STRING_SCH_DAY_VIEW_2			13
#define STRING_SCH_DAY_VIEW_3			14
#define STRING_SCH_DAY_VIEW_4			15
#define STRING_SCH_DAY_VIEW_5			16
#define STRING_SCH_DAY_VIEW_6			17
#define STRING_SCH_DAY_VIEW_7			18
#define STRING_SCH_DAY_VIEW_8			19
#define STRING_SCH_DAY_VIEW_9			20
#define STRING_SCH_DAY_VIEW_10			21
#define STRING_SCH_DAY_VIEW_11			22
#define FIELD_SCH_DAY_VIEW_0			23
#define FIELD_SCH_DAY_VIEW_1			24
#define FIELD_SCH_DAY_VIEW_2			25
#define FIELD_SCH_DAY_VIEW_3			26
#define FIELD_SCH_DAY_VIEW_4			27
#define FIELD_SCH_DAY_VIEW_5			28
#define FIELD_SCH_DAY_VIEW_6			29
#define FIELD_SCH_DAY_VIEW_7			30
#define FIELD_SCH_DAY_VIEW_8			31
#define FIELD_SCH_DAY_VIEW_9			32
#define FIELD_SCH_DAY_VIEW_10			33
#define FIELD_SCH_DAY_VIEW_11			34
#define BITMAP_SCH_DAY_VIEW_0			35
#define BITMAP_SCH_DAY_VIEW_1			36
#define BITMAP_SCH_DAY_VIEW_2			37
#define BITMAP_SCH_DAY_VIEW_3			38
#define BITMAP_SCH_DAY_VIEW_4			39
#define BITMAP_SCH_DAY_VIEW_5			40
#define BITMAP_SCH_DAY_VIEW_6			41
#define BITMAP_SCH_DAY_VIEW_7			42
#define BITMAP_SCH_DAY_VIEW_8			43
#define BITMAP_SCH_DAY_VIEW_9			44
#define BITMAP_SCH_DAY_VIEW_10			45
#define BITMAP_SCH_DAY_VIEW_11			46
#define SCROLLBAR_SCH_DAY_VIEW			47
#define	BUTTON_SCH_DAY_VIEW_ALARM		71
#define BUTTON_SCH_DAY_VIEW_DEL			99
//#define BUTTON_SCH_DAY_VIEW_PURGE		100
#define MENU_SCH_DAY_VIEW			151
#define CHECKBOX_SCH_DAY_VIEW			207
#define CHECKBOX_SCH_WEEK_VIEW			208
#define CHECKBOX_SCH_MONTH_VIEW			209

//==================== FORM_SCH_ALARM ===================================
#define FORM_SCH_ALARM				48
#define BITMAP_SCH_ALARM_X			49
#define PUSHBUTTON_SCH_ALARM_ON			50
#define PUSHBUTTON_SCH_ALARM_OFF		51
#define POPUP_TRIGGER_SCH_ALARM_TIME		52
#define PUSHBUTTON_SCH_ALARM_VOICE		53
#define PUSHBUTTON_SCH_ALARM_TONE		54
#define STRING_SCH_ALARM_0			55
#define STRING_SCH_ALARM_1			56

//==================== FORM_SCH_TIME_SETTINGS ===================================
#define FORM_SCH_TIME_SETTINGS			57
#define BITMAP_SCH_TIME_X			58
#define BUTTON_SCH_TIME_BACK_0			59
#define BUTTON_SCH_TIME_BACK_1			60
#define STRING_SCH_TIME_0			61
#define STRING_SCH_TIME_1			62
#define STRING_SCH_TIME_2			63
#define STRING_SCH_TIME_3			64
#define STRING_SCH_TIME_HOUR			65
#define STRING_SCH_TIME_MIN			66
#define LIST_SCH_TIME_HOUR_0			67
#define LIST_SCH_TIME_HOUR_1			68
#define LIST_SCH_TIME_MIN			69
#define BUTTON_SCH_TIME_NOTIME			70
//#define	BUTTON_SCH_TIME_ALARM		71


//==================== FORM_SCH_REC ===================================
#define FORM_SCH_REC				119
#define BITMAP_SCH_REC_RECORD			120
#define BITMAP_SCH_REC_X			121
#define BITMAP_SCH_REC_PAUSE			122
#define BITMAP_SCH_REC_STOP			123
#define STRING_SCH_REC_MIN			124
#define STRING_SCH_REC_MAX			125
#define STRING_SCH_REC_VOLUME			126
#define SCROLLBAR_SCH_REC			127

//==================== FORM_SCH_REPLAY ===================================
#define FORM_SCH_REPLAY				128
#define BITMAP_SCH_REPLAY_PLAY			129

//==================== FORM_SCH_ALARM_SAVE_CHANGES ===================================
#define FORM_SCH_ALARM_SAVE_CHANGES		130
#define BITMAP_SCH_ALARM_SAVE_CHANGES_X		131
#define STRING_SCH_ALARM_SAVE_CHANGES		132
#define BUTTON_SCH_ALARM_SAVE_CHANGES_YES	133
#define BUTTON_SCH_ALARM_SAVE_CHANGES_NO	134

//==================== FORM_SCH_ALARM_SELECT ===================================
#define FORM_SCH_ALARM_SELECT			135
#define BITMAP_SCH_ALARM_SELECT_X		136
#define STRING_SCH_ALARM_SELECT_0		137
#define STRING_SCH_ALARM_SELECT_1		138

//==================== FORM_SCH_ALARM_SELECT ===================================
#define FORM_SCH_VOICE_EXISTS			139
//#define BITMAP_SCH_ALARM_SELECT_X		136
#define STRING_SCH_VOICE_EXISTS			140
#define BUTTON_SCH_VOICE_EXISTS_PLAY		141
#define BUTTON_SCH_VOICE_EXISTS_REPLACE		142
#define BITMAP_SCH_VOICE_EXISTS_X		143

//==================== FORM_SCH_PURGE ==================================
#define FORM_SCH_PURGE				144
#define STRING_SCH_PURGE_0			145	
#define STRING_SCH_PURGE_1			146	
#define POPUP_TRIGGER_SCH_PURGE			147
#define CHECKBOX_SCH_PURGE			148
#define BUTTON_SCH_PURGE_PROCEED		149
#define BUTTON_SCH_PURGE_CANCEL			150

/*============== FORM_SCH_DATE ==================================*/
#define		FORM_SCH_DATE			72
#define		STRING_SCH_DATE_DATE		73
#define		PUSH_SCH_DATE_JAN		74
#define		PUSH_SCH_DATE_FEB		75
#define		PUSH_SCH_DATE_MAR		76
#define		PUSH_SCH_DATE_APR		77
#define		PUSH_SCH_DATE_MAY		78
#define		PUSH_SCH_DATE_JUN		79
#define		PUSH_SCH_DATE_JUL		80
#define		PUSH_SCH_DATE_AUG		81
#define		PUSH_SCH_DATE_SEP		82
#define		PUSH_SCH_DATE_OCT		83
#define		PUSH_SCH_DATE_NOV		84
#define		PUSH_SCH_DATE_DEC		85
#define		STRING_SCH_DATE_WDAY		86
#define		TABLE_SCH_DATE			87
#define		BITMAP_SCH_DATE_LEFT		88
#define		BITMAP_SCH_DATE_RIGHT		89
#define		BUTTON_SCH_DATE_DISABLE_BKGRD	90
#define		PUSH_SCH_DATE_Y1		91
#define		PUSH_SCH_DATE_Y2		92
#define		PUSH_SCH_DATE_Y3		93
#define		PUSH_SCH_DATE_Y4		94
#define		PUSH_SCH_DATE_Y5		95
#define		LINE_SCH_DATE_YUP		96
#define		LINE_SCH_DATE_YDWN		97
#define		BUTTON_SCH_DATE_TODAY		98

#define		GROUP_ID_SCH_DATE_MONTH		2
#define		GROUP_ID_SCH_DATE_YEAR		4

/*===============================================================*/
/*============== FORM_SCH_MONTH =================================*/
#define		FORM_SCH_MONTH			101
#define		BITMAP_SCH_MONTH_LEFT		102
#define		BITMAP_SCH_MONTH_RIGHT		103
#define		STRING_SCH_MONTH_MONTH		104
#define		STRING_SCH_MONTH_WDAY1		105
#define		STRING_SCH_MONTH_WDAY2		106
#define		STRING_SCH_MONTH_WDAY3		107
#define		STRING_SCH_MONTH_WDAY4		108
#define		STRING_SCH_MONTH_WDAY5		109
#define		STRING_SCH_MONTH_WDAY6		110
#define		STRING_SCH_MONTH_WDAY7		111
#define		TABLE_SCH_MONTH			112
#define		BUTTON_SCH_MONTH_GOTO		113

#define		SCH_MONTH_LEFT			0
#define		SCH_MONTH_RIGHT			1


/*============== FORM_SCH_WEEK ==================================*/
#define		FORM_SCH_WEEK			114
#define		STRING_SCH_WEEK_WEEK		115
#define		BITMAP_SCH_WEEK_LEFT		116
#define		BITMAP_SCH_WEEK_RIGHT		117
#define     SCHLINE_SCH_WEEK			118

//==================== FORM_SCH_NO_MEM ===================================
#define FORM_SCH_NO_MEM                     	154
#define STRING_SCH_NO_MEM                   	155
#define BITMAP_SCH_NO_MEM                   	156

//==================== FORM_SCH_VOICE_LOW_BATTERY ===================================
#define FORM_SCH_VOICE_LOW_BATTERY		157
#define BITMAP_SCH_VOICE_LOW_BATTERY_X		158
#define STRING_SCH_VOICE_LOW_BATTERY_0		159
#define STRING_SCH_VOICE_LOW_BATTERY_1		160

//==================== FORM_SCH_LOW_MEMORY =============================
#define FORM_SCH_LOW_MEMORY			161
#define BITMAP_SCH_LOW_MEMORY			162
#define STRING_SCH_LOW_MEMORY_0			163
#define STRING_SCH_LOW_MEMORY_1			164
// Michelle new add
//==================== FORM_SCH_REPEAT ==================================
#define FORM_SCH_REPEAT				165
#define BITMAP_SCH_REPEAT_X			166
#define PUSHBUTTON_SCH_REPEAT_NONE		167
#define PUSHBUTTON_SCH_REPEAT_DAY		168
#define PUSHBUTTON_SCH_REPEAT_WEEK		169
#define PUSHBUTTON_SCH_REPEAT_MONTH		170
#define PUSHBUTTON_SCH_REPEAT_YEAR		171
#define STRING_SCH_REPEAT_EVERY			172
#define STRING_SCH_REPEAT_UNIT			173
#define TEXTBOX_SCH_REPEAT_VALUE		174
#define STRING_SCH_REPEAT_END			175
#define POPUP_TRIGGER_REPEAT_END_SELECT		176
#define STRING_SCH_REPEAT_OPTION_SELECT		177
#define PUSHBUTTON_SCH_REPEAT_SUN		178
#define PUSHBUTTON_SCH_REPEAT_MON		179
#define PUSHBUTTON_SCH_REPEAT_TUE		180
#define PUSHBUTTON_SCH_REPEAT_WED		181
#define PUSHBUTTON_SCH_REPEAT_THU		182
#define PUSHBUTTON_SCH_REPEAT_FRI		183
#define PUSHBUTTON_SCH_REPEAT_SAT		184
#define PUSHBUTTON_SCH_REPEAT_MONTH_DATE	185
#define PUSHBUTTON_SCH_REPEAT_MONTH_DAY		186
#define FORM_REPEAT_SAVE_CHANGES		187
#define BITMAP_REPEAT_SAVE_CHANGES_X		188
#define STRING_REPEAT_SAVE_CHANGES		189
#define BUTTON_REPEAT_SAVE_CHANGES_YES		190
#define BUTTON_REPEAT_SAVE_CHANGES_NO		191
#define FORM_REPEAT_APPLY_ALL			192
#define BITMAP_REPEAT_APPLY_ALL_X		193
#define STRING_REPEAT_APPLY_ALL1		194
#define STRING_REPEAT_APPLY_ALL2		195
#define BUTTON_REPEAT_CURRENT			196
#define BUTTON_REPEAT_ALL			197

//==================== FORM_CHOOSE_MONTHLY_DAY_REPEAT ==============
#define FORM_CHOOSE_MONTHLY_DAY_REPEAT		198
#define BITMAP_CHOOSE_MONTHLY_REPEAT_X		199
#define STRING_CHOOSE_MONTHLY_DAY_REPEAT1	200
#define STRING_CHOOSE_MONTHLY_DAY_REPEAT2	201
#define PUSHBUTTON_MONTHLY_DAY_REPEAT_4TH	202
#define PUSHBUTTON_MONTHLY_DAY_REPEAT_LAST	203

//===================== FORM_REPEAT_INVALID_INPUT =========================
#define FORM_REPEAT_INVALID_INPUT		204
#define BITMAP_REPEAT_INVALID_INPUT_X		205
#define STRING_REPEAT_INVALID_INPUT		206

#endif
