/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   appfunc.h
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "app.h"
//#include "uifunc.h"
//#include "ui.h"
#include "virtable.h"

#ifndef __APPFUNC_H_
#define __APPFUNC_H_


/*==========================================================
================= Application Event Handler ================
===========================================================*/
BOOLEAN SchedulerDayView(EvtType* Event);
BOOLEAN SchedulerAlarmSettings(EvtType *Event);
BOOLEAN SchedulerTimeSettings(EvtType* Event);
BOOLEAN SchedulerRecordVoice(EvtType *Event);
BOOLEAN SchedulerReplayVoice(EvtType *Event);
BOOLEAN SchedulerAlarmSaveChanges(EvtType *Event);
BOOLEAN SchedulerAlarmAppmtSelectFirst(EvtType *Event);
BOOLEAN SchedulerAlarmVoiceMemoExists(EvtType *Event);
BOOLEAN SchedulerPurge(EvtType *Event);
BOOLEAN SchedulerDateSettings(EvtType* Event);
BOOLEAN SchedulerMonthView(EvtType *Event);
BOOLEAN SchedulerWeekView(EvtType *Event);
BOOLEAN SchedulerNoMem(EvtType *Event);
BOOLEAN SchedulerLowBattery(EvtType *Event);
BOOLEAN SchedulerLowMemoryHandle(EvtType* Event);
BOOLEAN SchedulerRepeatSettings(EvtType *Event);
BOOLEAN SchedulerRepeatSaveChanges(EvtType *Event);
BOOLEAN SchedulerRepeatApplyAll(EvtType *Event);
BOOLEAN SchedulerChooseMonthlyDayRepeat(EvtType *Event);
BOOLEAN SchedulerRepeatInvalidInput(EvtType *Event);
// Use function from ToDoList application
extern void ToDoPackDueDate(BYTE *ptr, SHORT year, SHORT month, SHORT day);
void EventLoop(void);

/*==========================================================
==================== Database Functions ====================
===========================================================*/
void SchedulerAppointmentDBInit();
void SchedulerDBAppmtToBuffer(AppointmentDB *appmt_rec, BYTE **string, WORD num_appmt, 
							  BYTE **appmt_rec_buf, BYTE **string_buf, WORD *num_bytes_appmt,
							  WORD *num_bytes_string);
void SchedulerDBGetAppmtDate(BYTE *date_buffer, BYTE *year, BYTE *month, BYTE *day);
void SchedulerDBGetAppmtString(BYTE *string_buffer, UWORD num_bytes, BYTE ***string, WORD *num_appmt);
void SchedulerDBGetAppmtRec(BYTE *string_buffer, UWORD num_bytes, AppointmentDB **appmt_rec, WORD *num_appmt);

/*==========================================================
===================== FORM_SCH_DAY_VIEW =====================
===========================================================*/
void SchedulerDayViewSetScreen(VirtualTable *vt);
void SchedulerDayViewHighlightString(ObjectID string_id);
void SchedulerDayViewNotHighlightString(ObjectID string_id);
void SchedulerDayViewDrawAppointmentLine(VirtualTable *vt,
										 ObjectID table_id,
										 WORD start_row_num,
										 WORD end_row_num,
										 BYTE layer_num);
BYTE SchedulerDayViewSearchOverlapTime(VirtualTable *vt, ObjectID table_id,
									   WORD start_row_num, WORD end_row_num);
void SchedulerDayViewDrawAppointmentColumn(VirtualTable *vt, ObjectID table_id);

void SchedulerHourMinuteToString(BYTE hour, BYTE minute, BYTE *string, BOOLEAN am_pm);
BOOLEAN SchedulerDayViewTapFieldNewAppointment(VirtualTable *vt, ObjectID table_id);
BYTE SchedulerDayViewNormal(VirtualTable *vt, ObjectID table_id, USHORT *start_row, USHORT *end_row,
							BOOLEAN *start_deleted, BOOLEAN *end_deleted);
BOOLEAN SchedulerStringHandleEvent(EvtType *Event);
void SchedulerDayViewSelectString(VirtualTable *vt, USHORT selected_row_num);
BOOLEAN SchedulerDayViewFindRowNum(VirtualTable *vt, BYTE hour, BYTE minute,
								   USHORT **row_num, USHORT *num_rows);
USHORT SchedulerDayViewCheckRowNumCovered(VirtualTable *vt, USHORT row_num);
BOOLEAN SchedulerDayViewSaveAppmtData(VirtualTable *vt, UBYTE *date);
BOOLEAN SchedulerDayViewLoadAppmtDataToScreen(VirtualTable *vt, UBYTE *date);
BOOLEAN SchedulerDayViewLoadAppmtDataToScreen1(VirtualTable *vt, UBYTE *date, USHORT *field_num);
BOOLEAN SchedulerDayViewDelAppointment(VirtualTable *vt);
void SchedulerDayViewChangeDate(VirtualTable *vt, BYTE direction);
void SchedulerDayViewPurge(VirtualTable *vt);
void SchedulerDayViewSetToDoAnn(UBYTE *date);
//Err SchedulerDayViewDuplicateAppointment(UBYTE *date);

//Michelle add 201299
BOOLEAN SchedulerDisplayDayViewRepeat(UBYTE *date, RecordID rec_id, BYTE **repeat_str);
BOOLEAN SchedulerDisplayWeekViewRepeat(SHORT view_year, SHORT view_month, SHORT view_day, RecordID rec_id, BYTE *start_hr, BYTE *end_hr);
//BOOLEAN SchedulerDisplayMonthViewRepeat();

BOOLEAN SchedulerCheckExceptionDB(UWORD repeat_no, UBYTE *view_date);
BOOLEAN SchedulerCheckDayViewDailyRepeat(RecordID rec_id, UBYTE *view_date, UBYTE *start, UBYTE *end, BYTE **repeat_str, BYTE view_status);
BOOLEAN SchedulerCheckDayViewWeeklyRepeat(RecordID rec_id, UBYTE *view_date, UBYTE *start, UBYTE *end, BYTE **repeat_str, BYTE view_status);
BOOLEAN SchedulerCheckDayViewMonthlyDateRepeat(RecordID rec_id, UBYTE *view_date, UBYTE *start, UBYTE *end, BYTE **repeat_str, BYTE view_status);
BOOLEAN SchedulerCheckDayViewMonthlyDayRepeat(RecordID rec_id, UBYTE *view_date, UBYTE *start, UBYTE *end, BYTE **repeat_str, BYTE view_status);
BOOLEAN SchedulerCheckDayViewYearlyRepeat(RecordID rec_id, UBYTE *view_date, UBYTE *start, UBYTE *end, BYTE **repeat_str, BYTE view_status);

BOOLEAN SchedulerDisplayMonthViewRepeat(SHORT year, SHORT month, RecordID rec_id, BYTE *month_repeat);
void SchedulerCheckMonthViewDailyRepeat(RecordID rec_id, UBYTE *start, UBYTE *end, UBYTE *view_date, BYTE *month_repeat);
void SchedulerCheckMonthViewWeeklyRepeat(RecordID rec_id, UBYTE *start, UBYTE *end, UBYTE *view_date, BYTE *month_repeat);
void SchedulerCheckMonthViewMonthlyRepeat(RecordID rec_id, UBYTE *start, UBYTE *end, UBYTE *view_date, BYTE *month_repeat, BYTE method);
void SchedulerCheckMonthViewYearlyRepeat(RecordID rec_id, UBYTE *start, UBYTE *end, UBYTE *view_date, BYTE *month_repeat);
/*
BOOLEAN SchedulerCheckMonthlyDayRepeat();
BOOLEAN SchedulerCheckYearlyRepeat();
*/
BOOLEAN SchedulerCalculatePopupDate(UBYTE *date, SHORT wday);
BOOLEAN SchedulerRepeatCheckPushbutton(ObjectID object_id);
BOOLEAN SchedulerCheckLastWday();
//end add


/*==========================================================
=============== FORM_SCH_TIME_SEETINGS ======================
===========================================================*/
void SchedulerTimeSettingsSetScreen();				
void SchedulerListSelectToTimeSettingsScreen(EvtType *Event);
void SchedulerPenDownOnString(EvtType *Event);
void SchedulerTimeSettingsStringToHourMinute(BYTE *string, BYTE *hour, BYTE *minute, BYTE *am_pm);
void SchedulerTimeSettingsSetStringList(ObjectID string_id, BYTE hour, BYTE minute);
void SchedulerTimeSettingsExit(VirtualTable *vt);
void SchedulerTimeSettingsOK(VirtualTable *vt);
void SchedulerTimeSettingsDeleteAllEmptyAppmts(VirtualTable *vt);
void SchedulerTimeSettingsAddAppmts(VirtualTable *vt);

/*==========================================================
=============== FORM_SCH_ALARM ======================
===========================================================*/
void SchedulerAlarmSave();
void SchedulerSetAppmtAlarmOn(BYTE alarm_type, BYTE alarm_time, UWORD alarm_num, UBYTE *date,
							  BYTE hour, BYTE minute, RecordID appmt_recid,
							  RecordID voice_recid, USHORT row_num, BOOLEAN repeat_flag);
void SchedulerSetAppmtWholeDayAlarm(UBYTE *date);
BOOLEAN SchedulerCheckWholeDayAlarmOff(RecordID rec_id);
void SchedulerSetAppmtAlarmOff(RecordID current_rec_id, USHORT row_num);
BOOLEAN SchedulerGetNextRecWithAlarm(RecordID current_rec_id, RecordID *next_rec_id);
BOOLEAN SchedulerCheckEarliestDayWithAlarm(UBYTE *date);
BYTE SchedulerCompareDate(UBYTE *input_date_0, UBYTE *input_date_1);
void SchedulerSaveAndSetAlarm();
BOOLEAN SchedulerFindNextAppmtAlarmDate(UBYTE *view_date, UBYTE *appmt_alarm_date);

/*==========================================================
=============== FORM_SCH_DATE ==============================
===========================================================*/
void	SchInitMainGlobal(void);
void	SchedulerCalculateDayViewDate(SHORT year, SHORT month, SHORT day, BYTE *sbuffer);
void	SchedulerSetDayViewDate(SHORT year, SHORT month, SHORT day, USHORT col_num);
void	SchedulerGotoPopupForm(ObjectID form_id, BOOLEAN return_prev_form);
BOOLEAN SchedulerRestoreMonthView(ObjectID form_id, ObjectID table_id, ObjectID year_push_id, 
			USHORT *row_num, USHORT *col_num, RTM timer);
BOOLEAN SchedulerMonthUpdateMonthView(SHORT shift_action, USHORT *row_num, USHORT *col_num);
void	SchedulerGetMonthViewDate(USHORT row_num, USHORT col_num, SHORT *year, SHORT *month, SHORT *day);
BOOLEAN	SchedulerGetDayViewDate(UBYTE *out_buf);
BOOLEAN SchedulerDateUpdateMonthTable(ObjectID table_id, SHORT year, SHORT month, SHORT start_of_week);
BOOLEAN SchedulerSortRecordOlderThan(BYTE year, BYTE mon, BYTE day, UWORD *output_rec_num);
UWORD	BiSort(DatabaseID Sch_dbid, WORD input_time_value, UWORD start_rec_num, UWORD end_rec_num, WORD rec_num);
BOOLEAN SchedulerUpdateWeekViewTable(SHORT year, SHORT week_no);
void	SchedulerGetWeekViewWeekNum(SHORT shift_action, SHORT *year, SHORT *week_no);
void    SchedulerRestoreDateSettings(ObjectID form_id, ObjectID table_id, ObjectID year_push_id, 
            ObjectID month_push_id, USHORT *row_num, USHORT *col_num);
SHORT SchedulerUpdateYearFromBoundryDay(SHORT year, SHORT week_no, SHORT total_week_no, SHORT mon, SHORT mday);

/*==========================================================
=============== FORM_SCH_REPEAT ==============================
===========================================================*/
void SchedulerRepeatSetUpScreen(SHORT repeat_status);
void SchedulerSaveRepeatSettings(BOOLEAN save_string_only, BOOLEAN save_date);
BOOLEAN SchedulerRestoreRepeatSettings(SHORT *status, UWORD repeat_num);
void SchedulerInitRepeatSettings();
void SchedulerSaveException();
BOOLEAN SchedulerDeleteRepeatDB(UWORD repeat_num, BOOLEAN delete_all);
void SchedulerConvertBYTEtoSHORT(BYTE *byte_ptr, SHORT number);
void SchedulerConvertBYTEtoUWORD(BYTE *byte_ptr, UWORD *number, BOOLEAN forward);
//BOOLEAN SchedulerDisplayDayViewRepeat(BYTE *date, RecordID rec_id);

/*==========================================================
=========== Application Save and Restore Functions =========
===========================================================*/
void SchedulerAppRestore(BOOLEAN restart, BOOLEAN today, void *cmd_ptr);
void SchedulerAppSave();
void SchedulerDatabaseChecking();

/*==========================================================
=========================== Menu ===========================
===========================================================*/
void MenuItemSelectedAction(USHORT item_num);
BOOLEAN SchedulerRepeatBlockCopyCutPaste(EvtType *Event);

/*==========================================================
====================== Rec Voice ===========================
===========================================================*/
void SchedulerReplayScrollbarSetVolume(EvtType *Event);

/*==========================================================
================= Application Launch Functions =====================
===========================================================*/
BOOLEAN SchedulerAppLaunch(WORD cmd, void *cmd_ptr);
void SchedulerGotoItem(DatabaseID dbid, RecordID rec_id, USHORT field_num, BYTE *search_string);
void SchedulerPrepareFindText(DatabaseID dbid, RecordID rec_id, WORD appmt_num, BYTE **prepare_string);
void SchedulerManageAlarm(AlarmEventHit *ptr);
BOOLEAN SchedulerBinarySearch(UBYTE *today, UWORD *rec_num);
BOOLEAN SchedulerRepeatFindDate(RecordID rec_id, UBYTE *alarm_date, UBYTE *today, UBYTE *next_alarm_date, BOOLEAN index);

#endif
