#ifndef __NEW_TIME_H_
#define __NEW_TIME_H_

typedef struct _NEW_TIME
{
	BYTE yr_offset;
	BYTE month;
	BYTE date;
	BYTE hr;
	BYTE min;
	SHORT day_in_yr;
} NEW_TIME;

typedef struct __REPEAT_ATTR
{
	BYTE method;
	BYTE every_info;
	BYTE every_data;
	BYTE n_week;
} REPEAT_ATTR;

typedef struct _ALARM_SETTING
{
	BYTE alarm_type;
	BYTE alarm_time;
} ALARM_SETTING;

typedef struct _PAYMENT_DISPLAY_TIME
{
	BYTE yr_offset;
	BYTE month;
} PAYMENT_DISPLAY_TIME;

void ConvertRTMtoTimeStr(RTM *time, BYTE time_str[8]);
SHORT GetDayOfYear(SHORT year, SHORT mon, SHORT day);	//not zero-based

void GetYearInOffsetFormat(UBYTE str[8], UBYTE *result);
void GetYear(UBYTE time[8], USHORT *result);
void GetMonth(UBYTE time[8], UBYTE *result);
void GetDate(UBYTE time[8], UBYTE *result);
void GetHour(BYTE time[8], BYTE *result);
void GetMinute(BYTE time[8], BYTE *result);
void GetDayInYear(UBYTE time[8], SHORT *result);
BOOLEAN IsCheckTimeBetweenStartAndEndTime(UBYTE start_time[8], UBYTE end_time[8], UBYTE check_time[8]);
BYTE GetEndDateOfViewMonth(PAYMENT_DISPLAY_TIME *view_time);
SHORT DifferenceDaysBetween2Dates(SHORT yr1, BYTE month1, BYTE date1, UBYTE time_str[8]);

void GetWeekdayOfTheDate(UBYTE date_str[8], BYTE *weekday);      //*weekday :    0:Mon, 1:Tue, 2:Wed, ..., 6:Sun

#endif
