#include "app.h"

#ifndef __VIRTABLE_H_
#define __VIRTABLE_H_

#include "uifunc.h"
#include "ui.h"
#include "mmu.h"


/*==========================================================
=============== VirTable Structure Defines =================
===========================================================*/
typedef struct _VTItems
{
	BYTE			hour;
	BYTE			minute;
	BYTE			*string_text;
	Field			*ptr;
	BYTE			alarm;
	BYTE			alarm_time;
	UWORD			alarm_num;
	WORD			appointment;
	UWORD			appmt_num;
	// Michelle add 061299
	BOOLEAN			repeat;
	UWORD			repeat_num;
	BYTE			repeat_method;
	BYTE			repeat_every_info;
	BYTE			repeat_every_data;
	// add end
	DatabaseID		dbid;
	RecordID		recid;
} VTItems;

typedef struct _VirtualTable
{
	ObjectBounds	vt_bounds;
	BYTE			vt_font_size;
	USHORT			vt_num_rows;
	USHORT			vt_num_cols;
	USHORT			vt_top_row_num;
	USHORT			vt_num_rows_displayed;
	WORD			vt_total_num_lines;
	USHORT			vt_ref_col;		//the column that contains column of virtual field objects
	SHORT			*vt_col_width;
	SHORT			*vt_row_height;
	VTItems			**vt_items;
	ObjectID		vt_scrollbar_id;
	WORD			vt_active_row;
} VirtualTable;
//extern VirtualTable virtual_table;

/*==========================================================
================= VirTable Error Defines =======================
===========================================================*/
#define ERR_VT_ROW_NUM_INVALID		6000
#define ERR_VT_TEXT_NOT_FOUND		6001
#define ERR_VT_FIELD_NOT_FOUND		6002

#define	NO_ALARM					0
#define	TONE_ALARM					1
#define	VOICE_ALARM					2
#define VOICE_NOT_ALARM             3

#define AM							0
#define PM							1

#define DONT_CARE					1
#define EXACT_TIME					2
#define MIN_15_BEFORE				3
#define MIN_30_BEFORE				4
#define MIN_60_BEFORE				5

/*==========================================================
================= VirTable BASIC Functions =======================
===========================================================*/
void VTInit(VirtualTable *vt, ObjectBounds bounds, USHORT num_rows, USHORT num_cols,
			USHORT top_row_num, SHORT *row_height, SHORT *col_width, SHORT ref_col, ObjectID scrollbar_id);
void VTDeleteAllRowItems(VirtualTable *vt);
Field *VTCreateVirtualFieldObject(VirtualTable *vt, ObjectBounds bounds);
void VTDeleteVirtualFieldObject(Field *field_ptr);
void VTSetTableBounds(VirtualTable *vt, ObjectBounds bounds);
void VTGetTableBounds(VirtualTable *vt, ObjectBounds *bounds);
Err VTSetTextPointer(VirtualTable *vt, USHORT row_num, BYTE *text);
Err VTGetTextPointer(VirtualTable *vt, USHORT row_num, BYTE **text);
Err VTSetFieldTextPointer(VirtualTable *vt, USHORT row_num, BYTE *text);
Err VTGetFieldTextPointer(VirtualTable *vt, USHORT row_num, BYTE **text);
Err VTGetFieldPointer(VirtualTable *vt, USHORT row_num, Field **field_ptr);
Err VTSetFieldBounds(VirtualTable *vt, USHORT row_num, ObjectBounds bounds);
Err VTGetFieldBounds(VirtualTable *vt, USHORT row_num, ObjectBounds *bounds);
Err VTSetFieldFontSize(VirtualTable *vt, USHORT row_num, BYTE font_size);
Err VTGetFieldFontSize(VirtualTable *vt, USHORT row_num, BYTE *font_size);
Err VTSetTableFontSize(VirtualTable *vt, BYTE font_size);
void VTGetTableFontSize(VirtualTable *vt, BYTE *font_size);
void VTSetTableColumnWidth(VirtualTable *vt, USHORT col_num, SHORT col_width);
Err VTSetTableRowHeight(VirtualTable *vt, USHORT row_num, SHORT row_height);
void VTGetTableTotalNumLines(VirtualTable *vt, WORD *num_lines);
Err VTSetFieldTopLineNum(VirtualTable *vt, USHORT row_num, WORD top_line_num);
Err VTGetFieldTopLineNum(VirtualTable *vt, USHORT row_num, WORD *top_line_num);
Err VTGetFieldNumLinesDisplayed(VirtualTable *vt, USHORT row_num, WORD *num_lines);
Err VTGetFieldTotalNumLines(VirtualTable *vt, USHORT row_num, WORD *num_lines);
Err VTSetRowHourMinute(VirtualTable *vt, USHORT row_num, BYTE hour, BYTE minute);
Err VTGetRowHourMinute(VirtualTable *vt, USHORT row_num, BYTE *hour, BYTE *minute);
Err VTSetRowAlarm(VirtualTable *vt, USHORT row_num, BYTE alarm, BYTE alarm_time, UWORD alarm_num);
Err VTGetRowAlarm(VirtualTable *vt, USHORT row_num, BYTE *alarm, BYTE *alarm_time, UWORD *alarm_num);
void VTInsertRow(VirtualTable *vt, USHORT row_num, BYTE hour, BYTE minute, BYTE alarm, 
				 BYTE alarm_time, UWORD alarm_num, WORD appointment, UWORD appmt_num, 
				 BOOLEAN repeat, UWORD repeat_num, BYTE repeat_method, BYTE repeat_every_info,
				 BYTE repeat_every_data, DatabaseID dbid, RecordID recid, BYTE *string_text,
				 BYTE *field_string);
Err VTDeleteRow(VirtualTable *vt, USHORT row_num);
void VTGetTableMaxNumLines(VirtualTable *vt, WORD *max_num_lines);
WORD VTGetScrollbarMaxValue(VirtualTable *vt);
void VTSetScrollbarID(VirtualTable *vt, ObjectID scrollbar_id);
void VTGetScrollbarID(VirtualTable *vt, ObjectID *scrollbar_id);
void VTUpdateFieldScreenBounds(VirtualTable *vt, USHORT row_num);
void VTFieldGetFirstVisibleChar (Field *field_ptr, WORD *char_pos);
void VTFieldGetLastVisibleChar (Field *field_ptr, WORD *char_pos);
Err VTSetActiveRow(VirtualTable *vt, USHORT active_row);
void VTChangeStringFormat(VirtualTable *vt);

BOOLEAN VTDecideTopRowNum(VirtualTable *vt, USHORT active_row);
BOOLEAN VTSetVirtualTableLayout(VirtualTable *vt);
BOOLEAN VTKeyInChangeVirtualTable(VirtualTable *vt);
BOOLEAN VTVirtualTableSetScrollbar(VirtualTable *vt);
BYTE VTScrollbarSetVirtualTable(VirtualTable* vt, EvtType *Event,
								USHORT *row_to_be_drawn);
void VTUpdateNumRowsDisplayed(VirtualTable *vt);
Err VTSetRowAppointment(VirtualTable *vt, USHORT row_num, WORD appointment);
Err VTGetRowAppointment(VirtualTable *vt, USHORT row_num, WORD *appointment);

void VTTransferStringToVT(VirtualTable *vt, ObjectID table_id);
void VTTransferHourMinuteToVT(VirtualTable *vt, ObjectID table_id);
void VTTransferFieldToVT(VirtualTable *vt, ObjectID table_id);
void VTTransferAlarmToVT(VirtualTable *vt, ObjectID table_id);
void VTTransferTableToVT(VirtualTable *vt, ObjectID table_id);
void VTTransferAllToVT(VirtualTable *vt, ObjectID table_id);

void VTTransferStringToRT(VirtualTable *vt, ObjectID table_id);
void VTTransferHourMinuteToRT(VirtualTable *vt, ObjectID table_id);
void VTTransferFieldToRT(VirtualTable *vt, ObjectID table_id);
void VTTransferAlarmToRT(VirtualTable *vt, ObjectID table_id);
void VTTransferTableToRT(VirtualTable *vt, ObjectID table_id);
void VTTransferAllToRT(VirtualTable *vt, ObjectID table_id);

#endif
