/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   main.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"
#include "appfunc.h"
#include "system.h"

//extern UWORD _fdata, etext, _fbss, ebss;
//#define DEBUG
/* ==================================================================== */
/* ========================= Function Prototypes ====================== */
/* ==================================================================== */
void EventLoop();
void MMUInit();
void KernelInit();
void ResInit();
static BOOLEAN ApplicationHandleEvent(EvtType *Event);

BOOLEAN (*FormDispatchEvent)(EvtType *Event);

extern REGISTRY app_reg[];


#ifdef PC_SIM
extern BOOL m_bIsExit;
#endif

/* ==================================================================== */
/* ========================= Global Variables ========================= */
/* ==================================================================== */
extern UBYTE res_data [];
UBYTE sysres_data[1];

/********************************************************
* Function:	ApplicationHandleEvent
* Purpose: 	This function is used to load the specific data of
form and set event handler of the form
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
static BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
	Form *form_ptr;
	ObjectID form_id;
	BYTE object_type;
	Err Error;
	
	if (Event->eventType == EVT_FORM_LOAD)
	{
		form_id = (ObjectID)Event->eventID;
		Error = UISearchForAddress(form_id,&object_type,(void**)&form_ptr);
		if (Event->para1 == 1 || Error != TRUE)
		{
			FormInitForm(form_id);
		}
		if (!UISearchForAddress(form_id,&object_type,(void**)&form_ptr)) return FALSE;
		switch (form_id)
		{
		case FORM_SCH_DAY_VIEW:
			FormSetEventHandler(FORM_SCH_DAY_VIEW,(void**) &FormDispatchEvent, (void*)SchedulerDayView);
			break;
		case FORM_SCH_ALARM:
			FormSetEventHandler(FORM_SCH_ALARM,(void**) &FormDispatchEvent, (void*)SchedulerAlarmSettings);
			break;
		case FORM_SCH_ALARM_SAVE_CHANGES:
			FormSetEventHandler(FORM_SCH_ALARM_SAVE_CHANGES,(void**) &FormDispatchEvent, (void*)SchedulerAlarmSaveChanges);
			break;
		case FORM_SCH_TIME_SETTINGS:
			FormSetEventHandler(FORM_SCH_TIME_SETTINGS,(void**) &FormDispatchEvent, (void*)SchedulerTimeSettings);
			break;						
		case FORM_SCH_DATE:
			FormSetEventHandler(FORM_SCH_DATE,(void**) &FormDispatchEvent, (void*)SchedulerDateSettings);
			break;						
		case FORM_SCH_MONTH:
			FormSetEventHandler(FORM_SCH_MONTH,(void**) &FormDispatchEvent, (void*)SchedulerMonthView);
			break;						
		case FORM_SCH_WEEK:
			FormSetEventHandler(FORM_SCH_WEEK,(void**) &FormDispatchEvent, (void*)SchedulerWeekView);
			break;						
		case FORM_SCH_REC:
			FormSetEventHandler(FORM_SCH_REC,(void**) &FormDispatchEvent, (void*)SchedulerRecordVoice);
			break;						
		case FORM_SCH_REPLAY:
			FormSetEventHandler(FORM_SCH_REPLAY,(void**) &FormDispatchEvent, (void*)SchedulerReplayVoice);
			break;						
		case FORM_SCH_ALARM_SELECT:
			FormSetEventHandler(FORM_SCH_ALARM_SELECT,(void**) &FormDispatchEvent, (void*)SchedulerAlarmAppmtSelectFirst);
			break;						
		case FORM_SCH_VOICE_EXISTS:
			FormSetEventHandler(FORM_SCH_VOICE_EXISTS,(void**) &FormDispatchEvent, (void*)SchedulerAlarmVoiceMemoExists);
			break;						
		case FORM_SCH_PURGE:
			FormSetEventHandler(FORM_SCH_PURGE,(void**) &FormDispatchEvent, (void*)SchedulerPurge);
			break;
			// Michelle add 021299
		case FORM_SCH_REPEAT:
			FormSetEventHandler(FORM_SCH_REPEAT, (void**) &FormDispatchEvent, (void*)SchedulerRepeatSettings);
			break;
		case FORM_REPEAT_SAVE_CHANGES:
			FormSetEventHandler(FORM_REPEAT_SAVE_CHANGES, (void**) &FormDispatchEvent, (void*)SchedulerRepeatSaveChanges);
			break;
		case FORM_REPEAT_APPLY_ALL:
			FormSetEventHandler(FORM_REPEAT_APPLY_ALL, (void**) &FormDispatchEvent, (void*)SchedulerRepeatApplyAll);
			break;
		case FORM_CHOOSE_MONTHLY_DAY_REPEAT:
			FormSetEventHandler(FORM_CHOOSE_MONTHLY_DAY_REPEAT, (void**) &FormDispatchEvent, (void*)SchedulerChooseMonthlyDayRepeat);
			break;
		case FORM_REPEAT_INVALID_INPUT:
			FormSetEventHandler(FORM_REPEAT_INVALID_INPUT, (void**)&FormDispatchEvent, (void*)SchedulerRepeatInvalidInput);
			break;
		case FORM_SCH_LOW_MEMORY:
			FormSetEventHandler(FORM_SCH_LOW_MEMORY, (void**)&FormDispatchEvent, (void*)SchedulerLowMemoryHandle);
			break;
		case FORM_SCH_VOICE_LOW_BATTERY:
			FormSetEventHandler(FORM_SCH_VOICE_LOW_BATTERY, (void**)&FormDispatchEvent, (void*)SchedulerLowBattery);
			break;
			// add end 021299
		}
		FormSetActiveForm(form_id);
		return TRUE;
	}
	return FALSE;
}
/********************************************************
* Function:	EventLoop
* Purpose: 	This function is a loop to get events from event
manager and then passes the event to different
event handler
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EventLoop(void)
{
	EvtType event;	
	do
	{
		EvtGetEvent (&event);
		if (!SchedulerRepeatBlockCopyCutPaste(&event))
			if (!SystemHandleEvent(&event))
				if (!MenuHandleEvent(&event))
					if (!ApplicationHandleEvent(&event))
						FormDispatchEvent(&event);
	}
#ifdef PC_SIM
	while (event.eventType != EVT_APP_STOP && m_bIsExit == FALSE);
#else
	while (event.eventType != EVT_APP_STOP);
#endif
}
/********************************************************
* Function:	main
* Purpose: 	main procedure of the application
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
__main(WORD cmd, void*cmd_ptr)
{
	//	SysEnableDebug();
	//	printf("\n Start Scheduler Application");	
	SchedulerAppLaunch(cmd, (void*)cmd_ptr);
	//    DataCloseDB(sch_appmt_dbid);
	//    DataCloseDB(sch_voice_dbid);
}
