/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   menufunc.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"
#include "appfunc.h"

extern ObjectID prev_form_id;

/********************************************************
* Function:	MenuItemSelectedAction
* Purpose: 	This fucntion is to do an action when 
an item in a menu is selected
* Scope:		application/internal
* Input:		menu_item		The item number of the selectd menu item
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void MenuItemSelectedAction(USHORT item_num)
{
	ObjectID active_form_id;
	ObjectID active_object_id;
	BOOLEAN highlighted = FALSE, insert_pt = FALSE;
	BYTE object_type;
	void *addr;
	Field *field_ptr;
	USHORT count;
	UBYTE date[4];
	SHORT i;
	
	BYTE *field_text;
	
	if (item_num != MENU_ITEM_PURGE)
	{
		FormGetActiveFormID(&active_form_id);
		FormGetActiveObject(active_form_id, &active_object_id);
		if (FormGetObjectPointer(active_object_id, &object_type, (void**)&addr) == FALSE)
			return;
		if (object_type != FIELD && item_num != MENU_ITEM_ZOOM)
		{
			FormPopupForm(FORM_SCH_ALARM_SELECT);
			return;
		}
		else if (object_type == FIELD)
		{
			field_ptr = (Field*)addr;
			highlighted = field_ptr->field_attr.field_highlight;
			insert_pt = field_ptr->field_attr.field_insert_pt_visible;
		}
	}
	
	switch(item_num)
	{
	case MENU_ITEM_COPY:
		KeyboardSendEvent(KEY_COPY, FALSE, FALSE, FALSE);
		break;
	case MENU_ITEM_CUT:
		KeyboardSendEvent(KEY_CUT, FALSE, FALSE, FALSE);
		break;
	case MENU_ITEM_REP:
		if (MemoryLow)
		{
			FormPopupForm(FORM_SCH_LOW_MEMORY);
			return;
		}
		
		if (virtual_table.vt_active_row == -1)
			return;
		
		if (strlen(field_ptr->field_string) == 0)
			return;
		
		if (new_appointment == FALSE)
		{
			SchedulerGetDayViewDate(date);
			SchedulerDayViewSaveAppmtData(&virtual_table, date);
			repeat_settings.change = FALSE;
			repeat_settings.every_data = 0;
			repeat_settings.every_info = 0;
			repeat_settings.exception = 0;
			repeat_settings.method = -1;
			repeat_settings.default_method = 255;
			repeat_settings.n_week = 0;
			repeat_settings.new_repeat = FALSE;
			repeat_settings.repeat_num = 0;
			if (virtual_table.vt_active_row != -1)
			{
				if (virtual_table.vt_items[virtual_table.vt_active_row]->alarm != NO_ALARM)
				{
					repeat_settings.alarm = virtual_table.vt_items[virtual_table.vt_active_row]->alarm;
					repeat_settings.alarm_time = virtual_table.vt_items[virtual_table.vt_active_row]->alarm_time;
					repeat_settings.alarm_num = virtual_table.vt_items[virtual_table.vt_active_row]->alarm_num;
					//Michelle add 310100
					if ((virtual_table.vt_items[virtual_table.vt_active_row]->alarm == VOICE_ALARM) ||
						(virtual_table.vt_items[virtual_table.vt_active_row]->alarm == VOICE_NOT_ALARM))
						repeat_settings.voice_recid = virtual_table.vt_items[virtual_table.vt_active_row]->recid;
					else repeat_settings.voice_recid = 0;
					//end add 310100
				}
				else
				{
					repeat_settings.alarm = 0;
					repeat_settings.alarm_time = 0;
					repeat_settings.alarm_num = 0;
					//Michelle add 310100
					repeat_settings.voice_recid = 0;
					//end 310100
				}
				virtual_table.vt_items[virtual_table.vt_active_row]->repeat = FALSE;
				FormInitAllFormObjects(FORM_SCH_REPEAT);
				FormPopupForm(FORM_SCH_REPEAT);
			}
			else
			{
				FormPopupForm(FORM_SCH_ALARM_SELECT);
				return;
			}
			i = 6;
			do
			{
				repeat_settings.end_date[i] = 0xFF;
				i--;
			}while(i >= 0);
		}
		break;
		// add end 021299
	case MENU_ITEM_PASTE:
		if (MemoryLow)
		{
			FormPopupForm(FORM_SCH_LOW_MEMORY);
			return;
		}				
		KeyboardSendEvent(KEY_PASTE, FALSE, FALSE, FALSE);
		break;
	case MENU_ITEM_UNDO:
		if (UIGetUndoStatus() != UNDO_EMPTY)
			KeyboardSendEvent(KEY_UNDO, FALSE, FALSE, FALSE);
		break;
		// --------------------------- modified at 280300 ---------------------------
	case MENU_ITEM_PURGE:
		SchedulerGetDayViewDate(date);
		SchedulerDayViewSaveAppmtData(&virtual_table, date);
		FormPopupForm(FORM_SCH_PURGE);
		break;
		// ---------------------------------------------------------------------------
	case MENU_ITEM_ZOOM:
		if (virtual_table.vt_font_size == SMALL_FONT)
			VTSetTableFontSize(&virtual_table, MEDIUM_FONT);
		else VTSetTableFontSize(&virtual_table, SMALL_FONT);
		SchedulerDayViewSetScreen(&virtual_table);
		for (count = 0; count < virtual_table.vt_num_rows; count++)
		{
			virtual_table.vt_items[count]->ptr->bounds.height = 9;
			virtual_table.vt_items[count]->ptr->screen_bounds.height = 9;
			virtual_table.vt_row_height[count] = 9; 
		}
		SchedulerTimeSettingsDeleteAllEmptyAppmts(&virtual_table);
		SchedulerTimeSettingsAddAppmts(&virtual_table);
		VTSetVirtualTableLayout(&virtual_table);
		VTVirtualTableSetScrollbar(&virtual_table);
		VTTransferAllToRT(&virtual_table, TABLE_SCH_DAY_VIEW);			
		TableDrawTable(TABLE_SCH_DAY_VIEW);
		ScrollbarDrawScrollbar(SCROLLBAR_SCH_DAY_VIEW);
		SchedulerDayViewDrawAppointmentColumn(&virtual_table, TABLE_SCH_DAY_VIEW);
		if (virtual_table.vt_font_size == SMALL_FONT)
		{
			MenuDeleteItem(MENU_SCH_DAY_VIEW, MENU_ITEM_ZOOM);
			MenuInsertItem(MENU_SCH_DAY_VIEW, MENU_ITEM_ZOOM, SCHLFONT);
		}
		else
		{
			MenuDeleteItem(MENU_SCH_DAY_VIEW, MENU_ITEM_ZOOM);
			MenuInsertItem(MENU_SCH_DAY_VIEW, MENU_ITEM_ZOOM, SCHSFONT);
		}
		break;
	default: break;
	}
}

/********************************************************
* Function:	SchedulerRepeatBlockCopyCutPaste 
* Purpose: 	This function is called to COPY, CUT, PASTE, UNDO
* Scope:	application/internal
* Input:	Event
* Output:	None
* Return:	TRUE        if handled
FALSE       if not handled
* Comment: 	None
*********************************************************/
BOOLEAN SchedulerRepeatBlockCopyCutPaste(EvtType *Event)
{   
	ObjectID    active_form_id;
	
	FormGetActiveFormID(&active_form_id);
	if (Event->eventType == EVT_FIELD_JOT_PASTE_STRING ||
		Event->eventType == EVT_TEXTBOX_JOT_PASTE_STRING)
	{
		if (active_form_id == FORM_SCH_REPEAT)
		{
			pfree(Event->evtPBP);
			return TRUE;
		}
		else return FALSE;
	}
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY && active_form_id == FORM_SCH_REPEAT)
	{
		switch(Event->para2)
		{
		case KEY_PASTE:
			return TRUE;
		case KEY_UNDO:
			return TRUE;
		default:
			return FALSE;                                                    
		}
	}
	return FALSE;
}
