/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   schrepla.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "app.h"
#include "appfunc.h"

/********************************************************
* Function:	SchedulerReplayScrollbarSetVolume
* Purpose: 	This function is called to handle the scrollbar 
event to set the volume
* Scope:		application/internal
* Input:		date				
* Output:		None
* Return:		TRUE		
FALSE		
* Comment: 	None
*********************************************************/
void SchedulerReplayScrollbarSetVolume(EvtType *Event)
{
	WORD value, max_value, min_value, pagesize, total_num_lines;
	
	ScrollbarGetScrollbar(SCROLLBAR_SCH_REC, &value, &max_value, 
						  &min_value, &pagesize, &total_num_lines);
	
	ScrollbarSetScrollbar(SCROLLBAR_SCH_REC, (Event->para2), max_value, 
						  min_value, pagesize, total_num_lines);
	
	ScrollbarDrawScrollbar(SCROLLBAR_SCH_REC);
	
#ifndef PC_SIM
	SySetupScrollbarSetVolSettings(min_value, max_value, (USHORT)(Event->para2));
#endif
	
	
}
