/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   skhform.c
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "Skhfunc.h"
#include "mmu.h"
#include "slang.h"

BOOLEAN SketchFormList(EvtType *Event)
{
	UWORD i;
	
#ifdef PR31700
	AppID           appid;
#endif
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if (Event->para2 & 0x00000200)
		{
			if (Event->para1 == KEY_UP)
			{
				Event->eventType = EVT_IO_KEY_CTRL;
				Event->eventID = EVT_IO_KEY_PRESS;
				Event->para2 = IO_UP_ARROW;
			}
			else if (Event->para1 == KEY_DOWN)
			{
				Event->eventType = EVT_IO_KEY_CTRL;
				Event->eventID = EVT_IO_KEY_PRESS;
				Event->para2 = IO_DOWN_ARROW;
			}
			else if (Event->para1 == LLETTER_NEW || Event->para1 == SLETTER_NEW)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_NEW_RECORD;
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_FORM_OPEN:
		application_status = RESTART_SKETCH;
		sketch_prevform = RESTART_SKETCH;
		sketch_change = FALSE;
		sketch_new = FALSE;
		sketch_select = FALSE;
		
		SketchListInit();
		SketchMenuSetFont(font_size);
		MenuInitMenu(SKETCH_DRAW_MENU);
		FormDrawForm(FORM_SKETCH_LIST);
		return TRUE;
	case	EVT_SCROLLBAR_REPEAT:
	case	EVT_SCROLLBAR_SELECT:
		SketchScrollbarSetList(Event);
		return TRUE;
		
	case EVT_CONTROL_SELECT:
		if (Event->eventID == BUTTON_NEW_RECORD)
		{
			sketch_new = TRUE;
			TextboxSetText(TEXTBOX_SKETCH_INFO, (BYTE *)"");
			memset(full_bmp1.bitmap_data, 0, full_bmp1.size);
			SketchNewRecord();
			MenuDeleteItem(SKETCH_DRAW_MENU, MENU_ITEM_RENAME);
			MenuDeleteItem(SKETCH_DRAW_MENU, MENU_ITEM_DELETE);
			if (MemoryCheckMemLow())
			{
				FormPopupForm(FORM_SKETCH_LOW_MEMORY);
			}
			else
				FormPopupForm(FORM_SKETCH_DRAW);
		}
		return TRUE;
	case EVT_LIST_SELECT:
		if (Event->para1 == -1)
			return TRUE;
		sketch_new = FALSE;
		SketchOpenRecord(Event->para1);
		FormPopupForm(FORM_SKETCH_DRAW);
		return TRUE;
#ifdef PR31700
	case 	EVT_IO_KEY_CTRL:
		if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
		{
			if (Event->para2 == IO_UP_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_SKETCH_LIST, SCROLLBAR_UP_ARROW);
			else if (Event->para2 == IO_DOWN_ARROW)
				ScrollbarHardButtonSetScrollbar(SCROLLBAR_SKETCH_LIST, SCROLLBAR_DOWN_ARROW);
			return TRUE;
		}
		return FALSE;
		
	case	EVT_INLAY_SELECT:
		if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
		{
			SysGetAppID(MAINMENU, &appid);
			EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
			EvtAppendEvt(EVT_APP_LAUNCH, appid, 0, 0, NULL);
		}
		return TRUE;
#endif
	case	EVT_MENU_SELECT_ITEM:
		if (font_size == SMALL_FONT)
			font_size = MEDIUM_FONT;
		else
			font_size = SMALL_FONT;
		SketchMenuSetFont(font_size);
	default:
		return FALSE;
	}
	return FALSE;
}

BOOLEAN SketchFormInfo(EvtType *Event)
{
	ObjectID control_id;
	WORD num_char;
	ObjectID tempID;
	UWORD rec_num;
	BYTE obj_type;
	Textbox *tb_ptr;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if (Event->para2 & 0x00000100)
		{
			if (Event->para1 == LLETTER_CUT || Event->para1 == SLETTER_CUT)
			{
				Event->eventType = EVT_MENU_SELECT_ITEM;
				Event->para1 = MENU_ITEM_CUT;
			}
			else if (Event->para1 == LLETTER_COPY || Event->para1 == SLETTER_COPY)
			{
				Event->eventType = EVT_MENU_SELECT_ITEM;
				Event->para1 = MENU_ITEM_COPY;
			}
			else if (Event->para1 == LLETTER_UNDO || Event->para1 == SLETTER_UNDO)
			{
				Event->eventType = EVT_MENU_SELECT_ITEM;
				Event->para1 = MENU_ITEM_UNDO;
			}
			else if (Event->para1 == LLETTER_PASTE || Event->para1 == SLETTER_PASTE)
			{
				Event->eventType = EVT_MENU_SELECT_ITEM;
				Event->para1 = MENU_ITEM_PASTE;
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_FORM_OPEN:
		sketch_change = TRUE;
		application_status = RESTART_SKETCH_INFO;
		sketch_prevform = RESTART_SKETCH_INFO;
		if (sketch_new == TRUE)
			TextboxSetText(TEXTBOX_SKETCH_INFO, (BYTE *)"");
		TextboxGetNumOfChars(TEXTBOX_SKETCH_INFO, &num_char);
		TextboxSetInsertPointPositionByCharPos(TEXTBOX_SKETCH_INFO, num_char);
		
		if (sketch_rename == TRUE)
		{
			TextboxSetInsertPointOff(TEXTBOX_SKETCH_INFO);
			FormGetObjectPointer(TEXTBOX_SKETCH_INFO, &obj_type, (void **)&tb_ptr);
			tb_ptr->textbox_highlight_start_char = 0;
			tb_ptr->textbox_highlight_length = num_char;
			(tb_ptr->textbox_attr).textbox_highlight = TRUE;
		}
		FormDrawForm(FORM_SKETCH_INFO);
		return TRUE;
	case EVT_INLAY_SELECT:
		switch (Event->para1)
		{
		case INLAY_OK:
			SketchSaveRecordText();
			FormPopupForm(FORM_SKETCH_LIST);
			return TRUE;
		case INLAY_EXIT:
			SketchSaveRecordText();
			FormPopupForm(FORM_SKETCH_LIST);
			return TRUE;
		}
		case EVT_KEY:
			if (Event->eventID == SOFT_KEY)
			{
				FormGetActiveObject(FORM_SKETCH_INFO,&tempID);
				if (tempID == TEXTBOX_SKETCH_INFO)
				{
					if ((BYTE)(Event->para1) == 13)
					{
						SketchSaveRecordText();
						FormPopupForm(FORM_SKETCH_LIST);
						return TRUE;
					}
					else TextboxAddKeyInChar(TEXTBOX_SKETCH_INFO, (BYTE)(Event->para1));
					return TRUE;
				}
			}
			break;
		case	EVT_MENU_SELECT_ITEM:
			SketchMenuSelectedAction((USHORT)(Event->para1));
			return TRUE;
			
		default:
			return FALSE;
	}
	return FALSE;
}

BOOLEAN SketchFormDraw(EvtType *Event)
{
	SHORT 		radius;
	BYTE 		*text_ptr;
	BYTE 		*buf;
	ObjectID 	control_id;
	SHORT 		tmp;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if (Event->para2 & 0x00000100)
		{
			if (Event->para1 == LLETTER_DEL || Event->para1 == SLETTER_DEL)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_DELETE_RECORD;
			}
		}
		else if (Event->para2 & 0x00000200)
		{
			if (Event->para1 == LLETTER_MENU_ERASE || Event->para1 == SLETTER_MENU_ERASE)
			{
				Event->eventType = EVT_MENU_SELECT_ITEM;
				Event->para1 = MENU_ITEM_ERASE;
			}
			else if (Event->para1 == LLETTER_MENU_DEL || Event->para1 == SLETTER_MENU_DEL)
			{
				Event->eventType = EVT_MENU_SELECT_ITEM;
				Event->para1 = MENU_ITEM_DELETE;
			}
			else if (Event->para1 == LLETTER_MENU_RENAME || Event->para1 == SLETTER_MENU_RENAME)
			{
				Event->eventType = EVT_MENU_SELECT_ITEM;
				Event->para1 = MENU_ITEM_RENAME;
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_FORM_OPEN:
		application_status = RESTART_SKETCH_DRAW;
		
		sketch_rename = FALSE;
		TextboxGetTextPointer(TEXTBOX_SKETCH_INFO, &text_ptr);
		if (text_ptr[0] != 0)
			StringSetText(STRING_SKETCH_TITLE, text_ptr);
		else
			StringSetText(STRING_SKETCH_TITLE, SKETCH_NOTITLE);
		FormDrawForm(FORM_SKETCH_DRAW);
		if (sketch_alphabet == TRUE)
		{
			bounds.xcoord = tmp_x;
			bounds.ycoord = tmp_y;
			bounds.width = 156-tmp_x;
			bounds.height = 140-tmp_y;
			TextboxGetTextPointer(TEXTBOX_INPUT_TEXT, &text_ptr);
			if (text_ptr[0] != 0 && bounds.height >= SysGetFontHeight(SMALL_FONT))
				LcdDrawFixedString(&bounds, text_ptr, COLOR_BLACK, COLOR_WHITE, SMALL_FONT, NO_DOTDOT, 0);
			sketch_alphabet = FALSE;
		}
		return TRUE;
	case EVT_MENU_SELECT_ITEM:
		switch(Event->para1)
		{
		case MENU_ITEM_ERASE:
			if (sketch_select == TRUE)
			{
				sketch_select = FALSE;
				sketch_clear_undo = TRUE;
				LcdDrawBitmap(&full_bmp1, COLOR_NO_INVERT);
				
				bounds.xcoord = part_bmp3.xcoord;
				bounds.ycoord = part_bmp3.ycoord;
				bounds.width = part_bmp3.width;
				bounds.height = part_bmp3.height;
				LcdDrawBox(&bounds, COLOR_WHITE, COLOR_BLACK, FILL_SOLID);
				
				SketchGetBitmap();
				
			}
			return TRUE;
			
		case MENU_ITEM_DELETE:
			if (sketch_select == TRUE)
			{
				sketch_select = FALSE;
				LcdDrawBitmap(&full_bmp1, COLOR_NO_INVERT);
				LcdDrawBitmap(&part_bmp3, COLOR_NO_INVERT);
				pfree(part_bmp3.bitmap_data);
			}
			SketchGetBitmap();
			FormPopupForm(FORM_CONFIRM_ERASE);
			return TRUE;
		case MENU_ITEM_RENAME:
			sketch_rename = TRUE;
			if (sketch_change == TRUE)
			{
				if (sketch_select == TRUE)
				{
					sketch_select = FALSE;
					LcdDrawBitmap(&full_bmp1, COLOR_NO_INVERT);
					LcdDrawBitmap(&part_bmp3, COLOR_NO_INVERT);
					pfree(part_bmp3.bitmap_data);
				}
				SketchGetBitmap();
				FormPopupForm(FORM_SAVE_CHANGES);
			}
			else
				FormPopupForm(FORM_SKETCH_INFO);
			return TRUE;
		}
		return TRUE;
		case EVT_CONTROL_SELECT:
			switch (Event->eventID)
			{
			case BUTTON_DELETE_RECORD:
				if (ControlGetCheckedCheckbox(FORM_SKETCH_DRAW, 0, &control_id) == TRUE)
				{
					if (control_id != CHECKBOX_SKETCH_SELECT)
						LcdDrawBitmap(&full_bmp1, COLOR_NO_INVERT);
					if (sketch_clear_undo == TRUE)
					{
						sketch_clear_undo = FALSE;
						LcdDrawBitmap(&full_bmp1, COLOR_NO_INVERT);
						LcdDrawBitmap(&part_bmp3, COLOR_NO_INVERT);
						pfree(part_bmp3.bitmap_data);
						SketchGetBitmap();
					}
				}
				return TRUE;
			case CHECKBOX_SKETCH_SELECT:
				return TRUE;
			case CHECKBOX_SKETCH_THICK1:
				sketch_thick = 1;
				return TRUE;
			case CHECKBOX_SKETCH_THICK2:
				sketch_thick = 3;
				return TRUE;
			case CHECKBOX_SKETCH_THICK3:
				sketch_thick = 5;
				return TRUE;
			default:
				if (sketch_select == TRUE)
				{
					sketch_select = FALSE;
					LcdDrawBitmap(&full_bmp1, COLOR_NO_INVERT);
					LcdDrawBitmap(&part_bmp3, COLOR_NO_INVERT);
					pfree(part_bmp3.bitmap_data);
					SketchGetBitmap();
				}
				return TRUE;
			}
			return FALSE;
			case EVT_INLAY_SELECT:
				switch (Event->para1)
				{
				case INLAY_OK:
					if (sketch_select == TRUE)
					{
						sketch_select = FALSE;
						LcdDrawBitmap(&full_bmp1, COLOR_NO_INVERT);
						LcdDrawBitmap(&part_bmp3, COLOR_NO_INVERT);
						pfree(part_bmp3.bitmap_data);
					}
					SketchGetBitmap();
					if (sketch_memo == FALSE)
					{
						if (sketch_change == TRUE)
						{
							if (sketch_new == TRUE)
							{
								SketchSaveNewRecord();
								FormPopupForm(FORM_SKETCH_INFO);
							}
							else
							{
								SketchSaveRecord();
								FormPopupForm(FORM_SKETCH_LIST);
							}
						}
						else
						{
							FormPopupForm(FORM_SKETCH_LIST);
						}
					}
					else
					{
						if (sketch_change == TRUE)
						{
							SketchSaveRecordMemo();
						}
						SketchBackMemo();
					}
					return TRUE;
				case INLAY_EXIT:
					if (sketch_select == TRUE)
					{
						sketch_select = FALSE;
						LcdDrawBitmap(&full_bmp1, COLOR_NO_INVERT);
						LcdDrawBitmap(&part_bmp3, COLOR_NO_INVERT);
						pfree(part_bmp3.bitmap_data);
					}
					SketchGetBitmap();
					if (sketch_change == FALSE)
					{
						if (sketch_memo == TRUE)
							SketchBackMemo();
						else
							FormPopupForm(FORM_SKETCH_LIST);
					}
					else
						FormPopupForm(FORM_SAVE_CHANGES);
					return TRUE;
				}
				return TRUE;
				case PEN_EVENT:
					if (Event->eventID == PEN_DOWN)
					{
						sketch_x = 0;
						sketch_y = 0;
						if (Event->para1 < 4 || Event->para1 > 156 || Event->para2 < 19 || Event->para2 > 140)
							return TRUE;
					}
					else if (sketch_x == 0 && sketch_y == 0)
						return TRUE;
					if (Event->para1 < 4)
						Event->para1 = 4;
					else if (Event->para1 > 156)
						Event->para1 = 156;
					if (Event->para2 < 19)
						Event->para2 = 19;
					else if (Event->para2 > 140)
						Event->para2 = 140;
					
					
					if (Event->eventID != PEN_UP && sketch_x == Event->para1 && sketch_y == Event->para2)
						return TRUE;
					
					if (ControlGetCheckedCheckbox(FORM_SKETCH_DRAW, 1, &control_id) == TRUE)
					{
						if (control_id == CHECKBOX_SKETCH_THICK1)
							sketch_thick = 1;
						else if (control_id == CHECKBOX_SKETCH_THICK2)
							sketch_thick = 3;
						else if (control_id == CHECKBOX_SKETCH_THICK3)
							sketch_thick = 5;
						sketch_change = TRUE;
					}
					
					if (ControlGetCheckedCheckbox(FORM_SKETCH_DRAW, 0, &control_id) == TRUE)
					{
						sketch_change = TRUE;
						if (sketch_clear_undo == TRUE)
						{
							sketch_clear_undo = FALSE;
							pfree(part_bmp3.bitmap_data);
						}
					}
					
					switch (Event->eventID)
					{
					case PEN_DOWN:
						if (control_id != CHECKBOX_SKETCH_SELECT)
							SketchGetBitmap();
						break;
					case PEN_MOVE:
						break;
					case PEN_UP:
						break;
					}
					
					switch (control_id)
					{
					case CHECKBOX_SKETCH_PEN:
						if (sketch_thick == 1)
							tmp = 0;
						else if (sketch_thick == 3)
							tmp = 2;
						else if (sketch_thick == 5)
							tmp = 3;
						
						if (Event->para1 < 4+tmp)
							Event->para1 = 4+tmp;
						else if (Event->para1 > 156-tmp)
							Event->para1 = 156-tmp;
						if (Event->para2 < 19+tmp)
							Event->para2 = 19+tmp;
						else if (Event->para2 > 140-tmp)
							Event->para2 = 140-tmp;
						
						switch (Event->eventID)
						{
						case PEN_DOWN:
							break;
						case PEN_MOVE:
							LcdDrawLine(sketch_x, sketch_y, Event->para1, Event->para2,
								sketch_thick, NON_DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
							break;
						case PEN_UP:
							LcdDrawLine(sketch_x, sketch_y, Event->para1, Event->para2,
								sketch_thick, NON_DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
							break;
						}
						break;
						case CHECKBOX_SKETCH_ERASER:
							if (Event->para1 < 4+2)
								Event->para1 = 4+2;
							else if (Event->para1 > 156-2)
								Event->para1 = 156-2;
							if (Event->para2 < 19+2)
								Event->para2 = 19+2;
							else if (Event->para2 > 140-2)
								Event->para2 = 140-2;
							
							switch (Event->eventID)
							{
							case PEN_DOWN:
								break;
							case PEN_MOVE:
								bounds.xcoord = Event->para1-2;
								bounds.ycoord = Event->para2-2;
								bounds.width = 5;
								bounds.height = 5;
								LcdDrawBox(&bounds, COLOR_WHITE, COLOR_BLACK, FILL_SOLID);
								
								LcdDrawLine(sketch_x, sketch_y, Event->para1, Event->para2,
									5, NON_DOTTED_LINE, COLOR_WHITE, COLOR_BLACK);
								break;
							case PEN_UP:
								break;
							}
							
							
							break;
							case CHECKBOX_SKETCH_FILL:
								if (Event->eventID == PEN_DOWN)
									SketchFillRegion(Event->para1, Event->para2);
								return TRUE;
							case CHECKBOX_SKETCH_SELECT:
								if (sketch_select == FALSE)
								{
									switch (Event->eventID)
									{
									case PEN_DOWN:
										//								printf("Select F PD ");
										tmp_x = Event->para1;
										tmp_y = Event->para2;
										SketchGetBitmap();
										break;
									case PEN_MOVE:
										//								printf("Select F PM ");
										bounds.xcoord = min(tmp_x, Event->para1);
										bounds.ycoord = min(tmp_y, Event->para2);
										bounds.width = abs(tmp_x-Event->para1)+1;
										bounds.height = abs(tmp_y-Event->para2)+1;
										LcdDrawBitmap(&full_bmp1, COLOR_NO_INVERT);
										
										LcdDrawHoriLine(bounds.xcoord, bounds.xcoord+bounds.width-1, bounds.ycoord, DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
										LcdDrawHoriLine(bounds.xcoord, bounds.xcoord+bounds.width-1, bounds.ycoord+bounds.height-1, DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
										LcdDrawVertLine(bounds.xcoord, bounds.ycoord, bounds.ycoord+bounds.height-1, DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
										LcdDrawVertLine(bounds.xcoord+bounds.width-1, bounds.ycoord, bounds.ycoord+bounds.height-1, DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
										break;
									case PEN_UP:
										LcdDrawBitmap(&full_bmp1, COLOR_NO_INVERT);
										if (Event->para1 != tmp_x || Event->para2 != tmp_y)
										{
											part_bmp3.xcoord = bounds.xcoord;
											part_bmp3.ycoord = bounds.ycoord;
											part_bmp3.width = bounds.width;
											part_bmp3.height = bounds.height;
											LcdGetBitmap(&part_bmp3);
											
											LcdDrawBox(&bounds, COLOR_WHITE, COLOR_BLACK, FILL_SOLID);
											SketchGetBitmap();
											
											LcdDrawBitmap(&part_bmp3, COLOR_NO_INVERT);
											LcdDrawHoriLine(bounds.xcoord, bounds.xcoord+bounds.width-1, bounds.ycoord, DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
											LcdDrawHoriLine(bounds.xcoord, bounds.xcoord+bounds.width-1, bounds.ycoord+bounds.height-1, DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
											LcdDrawVertLine(bounds.xcoord, bounds.ycoord, bounds.ycoord+bounds.height-1, DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
											LcdDrawVertLine(bounds.xcoord+bounds.width-1, bounds.ycoord, bounds.ycoord+bounds.height-1, DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
											//TRACE("\nabounds %d %d", bounds.xcoord, bounds.ycoord);
											sketch_select = TRUE;
										}
										break;
									}
								}
								else if (sketch_select == TRUE)
								{
									switch (Event->eventID)
									{
									case PEN_DOWN:
										tmp_x = Event->para1;
										tmp_y = Event->para2;
										drag_x = 0;
										drag_y = 0;
										if (Event->para1 <= bounds.xcoord || Event->para1 >= bounds.xcoord + bounds.width - 1
											|| Event->para2 <= bounds.ycoord || Event->para2 >= bounds.ycoord + bounds.height - 1)
										{
											sketch_select = FALSE;
											LcdDrawBitmap(&full_bmp1, COLOR_NO_INVERT);
											LcdDrawBitmap(&part_bmp3, COLOR_NO_INVERT);
											pfree(part_bmp3.bitmap_data);
											SketchGetBitmap();
										}
										break;
									case PEN_MOVE:
										part_bmp3.xcoord = bounds.xcoord + Event->para1 - tmp_x;
										part_bmp3.ycoord = bounds.ycoord + Event->para2 - tmp_y;
										
										if (part_bmp3.xcoord < 4)
											part_bmp3.xcoord = 4;
										else if (part_bmp3.xcoord + part_bmp3.width-1 > 156)
											part_bmp3.xcoord = 156-part_bmp3.width+1;
										if (part_bmp3.ycoord < 19)
											part_bmp3.ycoord = 19;
										else if (part_bmp3.ycoord + part_bmp3.height-1 > 140)
											part_bmp3.ycoord = 140-part_bmp3.height+1;
										
										if (part_bmp3.xcoord != drag_x || part_bmp3.ycoord != drag_y)
										{
											LcdDrawBitmap(&full_bmp1, COLOR_NO_INVERT);
											LcdDrawBitmap(&part_bmp3, COLOR_NO_INVERT);
											LcdDrawHoriLine(part_bmp3.xcoord, part_bmp3.xcoord+part_bmp3.width-1, part_bmp3.ycoord, DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
											LcdDrawHoriLine(part_bmp3.xcoord, part_bmp3.xcoord+part_bmp3.width-1, part_bmp3.ycoord+part_bmp3.height-1, DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
											LcdDrawVertLine(part_bmp3.xcoord, part_bmp3.ycoord, part_bmp3.ycoord+part_bmp3.height-1, DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
											LcdDrawVertLine(part_bmp3.xcoord+part_bmp3.width-1, part_bmp3.ycoord, part_bmp3.ycoord+part_bmp3.height-1, DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
											drag_x = part_bmp3.xcoord;
											drag_y = part_bmp3.ycoord;
										}
										break;
									case PEN_UP:
										bounds.xcoord = part_bmp3.xcoord;
										bounds.ycoord = part_bmp3.ycoord;
										break;
									}
								}
								break;
							case CHECKBOX_SKETCH_RECTANGLE:
								switch (Event->eventID)
								{
								case PEN_DOWN:
									tmp_x = Event->para1;
									tmp_y = Event->para2;
									SketchGetBitmap();
									break;
								case PEN_MOVE:
									bounds.xcoord = min(tmp_x, Event->para1);
									bounds.ycoord = min(tmp_y, Event->para2);
									bounds.width = abs(tmp_x-Event->para1)+1;
									bounds.height = abs(tmp_y-Event->para2)+1;
									LcdDrawBitmap(&full_bmp1, COLOR_NO_INVERT);
									LcdDrawBox(&bounds, COLOR_BLACK, COLOR_WHITE, FILL_TRANSPARENT);
									break;
								case PEN_UP:
									bounds.xcoord = min(tmp_x, Event->para1);
									bounds.ycoord = min(tmp_y, Event->para2);
									bounds.width = abs(tmp_x-Event->para1)+1;
									bounds.height = abs(tmp_y-Event->para2)+1;
									LcdDrawBox(&bounds, COLOR_BLACK, COLOR_WHITE, FILL_TRANSPARENT);
									break;
								}
								break;
								case CHECKBOX_SKETCH_CIRCLE:
									switch (Event->eventID)
									{
									case PEN_DOWN:
										tmp_x = Event->para1;
										tmp_y = Event->para2;
										tmp_r = 0;
										SketchGetBitmap();
										break;
									case PEN_MOVE:
										radius = sqrt(((tmp_x-Event->para1)*(tmp_x-Event->para1)+(tmp_y-Event->para2)*(tmp_y-Event->para2)));
										
										if (tmp_x-radius < 4)
											radius = tmp_x-4;
										if (tmp_x+radius > 156 && radius > 156-tmp_x)
											radius = 156-tmp_x;
										if (tmp_y-radius < 19 && radius > tmp_y-19)
											radius = tmp_y-19;
										if (tmp_y+radius > 140 && radius > 140-tmp_y)
											radius = 140-tmp_y;
										
										if (tmp_r != radius)
										{
											LcdDrawBitmap(&full_bmp1, COLOR_NO_INVERT);
											LcdDrawEllipse(tmp_x, tmp_y, 0, radius, COLOR_BLACK, COLOR_WHITE, FILL_TRANSPARENT);
											tmp_r = radius;
										}
										
										break;
									case PEN_UP:
										radius = sqrt(((tmp_x-Event->para1)*(tmp_x-Event->para1)+(tmp_y-Event->para2)*(tmp_y-Event->para2)));
										if (tmp_x-radius >= 4 && tmp_x+radius <= 156 && tmp_y-radius >= 19 && tmp_y+radius <= 140)
										{
											LcdDrawEllipse(tmp_x, tmp_y, 0, radius, COLOR_BLACK, COLOR_WHITE, FILL_TRANSPARENT);
										}
										break;
									}
									break;
									case CHECKBOX_SKETCH_TEXT:
										tmp_x = Event->para1;
										tmp_y = Event->para2;
										SketchGetBitmap();
										FormPopupForm(FORM_INPUT_TEXT);
										return TRUE;
									case CHECKBOX_SKETCH_LINE:
										switch (Event->eventID)
										{
										case PEN_DOWN:
											tmp_x = Event->para1;
											tmp_y = Event->para2;
											SketchGetBitmap();
											break;
										case PEN_MOVE:
											LcdDrawBitmap(&full_bmp1, COLOR_NO_INVERT);
											LcdDrawLine(tmp_x, tmp_y, Event->para1, Event->para2,
												1, NON_DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
											break;
										case PEN_UP:
											LcdDrawLine(tmp_x, tmp_y, Event->para1, Event->para2,
												1, NON_DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
											break;
										}
										break;
				}
				if (Event->eventID == PEN_UP)
				{
					sketch_x = 0;
					sketch_y = 0;
				}
				else
				{
					sketch_x = Event->para1;
					sketch_y = Event->para2;
				}
				
				return TRUE;
			}
			return TRUE;
}

BOOLEAN SketchFormText(EvtType *Event)
{
	ObjectID 	tempID;
	BYTE		object_type;
	Textbox		*textbox_ptr;
	
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if (Event->para2 & 0x00000100)
		{
            if (Event->para1 == LLETTER_CUT || Event->para1 == SLETTER_CUT)
			{
				Event->eventType = EVT_MENU_SELECT_ITEM;
				Event->para1 = MENU_ITEM_CUT;
			}
			else if (Event->para1 == LLETTER_COPY || Event->para1 == SLETTER_COPY)
			{
				Event->eventType = EVT_MENU_SELECT_ITEM;
				Event->para1 = MENU_ITEM_COPY;
			}
			else if (Event->para1 == LLETTER_UNDO || Event->para1 == SLETTER_UNDO)
			{
				Event->eventType = EVT_MENU_SELECT_ITEM;
				Event->para1 = MENU_ITEM_UNDO;
			}
			else if (Event->para1 == LLETTER_PASTE || Event->para1 == SLETTER_PASTE)
			{
				Event->eventType = EVT_MENU_SELECT_ITEM;
				Event->para1 = MENU_ITEM_PASTE;
			}
		}
		else if (Event->para2 & 0x00000200)
		{
			if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_INPUT_TEXT_X;
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_FORM_OPEN:
		application_status = RESTART_SKETCH_TEXT;
		sketch_alphabet = TRUE;
		FormGetObjectPointer(TEXTBOX_INPUT_TEXT, &object_type, (void**)&textbox_ptr);
		textbox_ptr->textbox_attr.textbox_highlight = FALSE;
		TextboxSetText(TEXTBOX_INPUT_TEXT, (BYTE *)"");
		TextboxSetInsertPointOn(TEXTBOX_INPUT_TEXT);
		TextboxSetInsertPointPositionByCharPos(TEXTBOX_INPUT_TEXT, 0);
		FormSetFormActiveObject(FORM_INPUT_TEXT, TEXTBOX_INPUT_TEXT);
		FormDrawForm(FORM_INPUT_TEXT);
		return TRUE;
	case EVT_INLAY_SELECT:
		switch (Event->para1)
		{
		case INLAY_OK:
			FormPopupForm(FORM_SKETCH_DRAW);
			return TRUE;
		case INLAY_EXIT:
			sketch_alphabet = FALSE;
			FormPopupForm(FORM_SKETCH_DRAW);
			return TRUE;
		}
		return TRUE;
		case EVT_KEY:
			if (Event->eventID == SOFT_KEY)
			{
				FormGetActiveObject(FORM_INPUT_TEXT,&tempID);
				if (tempID == TEXTBOX_INPUT_TEXT)
				{
					if ((BYTE)(Event->para1) == 13)
					{
						FormPopupForm(FORM_SKETCH_DRAW);
						return TRUE;
					}
					else TextboxAddKeyInChar(TEXTBOX_INPUT_TEXT, (BYTE)(Event->para1));
					return TRUE;
				}
			}
			break;
		case EVT_BITMAP_SELECT:
			if (Event->eventID == BITMAP_INPUT_TEXT_X)
			{
				sketch_alphabet = FALSE;
				FormPopupForm(FORM_SKETCH_DRAW);
			}
			return TRUE;
		case	EVT_MENU_SELECT_ITEM:
			SketchMenuSelectedAction((USHORT)(Event->para1));
			return TRUE;
		default:
			return FALSE;
	}
	return FALSE;
}

BOOLEAN SketchFormErase(EvtType *Event)
{
	BOOLEAN control_value;
	
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if (Event->para2 & 0x00000200)
		{
			if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_ERASE_YES;
			}
			else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_ERASE_NO;
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_FORM_OPEN:
		application_status = RESTART_SKETCH_ERASE;
		FormDrawForm(FORM_CONFIRM_ERASE);
		return TRUE;
	case EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{
		case BUTTON_ERASE_YES:
			if (sketch_memo == TRUE)
			{
				SketchEraseRecordMemo();
				SketchBackMemo();
			}
			else
			{
				FormGetControlValue(CHECKBOX_ERASE_SAVE_ARCHIVE, &control_value);
				DataDeleteRecord(dbid, grecid, control_value);
				
				FormPopupForm(FORM_SKETCH_LIST);
			}
			return TRUE;
		case BUTTON_ERASE_NO:
			if (sketch_prevform == RESTART_SKETCH)
				FormPopupForm(FORM_SKETCH_DRAW);
			else if (sketch_prevform == RESTART_SKETCH_INFO)
				FormPopupForm(FORM_SKETCH_INFO);
			return TRUE;
		}
		default:
			return FALSE;
	}
	return FALSE;
}

BOOLEAN SketchFormSave(EvtType *Event)
{
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if (Event->para2 & 0x00000200)
		{
			if (Event->para1 == LLETTER_YES || Event->para1 == SLETTER_YES)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_SAVE_CHANGES_YES;
			}
			else if (Event->para1 == LLETTER_NO || Event->para1 == SLETTER_NO)
			{
				Event->eventType = EVT_CONTROL_SELECT;
				Event->eventID = BUTTON_SAVE_CHANGES_NO;
			}
			else if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_INPUT_TEXT_X;
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_FORM_OPEN:
		application_status = RESTART_SKETCH_SAVE;
		FormDrawForm(FORM_SAVE_CHANGES);
		return TRUE;
	case EVT_CONTROL_SELECT:
		switch (Event->eventID)
		{
		case BUTTON_SAVE_CHANGES_YES:
			if (sketch_memo == FALSE)
			{
				if (sketch_prevform == RESTART_SKETCH)
				{
					if (sketch_new == TRUE)
					{
						SketchSaveNewRecord();
						FormPopupForm(FORM_SKETCH_INFO);
					}
					else
					{
						SketchSaveRecord();
						if (sketch_rename == FALSE)
							FormPopupForm(FORM_SKETCH_LIST);
						else
							FormPopupForm(FORM_SKETCH_INFO);
					}
				}
				else if (sketch_prevform == RESTART_SKETCH_INFO)
				{
					SketchSaveRecordText();
					FormPopupForm(FORM_SKETCH_LIST);
				}
			}
			else
			{
				SketchSaveRecordMemo();
				SketchBackMemo();
			}
			return TRUE;
			
		case BUTTON_SAVE_CHANGES_NO:
			if (sketch_memo == TRUE)
				SketchBackMemo();
			else
				FormPopupForm(FORM_SKETCH_LIST);
			return TRUE;
		default:
			return FALSE;
		}
		return TRUE;
		case EVT_BITMAP_SELECT:
			if (Event->eventID == BITMAP_SAVE_CHANGES_X)
			{
				if (sketch_prevform == RESTART_SKETCH)
					FormPopupForm(FORM_SKETCH_DRAW);
				else if (sketch_prevform == RESTART_SKETCH_INFO)
					FormPopupForm(FORM_SKETCH_INFO);
			}
			return TRUE;
		default:
			return FALSE;
	}
	return FALSE;
}

BOOLEAN SketchFormLowMemory(EvtType *Event)
{
	if (Event->eventType == EVT_KEY && Event->eventID == SOFT_KEY)
	{
		if (Event->para2 & 0x00000200)
		{
			if (Event->para1 == LLETTER_X || Event->para1 == SLETTER_X)
			{
				Event->eventType = EVT_BITMAP_SELECT;
				Event->eventID = BITMAP_SKETCH_LOW_MEMORY_X;
			}
		}
	}
	
	switch (Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SKETCH_LOW_MEMORY);
		return TRUE;
	case EVT_BITMAP_SELECT:
		if (Event->eventID == BITMAP_SKETCH_LOW_MEMORY_X)
		{
			FormPopupForm(FORM_SKETCH_LIST);
		}
		return TRUE;
	default:
		return FALSE;
	}
	return FALSE;
}
