/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   skhfunc.c
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "Skhfunc.h"
#include "LcdApi.h"
#include "slang.h"

void SketchGetBitmap()
{
	pfree(full_bmp1.bitmap_data);
	pfree(full_bmp4.bitmap_data);
	LcdGetBitmap(&full_bmp1);
	(full_scr->bitmap_bitmap1).quantisation = full_bmp1.quantisation;
	(full_scr->bitmap_bitmap1).bitmap_data = full_bmp1.bitmap_data;
	BmpQ4ToBmpQ1(&full_bmp1, &full_bmp4);
}

void SketchScrollbarSetList(EvtType *Event)
{
	WORD		max,min,value,pagesize;
	WORD		scroll_total_lines;
	BYTE		object_type;
	Scrollbar*	scroll_ptr;
	ScrollbarGetScrollbar(SCROLLBAR_SKETCH_LIST, &value, &max, &min, &pagesize, &scroll_total_lines);
	
	if ((Event->para2 - Event->para1) >= pagesize)
	{
		ScrollbarSetScrollbar(SCROLLBAR_SKETCH_LIST, (Event->para2 - 1), max, min, pagesize, scroll_total_lines);
		ListSetTopItemNum(LIST_TITLE, (USHORT)(Event->para2) - 1);
	}
	else if ((Event->para1 - Event->para2) >= pagesize)
	{
		ScrollbarSetScrollbar(SCROLLBAR_SKETCH_LIST, (Event->para2 + 1), max, min, pagesize, scroll_total_lines);
		ListSetTopItemNum(LIST_TITLE, (USHORT)(Event->para2) + 1);
	}
	else
	{
		ScrollbarSetScrollbar(SCROLLBAR_SKETCH_LIST, Event->para2, max, min, pagesize, scroll_total_lines);
		ListSetTopItemNum(LIST_TITLE, (USHORT)(Event->para2));
	}
	
	if (Event->para2 != Event->para1)
		ListDrawList(LIST_TITLE);
	
    FormGetObjectPointer(SCROLLBAR_SKETCH_LIST, &object_type, (void**)&scroll_ptr);
    scroll_ptr->scrollbar_draw_pagesize = pagesize;
    ScrollbarDrawScrollbar(SCROLLBAR_SKETCH_LIST);
}

void SketchMenuSelectedAction(USHORT item_num)
{
	ObjectID active_form_id;
	ObjectID active_object_id;
	BOOLEAN highlighted = FALSE, insert_pt = FALSE;
	BYTE object_type;
	void *addr;
	Field *field_ptr;
	Textbox *textbox_ptr;
	
	
	FormGetActiveFormID(&active_form_id);
	FormGetActiveObject(active_form_id, &active_object_id);
	if (FormGetObjectPointer(active_object_id, &object_type, (void**)&addr) == FALSE)
		return;
	if (object_type != TEXTBOX && item_num != MENU_ITEM_ZOOM)
		return;
	else if (object_type == TEXTBOX)
	{
		textbox_ptr = (Textbox*)addr;
		highlighted = textbox_ptr->textbox_attr.textbox_highlight;
		insert_pt = textbox_ptr->textbox_attr.textbox_insert_pt_visible;
	}
	
	switch(item_num)
	{
	case	MENU_ITEM_COPY:
		KeyboardSendEvent(KEY_COPY, FALSE, FALSE, FALSE);
		break;
		
	case	MENU_ITEM_CUT:
		KeyboardSendEvent(KEY_CUT, FALSE, FALSE, FALSE);
		break;
		
	case	MENU_ITEM_PASTE:
		KeyboardSendEvent(KEY_PASTE, FALSE, FALSE, FALSE);
		break;
		
	case	MENU_ITEM_UNDO:
		if (UIGetUndoStatus() != UNDO_EMPTY)
			KeyboardSendEvent(KEY_UNDO, FALSE, FALSE, FALSE);
		break;
	default: break;
	}
}

void SketchMenuSetFont(BYTE font_size)
{
	List *list_ptr;
	Scrollbar *scroll_ptr;
	BYTE obj_type;
	
	FormGetObjectPointer(LIST_TITLE, &obj_type, (void**)&list_ptr);
	FormGetObjectPointer(SCROLLBAR_SKETCH_LIST, &obj_type, (void**)&scroll_ptr);
	ListSetFont(LIST_TITLE, font_size);
	if (list_ptr->list_total_num_items > list_ptr->list_max_num_items_on_display)
	{
		scroll_ptr->scrollbar_attr.scrollbar_visible = TRUE;
		
		if (list_ptr->list_highlighted_item >0 && list_ptr->list_highlighted_item < list_ptr->list_top_item_num)
			list_ptr->list_top_item_num = list_ptr->list_highlighted_item;
        else if (list_ptr->list_highlighted_item >= (list_ptr->list_top_item_num + list_ptr->list_max_num_items_on_display))
			list_ptr->list_top_item_num = list_ptr->list_highlighted_item;
		
        if (list_ptr->list_top_item_num >= (list_ptr->list_total_num_items - list_ptr->list_max_num_items_on_display))
			list_ptr->list_top_item_num = (list_ptr->list_total_num_items - list_ptr->list_max_num_items_on_display);
		
		scroll_ptr->scrollbar_value 		= list_ptr->list_top_item_num;
        scroll_ptr->scrollbar_pagesize		= list_ptr->list_max_num_items_on_display;
		scroll_ptr->scrollbar_draw_pagesize = scroll_ptr->scrollbar_pagesize;
		scroll_ptr->scrollbar_total_num_lines = list_ptr->list_total_num_items;
		scroll_ptr->scrollbar_max			= scroll_ptr->scrollbar_total_num_lines - scroll_ptr->scrollbar_pagesize;
		scroll_ptr->scrollbar_min			= 0;
	}
	else
	{
		scroll_ptr->scrollbar_attr.scrollbar_visible = FALSE;
		ScrollbarEraseScrollbar(SCROLLBAR_SKETCH_LIST);	
		list_ptr->list_top_item_num = 0;
	}
	
	if (list_ptr->list_text_font == SMALL_FONT)
	{
		MenuDeleteItem(SKETCH_LIST_MENU, 0);
		MenuInsertItem(SKETCH_LIST_MENU, 0, SKETCHLFONT);
	}
	else
	{
		MenuDeleteItem(SKETCH_LIST_MENU, 0);
		MenuInsertItem(SKETCH_LIST_MENU, 0, SKETCHSFONT);
	}
	ListDrawList(LIST_TITLE);
	ScrollbarDrawScrollbar(SCROLLBAR_SKETCH_LIST);
}

void SketchInit()
{
	BYTE obj_type;
	
	sketch_new = FALSE;
	sketch_alphabet = FALSE;
	sketch_select = FALSE;
	sketch_change = FALSE;
	
	full_bmp1.xcoord = 4;
	full_bmp1.ycoord = 19;
	full_bmp1.width = 153;
	full_bmp1.height = 122;
	full_bmp1.size = 0;
	full_bmp4.xcoord = 4;
	full_bmp4.ycoord = 19;
	full_bmp4.width = 153;
	full_bmp4.height = 122;
	full_bmp4.size = 0;
	part_bmp3.size = 0;
	
	FormGetObjectPointer(BITMAP_SKETCH_DRAW, &obj_type, (void **)&full_scr);
	LcdGetBitmap(&full_bmp1);
	(full_scr->bitmap_bitmap1).quantisation = full_bmp1.quantisation;
	(full_scr->bitmap_bitmap1).bitmap_data = full_bmp1.bitmap_data;
	BmpQ4ToBmpQ1(&full_bmp1, &full_bmp4);
}

void SketchPrepareFindText(DatabaseID f_dbid, RecordID rec_id, BYTE **prepare_string)
{
	ObjectBounds	content_bounds;
	BYTE			*content, *buffer;
	UWORD			byte_read;
	
	
	
	content_bounds.xcoord	=0;
	content_bounds.ycoord	=0;
	content_bounds.width	=67;
	content_bounds.height	=9;
	
	*prepare_string = (BYTE*)pmalloc(100*sizeof(BYTE));
	DataGetField(f_dbid, rec_id, 0, &buffer, &byte_read);
    content = (BYTE*)pmalloc((strlen(buffer) + 10) *sizeof(BYTE));
	strcpy(content, buffer);
	StrChopString(&content_bounds, content, SMALL_FONT, TRUE, 0);
	strcpy(*prepare_string, content);
	
    qfree(buffer);
	pfree(content);
}


BOOLEAN SketchFillLine(SHORT xcoord, SHORT ycoord)
{
	SHORT x;
	BYTE color;
	if (ycoord < 19 || ycoord > 140)
		return FALSE;
	
	LcdGetPixel(xcoord, ycoord, &color);
	if (color != COLOR_WHITE)
		return FALSE;
	LcdSetPixel(xcoord, ycoord, COLOR_GREY2_4);
	x = xcoord;
	while (x > 4)
	{
		x--;
		LcdGetPixel(x, ycoord, &color);
		if (color != COLOR_WHITE)
			break;
		LcdSetPixel(x, ycoord, COLOR_GREY2_4);
	};
	x = xcoord;
	while (x < 156)
	{
		x++;
		LcdGetPixel(x, ycoord, &color);
		if (color != COLOR_WHITE)
			break;
		LcdSetPixel(x, ycoord, COLOR_GREY2_4);
	};
	return TRUE;
}

BOOLEAN SketchFillRegion(SHORT xcoord, SHORT ycoord)
{
	SHORT i, x, j;
	BYTE color;
	BOOLEAN sketch_flag;
	BOOLEAN sketch_line[160];
	
	for (i=0; i<160; i++)
		sketch_line[i] = FALSE;
	
	if (SketchFillLine(xcoord, ycoord) == TRUE)
		sketch_line[ycoord] = TRUE;
	do
	{
		sketch_flag = FALSE;
		for (i=19; i<=140; i++)
		{
			if (sketch_line[i] == TRUE)
			{
				for (x=4; x<=156; x++)
				{
					LcdGetPixel(x, i, &color);
					if (color == COLOR_GREY2_4)
					{
						if (SketchFillLine(x, i-1) == TRUE)
						{
							sketch_line[i-1] = TRUE;
							sketch_flag = TRUE;
						}
						if (SketchFillLine(x, i+1) == TRUE)
							sketch_line[i+1] = TRUE;
						LcdSetPixel(x, i, COLOR_BLACK);
					}
				}
				sketch_line[i] = FALSE;
			}
		}
	} while (sketch_flag == TRUE);
	return TRUE;
}



