/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   skhmain.c
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#ifdef PC_SIM
#include "resource.h"
#endif
#include "kernel.h"
#include "resmgr.h"
#include "Skhfunc.h"
#include "ui.h"
#include "uifunc.h"
#include "inlay.h"
#include "system.h"
#include "slang.h"

/* ==================================================================== */
/* ========================= Function Prototypes ====================== */
/* ==================================================================== */
void MMUInit();
void KernelInit();
void ResInit();
static BOOLEAN ApplicationHandleEvent(EvtType *Event);

#ifdef PR31700
BOOLEAN (*FormDispatchEvent)(EvtType *Event);
#endif
extern UWORD *sys_page, *app_page;
extern REGISTRY app_reg[];

#ifdef PC_SIM
extern BOOL m_bIsExit;
#endif



/* ==================================================================== */
/* ========================= Global Defines =========================== */
/* ==================================================================== */

/* ==================================================================== */
/* ========================= Global Variables ========================= */
/* ==================================================================== */
extern UBYTE res_data[];

/********************************************************
* Function:	ApplicationHandleEvent
* Purpose: 	This function is used to load the specific data of
form and set event handler of the form
* Scope:		application/internal
* Input:		Event		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment: 	None
*********************************************************/
static BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
	Form *form_ptr;
	ObjectID form_id;
	BYTE object_type;
	Err Error;
	
	if (Event->eventType == EVT_FORM_LOAD)
	{
		form_id = (ObjectID)Event->eventID;
		Error = UISearchForAddress(form_id,&object_type,(void**)&form_ptr);
		if (Event->para1 == 1 || Error != TRUE)
		{
			FormInitForm(form_id);
		}
		if (!UISearchForAddress(form_id,&object_type,(void**)&form_ptr)) return FALSE;
		switch (form_id)
		{
		case FORM_SKETCH_LIST:
			FormSetEventHandler(FORM_SKETCH_LIST, (void**)&FormDispatchEvent, (void*)SketchFormList);
			break;
		case FORM_SKETCH_INFO:
			FormSetEventHandler(FORM_SKETCH_INFO, (void**)&FormDispatchEvent, (void*)SketchFormInfo);
			break;
		case FORM_SKETCH_DRAW:
			FormSetEventHandler(FORM_SKETCH_DRAW, (void**)&FormDispatchEvent, (void*)SketchFormDraw);
			break;
		case FORM_INPUT_TEXT:
			FormSetEventHandler(FORM_INPUT_TEXT, (void**)&FormDispatchEvent, (void*)SketchFormText);
			break;
		case FORM_CONFIRM_ERASE:
			FormSetEventHandler(FORM_CONFIRM_ERASE, (void**)&FormDispatchEvent, (void*)SketchFormErase);
			break;
		case FORM_SAVE_CHANGES:
			FormSetEventHandler(FORM_SAVE_CHANGES, (void**)&FormDispatchEvent, (void*)SketchFormSave);
			break;
		case FORM_SKETCH_LOW_MEMORY:
			FormSetEventHandler(FORM_SAVE_CHANGES, (void**)&FormDispatchEvent, (void*)SketchFormLowMemory);
			break;
		}
		FormSetActiveForm(form_id);
		return TRUE;
	}
	return FALSE;
}


/********************************************************
* Function:	EventLoop
* Purpose: 	This function is a loop to get events from event
manager and then passes the event to different
event handler
* Scope:		application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
void EventLoop(void)
{
	EvtType event;
	do
	{
		EvtGetEvent (&event);
		if (!SystemHandleEvent(&event))
			if (!MenuHandleEvent(&event))
				if (!ApplicationHandleEvent(&event))
					FormDispatchEvent(&event);
	}
#ifdef PC_SIM
	while (event.eventType != EVT_APP_STOP && m_bIsExit == FALSE);
#else
	while (event.eventType != EVT_APP_STOP);
#endif
	
	if (event.para1 == FROM_SYSTEM_DIALOG && application_status == RESTART_SKETCH_DRAW)
	{
#ifdef DEBUG
		printf("\nGF Draw Bitmap");
#endif
		LcdDrawBitmap(event.evtPBP, COLOR_NO_INVERT);
	}
}

/********************************************************
* Function:	main
* Purpose: 	main procedure of the application
* Scope:		Application
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
#ifdef PC_SIM
void LoadRes();
#endif

#ifdef PC_SIM
void main(WORD cmd, void *cmd_ptr)
#endif
#ifdef PR31700
__main(WORD cmd, void *cmd_ptr)
#endif
{
#ifdef PC_SIM
	MsgQueueCreate(&msgQueue);
	EvtQueueCreate(&evtQueue);
	KeyboardInitKeyboard();
	MMUInit();
	ResInit();
	LcdInit();
	UIInit();
	LoadRes();
	cmd = LAUNCH_CMD_NORMAL_LAUNCH;
	//	cmd = LAUNCH_CMD_FIND;
	//	cmd = LAUNCH_CMD_GOTO_REC;
	//	cmd = LAUNCH_CMD_ALARM_HIT;
	
	if (cmd == LAUNCH_CMD_NORMAL_LAUNCH)
		cmd_ptr = NULL;
	else if (cmd == LAUNCH_CMD_FIND)
	{
		cmd_ptr = (BYTE*)pmalloc(30*sizeof(BYTE));
		strcpy((BYTE*)cmd_ptr, SKETCH_A);
		SketchDatabaseTemp();
	}
	else if (cmd == LAUNCH_CMD_GOTO_REC)
	{
		cmd_ptr = (GotoRec*)pmalloc(sizeof(GotoRec));
		//((GotoRec*)cmd_ptr)->dbid = appid;
		((GotoRec*)cmd_ptr)->rec_id = 1001;
		((GotoRec*)cmd_ptr)->field_num = 1;
		((GotoRec*)cmd_ptr)->find_string = (BYTE*)pmalloc(30*sizeof(BYTE));
		strcpy(((GotoRec*)cmd_ptr)->find_string, SKETCH_E1);
		//		((GotoRec*)cmd_ptr)->find_string = NULL;
		
		SketchListInit();
	}
	else
		cmd_ptr = NULL;
	
#endif
	
	if (DataFindDB(SKETCHDB, &dbid) != TRUE)
	{
		SketchDatabaseTemp();
		restore_status = TRUE;
	}
	else
	{
		retval = DataOpenDB(dbid, SORT_TEXT_MODE|0, OPEN_RW);
		if (DataRecordInfo(dbid, SKETCH_STATUS, NULL, NULL, NULL, NULL, NULL) != TRUE)
			restore_status = TRUE;
		else
			restore_status = FALSE;
		
	}
	SketchAppLaunch(cmd, (void*)cmd_ptr);
}

#ifdef PC_SIM
void LoadRes()
{
	char app_name[20];
	UBYTE *ptr;
	UWORD *ptable;
	AppID app_id;
	unsigned long res_size = 10389;//15950;
	unsigned long i;
	
	MemoryInstallProg(SKETCH, res_size, APP_TYPE_APP, FALSE, 0, &app_id, (UBYTE **) &ptr, (UWORD **)&ptable);
	
	if(ptr == NULL)
	{
		printf("\nNot enough memory to install resource ");
		return;
	}
	
	for(i=0;i<res_size;i++)
		ptr[i] = res_data[i];
	
	strcpy(app_name, SKETCH);
	
}
#endif
