/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   sysmain.c
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application c file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "platform.h"
#include "syslang.h"
#include "sysdef.h"
#include "SySetup.h"
#include "system.h"
#ifdef PR31700
#include "dev_pwr.h"
#endif

#ifdef PC_SIM
#include "resource.h"
#include "pdaemu.h"
#include "PdaEmuDlg.h"
extern CPDAEmuDlg* m_EmuDlg;
#endif

//#define DEBUG
/*****************************************************************
********************** Global Variables **************************
*****************************************************************/

BYTE		password_hints_field_enable, Update_Timing;
BYTE		enter_text[30], change_text[30], confirm_text[30];
BYTE		login_password[45], email_password[45];
BYTE		GOwnInfoFont, GEmailFont;
RTM			Gtimer;
BOOLEAN		email2_popup;
USHORT		prev_row_num, prev_col_num;
UWORD		Tmr_Label;
BYTE		*global_string;

extern	BOOLEAN		home_day_clk, visit_day_clk;
extern 	BYTE		ShortCutSysInfo;
extern	UWORD		Tmr_Label;
extern	DelAppData	*G_del_app_ptr, *G_del_dd_ptr;
extern	USHORT		G_total_app, G_total_dd;

/*****************************************************************
* Function:	SySetupMenuGotoForm
* Purpose: 	This function is used to initialize the form 
which will be poped up by main menu or restore
* Scope:		application/internal
* Input:		popup_form_id
* Output:		None
* Return:		None
* Comment: 	None
******************************************************************/
BOOLEAN SySetupMenuGotoForm(ObjectID popup_form_id)
{
	BYTE	null_string[1]={0};
	BOOLEAN		ctrl_value;
	PasswordSettings password;
	
	switch (popup_form_id)
	{	
	case FORM_SYSETUP_DATE:
		FormInitAllFormObjects(FORM_SYSETUP_DATE);
		SySetupRestoreDateSettings(FORM_SYSETUP_DATE, TABLE_SYSETUP_DATE, PUSH_SYSETUP_DATE_Y1, PUSH_SYSETUP_DATE_JAN, &prev_row_num, &prev_col_num);
		FormPopupForm(FORM_SYSETUP_DATE);
		break;
		
	case FORM_SYSETUP_CLOCK:
		FormInitAllFormObjects(FORM_SYSETUP_DATE);
		FormInitAllFormObjects(FORM_SYSETUP_CLOCK_12HR);
		FormInitAllFormObjects(FORM_SYSETUP_CLOCK_24HR);
		FormInitAllFormObjects(FORM_SYSETUP_CLOCK);
		home_day_clk = TRUE;
		visit_day_clk = TRUE;
		if (!SySetupRestoreClockSettings())
			return FALSE;
		RtcGetTime(&Gtimer);
		SySetupClockPutRtmTime(Gtimer);
		SySetupClockWriteTime(&Gtimer);
		
		// ------ enable interrupt
		if (Update_Timing == 0)
		{
			Tmr_Label = TmrIntEnable(30000, SySetupClockUpdateClockTiming);
			Update_Timing = 1;
		}
		
		FormPopupForm(FORM_SYSETUP_CLOCK);
		break;
		
	case FORM_SYSETUP_CLOCK_12HR:
		FormInitAllFormObjects(FORM_SYSETUP_CLOCK);
		FormInitAllFormObjects(FORM_SYSETUP_CLOCK_12HR);
		FormInitAllFormObjects(FORM_SYSETUP_CLOCK_24HR);
		if (!SySetupRestoreClockSettings())
			return FALSE;
		RtcGetTime(&Gtimer);
		SySetupClockPutRtmTime(Gtimer);
		SySetupClockWriteTime(&Gtimer);
		// ------ enable interrupt
		if (Update_Timing == 0)
		{
			Tmr_Label = TmrIntEnable(30000, SySetupClockUpdateClockTiming);
			Update_Timing = 1;
		}
		
		FormPopupForm(FORM_SYSETUP_CLOCK);
		break;
		
	case FORM_SYSETUP_CLOCK_24HR:
		FormInitAllFormObjects(FORM_SYSETUP_CLOCK);
		FormInitAllFormObjects(FORM_SYSETUP_CLOCK_12HR);
		FormInitAllFormObjects(FORM_SYSETUP_CLOCK_24HR);
		if (!SySetupRestoreClockSettings())
			return FALSE;
		RtcGetTime(&Gtimer);
		SySetupClockPutRtmTime(Gtimer);
		SySetupClockWriteTime(&Gtimer);
		// ------ enable interrupt
		if (Update_Timing == 0)
		{
			Tmr_Label = TmrIntEnable(30000, SySetupClockUpdateClockTiming);
			Update_Timing = 1;
		}
		
		FormPopupForm(FORM_SYSETUP_CLOCK);
		break;
		
	case FORM_SYSETUP_SCRCAL:
		if (LcdGetOrientation() == 1)
			break;
		FormInitAllFormObjects(FORM_SYSETUP_SCRCAL);
		FormSetObjectPosition(BITMAP_SYSETUP_SCRCAL, SYSETUP_LEFT_TOP_X, SYSETUP_LEFT_TOP_Y);
		FormPopupForm(FORM_SYSETUP_SCRCAL);
		break;
		
	case FORM_SYSETUP_SOUND:
		FormInitAllFormObjects(FORM_SYSETUP_SOUND);
		SySetupRestoreSoundSettings();
		FormPopupForm(FORM_SYSETUP_SOUND);
		break;
		
	case FORM_SYSETUP_SYSINFO:
		FormPopupForm(FORM_SYSETUP_SYSINFO);
		break;
		
	case FORM_SYSETUP_PASSWORD:
		FormInitAllFormObjects(FORM_SYSETUP_PASSWORD);
		FormInitAllFormObjects(FORM_SYSETUP_PASSWORD_FAILURE);
		FormInitAllFormObjects(FORM_SYSETUP_PASSWORD_HINTS);
		FormInitAllFormObjects(FORM_SYSETUP_PASSWORD_ENTER);
		SySetupGetPasswordSettings(&password);
		qfree(password.hints);
		if (password.password[0] == 0)
		{
			TextboxSetText(TEXTBOX_SYSETUP_PASSWORD_CONFIRM, null_string);
			TextboxSetText(TEXTBOX_SYSETUP_PASSWORD_NEW, null_string);
			FormSetFormActiveObject(FORM_SYSETUP_PASSWORD, TEXTBOX_SYSETUP_PASSWORD_NEW);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_SYSETUP_PASSWORD_NEW, 0);
			TextboxSetInsertPointOn(TEXTBOX_SYSETUP_PASSWORD_NEW);
			FormGetControlValue(CHECKBOX_SYSETUP_PASSWORD_CHECK, &ctrl_value);
			SySetupGetPasswordSettings(&password);
			qfree(password.hints);
			if (ctrl_value != (SHORT)password.check_password)
				FormSetControlGroupSelection(FORM_SYSETUP_PASSWORD, CHECKBOX_SYSETUP_PASSWORD_CHECK);
			
			FormPopupForm(FORM_SYSETUP_PASSWORD);
		}
		else
		{
			TextboxSetText(TEXTBOX_SYSETUP_PASSWORD_OLD, null_string);
			FormSetFormActiveObject(FORM_SYSETUP_PASSWORD_ENTER, TEXTBOX_SYSETUP_PASSWORD_OLD);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_SYSETUP_PASSWORD_OLD, 0);
			TextboxSetInsertPointOn(TEXTBOX_SYSETUP_PASSWORD_OLD);
			FormDrawForm(FORM_SYSETUP_PASSWORD);
			FormPopupForm(FORM_SYSETUP_PASSWORD_ENTER);
		}
		break;
		
	case FORM_SYSETUP_PASSWORD_FAILURE:
		FormInitAllFormObjects(FORM_SYSETUP_PASSWORD);
		FormInitAllFormObjects(FORM_SYSETUP_PASSWORD_FAILURE);
		FormInitAllFormObjects(FORM_SYSETUP_PASSWORD_HINTS);
		
		TextboxInitTextbox(TEXTBOX_SYSETUP_PASSWORD_OLD);
		TextboxSetInsertPointPositionByCharPos(TEXTBOX_SYSETUP_PASSWORD_OLD, 0);
		FormGetControlValue(CHECKBOX_SYSETUP_PASSWORD_CHECK, &ctrl_value);
		SySetupGetPasswordSettings(&password);
		qfree(password.hints);
		if (ctrl_value != (SHORT)password.check_password)
			FormSetControlGroupSelection(FORM_SYSETUP_PASSWORD, CHECKBOX_SYSETUP_PASSWORD_CHECK);
		
		FormPopupForm(FORM_SYSETUP_PASSWORD);
		break;
		
	case FORM_SYSETUP_PASSWORD_SUCCESS:
		FormGetControlValue(CHECKBOX_SYSETUP_PASSWORD_CHECK, &ctrl_value);
		SySetupGetPasswordSettings(&password);
		qfree(password.hints);
		if (ctrl_value != (SHORT)password.check_password)
			FormSetControlGroupSelection(FORM_SYSETUP_PASSWORD, CHECKBOX_SYSETUP_PASSWORD_CHECK);
		FormPopupForm(FORM_SYSETUP_PASSWORD);
		break;
		
	case FORM_SYSETUP_PASSWORD_HINTS:
		FormInitAllFormObjects(FORM_SYSETUP_PASSWORD);
		FormInitAllFormObjects(FORM_SYSETUP_PASSWORD_FAILURE);
		FormInitAllFormObjects(FORM_SYSETUP_PASSWORD_HINTS);
		SySetupRestorePasswordHints();
		FormPopupForm(FORM_SYSETUP_PASSWORD_HINTS);
		break;
		
	case FORM_SYSETUP_COUNTRY:
		FormInitAllFormObjects(FORM_SYSETUP_DATE);
		FormInitAllFormObjects(FORM_SYSETUP_COUNTRY);
		FormInitAllFormObjects(FORM_SYSETUP_CLOCK);
		FormInitAllFormObjects(FORM_SYSETUP_CLOCK_12HR);
		FormInitAllFormObjects(FORM_SYSETUP_CLOCK_24HR);
		SySetupRestoreCountrySettings();
		FormPopupForm(FORM_SYSETUP_COUNTRY);
		break;
		
	case FORM_SYSETUP_OWNINFO:
		FormInitAllFormObjects(FORM_SYSETUP_OWNINFO);
		SySetupRestoreOwnerInfo();
		FormPopupForm(FORM_SYSETUP_OWNINFO);
		break;
		
	case FORM_SYSETUP_MODEM:
		FormInitAllFormObjects(FORM_SYSETUP_MODEM);
		FormInitAllFormObjects(FORM_SYSETUP_MODEM_CUSTOM);
		SySetupRestoreModemSettings();
		FormPopupForm(FORM_SYSETUP_MODEM);
		break;
		
	case FORM_SYSETUP_MODEM_CUSTOM:
		FormInitAllFormObjects(FORM_SYSETUP_MODEM_CUSTOM);
		SySetupRestoreModemCustomSettings();
		FormPopupForm(FORM_SYSETUP_MODEM_CUSTOM);
		break;
		
	case FORM_SYSETUP_EMAIL:
		FormInitAllFormObjects(FORM_SYSETUP_EMAIL);
		FormInitAllFormObjects(FORM_SYSETUP_EMAIL2);
		SySetupRestoreEmailSettings();
		FormPopupForm(FORM_SYSETUP_EMAIL);
		break;
		
	case FORM_SYSETUP_EMAIL2:
		FormInitAllFormObjects(FORM_SYSETUP_EMAIL2);
		SySetupRestoreEmailSettings();
		FormPopupForm(FORM_SYSETUP_EMAIL2);
		break;
		
	case FORM_SYSETUP_KEY_MAPPING:
		FormInitAllFormObjects(FORM_SYSETUP_KEY_MAPPING);
		SySetupRestoreKeyMappingSettings();
		FormPopupForm(FORM_SYSETUP_KEY_MAPPING);
		break;
		
	default:
		FormPopupForm(FORM_SYSETUP_MENU);
		break;
		}
		
		return TRUE;
}

/*****************************************************************
* Function:	SySetupInitMainGlobal
* Purpose: 	This function is used to initialize the global variables
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
******************************************************************/
BOOLEAN	SySetupInitMainGlobal(BOOLEAN is_restart)
{
	BYTE		*buffer ,null_string[1]={0};
	UWORD		byte_read;
	DatabaseID	SySetup_dbid;
	
	Update_Timing = 0;
	
	if (is_restart)
	{
		email2_popup = FALSE;
		prev_row_num = 0;
		prev_col_num = 0;
		GOwnInfoFont = 'S';
		GEmailFont = 'S';
		
	}
	else
	{
		if (DataFindDB(SYSETUPDB, &SySetup_dbid) != TRUE)
			return FALSE;
		if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
			return FALSE;
		DataGetField(SySetup_dbid, SYSETUP_MAIN_APP_SAVE, F_email2_popup, &buffer, &byte_read);
		email2_popup = *(BOOLEAN*)buffer;
		qfree(buffer);
		DataGetField(SySetup_dbid, SYSETUP_MAIN_APP_SAVE, F_prev_row_num, &buffer, &byte_read);
		prev_row_num = *(USHORT*)buffer;
		qfree(buffer);
		DataGetField(SySetup_dbid, SYSETUP_MAIN_APP_SAVE, F_prev_col_num, &buffer, &byte_read);
		prev_col_num = *(USHORT*)buffer;
		qfree(buffer);
		DataGetField(SySetup_dbid, SYSETUP_MAIN_APP_SAVE, F_GOwnInfoFont, &buffer, &byte_read);
		GOwnInfoFont = *(BYTE*)buffer;
		qfree(buffer);
		DataGetField(SySetup_dbid, SYSETUP_MAIN_APP_SAVE, F_GEmailFont, &buffer, &byte_read);
		GEmailFont = *(BYTE*)buffer;
		qfree(buffer);
		
		DataGetField(SySetup_dbid, SYSETUP_MAIN_APP_SAVE, F_ActiveFormID, &buffer, &byte_read);
#ifdef GOTO_SYSETUP_FORM
		if (!SySetupMenuGotoForm(*(ObjectID*)buffer))
			return FALSE;
#else
			/*		if ((*(ObjectID*)buffer) == FORM_SYSETUP_SCRCAL)
			{
			qfree(buffer);
			if (DataCloseDB(SySetup_dbid) != TRUE)
			return FALSE;
			
			  SySetupInitScrCalData();
			  SySetupMenuGotoForm(FORM_SYSETUP_SCRCAL);    
			  return TRUE;
			  }
			  else
		*/			SySetupMenuGotoForm(FORM_SYSETUP_MENU);
		
#endif
		qfree(buffer);
		if (DataCloseDB(SySetup_dbid) != TRUE)
			return FALSE;
	}
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupMainAppSave
* Purpose: 	This function is called to save the data in 
the SySetup database when it is called to stopped
* Scope:		application/internal
* Input:		None
* Output:		None
* Return:		None
* Comment: 	None
******************************************************************/
BOOLEAN SySetupMainAppSave(void)
{
	ObjectID	active_form_id;
	DatabaseID	SySetup_dbid;
	
	if (Update_Timing == 1)
	{
		TmrIntDisable(Tmr_Label);
		Update_Timing = 0;
	}
	
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	FormGetActiveFormID(&active_form_id);
	switch(active_form_id)
	{
	case FORM_SYSETUP_CLOCK_12HR:
		if (!SySetupSetClockSettings())
			return FALSE;
		//RtcSetTime(&Gtimer);
		break;
	case FORM_SYSETUP_CLOCK_24HR:
		if (!SySetupSetClockSettings())
			return FALSE;
		//RtcSetTime(&Gtimer);
		break;
	case FORM_SYSETUP_CLOCK:
		if (!SySetupSetClockSettings())
			return FALSE;
		//RtcSetTime(&Gtimer);
		break;
	case FORM_SYSETUP_COUNTRY:
		if (!SySetupSetCountrySettings())
			return FALSE;
		break;
	case FORM_SYSETUP_KEY_MAPPING:
		if (!SySetupSetKeyMappingSettings())
			return FALSE;
		break;
	case FORM_SYSETUP_MODEM:
		KeyboardSetKeyboardVisible();
		if (!SySetupSetModemSettings())
			return FALSE;
		if (!SySetupSetModemCustomSettings())
			return FALSE;
		break;
	case FORM_SYSETUP_MODEM_CUSTOM:
		if (!SySetupSetModemSettings())
			return FALSE;
		if (!SySetupSetModemCustomSettings())
			return FALSE;
		break;
	case FORM_SYSETUP_SOUND:
		if (!SySetupSetSoundSettings())
			return FALSE;
		break;
	case FORM_SYSETUP_OWNINFO:
		if (!SySetupSetOwnerInfo())
			return FALSE;
		break;
	case FORM_SYSETUP_PASSWORD_HINTS:
		if (!SySetupEditPasswordHints())
			return FALSE;
		break;
	case FORM_SYSETUP_EMAIL:
		if (!SySetupSetEmailSettings())
			return FALSE;
		email2_popup = FALSE;
		break;
	case FORM_SYSETUP_EMAIL2:
		if (!SySetupSetEmailSettings())
			return FALSE;
		email2_popup = FALSE;
		break;
	default:
		break;
	}
	
	if (DataWriteField(SySetup_dbid, SYSETUP_MAIN_APP_SAVE, F_ActiveFormID, sizeof(ObjectID), (BYTE*)&active_form_id) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, SYSETUP_MAIN_APP_SAVE, F_email2_popup, sizeof(BOOLEAN), (BYTE*)&email2_popup) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, SYSETUP_MAIN_APP_SAVE, F_prev_row_num, sizeof(USHORT), (BYTE*)&prev_row_num) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, SYSETUP_MAIN_APP_SAVE, F_prev_col_num, sizeof(USHORT), (BYTE*)&prev_col_num) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, SYSETUP_MAIN_APP_SAVE, F_GOwnInfoFont, sizeof(BYTE), (BYTE*)&GOwnInfoFont) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, SYSETUP_MAIN_APP_SAVE, F_GEmailFont, sizeof(BYTE), (BYTE*)&GEmailFont) != TRUE)
		return FALSE;
	
	DataCloseDB(SySetup_dbid);
	
	
	return TRUE;
}






/*****************************************************************
***************** Application Event Handle Function **************
*****************************************************************/

/*****************************************************************
* Function:	SySetupMenu
* Purpose: 	This function is the event handler for the MENU
*				page of the System setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupMenu(EvtType *Event)
{
	BYTE	null_string[1]={0};
    AppID	app_id;
    //static	BYTE	pwr_evt_counter;
    //static	SHORT	pwr_evt_level;
	
    
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		if (!ShortCutSysInfo)
			FormDrawForm(FORM_SYSETUP_MENU);
		ShortCutSysInfo = 0;
		BatteryWarningSetEnableStatus(TRUE);
		//pwr_evt_counter = 0;
		return TRUE;
		
		
#ifdef PR31700
	case POWER_EVENT:	
		//if (Event->eventID == BAT_MAIN_LEVEL)
		/*{
		if (pwr_evt_counter < 3)
		{
		pwr_evt_counter++;
		pwr_evt_level += (SHORT)Event->para1;
		if (BatChkMainLevel() != 0)
		{					
		FormInitAllFormObjects(FORM_SYSETUP_SYSINFO);
		SySetupRestoreSysInfo();
		SySetupDisplaySystemInfo((WORD)BatChkMainLevelBakup());
		pwr_evt_counter = 0;
		pwr_evt_level = 0;
		FormPopupForm(FORM_SYSETUP_SYSINFO);
		}
		}
		else
		{*/
		FormInitAllFormObjects(FORM_SYSETUP_SYSINFO);
		SySetupRestoreSysInfo();
		SySetupRestoreSyncSpeedSettings();
		SySetupDisplaySystemInfo((WORD)Event->para1);
		//pwr_evt_counter = 0;
		//pwr_evt_level = 0;
		FormPopupForm(FORM_SYSETUP_SYSINFO);
		/*}
	}*/
		return TRUE;
#endif
		
	case EVT_BITMAP_SELECT:
		switch (Event->eventID)
		{	
		case BITMAP_SYSETUP_MENU_CLOCK:
		case BITMAP_SYSETUP_MENU_AUTOFFTIME:
			SySetupMenuGotoForm(FORM_SYSETUP_CLOCK);
			return TRUE;
			
		case BITMAP_SYSETUP_MENU_KEY_MAPPING:
			SySetupMenuGotoForm(FORM_SYSETUP_KEY_MAPPING);
			return TRUE;
			
		case BITMAP_SYSETUP_MENU_SCRCAL:
			SySetupMenuGotoForm(FORM_SYSETUP_SCRCAL);
			return TRUE;
			
		case BITMAP_SYSETUP_MENU_SOUND:
			SySetupMenuGotoForm(FORM_SYSETUP_SOUND);
			return TRUE;
			
		case BITMAP_SYSETUP_MENU_SYSINFO:
			//					FormInitAllFormObjects(FORM_SYSETUP_SYSINFO);
			//					SySetupRestoreSysInfo();
			//					FormPopupForm(FORM_SYSETUP_SYSINFO);
#ifdef PR31700
			BatteryWarningSetEnableStatus(FALSE);
			if (BatChkMainLevel() != 0)
			{					
				FormInitAllFormObjects(FORM_SYSETUP_SYSINFO);
				SySetupRestoreSysInfo();
				SySetupRestoreSyncSpeedSettings();
				SySetupDisplaySystemInfo((WORD)BatChkMainLevelBakup());
				FormPopupForm(FORM_SYSETUP_SYSINFO);
			}
			
#endif
			return TRUE;
			
		case BITMAP_SYSETUP_MENU_PASSWORD:			
			if (SySetupCheckMemoryEmpty())
			{
				FormPopupForm(FORM_SYSETUP_DIALOG_LOW_MEMORY);
				return TRUE;
			}
			SySetupMenuGotoForm(FORM_SYSETUP_PASSWORD);
			return TRUE;
			
		case BITMAP_SYSETUP_MENU_COUNTRY:
			SySetupMenuGotoForm(FORM_SYSETUP_COUNTRY);
			return TRUE;
			
		case BITMAP_SYSETUP_MENU_OWNINFO:
			if (SySetupCheckMemoryEmpty())
			{
				FormPopupForm(FORM_SYSETUP_DIALOG_LOW_MEMORY);
				return TRUE;
			}
			SySetupMenuGotoForm(FORM_SYSETUP_OWNINFO);
			return TRUE;
			
		case BITMAP_SYSETUP_MENU_MODEM:
			SySetupMenuGotoForm(FORM_SYSETUP_MODEM);
			return TRUE;
			
		case BITMAP_SYSETUP_MENU_EMAIL:
			if (SySetupCheckMemoryEmpty())
			{
				FormPopupForm(FORM_SYSETUP_DIALOG_LOW_MEMORY);
				return TRUE;
			}
			SySetupMenuGotoForm(FORM_SYSETUP_EMAIL);
			return TRUE;
			
		default:	return FALSE;	
		}
		
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
			case INLAY_EXIT:			
#ifdef PR31700
				SysGetAppID(MAINMENU, &app_id);
				EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
				EvtAppendEvt(EVT_APP_LAUNCH, app_id, 0, 0, NULL);
#endif
				return TRUE;
			default:	return FALSE;
			}
			
			default:	return FALSE;	
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	SySetupKeyMapping
* Purpose: 	This function is the event handler for the key mapping
*				page of the System setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupKeyMapping(EvtType *Event)
{
	SHORT	item_num;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SYSETUP_KEY_MAPPING);
		return TRUE;
		
	case EVT_CONTROL_POPUP_SELECT:
		//			ControlPopupGetSelectedItem((ObjectID)Event->eventID, &item_num);
		//			if (!SySetupSetKeyMappingSettings())
		//				return FALSE;
		return TRUE;
	case EVT_CONTROL_SELECT:
		if ((ObjectID)Event->eventID == BUTTON_SYSETUP_KEY_MAPPING_DEFAULT)
		{
			if (!SySetupSetDefaultKeyMappingSettings())
				return FALSE;
		}
		return TRUE;	
		
	case EVT_INLAY_SELECT:
		switch(Event->para1)
		{	
		case INLAY_OK:
			if (!SySetupSetKeyMappingSettings())
				return FALSE;
			FormPopupForm(FORM_SYSETUP_MENU);
			return TRUE;
			
		case INLAY_EXIT:
			//					if (!SySetupSetDefaultKeyMappingSettings())
			//						return FALSE;
			FormPopupForm(FORM_SYSETUP_MENU);
			return TRUE;
		}
		
		default:	return FALSE;	
	}
	
	return FALSE;
}





/*****************************************************************
* Function:	SySetupCountry
* Purpose: 	This function is the event handler for the country
*				settings page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupCountry(EvtType *Event)
{
	BYTE	text[60] = {0};
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SYSETUP_COUNTRY);
		return TRUE;
		
	case EVT_CONTROL_POPUP_SELECT:
		switch(Event->eventID)
		{
		case POPUP_SYSETUP_COUNTRY_TFORMAT:
			switch(Event->para1)
			{
			case SYSETUP_12HR_DISPLAY:
				strcpy(text, SYSSTR1);
				break;
				
			case SYSETUP_24HR_DISPLAY:
				strcpy(text, "15:04:59         ");
				break;
				
			default: break;
			}
			StringSetText(STRING_SYSETUP_COUNTRY_TSAMPLE_TIME, text);
			StringDrawString(STRING_SYSETUP_COUNTRY_TSAMPLE_TIME);
			return TRUE;
			
			case POPUP_SYSETUP_COUNTRY_DFORMAT:
				switch(Event->para1)
				{
				case SYSETUP_YMD:
					strcpy(text, "99/6/30        ");
					break;
				case SYSETUP_DMY:
					strcpy(text, "30/6/99        ");
					break;
				case SYSETUP_MDY:
					strcpy(text, "6/30/99        ");
					break;
					
				default: break;
				}
				StringSetText(STRING_SYSETUP_COUNTRY_DSAMPLE_DATE, text);
				StringDrawString(STRING_SYSETUP_COUNTRY_DSAMPLE_DATE);
				return TRUE;
				
				case POPUP_SYSETUP_COUNTRY_START_WK:
					switch(Event->para1)
					{
					case SYSETUP_SUN:
						strcpy(text, SYSSTR2);
						break;
						
					case SYSETUP_MON:
						strcpy(text, SYSSTR3);
						break;
						
					default:	return FALSE;	
					}
					StringSetText(STRING_SYSETUP_DATE_WDAY1, text);
					return TRUE;
					
					
					case POPUP_SYSETUP_COUNTRY_REGIONAL:
						if (!SySetupRestoreRegionalSettings())
							return FALSE;
						
					default:	return FALSE;	
						
		}
		
		
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
				if (!SySetupSetCountrySettings())
					return FALSE;
				FormPopupForm(FORM_SYSETUP_MENU);
				return TRUE;
				
			case INLAY_EXIT:
				FormPopupForm(FORM_SYSETUP_MENU);
				return TRUE;
			}
			
			
			default:	return FALSE;	
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	SySetupModem
* Purpose: 	This function is the event handler for the modem
*				settings page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupModem(EvtType *Event)
{
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SYSETUP_MODEM);
		KeyboardSetKeyboardInvisible();
		TextboxSetInsertPointOn(TEXTBOX_SYSETUP_MODEM_DIAL);
		return TRUE;
		
	case EVT_MENU_SELECT_ITEM:
		switch((USHORT)(Event->para1))
		{
		case MENU_ITEM_COPY:
			KeyboardSendEvent(KEY_COPY, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_CUT:
			KeyboardSendEvent(KEY_CUT, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_PASTE:
			KeyboardSendEvent(KEY_PASTE, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_UNDO:
			if (UIGetUndoStatus() != UNDO_EMPTY)
				KeyboardSendEvent(KEY_UNDO, FALSE, FALSE, FALSE);
			break;
		default:
			break;
		}
		return TRUE;
		
		case EVT_CONTROL_SELECT:
			switch(Event->eventID)
			{	
			case BUTTON_SYSETUP_MODEM_CUSTOM:
				SySetupRestoreModemCustomSettings();
				FormPopupForm(FORM_SYSETUP_MODEM_CUSTOM);
				return TRUE;
				
			default:	return FALSE;
			}
			
			case EVT_BITMAP_SELECT:
				switch(Event->eventID)
				{	
				case BITMAP_SYSETUP_MODEM_DIALKB:
					FormSetFormActiveObject(FORM_SYSETUP_MODEM, TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_MODEM_DIAL);
					KeyboardSendEvent(KEY_LEFT, FALSE, FALSE, FALSE);
					return TRUE;
					
				case BITMAP_SYSETUP_MODEM_DIALKC:
					FormSetFormActiveObject(FORM_SYSETUP_MODEM, TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_MODEM_DIAL);
					KeyboardSendEvent(KEY_BACKSPACE, FALSE, FALSE, FALSE);
					return TRUE;
					
				case BITMAP_SYSETUP_MODEM_DIALKF:
					FormSetFormActiveObject(FORM_SYSETUP_MODEM, TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_MODEM_DIAL);
					KeyboardSendEvent(KEY_RIGHT, FALSE, FALSE, FALSE);
					return TRUE;
					
				case BITMAP_SYSETUP_MODEM_DIALK1:
					FormSetFormActiveObject(FORM_SYSETUP_MODEM, TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxAddKeyInChar(TEXTBOX_SYSETUP_MODEM_DIAL, '1');
					return TRUE;
					
				case BITMAP_SYSETUP_MODEM_DIALK2:
					FormSetFormActiveObject(FORM_SYSETUP_MODEM, TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxAddKeyInChar(TEXTBOX_SYSETUP_MODEM_DIAL, '2');
					return TRUE;
					
				case BITMAP_SYSETUP_MODEM_DIALK3:
					FormSetFormActiveObject(FORM_SYSETUP_MODEM, TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxAddKeyInChar(TEXTBOX_SYSETUP_MODEM_DIAL, '3');
					return TRUE;
					
				case BITMAP_SYSETUP_MODEM_DIALK4:
					FormSetFormActiveObject(FORM_SYSETUP_MODEM, TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxAddKeyInChar(TEXTBOX_SYSETUP_MODEM_DIAL, '4');
					return TRUE;
					
				case BITMAP_SYSETUP_MODEM_DIALK5:
					FormSetFormActiveObject(FORM_SYSETUP_MODEM, TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxAddKeyInChar(TEXTBOX_SYSETUP_MODEM_DIAL, '5');
					return TRUE;
					
				case BITMAP_SYSETUP_MODEM_DIALK6:
					FormSetFormActiveObject(FORM_SYSETUP_MODEM, TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxAddKeyInChar(TEXTBOX_SYSETUP_MODEM_DIAL, '6');
					return TRUE;
					
				case BITMAP_SYSETUP_MODEM_DIALK7:
					FormSetFormActiveObject(FORM_SYSETUP_MODEM, TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxAddKeyInChar(TEXTBOX_SYSETUP_MODEM_DIAL, '7');
					return TRUE;
					
				case BITMAP_SYSETUP_MODEM_DIALK8:
					FormSetFormActiveObject(FORM_SYSETUP_MODEM, TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxAddKeyInChar(TEXTBOX_SYSETUP_MODEM_DIAL, '8');
					return TRUE;
					
				case BITMAP_SYSETUP_MODEM_DIALK9:
					FormSetFormActiveObject(FORM_SYSETUP_MODEM, TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxAddKeyInChar(TEXTBOX_SYSETUP_MODEM_DIAL, '9');
					return TRUE;
					
				case BITMAP_SYSETUP_MODEM_DIALKA:
					FormSetFormActiveObject(FORM_SYSETUP_MODEM, TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxAddKeyInChar(TEXTBOX_SYSETUP_MODEM_DIAL, '#');
					return TRUE;
					
				case BITMAP_SYSETUP_MODEM_DIALK0:
					FormSetFormActiveObject(FORM_SYSETUP_MODEM, TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxAddKeyInChar(TEXTBOX_SYSETUP_MODEM_DIAL, '0');
					return TRUE;
					
				case BITMAP_SYSETUP_MODEM_DIALKS:
					FormSetFormActiveObject(FORM_SYSETUP_MODEM, TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_MODEM_DIAL);
					TextboxAddKeyInChar(TEXTBOX_SYSETUP_MODEM_DIAL, '*');
					return TRUE;
					
				case BITMAP_SYSETUP_MODEM_DIALKEN:
					SySetupSetModemSettings();
					TextboxSetInsertPointOff(TEXTBOX_SYSETUP_MODEM_DIAL);
					return TRUE;
					
				default:	return FALSE;
				}
				
				
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
				if (!SySetupSetModemSettings())
					return FALSE;
				KeyboardSetKeyboardVisible();
				FormPopupForm(FORM_SYSETUP_MENU);
				return TRUE;
				
			case INLAY_EXIT:
				KeyboardSetKeyboardVisible();
				FormPopupForm(FORM_SYSETUP_MENU);
				return TRUE;
				
			default:	return FALSE;
			}
			
	}
	
	return FALSE;
}



/*****************************************************************
* Function:	SySetupModemCustom
* Purpose: 	This function is the event handler for the modem
*				custom settings page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupModemCustom(EvtType *Event)
{
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SYSETUP_MODEM_CUSTOM);
		return TRUE;
		
	case EVT_INLAY_SELECT:
		switch(Event->para1)
		{	
		case INLAY_OK:
			if (!SySetupSetModemCustomSettings())
				return FALSE;
			FormPopupForm(FORM_SYSETUP_MODEM);
			return TRUE;
			
		case INLAY_EXIT:
			FormPopupForm(FORM_SYSETUP_MODEM);
			return TRUE;
			
		default:	return FALSE;
		}
		
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	SySetupClock
* Purpose: 	This function is the event handler for the clock
*				settings page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupClock(EvtType *Event)
{
	CountrySettings	country;
	static SHORT	prev_home_country;
	SHORT			new_home_country;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SYSETUP_CLOCK);
		ControlPopupGetSelectedItem(POPUP_SYSETUP_CLOCK_HOME_COUNTRY, &prev_home_country);
		BatteryWarningSetEnableStatus(TRUE);
		return TRUE;
		
	case EVT_CONTROL_SELECT:
		if (Update_Timing == 1)
		{
			TmrIntDisable(Tmr_Label);       
			Update_Timing = 0;
		}
		switch(Event->eventID)
		{	
		case BUTTON_SYSETUP_CLOCK_HOME_TIME:
			if (!SySetupGetCountrySettings(&country))
				return TRUE;
			if (country.time_fmt == SYSETUP_12HR_DISPLAY)
				FormPopupForm(FORM_SYSETUP_CLOCK_12HR);
			else
				FormPopupForm(FORM_SYSETUP_CLOCK_24HR);
			return TRUE;
			
		case BUTTON_SYSETUP_CLOCK_HOME_DATE:
			SySetupRestoreDateSettings(FORM_SYSETUP_DATE, TABLE_SYSETUP_DATE, PUSH_SYSETUP_DATE_Y1, PUSH_SYSETUP_DATE_JAN, &prev_row_num, &prev_col_num);
			FormPopupForm(FORM_SYSETUP_DATE);
			return TRUE;
			
		case PUSH_SYSETUP_CLOCK_VIST_DST:
			SySetupClockPutRtmTime(Gtimer);
			SySetupClockWriteTime(&Gtimer);
			SySetupClockUpdateClockView();
			return TRUE;
			
		case PUSH_SYSETUP_CLOCK_HOME_DST:
			SySetupClockSetHomeDSTTime(&Gtimer);
			SySetupClockPutRtmTime(Gtimer);
			SySetupClockWriteTime(&Gtimer);
			SySetupClockUpdateClockView();
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_CONTROL_POPUP_SELECT:
			//Tmr_Label = TmrIntEnable(30000, SySetupClockUpdateClockTiming);
			//Update_Timing = 1;
			switch(Event->eventID)
			{
			case POPUP_SYSETUP_CLOCK_VIST_COUNTRY:
				//						ControlPopupGetSelectedItem(POPUP_SYSETUP_CLOCK_HOME_COUNTRY, &new_home_country);
				//						SySetupClockCalTimeDiff(new_home_country, prev_home_country, &Gtimer);
				SySetupClockPutRtmTime(Gtimer);
				SySetupClockWriteTime(&Gtimer);
				SySetupClockUpdateClockView();
				return TRUE;
				
			case POPUP_SYSETUP_CLOCK_HOME_COUNTRY:
				ControlPopupGetSelectedItem(POPUP_SYSETUP_CLOCK_HOME_COUNTRY, &new_home_country);
				
				// if local time will be changed by popup
				/*temp_timer = Gtimer;
				SySetupClockCalTimeDiff(new_home_country, prev_home_country, temp_timer, &Gtimer);*/
				
				SySetupClockPutRtmTime(Gtimer);
				SySetupClockWriteTime(&Gtimer);
				SySetupClockUpdateClockView();
				prev_home_country = new_home_country;
				return TRUE;
				
			case POPUP_SYSETUP_CLOCK_AUTOFFTIME:
				return TRUE;
				
			default:	return FALSE;
			}
			
			/*
			case RTC_EVENT:
			if (Event->eventID == RTC_GETTIME)
			{
			if (Update_Timing == 1)
			{
			tmp_Gtimer = Event->evtPBP;
			Gtimer = *tmp_Gtimer;
			qfree(tmp_Gtimer);
			
			  SySetupClockPutRtmTime(Gtimer);
			  SySetupClockWriteTime(&Gtimer);
			  SySetupClockUpdateClockView();
			  Tmr_Label = TmrIntEnable(30000, SySetupClockUpdateClockTiming);
			  }
			  return TRUE;
			  }
			  return FALSE;
			*/
			
			case EVT_INLAY_SELECT:
				switch(Event->para1)
				{	
				case INLAY_OK:
					if (Update_Timing == 1)
					{
						TmrIntDisable(Tmr_Label);       
						Update_Timing = 0;
					}
					
					if (!SySetupSetClockSettings())
						return TRUE;
					RtcSetTime(&Gtimer);
					FormPopupForm(FORM_SYSETUP_MENU);
					return TRUE;
					
				case INLAY_EXIT:
					if (Update_Timing == 1)
					{
						TmrIntDisable(Tmr_Label);       
						Update_Timing = 0;
					}
					FormPopupForm(FORM_SYSETUP_MENU);
					return TRUE;
					
				default:	return FALSE;
				}
				
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	SySetupClock12Hr
* Purpose: 	This function is the event handler for 12 hours display dialog box
*				in the clock settings
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupClock12Hr(EvtType *Event)
{
	
	ObjectID	control_id;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SYSETUP_CLOCK_12HR);
		return TRUE;
		
	case PEN_EVENT:
		if (Event->eventID == PEN_DOWN)
		{
			//=================================== modified at 270300 ==============================
			/*
			if ((Event->para1 < 81 || Event->para2 < 89 || Event->para1 > 155 || Event->para2 > 122)
			&& Event->para1 < 160 && Event->para2 < 160)
			*/
			if ((Event->para1 < 5 || Event->para2 < 89 || Event->para1 > 79 || Event->para2 > 122))
				//					&& Event->para1 < 160 && Event->para2 < 160)
				//=========================================================================================
			{
				SySetupClockWriteTime(&Gtimer);
				// ------------------------
				RtcSetTime(&Gtimer);
				FormPopupForm(FORM_SYSETUP_CLOCK);
			}
		}
		return TRUE;
		
	case EVT_BITMAP_SELECT:
		ControlGetPushedPushButton(FORM_SYSETUP_CLOCK_12HR, GROUP_ID_SYSETUP_CLOCK_12HR_TIME, &control_id);
		switch(Event->eventID)
		{	
		case BITMAP_SYSETUP_CLOCK_12HR_UPARW:
			SySetupSetClockTimeUp(control_id, SYSETUP_12HR_DISPLAY);
			return TRUE;
			
		case BITMAP_SYSETUP_CLOCK_12HR_DNARW:
			SySetupSetClockTimeDn(control_id, SYSETUP_12HR_DISPLAY);
			return TRUE;
			
		default:	return FALSE;
		}
		
#ifdef PR31700
		case EVT_IO_KEY_CTRL:
			ControlGetPushedPushButton(FORM_SYSETUP_CLOCK_12HR, GROUP_ID_SYSETUP_CLOCK_12HR_TIME, &control_id);
			if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
            {
                if (Event->para2 == IO_UP_ARROW)
					SySetupSetClockTimeUp(control_id, SYSETUP_12HR_DISPLAY);
                else if (Event->para2 == IO_DOWN_ARROW)
					SySetupSetClockTimeDn(control_id, SYSETUP_12HR_DISPLAY);
				return TRUE;
			}
			return FALSE;
#endif
			
			
			
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
				SySetupClockWriteTime(&Gtimer);
				// ------------------------
				RtcSetTime(&Gtimer);
				FormPopupForm(FORM_SYSETUP_CLOCK);
				return TRUE;
				
			case INLAY_EXIT:
				FormPopupForm(FORM_SYSETUP_CLOCK);
				return TRUE;
				
			default:	return FALSE;
			}
			
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	SySetupClock24Hr
* Purpose: 	This function is the event handler for 24 hours display dialog box
*				in the clock settings
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupClock24Hr(EvtType *Event)
{
	
	ObjectID	control_id;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SYSETUP_CLOCK_24HR);
		return TRUE;
		
	case PEN_EVENT:
		if (Event->eventID == PEN_DOWN)
		{
			//=================================== modified at 270300 ==============================
			/*
			if ((Event->para1 < 81 || Event->para2 < 89 || Event->para1 > 155 || Event->para2 > 122)
			&& Event->para1 < 160 && Event->para2 < 160)
			*/
			if ((Event->para1 < 5 || Event->para2 < 89 || Event->para1 > 79 || Event->para2 > 122))
				//					&& Event->para1 < 160 && Event->para2 < 160)
				//=========================================================================================
			{
				SySetupClockWriteTime(&Gtimer);
				// ------------------------
				RtcSetTime(&Gtimer);
				FormPopupForm(FORM_SYSETUP_CLOCK);
			}
		}
		return TRUE;
		
	case EVT_BITMAP_SELECT:
		ControlGetPushedPushButton(FORM_SYSETUP_CLOCK_24HR, GROUP_ID_SYSETUP_CLOCK_24HR_TIME, &control_id);
		switch(Event->eventID)
		{	
		case BITMAP_SYSETUP_CLOCK_24HR_UPARW:
			SySetupSetClockTimeUp(control_id, SYSETUP_24HR_DISPLAY);
			return TRUE;
			
		case BITMAP_SYSETUP_CLOCK_24HR_DNARW:
			SySetupSetClockTimeDn(control_id, SYSETUP_24HR_DISPLAY);
			return TRUE;
			
		default:	return FALSE;
		}
		
#ifdef PR31700
		case EVT_IO_KEY_CTRL:
			ControlGetPushedPushButton(FORM_SYSETUP_CLOCK_24HR, GROUP_ID_SYSETUP_CLOCK_24HR_TIME, &control_id);
			if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
            {
                if (Event->para2 == IO_UP_ARROW)
					SySetupSetClockTimeUp(control_id, SYSETUP_24HR_DISPLAY);
                else if (Event->para2 == IO_DOWN_ARROW)
					SySetupSetClockTimeDn(control_id, SYSETUP_24HR_DISPLAY);
				return TRUE;
			}
			return FALSE;
#endif
			
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
				SySetupClockWriteTime(&Gtimer);
				// ------------------------
				RtcSetTime(&Gtimer);
				FormPopupForm(FORM_SYSETUP_CLOCK);
				return TRUE;
				
			case INLAY_EXIT:
				FormPopupForm(FORM_SYSETUP_CLOCK);
				return TRUE;
				
			default:	return FALSE;
			}
	}
	
	return FALSE;
}



/*****************************************************************
* Function:	SySetupDate
* Purpose: 	This function is the event handler for the date
*				settings page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupDate(EvtType *Event)
{
	BYTE	*item_text, day_text[3] = {0};
	BYTE	text[60];
	SHORT	year, month, day;
	CountrySettings country;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		SySetupGetCountrySettings(&country);
		switch(country.start_of_week)
		{
		case SYSETUP_SUN:
			strcpy(text, SYSSTR2);
			break;
		case SYSETUP_MON:
			strcpy(text, SYSSTR3);
			break;
		default:	return FALSE;	
		}
		StringSetText(STRING_SYSETUP_DATE_WDAY1, text);
		FormDrawForm(FORM_SYSETUP_DATE);
		return TRUE;
		
		case EVT_BITMAP_SELECT:
			SySetupGetCountrySettings(&country);
			switch (Event->eventID)
			{
			case BITMAP_SYSETUP_DATE_LEFT:
				SySetupDateUpdateYearBar(PUSH_SYSETUP_DATE_Y1, BUTTON_SYSETUP_DATE_DISABLE_BKGRD, SYSETUP_YEAR_LEFT);
				SySetupGetDateSettings(FORM_SYSETUP_DATE, TABLE_SYSETUP_DATE, PUSH_SYSETUP_DATE_JAN, GROUP_ID_SYSETUP_DATE_YEAR, GROUP_ID_SYSETUP_DATE_MONTH, 
					prev_row_num, prev_col_num, &year, &month, &day);
				SySetupDateUpdateTable(TABLE_SYSETUP_DATE, year, month, day, (SHORT)country.start_of_week, &prev_row_num, &prev_col_num);
				TableEraseTable(TABLE_SYSETUP_DATE);
				TableDrawTable(TABLE_SYSETUP_DATE);
				return TRUE;
				
			case BITMAP_SYSETUP_DATE_RIGHT:
				SySetupDateUpdateYearBar(PUSH_SYSETUP_DATE_Y1, BUTTON_SYSETUP_DATE_DISABLE_BKGRD, SYSETUP_YEAR_RIGHT);
				SySetupGetDateSettings(FORM_SYSETUP_DATE, TABLE_SYSETUP_DATE, PUSH_SYSETUP_DATE_JAN, GROUP_ID_SYSETUP_DATE_YEAR, GROUP_ID_SYSETUP_DATE_MONTH, 
					prev_row_num, prev_col_num, &year, &month, &day);
				SySetupDateUpdateTable(TABLE_SYSETUP_DATE, year, month, day, (SHORT)country.start_of_week, &prev_row_num, &prev_col_num);
				TableEraseTable(TABLE_SYSETUP_DATE);
				TableDrawTable(TABLE_SYSETUP_DATE);
				return TRUE;
				
				
			default:	return FALSE;
			}
			
			case EVT_CONTROL_SELECT:
				SySetupGetCountrySettings(&country);
				SySetupGetDateSettings(FORM_SYSETUP_DATE, TABLE_SYSETUP_DATE, PUSH_SYSETUP_DATE_JAN, GROUP_ID_SYSETUP_DATE_YEAR, GROUP_ID_SYSETUP_DATE_MONTH, 
					prev_row_num, prev_col_num, &year, &month, &day);
				SySetupDateUpdateTable(TABLE_SYSETUP_DATE, year, month, day, (SHORT)country.start_of_week, &prev_row_num, &prev_col_num);
				TableEraseTable(TABLE_SYSETUP_DATE);
				TableDrawTable(TABLE_SYSETUP_DATE);
				return TRUE;
				
				
			case EVT_TABLE_SELECT:			
				TableGetItemText(TABLE_SYSETUP_DATE, (USHORT)Event->para1, (USHORT)Event->para2, &item_text);
				if (item_text[0] != 0)
				{
					if ((prev_row_num == (USHORT)Event->para1) && (prev_col_num == (USHORT)Event->para2))
						TableSetHighlightCell(TABLE_SYSETUP_DATE, prev_row_num, prev_col_num, TRUE);
					else
					{
						TableSetHighlightCell(TABLE_SYSETUP_DATE, prev_row_num, prev_col_num, FALSE);
						prev_row_num = (USHORT)Event->para1;
						prev_col_num = (USHORT)Event->para2;		
					}
					TableDrawTable(TABLE_SYSETUP_DATE);
				}
				return TRUE;
				
			case EVT_INLAY_SELECT:
				switch(Event->para1)
				{	
				case INLAY_OK:
					SySetupSetDateSettings(prev_row_num, prev_col_num, &Gtimer);
					SySetupClockPutRtmTime(Gtimer);
					SySetupClockWriteTime(&Gtimer);
					FormPopupForm(FORM_SYSETUP_CLOCK);
					return TRUE;
					
				case INLAY_EXIT:
					FormPopupForm(FORM_SYSETUP_CLOCK);
					return TRUE;
					
				default:	return FALSE;
				}
				
	}
	
	return FALSE;
}



/*****************************************************************
* Function:	SySetupSound
* Purpose: 	This function is the event handler for the sound
*				settings page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupSound(EvtType *Event)
{
	SoundSettings	sound;
	
	WORD	sync_speed;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SYSETUP_SOUND);
		return TRUE;
		
	case EVT_SCROLLBAR_SELECT:
		ScrollbarDrawScrollbar((USHORT)Event->eventID);
		if (!SySetupGetSoundSettings(&sound))
			return FALSE;
#ifdef PR31700
		if ((USHORT)Event->eventID == SCROLLBAR_SYSETUP_SOUND_CLICK)
		{
			if (Event->para2 == 0)
			{
				//if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	(SHORT)((8*sound.vol_curr)/(sound.click_max-sound.click_min)+23), 0, 3))
				if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	-1, 0, 3))
					return FALSE;
			}
			else
			{
				//if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	(SHORT)((8*sound.vol_curr)/(sound.click_max-sound.click_min)+23),
				//		(SHORT)((4*Event->para2)/(sound.click_max-sound.click_min)+23), 3))					
				if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	-1,	(SHORT)((4*Event->para2)/(sound.click_max-sound.click_min)+23), 3))
					return FALSE;
			}
		}
		else
		{
			if (Event->para2 == 0)
			{
				//if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	0, (SHORT)((4*sound.click_curr)/(sound.click_max-sound.click_min)+23), 3))
				if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	0, -1, 3))
					return FALSE;
			}
			else
			{
				//if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	(SHORT)((8*Event->para2)/(sound.click_max-sound.click_min)+23),
				//						(SHORT)((4*sound.click_curr)/(sound.click_max-sound.click_min)+23), 3))
				if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	(SHORT)((8*Event->para2)/(sound.click_max-sound.click_min)+23),	-1, 3))
					return FALSE;
			}
		}
		
#endif
		
		return TRUE;
		
	case EVT_SCROLLBAR_REPEAT:
		if (Event->para1 == Event->para2)
			return TRUE;
		ScrollbarDrawScrollbar((USHORT)Event->eventID);
		//				SySetupScrollbarSetClickSoundSettings((USHORT)Event->eventID, (USHORT)Event->para2);
		return TRUE;
		
	case EVT_INLAY_SELECT:
		switch(Event->para1)
		{	
		case INLAY_OK:
			if (!SySetupSetSoundSettings())
				return FALSE;
			FormPopupForm(FORM_SYSETUP_MENU);
			return TRUE;
			
		case INLAY_EXIT:
			if (!SySetupRestoreSoundSettings())
				return FALSE;
			FormPopupForm(FORM_SYSETUP_MENU);
			return TRUE;
			
		default:	return FALSE;
		}
		
	}
	
	return FALSE;
}

/*****************************************************************
* Function:	SySetupSysInfo
* Purpose: 	This function is the event handler for the system
*				information settings page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupSysInfo(EvtType *Event)
{
    static	BYTE	pwr_evt_counter;
    static	SHORT	pwr_evt_level;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		//			pwr_evt_counter = 0;
		//			BatChkMainLevel();
		FormDrawForm(FORM_SYSETUP_SYSINFO);
		BatteryWarningSetEnableStatus(TRUE);
		return TRUE;
		
#ifdef PR31700
	case POWER_EVENT:	
		if (Event->eventID == BAT_MAIN_LEVEL)
		{
			if (pwr_evt_counter < 5)
			{
				pwr_evt_counter++;
				pwr_evt_level += (SHORT)Event->para1;
				BatChkMainLevel();
			}
			else
			{
				SySetupDisplaySystemInfo((WORD)(pwr_evt_level / 5));
				pwr_evt_counter = 0;
				pwr_evt_level = 0;
				FormDrawForm(FORM_SYSETUP_SYSINFO);
			}
		}
		return TRUE;
#endif
	case EVT_CONTROL_SELECT:
		FormInitAllFormObjects(FORM_SYSETUP_SYSINFO_DELAPP);
		FormPopupForm(FORM_SYSETUP_SYSINFO_DELAPP);
		return TRUE;
		
	case EVT_INLAY_SELECT:
		switch(Event->para1)
		{	
		case INLAY_OK:
			SySetupSetSyncSpeedSettings();
			FormPopupForm(FORM_SYSETUP_MENU);
			return TRUE;
			
		case INLAY_EXIT:
			SySetupRestoreSyncSpeedSettings();
			FormPopupForm(FORM_SYSETUP_MENU);
			return TRUE;
			
		default:	return FALSE;
		}
		
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	SySetupSysInfoDelApp
* Purpose: 	This function is the event handler for the delete
*				application page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
#ifdef PR31700
BOOLEAN SySetupSysInfoDelApp(EvtType *Event)
{
	BYTE	*item_text;
	SHORT	item_num;
	USHORT	total_num_items;
	static USHORT	top_item_num = 0;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		SySetupDelAppToList();
		SySetupScrollbarSetDelAppList(top_item_num);
		FormDrawForm(FORM_SYSETUP_SYSINFO_DELAPP);
		return TRUE;
		
	case EVT_SCROLLBAR_REPEAT:
		if (Event->para1 == Event->para2)
			return TRUE;
		SySetupScrollbarSetDelAppList((USHORT)Event->para2);
		ListDrawList(LIST_SYSETUP_SYSINFO_DELAPP_APPNAME);
		ListDrawList(LIST_SYSETUP_SYSINFO_DELAPP_APPSIZE);
		ScrollbarDrawScrollbar((USHORT)Event->eventID);
		return TRUE;
		
	case EVT_SCROLLBAR_SELECT:
		SySetupScrollbarSetDelAppList((USHORT)Event->para2);
		ListDrawList(LIST_SYSETUP_SYSINFO_DELAPP_APPNAME);
		ListDrawList(LIST_SYSETUP_SYSINFO_DELAPP_APPSIZE);
		ScrollbarDrawScrollbar((USHORT)Event->eventID);
		return TRUE;
		
	case EVT_CONTROL_SELECT:
		// =============================================================================
		// added at 15062000
		if (G_total_app != 0)
		{
			ListGetTotalItems(LIST_SYSETUP_SYSINFO_DELAPP_APPNAME, &total_num_items);
			ListGetSelectedItem(LIST_SYSETUP_SYSINFO_DELAPP_APPNAME, &item_num);
			if (item_num > 0 && item_num < total_num_items)
			{
				ListGetListItem(LIST_SYSETUP_SYSINFO_DELAPP_APPNAME, (USHORT)item_num, &item_text);
				if (SySetupDelApp((USHORT) item_num, item_text) != TRUE)
					return TRUE;
				qfree(G_del_app_ptr);
				qfree(G_del_dd_ptr);
				if (item_num < 12)
					top_item_num = 0;
				else
				{
					ListGetTotalItems(LIST_SYSETUP_SYSINFO_DELAPP_APPNAME, &total_num_items);
					ListGetTopItemNum(LIST_SYSETUP_SYSINFO_DELAPP_APPNAME, &top_item_num);
					if (total_num_items - top_item_num < 13)
						top_item_num -= 13 - (total_num_items - top_item_num);
				}
			}
		}
		// =============================================================================
		FormPopupForm(FORM_SYSETUP_SYSINFO_DELAPP);
		return TRUE;
		
	case EVT_LIST_SELECT:
		if (Event->para1 <= 0 || (G_total_app > 0 && Event->para1 == G_total_app+1))
			return TRUE;
		
		ListSetHighlightedItem(LIST_SYSETUP_SYSINFO_DELAPP_APPNAME, (SHORT)Event->para1);
		ListSetHighlightedItem(LIST_SYSETUP_SYSINFO_DELAPP_APPSIZE, (SHORT)Event->para1);
		ListDrawList(LIST_SYSETUP_SYSINFO_DELAPP_APPNAME);
		ListDrawList(LIST_SYSETUP_SYSINFO_DELAPP_APPSIZE);
		return TRUE;
		
		
	case EVT_INLAY_SELECT:
		switch(Event->para1)
		{	
		case INLAY_OK:
		case INLAY_EXIT:
			qfree(G_del_app_ptr);
			qfree(G_del_dd_ptr);	
			FormPopupForm(FORM_SYSETUP_SYSINFO);
			return TRUE;
			
		default:	return FALSE;
		}
		
	}
	
	return FALSE;
}
#endif


/*****************************************************************
* Function:	SySetupScrCal
* Purpose: 	This function is the event handler for the screen
*				calibration settings page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupScrCal(EvtType *Event)
{
	BYTE	string_text[40], object_type, cal_pen_mode;
	Bitmap	*bitmap_ptr;
	
	static	SHORT	cal_pos, cal_pos_flag;
	static	SHORT	lt_x1, lt_x2, lt_x3, lt_y1, lt_y2, lt_y3;
	static	SHORT	rb_x1, rb_x2, rb_x3, rb_y1, rb_y2, rb_y3;
	static	SHORT	arb_x1, arb_x2, arb_x3, arb_y1, arb_y2, arb_y3;
	
	
    switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SYSETUP_SCRCAL);
		BitmapEraseBitmap(BITMAP_SYSETUP_SCRCAL);
		FormSetObjectPosition(BITMAP_SYSETUP_SCRCAL, SYSETUP_LEFT_TOP_X, SYSETUP_LEFT_TOP_Y);
		FormGetObjectPointer(BITMAP_SYSETUP_SCRCAL, &object_type, (void**)&bitmap_ptr);
		bitmap_ptr->bitmap_attr.bitmap_enter = 0;
		BitmapDrawBitmap(BITMAP_SYSETUP_SCRCAL);
#ifdef PR31700
		BatteryWarningSetEnableStatus(FALSE);
		PenSetCalMode();
		InlaySetEnableStatus(FALSE);
		SystemSetMappedHardwareKeyStatus(FALSE);
		AlarmMgrEnable(FALSE);	            
#endif
		cal_pos = (SHORT)NONE_POS;
		
		//FormSetObjectPosition(BITMAP_SYSETUP_SCRCAL, SYSETUP_RIGHT_BOTTOM_X, SYSETUP_RIGHT_BOTTOM_Y);
		//BitmapDrawBitmap(BITMAP_SYSETUP_SCRCAL);
		// ----------------------------------------------------------
		// ----------------------------------------------------------
		return TRUE;
		
	case PEN_EVENT:	
		switch(Event->eventID)
		{
		case PEN_UP:
			{
				if (cal_pos_flag == 0)
				{
					if (cal_pos > 0)
						cal_pos--;
					
#ifdef PR31700
                    SndPlaySndEffect(SNDRES5_BEEP);
#endif
					return TRUE;
				}
				
				switch(cal_pos)
				{
				case LT_POS:
					{
						
#ifdef	DEBUG
						printf("\n^^^^^^^^^^^ LT_POSa ^^^^^^^^^^^^^");
						printf("\nlt_x1=%d,\t lt_x2=%d,\t lt_x3=%d,\n lt_y1=%d,\t lt_y2=%d,\t lt_y3=%d" , lt_x1, lt_x2, lt_x3, lt_y1, lt_y2, lt_y3);
						printf("\nrb_x1=%d,\t rb_x2=%d,\t rb_x3=%d,\n rb_y1=%d,\t rb_y2=%d,\t rb_y3=%d" , rb_x1, rb_x2, rb_x3, rb_y1, rb_y2, rb_y3);
						printf("\narb_x1=%d,\t arb_x2=%d,\t arb_x3=%d,\n arb_y1=%d,\t arb_y2=%d,\t arb_y3=%d\n" , arb_x1, arb_x2, arb_x3, arb_y1, arb_y2, arb_y3);
#endif
						SySetupCalScrCalData(cal_pos, &lt_x1, &lt_x2, &lt_x3, &lt_y1, &lt_y2, &lt_y3);
						
#ifdef	DEBUG
						printf("\n^^^^^^^^^^^ LT_POSb ^^^^^^^^^^^^^");
						printf("\nlt_x1=%d,\t lt_x2=%d,\t lt_x3=%d,\n lt_y1=%d,\t lt_y2=%d,\t lt_y3=%d" , lt_x1, lt_x2, lt_x3, lt_y1, lt_y2, lt_y3);
						printf("\nrb_x1=%d,\t rb_x2=%d,\t rb_x3=%d,\n rb_y1=%d,\t rb_y2=%d,\t rb_y3=%d" , rb_x1, rb_x2, rb_x3, rb_y1, rb_y2, rb_y3);
						printf("\narb_x1=%d,\t arb_x2=%d,\t arb_x3=%d,\n arb_y1=%d,\t arb_y2=%d,\t arb_y3=%d\n" , arb_x1, arb_x2, arb_x3, arb_y1, arb_y2, arb_y3);
#endif
						BitmapEraseBitmap(BITMAP_SYSETUP_SCRCAL);
						FormSetObjectPosition(BITMAP_SYSETUP_SCRCAL, SYSETUP_RIGHT_BOTTOM_X, SYSETUP_RIGHT_BOTTOM_Y);
						BitmapDrawBitmap(BITMAP_SYSETUP_SCRCAL);
						FormGetObjectPointer(BITMAP_SYSETUP_SCRCAL, &object_type, (void**)&bitmap_ptr);
						bitmap_ptr->bitmap_attr.bitmap_enter = 0;
						BitmapDrawBitmap(BITMAP_SYSETUP_SCRCAL);
						
						//strcpy(string_text, "below until it darkens and then");
						//StringSetText(STRING_SYSETUP_SCRCAL_TEXT5, string_text);
						//StringDrawString(STRING_SYSETUP_SCRCAL_TEXT5);
						//FormDrawForm(FORM_SYSETUP_SCRCAL);
						break;
					}
				case RB_POS:
					{
#ifdef	DEBUG
						printf("\n^^^^^^^^^^^ RB_POSa ^^^^^^^^^^^^^");
						printf("\nlt_x1=%d,\t lt_x2=%d,\t lt_x3=%d,\n lt_y1=%d,\t lt_y2=%d,\t lt_y3=%d" , lt_x1, lt_x2, lt_x3, lt_y1, lt_y2, lt_y3);
						printf("\nrb_x1=%d,\t rb_x2=%d,\t rb_x3=%d,\n rb_y1=%d,\t rb_y2=%d,\t rb_y3=%d" , rb_x1, rb_x2, rb_x3, rb_y1, rb_y2, rb_y3);
						printf("\narb_x1=%d,\t arb_x2=%d,\t arb_x3=%d,\n arb_y1=%d,\t arb_y2=%d,\t arb_y3=%d\n" , arb_x1, arb_x2, arb_x3, arb_y1, arb_y2, arb_y3);
#endif
						SySetupCalScrCalData(cal_pos, &rb_x1, &rb_x2, &rb_x3, &rb_y1, &rb_y2, &rb_y3);
#ifdef	DEBUG
						printf("\n^^^^^^^^^^^ RB_POSb ^^^^^^^^^^^^^");
						printf("\nlt_x1=%d,\t lt_x2=%d,\t lt_x3=%d,\n lt_y1=%d,\t lt_y2=%d,\t lt_y3=%d" , lt_x1, lt_x2, lt_x3, lt_y1, lt_y2, lt_y3);
						printf("\nrb_x1=%d,\t rb_x2=%d,\t rb_x3=%d,\n rb_y1=%d,\t rb_y2=%d,\t rb_y3=%d" , rb_x1, rb_x2, rb_x3, rb_y1, rb_y2, rb_y3);
						printf("\narb_x1=%d,\t arb_x2=%d,\t arb_x3=%d,\n arb_y1=%d,\t arb_y2=%d,\t arb_y3=%d\n" , arb_x1, arb_x2, arb_x3, arb_y1, arb_y2, arb_y3);
#endif
						
						BitmapEraseBitmap(BITMAP_SYSETUP_SCRCAL);
						FormSetObjectPosition(BITMAP_SYSETUP_SCRCAL, SYSETUP_RIGHT_BOTTOM_X-20, SYSETUP_LEFT_TOP_Y+20);
						FormGetObjectPointer(BITMAP_SYSETUP_SCRCAL, &object_type, (void**)&bitmap_ptr);
						bitmap_ptr->bitmap_attr.bitmap_enter = 0;
						BitmapDrawBitmap(BITMAP_SYSETUP_SCRCAL);
						
						strcpy(string_text, SYSSTR4);
						StringSetText(STRING_SYSETUP_SCRCAL_TEXT2, string_text);
						strcpy(string_text, SYSSTR5);
						StringSetText(STRING_SYSETUP_SCRCAL_TEXT3, string_text);
						strcpy(string_text, SYSSTR6);
						StringSetText(STRING_SYSETUP_SCRCAL_TEXT4, string_text);
						StringEraseString(STRING_SYSETUP_SCRCAL_TEXT2);
						StringEraseString(STRING_SYSETUP_SCRCAL_TEXT3);
						StringEraseString(STRING_SYSETUP_SCRCAL_TEXT4);							
						StringDrawString(STRING_SYSETUP_SCRCAL_TEXT2);
						StringDrawString(STRING_SYSETUP_SCRCAL_TEXT3);
						StringDrawString(STRING_SYSETUP_SCRCAL_TEXT4);
						//FormPopupForm(FORM_SYSETUP_MENU);
						break;
					}
				case ARB_POS:
					{
#ifdef	DEBUG
						printf("\n^^^^^^^^^^^ ARB_POSa ^^^^^^^^^^^^^");
						printf("\nlt_x1=%d,\t lt_x2=%d,\t lt_x3=%d,\n lt_y1=%d,\t lt_y2=%d,\t lt_y3=%d" , lt_x1, lt_x2, lt_x3, lt_y1, lt_y2, lt_y3);
						printf("\nrb_x1=%d,\t rb_x2=%d,\t rb_x3=%d,\n rb_y1=%d,\t rb_y2=%d,\t rb_y3=%d" , rb_x1, rb_x2, rb_x3, rb_y1, rb_y2, rb_y3);
						printf("\narb_x1=%d,\t arb_x2=%d,\t arb_x3=%d,\n arb_y1=%d,\t arb_y2=%d,\t arb_y3=%d\n" , arb_x1, arb_x2, arb_x3, arb_y1, arb_y2, arb_y3);
#endif
						SySetupCalScrCalData(cal_pos, &arb_x1, &arb_x2, &arb_x3, &arb_y1, &arb_y2, &arb_y3);
						
#ifdef	DEBUG
						printf("\n^^^^^^^^^^^ ARB_POSb ^^^^^^^^^^^^^");
						printf("\nlt_x1=%d,\t lt_x2=%d,\t lt_x3=%d,\n lt_y1=%d,\t lt_y2=%d,\t lt_y3=%d" , lt_x1, lt_x2, lt_x3, lt_y1, lt_y2, lt_y3);
						printf("\nrb_x1=%d,\t rb_x2=%d,\t rb_x3=%d,\n rb_y1=%d,\t rb_y2=%d,\t rb_y3=%d" , rb_x1, rb_x2, rb_x3, rb_y1, rb_y2, rb_y3);
						printf("\narb_x1=%d,\t arb_x2=%d,\t arb_x3=%d,\n arb_y1=%d,\t arb_y2=%d,\t arb_y3=%d\n" , arb_x1, arb_x2, arb_x3, arb_y1, arb_y2, arb_y3);
#endif
						
						cal_pos = NONE_POS;
						FormSetObjectPosition(BITMAP_SYSETUP_SCRCAL, SYSETUP_LEFT_TOP_X, SYSETUP_LEFT_TOP_Y);
						FormGetObjectPointer(BITMAP_SYSETUP_SCRCAL, &object_type, (void**)&bitmap_ptr);
						bitmap_ptr->bitmap_attr.bitmap_enter = 0;
						
#ifdef	DEBUG
						printf("\n^^^^^^^^^^^^^^^^^^^^^^^^^^^ TotalValue ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
						printf("\nlt_x1=%d,\t lt_x2=%d,\t lt_x3=%d,\n lt_y1=%d,\t lt_y2=%d,\t lt_y3=%d" , lt_x1, lt_x2, lt_x3, lt_y1, lt_y2, lt_y3);
						printf("\nrb_x1=%d,\t rb_x2=%d,\t rb_x3=%d,\n rb_y1=%d,\t rb_y2=%d,\t rb_y3=%d" , rb_x1, rb_x2, rb_x3, rb_y1, rb_y2, rb_y3);
						printf("\narb_x1=%d,\t arb_x2=%d,\t arb_x3=%d,\n arb_y1=%d,\t arb_y2=%d,\t arb_y3=%d\n" , arb_x1, arb_x2, arb_x3, arb_y1, arb_y2, arb_y3);
#endif
						cal_pos = (SHORT)NONE_POS;
						strcpy(string_text, "");
						StringSetText(STRING_SYSETUP_SCRCAL_TEXT2, string_text);
						strcpy(string_text, SYSSTR7);
						StringSetText(STRING_SYSETUP_SCRCAL_TEXT3, string_text);
						strcpy(string_text, SYSSTR8);
						StringSetText(STRING_SYSETUP_SCRCAL_TEXT4, string_text);
						
						SySetupGetCalPenMode(&cal_pen_mode);
						if (cal_pen_mode)
						{
							//if (!SySetupVerifyScrCalData(lt_x1, rb_x2, arb_x3, lt_y1, rb_y2, arb_y3))
							if (!SySetupVerifyScrCalData(lt_x1, rb_x1, arb_x1, lt_y1, rb_y1, arb_y1))
							{
								/*
								strcpy(string_text, "");
								StringSetText(STRING_SYSETUP_SCRCAL_TEXT2, string_text);
								strcpy(string_text, SYSSTR7);
								StringSetText(STRING_SYSETUP_SCRCAL_TEXT3, string_text);
								strcpy(string_text, SYSSTR8);
								StringSetText(STRING_SYSETUP_SCRCAL_TEXT4, string_text);
								StringDrawString(STRING_SYSETUP_SCRCAL_TEXT2);
								StringDrawString(STRING_SYSETUP_SCRCAL_TEXT3);
								StringDrawString(STRING_SYSETUP_SCRCAL_TEXT4);
								*/
#ifdef PR31700
			                    SndPlaySndEffect(SNDRES5_BEEP);
#endif
								FormPopupForm(FORM_SYSETUP_SCRCAL);
								//BatteryWarningSetEnableStatus(TRUE);
								return TRUE;
							}
#ifdef PR31700
							
							PenSetNormalMode();                               
							InlaySetEnableStatus(TRUE);
							SystemSetMappedHardwareKeyStatus(TRUE);
							SySetupMenuGotoForm(FORM_SYSETUP_CLOCK);
							AlarmMgrEnable(TRUE);				            
							SySetupSetCalPenMode(0);
							//HENRY							    BatteryWarningSetEnableStatus(TRUE);
							SIOInit();
#endif
							//FormPopupForm(FORM_SYSETUP_MENU);
						}
						else
						{
							if (!SySetupVerifyScrCalData(lt_x1, rb_x1, arb_x1, lt_y1, rb_y1, arb_y1))
							{	
#ifdef PR31700
			                    SndPlaySndEffect(SNDRES5_BEEP);
#endif
								FormPopupForm(FORM_SYSETUP_SCRCAL);
								return TRUE;
							}
#ifdef PR31700
							PenSetNormalMode();
							InlaySetEnableStatus(TRUE);
							SystemSetMappedHardwareKeyStatus(TRUE);
#endif
							FormPopupForm(FORM_SYSETUP_MENU);
#ifdef PR31700
							AlarmMgrEnable(TRUE);
							//HENRY							    BatteryWarningSetEnableStatus(TRUE);
#endif
						}
						break;
					}
				default:
					{
						BitmapEraseBitmap(BITMAP_SYSETUP_SCRCAL);
						FormSetObjectPosition(BITMAP_SYSETUP_SCRCAL, SYSETUP_LEFT_TOP_X, SYSETUP_LEFT_TOP_Y);
						BitmapDrawBitmap(BITMAP_SYSETUP_SCRCAL);
						
						strcpy(string_text, "");
						StringSetText(STRING_SYSETUP_SCRCAL_TEXT2, string_text);
						strcpy(string_text, SYSSTR7);
						StringSetText(STRING_SYSETUP_SCRCAL_TEXT3, string_text);
						strcpy(string_text, SYSSTR8);
						StringSetText(STRING_SYSETUP_SCRCAL_TEXT4, string_text);
						StringDrawString(STRING_SYSETUP_SCRCAL_TEXT2);
						StringDrawString(STRING_SYSETUP_SCRCAL_TEXT3);
						StringDrawString(STRING_SYSETUP_SCRCAL_TEXT4);
						cal_pos = (SHORT)NONE_POS;
						break;
					}
					}			
					//PenSetNormalMode();
#ifdef PR31700
                    SndPlaySndEffect(SNDRES5_BEEP);
#endif
					return TRUE;
				}
				
				case PEN_DOWN:
					{
					/*
					FormGetObjectPointer(BITMAP_SYSETUP_SCRCAL, &object_type, (void**)&bitmap_ptr);
					bitmap_ptr->bitmap_attr.bitmap_enter = 1;
					BitmapDrawBitmap(BITMAP_SYSETUP_SCRCAL);
						*/
						cal_pos++;
						cal_pos_flag = 0;
						
						return TRUE;		
					}
					
				case PEN_MOVE:
					{
#ifdef	DEBUG
						printf("\n ----->PM: para1=%ld, para2=%ld, cal_pos=%d", Event->para1, Event->para2, cal_pos);
#endif
						if (cal_pos == NONE_POS)
							return TRUE;
						
#ifdef	DEBUG
						printf("\n --=========>PM2: para1=%ld, para2=%ld, cal_pos=%d", Event->para1, Event->para2, cal_pos);
#endif
						if (SySetupSetScrCalData((SHORT)Event->para1, (SHORT)Event->para2, cal_pos))
							cal_pos_flag = 1;
						
						return TRUE;
					}
					return TRUE;
			}
			
		case EVT_INLAY_SELECT:
			SySetupGetCalPenMode(&cal_pen_mode);
			if (cal_pen_mode)
				return TRUE;
			switch(Event->para1)
			{	
			case INLAY_OK:
				FormPopupForm(FORM_SYSETUP_MENU);
				return TRUE;
				
			case INLAY_EXIT:
				FormPopupForm(FORM_SYSETUP_MENU);
				return TRUE;
				
			default:	return FALSE;
			}
			
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	SySetupOwnInfo
* Purpose: 	This function is the event handler for the owner
*				information settings page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupOwnInfo(EvtType *Event)
{
	ObjectID	active_id;
    BYTE        *item_text, font, object_type;
    WORD        count;
    Field       *field_ptr;
    Table       *table_ptr;
    static BYTE	set_font = 0;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		MenuDeleteItem(MENU_SYSETUP, MENU_ITEM_FONT);
		if (GOwnInfoFont == SYSETUP_LFONT_INT)
		{
			font = MEDIUM_FONT;
			MenuInsertItem(MENU_SYSETUP, MENU_ITEM_FONT, SYSSFONT);
		}
		else
		{
			font = SMALL_FONT;
			MenuInsertItem(MENU_SYSETUP, MENU_ITEM_FONT, SYSLFONT);
		}
		
		active_id = FIELD_SYSETUP_OWNINFO_FNAME;
		SySetupFieldSetFont(active_id++, font);
		SySetupFieldSetFont(active_id++, font);
		SySetupFieldSetFont(active_id++, font);
		SySetupFieldSetFont(active_id, font);
		
		SySetupSetScreen(FORM_SYSETUP_OWNINFO);
		SySetupSetTable(FORM_SYSETUP_OWNINFO, TABLE_SYSETUP_OWNINFO);
		//TableSetTopRowNum(TABLE_SYSETUP_OWNINFO, 0);
		SySetupTableSetScrollbar(TABLE_SYSETUP_OWNINFO, SCROLLBAR_SYSETUP_OWNINFO);
		FormDrawForm(FORM_SYSETUP_OWNINFO);
		if (!set_font)
		{
			FieldSetInsertPointOn(FIELD_SYSETUP_OWNINFO_FNAME);
		}
		else
			set_font = 0;
		return TRUE;
		
	case EVT_MENU_SELECT_ITEM:
		switch((USHORT)(Event->para1))
		{
		case MENU_ITEM_COPY:
			KeyboardSendEvent(KEY_COPY, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_CUT:
			KeyboardSendEvent(KEY_CUT, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_PASTE:
			KeyboardSendEvent(KEY_PASTE, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_UNDO:
			if (UIGetUndoStatus() != UNDO_EMPTY)
				KeyboardSendEvent(KEY_UNDO, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_FONT:
			MenuGetMenuItem(MENU_SYSETUP, MENU_ITEM_FONT, &item_text);
			if (item_text[0] == SYSETUP_LFONT_INT)
				GOwnInfoFont = SYSETUP_LFONT_INT;
			else
				GOwnInfoFont = SYSETUP_SFONT_INT;
			set_font = 1;
			//					FormPopupForm(FORM_SYSETUP_OWNINFO);
			MenuDeleteItem(MENU_SYSETUP, MENU_ITEM_FONT);
			if (GOwnInfoFont == SYSETUP_LFONT_INT)
			{
				font = MEDIUM_FONT;
				MenuInsertItem(MENU_SYSETUP, MENU_ITEM_FONT, SYSSFONT);
			}
			else
			{
				font = SMALL_FONT;
				MenuInsertItem(MENU_SYSETUP, MENU_ITEM_FONT, SYSLFONT);
			}
			
			active_id = FIELD_SYSETUP_OWNINFO_FNAME;
			SySetupFieldSetFont(active_id++, font);
			SySetupFieldSetFont(active_id++, font);
			SySetupFieldSetFont(active_id++, font);
			SySetupFieldSetFont(active_id, font);
			
			SySetupSetScreen(FORM_SYSETUP_OWNINFO);
			SySetupSetTable(FORM_SYSETUP_OWNINFO, TABLE_SYSETUP_OWNINFO);
			//TableSetTopRowNum(TABLE_SYSETUP_OWNINFO, 0);
			SySetupTableSetScrollbar(TABLE_SYSETUP_OWNINFO, SCROLLBAR_SYSETUP_OWNINFO);
			ScrollbarDrawScrollbar(SCROLLBAR_SYSETUP_OWNINFO);
			TableDrawTable(TABLE_SYSETUP_OWNINFO);
			
			break;
		default:
			break;
		}
		return TRUE;
		
		
		case EVT_KEYBOARD_STATUS:
			SySetupSetScreen(FORM_SYSETUP_OWNINFO);
			SySetupSetTable(FORM_SYSETUP_OWNINFO, TABLE_SYSETUP_OWNINFO);
			SySetupTableSetScrollbar(TABLE_SYSETUP_OWNINFO, SCROLLBAR_SYSETUP_OWNINFO);
			TableEraseTable(TABLE_SYSETUP_OWNINFO);
			TableDrawTable(TABLE_SYSETUP_OWNINFO);
			return TRUE;
			
#ifdef PR31700
		case EVT_IO_KEY_CTRL:
			if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
            {
                if (Event->para2 == IO_UP_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_SYSETUP_OWNINFO, SCROLLBAR_UP_ARROW);
                else if (Event->para2 == IO_DOWN_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_SYSETUP_OWNINFO, SCROLLBAR_DOWN_ARROW);
				return TRUE;
			}
			return FALSE;
#endif
		case EVT_SCROLLBAR_REPEAT:
			//			if (Event->para1 != Event->para2)
			if (Event->para1 == Event->para2)
				return TRUE;		
			SySetupScrollbarSetTable(TABLE_SYSETUP_OWNINFO, FIELD_SYSETUP_OWNINFO_FNAME, SCROLLBAR_SYSETUP_OWNINFO, Event);
			return	TRUE;
			
		case EVT_SCROLLBAR_SELECT:
			SySetupScrollbarSetTable(TABLE_SYSETUP_OWNINFO, FIELD_SYSETUP_OWNINFO_FNAME, SCROLLBAR_SYSETUP_OWNINFO, Event);
			return	TRUE;
			
		case EVT_KEY:
			if (Event->para2 & 0x00000300)
				return TRUE;
			if (Event->eventID == SOFT_KEY)
			{
				FormGetActiveObject(FORM_SYSETUP_OWNINFO, &active_id);
				if ((active_id >= FIELD_SYSETUP_OWNINFO_FNAME) && (active_id <= FIELD_SYSETUP_OWNINFO_COMPANY_NAME))
				{
					if (active_id != FIELD_SYSETUP_OWNINFO_COMPANY_NAME && (BYTE)(Event->para1) == '\r')
						return TRUE;
					FieldAddKeyInChar(active_id, (BYTE)(Event->para1));
					return	TRUE;
				}
			}
			return TRUE;
			
		case EVT_FIELD_CHANGED:
			SySetupSetScreen(FORM_SYSETUP_OWNINFO);
			if (SySetupKeyInChangeTable(FORM_SYSETUP_OWNINFO, TABLE_SYSETUP_OWNINFO, SCROLLBAR_SYSETUP_OWNINFO))
			{
				//				TableEraseTable(TABLE_SYSETUP_OWNINFO);
				TableDrawTable(TABLE_SYSETUP_OWNINFO);
			}
			return	TRUE;
			
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
				if (!SySetupSetOwnerInfo())
					return FALSE;
				FormPopupForm(FORM_SYSETUP_MENU);
				return TRUE;
				
			case INLAY_EXIT:
				FormPopupForm(FORM_SYSETUP_MENU);
				return TRUE;
				
			default:	return FALSE;
			}
			
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	SySetupPassword
* Purpose: 	This function is the event handler for the password
*				settings page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BYTE	Textbox_Highlight_Flag;
BOOLEAN SySetupPassword(EvtType *Event)
{
	PasswordSettings	password;
	ObjectID	active_id;
	BYTE		text[45] = {0}, old_password[20]={0};
	WORD		num_chars, insert_pt_pos, start_pos, end_pos;
    BYTE		object_type;
    Field		*field_ptr;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:	
		// ---------------------------------New edit 041699			
		/*
		FormGetControlValue(CHECKBOX_SYSETUP_PASSWORD_CHECK, &ctrl_value);
		SySetupGetPasswordSettings(&password);
		qfree(password.hints);
		if (ctrl_value != (SHORT)password.check_password)
		FormSetControlGroupSelection(FORM_SYSETUP_PASSWORD, CHECKBOX_SYSETUP_PASSWORD_CHECK);
		*/
		// -------------------------------------------------
		FormDrawForm(FORM_SYSETUP_PASSWORD);
		return TRUE;
		
	case EVT_KEY:		
		if (Event->para2 & 0x00000300)
			return TRUE;
		FormGetActiveObject(FORM_SYSETUP_PASSWORD, &active_id);
		if (Event->para1 == '\r' || Event->para1 == '\n')
		{			
			switch(active_id)
			{
			case TEXTBOX_SYSETUP_PASSWORD_NEW:
				TextboxSetInsertPointOff(TEXTBOX_SYSETUP_PASSWORD_NEW);
				FormSetFormActiveObject(FORM_SYSETUP_PASSWORD, TEXTBOX_SYSETUP_PASSWORD_CONFIRM);
				TextboxGetNumOfCharsDisplayed(TEXTBOX_SYSETUP_PASSWORD_CONFIRM, &num_chars);
				if (num_chars > 0)
				{
					Textbox_Highlight_Flag = 1;
					TextboxSetHighlightSelection(TEXTBOX_SYSETUP_PASSWORD_CONFIRM, 0, num_chars);
					TextboxDrawTextbox(TEXTBOX_SYSETUP_PASSWORD_CONFIRM);
				}
				else
				{
					Textbox_Highlight_Flag = 0;
					TextboxSetInsertPointPositionByCharPos(TEXTBOX_SYSETUP_PASSWORD_CONFIRM, 0);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_PASSWORD_CONFIRM);
				}
				return TRUE;
				
			case TEXTBOX_SYSETUP_PASSWORD_CONFIRM:
				EvtAppendEvt(EVT_INLAY_SELECT, 0, INLAY_OK, 0, NULL);
				return TRUE;
				
			default: return FALSE;
			}
		}
		else if (Event->para1 <= 32)
			return TRUE;
		else if(active_id == TEXTBOX_SYSETUP_PASSWORD_NEW || active_id == TEXTBOX_SYSETUP_PASSWORD_CONFIRM)
			TextboxAddKeyInChar(active_id, '*');
		else
			return TRUE;
		
		TextboxGetNumOfCharsDisplayed(active_id, &num_chars);
		if (num_chars <= 20)
		{
			switch(active_id)
			{
			case TEXTBOX_SYSETUP_PASSWORD_NEW:
				change_text[num_chars-1] = (BYTE)Event->para1;
				change_text[num_chars] = 0;
				break;
				
			case TEXTBOX_SYSETUP_PASSWORD_CONFIRM:
				confirm_text[num_chars-1] = (BYTE)Event->para1;
				confirm_text[num_chars] = 0;
				break;
				
			default: return FALSE;
			}
		}
		return TRUE;
		
	case EVT_TEXTBOX_SELECT:
		FormGetActiveObject(FORM_SYSETUP_PASSWORD, &active_id);
		if(active_id == TEXTBOX_SYSETUP_PASSWORD_NEW || active_id == TEXTBOX_SYSETUP_PASSWORD_CONFIRM)
		{
			TextboxGetInsertPointPosition(active_id, &insert_pt_pos);
			TextboxGetNumOfCharsDisplayed(active_id, &num_chars);
			if (insert_pt_pos != num_chars)
			{
				if(insert_pt_pos < 0)
				{
					TextboxGetCurrentHighlightedSelection(active_id, &start_pos, &end_pos);
					TextboxGetNumOfCharsDisplayed(active_id, &num_chars);
					if ((start_pos==0 && end_pos==num_chars) || (start_pos==num_chars && end_pos==0))
					{
						Textbox_Highlight_Flag = 1;
						return TRUE;
					}
					Textbox_Highlight_Flag = 0;
					SySetupSetTextboxHighlightSelectionOff(active_id);
				}
				else
					TextboxSetInsertPointOff(active_id);
				TextboxSetInsertPointPositionByCharPos(active_id, num_chars);
				TextboxSetInsertPointOn(active_id);
				TextboxDrawTextbox(active_id);
			}
		}
		return TRUE;
		
		
	case EVT_CONTROL_SELECT:
		switch(Event->eventID)
		{	
		case BUTTON_SYSETUP_PASSWORD_HINTS:
			SySetupRestorePasswordHints();
			FormGetObjectPointer(FIELD_SYSETUP_PASSWORD_HINTS, &object_type, (void**)&field_ptr);
			field_ptr->field_back_line = GREY_LINE;
			field_ptr->field_attr.field_active = TRUE;
			field_ptr->field_attr.field_enable = TRUE;
			field_ptr->field_attr.field_insert_pt_visible = TRUE;
			password_hints_field_enable = 1;
			FormPopupForm(FORM_SYSETUP_PASSWORD_HINTS);
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
				SySetupGetPasswordSettings(&password);
				qfree(password.hints);
				if (password.password[0] != 0 && confirm_text[0]==0 && change_text[0]==0)
				{
					FormPopupForm(FORM_SYSETUP_PASSWORD_ERASE);
					return TRUE;
				}
				switch(SySetupSetPassword(change_text, confirm_text))
				{
				case 0:
					for(num_chars=0; num_chars<20; num_chars++)
					{
						change_text[num_chars] = 0;
						confirm_text[num_chars] = 0;
					}
					FormPopupForm(FORM_SYSETUP_MENU);
					return TRUE;
					
				case SYSETUP_PASSWORD_CHANGED:
					for(num_chars=0; num_chars<20; num_chars++)
					{
						change_text[num_chars] = 0;
						confirm_text[num_chars] = 0;
					}			
					FormPopupForm(FORM_SYSETUP_PASSWORD_SUCCESS);
					return TRUE;
				case SYSETUP_CONFIRM_PASSWORD_NOT_MATCH:
					for(num_chars=0; num_chars<20; num_chars++)
						confirm_text[num_chars] = 0;
					strcpy(text, SYSSTR9);
					StringSetText(STRING_SYSETUP_PASSWORD_FAILURE, text);
					TextboxSetInsertPointOff(TEXTBOX_SYSETUP_PASSWORD_OLD);
					TextboxSetInsertPointOff(TEXTBOX_SYSETUP_PASSWORD_NEW);
					TextboxInitTextbox(TEXTBOX_SYSETUP_PASSWORD_CONFIRM);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_PASSWORD_CONFIRM);
					TextboxSetInsertPointPositionByCharPos(TEXTBOX_SYSETUP_PASSWORD_CONFIRM, 0);
					FormSetFormActiveObject(FORM_SYSETUP_PASSWORD, TEXTBOX_SYSETUP_PASSWORD_CONFIRM);
					FormPopupForm(FORM_SYSETUP_PASSWORD_FAILURE);
					return TRUE;
					
				default: return FALSE;
				}
				return TRUE;
				
				case INLAY_EXIT:
					for(num_chars=0; num_chars<20; num_chars++)
					{
						change_text[num_chars] = 0;
						confirm_text[num_chars] = 0;
					}
					FormPopupForm(FORM_SYSETUP_MENU);
					return TRUE;
					
				default:	return FALSE;
			}
			
	}
	
	return FALSE;
}




/*****************************************************************
* Function:	SySetupPasswordEnter
* Purpose: 	This function is the event handler for the password
*				settings page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupPasswordEnter(EvtType *Event)
{
	PasswordSettings	password;
	BOOLEAN		ctrl_value;
	BYTE		text[45] = {0},  null_string[1]={0};
	WORD		num_chars, tmp_num, insert_pt_pos, start_pos, end_pos;
	
    BYTE		object_type;
    Field		*field_ptr;
	
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		Textbox_Highlight_Flag = 0;
		FormDrawForm(FORM_SYSETUP_PASSWORD_ENTER);
		return TRUE;
		
	case EVT_KEY:
		if (Event->para2 & 0x00000300)
			return TRUE;
		if (Event->para1 == '\r' || Event->para1 == '\n')
		{
			EvtAppendEvt(EVT_INLAY_SELECT, 0, INLAY_OK, 0, NULL);
			return TRUE;
		}
		else if (Event->para1 <= 32)
			return TRUE;
		else
			TextboxAddKeyInChar(TEXTBOX_SYSETUP_PASSWORD_OLD, '*');
		
		TextboxGetNumOfCharsDisplayed(TEXTBOX_SYSETUP_PASSWORD_OLD, &num_chars);
		if (num_chars <= 20)
		{
			enter_text[num_chars-1] = (BYTE)Event->para1;
			enter_text[num_chars] = 0;
		}				
		
		return TRUE;
		
		
	case EVT_TEXTBOX_SELECT:
		TextboxGetInsertPointPosition(TEXTBOX_SYSETUP_PASSWORD_OLD, &insert_pt_pos);
		TextboxGetNumOfCharsDisplayed(TEXTBOX_SYSETUP_PASSWORD_OLD, &num_chars);
		if (insert_pt_pos != num_chars)
		{
			if(insert_pt_pos < 0)
			{
				TextboxGetCurrentHighlightedSelection(TEXTBOX_SYSETUP_PASSWORD_OLD, &start_pos, &end_pos);
				TextboxGetNumOfCharsDisplayed(TEXTBOX_SYSETUP_PASSWORD_OLD, &num_chars);
				if ((start_pos==0 && end_pos==num_chars) || (start_pos==num_chars && end_pos==0))
				{
					Textbox_Highlight_Flag = 1;
					return TRUE;
				}
				Textbox_Highlight_Flag = 0;
				SySetupSetTextboxHighlightSelectionOff(TEXTBOX_SYSETUP_PASSWORD_OLD);
			}
			else
				TextboxSetInsertPointOff(TEXTBOX_SYSETUP_PASSWORD_OLD);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_SYSETUP_PASSWORD_OLD, num_chars);
			TextboxSetInsertPointOn(TEXTBOX_SYSETUP_PASSWORD_OLD);
			TextboxDrawTextbox(TEXTBOX_SYSETUP_PASSWORD_OLD);
		}
		return TRUE;
		
		
	case EVT_CONTROL_SELECT:
		switch(Event->eventID)
		{	
		case BUTTON_SYSETUP_PASSWORD_ENTER:
			SySetupRestorePasswordHints();
			FormGetObjectPointer(FIELD_SYSETUP_PASSWORD_HINTS, &object_type, (void**)&field_ptr);
			field_ptr->field_back_line = NO_LINE;
			field_ptr->field_attr.field_active = FALSE;
			field_ptr->field_attr.field_enable = FALSE;
			field_ptr->field_attr.field_insert_pt_visible = FALSE;
			password_hints_field_enable = 0;
#ifdef PR31700
			InlaySetEnableStatus(FALSE);
#endif
			FormPopupForm(FORM_SYSETUP_PASSWORD_HINTS);
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
				if (SySetupCheckPassword(enter_text))
				{
					TextboxSetText(TEXTBOX_SYSETUP_PASSWORD_CONFIRM, null_string);
					TextboxSetText(TEXTBOX_SYSETUP_PASSWORD_NEW, null_string);
					
					FormGetControlValue(CHECKBOX_SYSETUP_PASSWORD_CHECK, &ctrl_value);
					SySetupGetPasswordSettings(&password);
					qfree(password.hints);
					if (ctrl_value != (SHORT)password.check_password)
						FormSetControlGroupSelection(FORM_SYSETUP_PASSWORD, CHECKBOX_SYSETUP_PASSWORD_CHECK);
					
					Textbox_Highlight_Flag = 1;
					FormPopupForm(FORM_SYSETUP_PASSWORD);
					
					num_chars = strlen(enter_text);
					
					
					TextboxSetInsertPointOff(TEXTBOX_SYSETUP_PASSWORD_OLD);
					FormSetFormActiveObject(FORM_SYSETUP_PASSWORD, TEXTBOX_SYSETUP_PASSWORD_CONFIRM);
					TextboxSetInsertPointPositionByCharPos(TEXTBOX_SYSETUP_PASSWORD_CONFIRM, 0);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_PASSWORD_CONFIRM);
					
					for(tmp_num=0; tmp_num<num_chars; tmp_num++)
						TextboxAddKeyInChar(TEXTBOX_SYSETUP_PASSWORD_CONFIRM, '*');
					
					TextboxSetInsertPointOff(TEXTBOX_SYSETUP_PASSWORD_CONFIRM);
					FormSetFormActiveObject(FORM_SYSETUP_PASSWORD, TEXTBOX_SYSETUP_PASSWORD_NEW);
					
					for(tmp_num=0; tmp_num<num_chars; tmp_num++)
						TextboxAddKeyInChar(TEXTBOX_SYSETUP_PASSWORD_NEW, '*');
					TextboxSetHighlightSelection(TEXTBOX_SYSETUP_PASSWORD_NEW, 0, num_chars);
					TextboxSetInsertPointOff(TEXTBOX_SYSETUP_PASSWORD_NEW);
					
					strcpy(change_text, enter_text);
					strcpy(confirm_text, enter_text);
					
					enter_text[num_chars] = 0;
					confirm_text[num_chars] = 0;
					
				}
				else
				{
					for(num_chars=0; num_chars<20; num_chars++)
						enter_text[num_chars] = 0;
					strcpy(text, SYSSTR10);
					StringSetText(STRING_SYSETUP_PASSWORD_FAILURE, text);
					TextboxInitTextbox(TEXTBOX_SYSETUP_PASSWORD_OLD);
					FormSetFormActiveObject(FORM_SYSETUP_PASSWORD_ENTER, TEXTBOX_SYSETUP_PASSWORD_OLD);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_PASSWORD_OLD);
					TextboxSetInsertPointPositionByCharPos(TEXTBOX_SYSETUP_PASSWORD_OLD, 0);
					FormPopupForm(FORM_SYSETUP_PASSWORD_FAILURE);
				}
				return TRUE;
				
			case INLAY_EXIT:
				FormPopupForm(FORM_SYSETUP_MENU);
				return TRUE;
				
			default:	return FALSE;
			}
			
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	SySetupPasswordHints
* Purpose: 	This function is the event handler for the password
*				hints settings page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupPasswordHints(EvtType *Event)
{
	static BYTE	set_font = 0;
	BYTE		font, *item_text;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		MenuDeleteItem(MENU_SYSETUP, MENU_ITEM_FONT);
		if (GOwnInfoFont == SYSETUP_LFONT_INT)
		{
			font = MEDIUM_FONT;
			MenuInsertItem(MENU_SYSETUP, MENU_ITEM_FONT, SYSSFONT);
		}
		else
		{
			font = SMALL_FONT;
			MenuInsertItem(MENU_SYSETUP, MENU_ITEM_FONT, SYSLFONT);
		}
		
		SySetupFieldSetFont(FIELD_SYSETUP_PASSWORD_HINTS, font);
		
		if (!set_font)
		{
			FieldSetTopLineNum(FIELD_SYSETUP_PASSWORD_HINTS, 0);
			if (password_hints_field_enable)
			{
				FieldSetInsertPointOn(FIELD_SYSETUP_PASSWORD_HINTS);
				FieldSetInsertPointPositionByCharPos(FIELD_SYSETUP_PASSWORD_HINTS, 0);
			}
		}
		else
			set_font = 0;
		
		SySetupSetScreen(FORM_SYSETUP_PASSWORD_HINTS);
		SySetupFieldSetScrollbar(FIELD_SYSETUP_PASSWORD_HINTS, SCROLLBAR_SYSETUP_PASSWORD_HINTS);
		FormDrawForm(FORM_SYSETUP_PASSWORD_HINTS);
		return TRUE;
		
	case EVT_MENU_SELECT_ITEM:
		switch((USHORT)(Event->para1))
		{
		case MENU_ITEM_COPY:
			KeyboardSendEvent(KEY_COPY, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_CUT:
			KeyboardSendEvent(KEY_CUT, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_PASTE:
			KeyboardSendEvent(KEY_PASTE, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_UNDO:
			if (UIGetUndoStatus() != UNDO_EMPTY)
				KeyboardSendEvent(KEY_UNDO, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_FONT:
			MenuGetMenuItem(MENU_SYSETUP, MENU_ITEM_FONT, &item_text);
			if (item_text[0] == SYSETUP_LFONT_INT)
				GOwnInfoFont = SYSETUP_LFONT_INT;
			else
				GOwnInfoFont = SYSETUP_SFONT_INT;
			set_font = 1;
			MenuDeleteItem(MENU_SYSETUP, MENU_ITEM_FONT);
			if (GOwnInfoFont == SYSETUP_LFONT_INT)
			{
				font = MEDIUM_FONT;
				MenuInsertItem(MENU_SYSETUP, MENU_ITEM_FONT, SYSSFONT);
			}
			else
			{
				font = SMALL_FONT;
				MenuInsertItem(MENU_SYSETUP, MENU_ITEM_FONT, SYSLFONT);
			}
			
			SySetupFieldSetFont(FIELD_SYSETUP_PASSWORD_HINTS, font);
			
			SySetupSetScreen(FORM_SYSETUP_PASSWORD_HINTS);
			SySetupFieldSetScrollbar(FIELD_SYSETUP_PASSWORD_HINTS, SCROLLBAR_SYSETUP_PASSWORD_HINTS);
			ScrollbarDrawScrollbar(SCROLLBAR_SYSETUP_PASSWORD_HINTS);
			FieldDrawField(FIELD_SYSETUP_PASSWORD_HINTS);
			
		default:
			break;
		}
		return TRUE;
		
		case EVT_KEYBOARD_STATUS:
			SySetupSetScreen(FORM_SYSETUP_PASSWORD_HINTS);
			SySetupSetField(FORM_SYSETUP_PASSWORD_HINTS, FIELD_SYSETUP_PASSWORD_HINTS);
			SySetupFieldSetScrollbar(FIELD_SYSETUP_PASSWORD_HINTS, SCROLLBAR_SYSETUP_PASSWORD_HINTS);
			FieldDrawField(FIELD_SYSETUP_PASSWORD_HINTS);
			return TRUE;
			
#ifdef PR31700
		case EVT_IO_KEY_CTRL:
			if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
            {
                if (Event->para2 == IO_UP_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_SYSETUP_PASSWORD_HINTS, SCROLLBAR_UP_ARROW);
                else if (Event->para2 == IO_DOWN_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_SYSETUP_PASSWORD_HINTS, SCROLLBAR_DOWN_ARROW);
				return TRUE;
			}
			return FALSE;
#endif
		case EVT_SCROLLBAR_REPEAT:
			//			if (Event->para1 != Event->para2)
			if (Event->para1 == Event->para2)
				return TRUE;
			SySetupScrollbarSetField(FIELD_SYSETUP_PASSWORD_HINTS, SCROLLBAR_SYSETUP_PASSWORD_HINTS, Event);
			return TRUE;
			
		case EVT_SCROLLBAR_SELECT:
			SySetupScrollbarSetField(FIELD_SYSETUP_PASSWORD_HINTS, SCROLLBAR_SYSETUP_PASSWORD_HINTS, Event);
			//			ScrollbarDrawScrollbar(SCROLLBAR_SYSETUP_PASSWORD_HINTS);
			return TRUE;
		case EVT_FIELD_CHANGED:
			SySetupFieldSetScrollbar(FIELD_SYSETUP_PASSWORD_HINTS, SCROLLBAR_SYSETUP_PASSWORD_HINTS);
			return TRUE;
		case EVT_KEY:
			if (Event->para2 & 0x00000300)
				return TRUE;
			if (password_hints_field_enable)
			{
				FieldAddKeyInChar(FIELD_SYSETUP_PASSWORD_HINTS, (BYTE)(Event->para1));
				SySetupFieldSetScrollbar(FIELD_SYSETUP_PASSWORD_HINTS, SCROLLBAR_SYSETUP_PASSWORD_HINTS);
			}
			return TRUE;
			
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
				if (password_hints_field_enable)
				{
					if (!SySetupEditPasswordHints())
						return TRUE;
					FormSetFormActiveObject(FORM_SYSETUP_PASSWORD, TEXTBOX_SYSETUP_PASSWORD_NEW);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_PASSWORD_NEW);
					FormPopupForm(FORM_SYSETUP_PASSWORD);
				}
				else
				{
#ifdef PR31700
					InlaySetEnableStatus(TRUE);
#endif
					FormSetFormActiveObject(FORM_SYSETUP_PASSWORD_ENTER, TEXTBOX_SYSETUP_PASSWORD_OLD);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_PASSWORD_OLD);
					FormDrawForm(FORM_SYSETUP_PASSWORD);
					FormPopupForm(FORM_SYSETUP_PASSWORD_ENTER);
				}
				return TRUE;
				
			case INLAY_EXIT:
				if (password_hints_field_enable)
				{
					FormSetFormActiveObject(FORM_SYSETUP_PASSWORD, TEXTBOX_SYSETUP_PASSWORD_NEW);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_PASSWORD_NEW);
					FormPopupForm(FORM_SYSETUP_PASSWORD);
				}
				else
				{
#ifdef PR31700
					InlaySetEnableStatus(TRUE);
#endif
					FormSetFormActiveObject(FORM_SYSETUP_PASSWORD_ENTER, TEXTBOX_SYSETUP_PASSWORD_OLD);
					TextboxSetInsertPointOn(TEXTBOX_SYSETUP_PASSWORD_OLD);
					FormDrawForm(FORM_SYSETUP_PASSWORD);
					FormPopupForm(FORM_SYSETUP_PASSWORD_ENTER);
				}
				return TRUE;
				
			default:	return FALSE;
			}
			
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	SySetupPasswordFailure
* Purpose: 	This function is the event handler for the password
*				settings failure page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupPasswordFailure(EvtType *Event)
{
	BYTE	*text, text_on_dialog[30];
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		TextboxSetInsertPointOff(TEXTBOX_SYSETUP_PASSWORD_OLD);
		TextboxSetInsertPointOff(TEXTBOX_SYSETUP_PASSWORD_NEW);
		TextboxSetInsertPointOff(TEXTBOX_SYSETUP_PASSWORD_CONFIRM);
		FormDrawForm(FORM_SYSETUP_PASSWORD_FAILURE);
		return TRUE;
		
	case EVT_CONTROL_SELECT:
		switch(Event->eventID)
		{	
		case BUTTON_SYSETUP_PASSWORD_FAILURE_YES:
			StringGetText(STRING_SYSETUP_PASSWORD_FAILURE, &text);
			strcpy(text_on_dialog, SYSSTR10);
			if (!strcmp(text, text_on_dialog))
			{
				TextboxInitTextbox(TEXTBOX_SYSETUP_PASSWORD_OLD);
				FormSetFormActiveObject(FORM_SYSETUP_PASSWORD, TEXTBOX_SYSETUP_PASSWORD_OLD);
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_SYSETUP_PASSWORD_OLD, 0);
				TextboxSetInsertPointOn(TEXTBOX_SYSETUP_PASSWORD_OLD);
				FormDrawForm(FORM_SYSETUP_PASSWORD);
				FormPopupForm(FORM_SYSETUP_PASSWORD_ENTER);
			}
			else
			{
				TextboxInitTextbox(TEXTBOX_SYSETUP_PASSWORD_CONFIRM);
				FormSetFormActiveObject(FORM_SYSETUP_PASSWORD, TEXTBOX_SYSETUP_PASSWORD_CONFIRM);
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_SYSETUP_PASSWORD_CONFIRM, 0);
				TextboxSetInsertPointOn(TEXTBOX_SYSETUP_PASSWORD_CONFIRM);
				FormPopupForm(FORM_SYSETUP_PASSWORD);
			}
			return TRUE;
			
		case BUTTON_SYSETUP_PASSWORD_FAILURE_NO:
			FormPopupForm(FORM_SYSETUP_MENU);
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
				EvtAppendEvt(EVT_CONTROL_SELECT, BUTTON_SYSETUP_PASSWORD_FAILURE_YES, 0, 0, NULL);
				return TRUE;
			case INLAY_EXIT:
				FormPopupForm(FORM_SYSETUP_MENU);
				return TRUE;
				
			default:	return FALSE;
			}
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	SySetupPasswordSuccess
* Purpose: 	This function is the event handler for the password
*				settings success page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupPasswordSuccess(EvtType *Event)
{
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SYSETUP_PASSWORD_SUCCESS);
		return TRUE;
		
	case EVT_CONTROL_SELECT:
		switch(Event->eventID)
		{	
		case BUTTON_SYSETUP_PASSWORD_SUCCESS_OK:
			FormPopupForm(FORM_SYSETUP_MENU);
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
			case INLAY_EXIT:
				FormPopupForm(FORM_SYSETUP_MENU);
				return TRUE;
				
			default:	return FALSE;
			}
	}
	
	return FALSE;
}


/*****************************************************************
* Function:	SySetupPasswordErase
* Purpose: 	This function is the event handler for the password
*				settings erase page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupPasswordErase(EvtType *Event)
{
	BYTE	null_string[20];
	WORD	i;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SYSETUP_PASSWORD_ERASE);
		return TRUE;
		
	case EVT_CONTROL_SELECT:
		switch(Event->eventID)
		{	
		case BUTTON_SYSETUP_PASSWORD_ERASE_YES:
			for(i=0; i<20; i++)		null_string[i] = 0;
			SySetupSetPassword(null_string, null_string);
			FormPopupForm(FORM_SYSETUP_MENU);
			return TRUE;
			
		case BUTTON_SYSETUP_PASSWORD_ERASE_NO:
			TextboxSetInsertPointOff(TEXTBOX_SYSETUP_PASSWORD_CONFIRM);
			FormSetFormActiveObject(FORM_SYSETUP_PASSWORD, TEXTBOX_SYSETUP_PASSWORD_NEW);
			TextboxSetInsertPointPositionByCharPos(TEXTBOX_SYSETUP_PASSWORD_NEW, 0);
			TextboxSetInsertPointOn(TEXTBOX_SYSETUP_PASSWORD_NEW);
			FormPopupForm(FORM_SYSETUP_PASSWORD);
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
				for(i=0; i<20; i++)		null_string[i] = 0;
				SySetupSetPassword(null_string, null_string);
				FormPopupForm(FORM_SYSETUP_MENU);
				return TRUE;
			case INLAY_EXIT:
				TextboxSetInsertPointOff(TEXTBOX_SYSETUP_PASSWORD_CONFIRM);
				FormSetFormActiveObject(FORM_SYSETUP_PASSWORD, TEXTBOX_SYSETUP_PASSWORD_NEW);
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_SYSETUP_PASSWORD_NEW, 0);
				TextboxSetInsertPointOn(TEXTBOX_SYSETUP_PASSWORD_NEW);
				FormPopupForm(FORM_SYSETUP_PASSWORD);
				return TRUE;
				
			default:	return FALSE;
			}
	}
	
	return FALSE;
}



/*****************************************************************
* Function:	SySetupEmail
* Purpose: 	This function is the event handler for the email
*				settings page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupEmail(EvtType *Event)
{
	ObjectID	active_id;
	BYTE		font, *item_text;
	static BYTE	set_font = 0;
	BYTE		*field_text;	
	UWORD		num_chars;
	Field		*field_ptr;
	BYTE		object_type;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:	
		MenuDeleteItem(MENU_SYSETUP, MENU_ITEM_FONT);
		if (GOwnInfoFont == SYSETUP_LFONT_INT)
		{
			font = MEDIUM_FONT;
			MenuInsertItem(MENU_SYSETUP, MENU_ITEM_FONT, SYSSFONT);
		}
		else
		{
			font = SMALL_FONT;
			MenuInsertItem(MENU_SYSETUP, MENU_ITEM_FONT, SYSLFONT);
		}
		
		for (active_id = FIELD_SYSETUP_EMAIL_ISP; active_id <= FIELD_SYSETUP_EMAIL_PASSWORD; active_id++)
			SySetupFieldSetFont(active_id, font);
		
		if (!email2_popup)
		{
			if (!SySetupRestoreEmailSettings())
				return TRUE;
		}
		
		if (!set_font)
		{
			FieldSetInsertPointOn(FIELD_SYSETUP_EMAIL_ISP);
			FieldSetInsertPointPositionByCharPos(FIELD_SYSETUP_EMAIL_ISP, 0);
			FormSetFormActiveObject(FORM_SYSETUP_EMAIL, FIELD_SYSETUP_EMAIL_ISP);
		}
		else
			set_font = 0;
		
		SySetupSetScreen(FORM_SYSETUP_EMAIL);
		SySetupSetTable(FORM_SYSETUP_EMAIL, TABLE_SYSETUP_EMAIL);
		SySetupTableSetScrollbar(TABLE_SYSETUP_EMAIL, SCROLLBAR_SYSETUP_EMAIL);		
		FormDrawForm(FORM_SYSETUP_EMAIL);			
		FieldSetInsertPointOn(FIELD_SYSETUP_EMAIL_ISP);
		FieldSetInsertPointPositionByCharPos(FIELD_SYSETUP_EMAIL_ISP, 0);
		FormSetFormActiveObject(FORM_SYSETUP_EMAIL, FIELD_SYSETUP_EMAIL_ISP);			
		FieldDrawField(FIELD_SYSETUP_EMAIL_ISP);
		return TRUE;
		//HENRY
	case EVT_FIELD_SELECT:
		if (Event->eventID == FIELD_SYSETUP_EMAIL_LOGIN_PASSWORD || 
			Event->eventID == FIELD_SYSETUP_EMAIL_PASSWORD)
		{
			FormGetObjectPointer(Event->eventID, &object_type, (void**)&field_ptr);
			field_ptr->field_attr.field_highlight 			= FALSE;
			field_ptr->field_attr.field_insert_pt_visible 	= TRUE;
			FieldSetInsertPointPositionByCharPos(Event->eventID, field_ptr->field_current_num_chars);			    
			FieldDrawField(Event->eventID);
		}
		return TRUE;
		//HENRY			
	case EVT_MENU_SELECT_ITEM:
		switch((USHORT)(Event->para1))
		{
		case MENU_ITEM_COPY:
			KeyboardSendEvent(KEY_COPY, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_CUT:
			KeyboardSendEvent(KEY_CUT, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_PASTE:
			KeyboardSendEvent(KEY_PASTE, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_UNDO:
			if (UIGetUndoStatus() != UNDO_EMPTY)
				KeyboardSendEvent(KEY_UNDO, FALSE, FALSE, FALSE);
			break;
		case MENU_ITEM_FONT:
			MenuGetMenuItem(MENU_SYSETUP, MENU_ITEM_FONT, &item_text);
			if (item_text[0] == SYSETUP_LFONT_INT)
				GOwnInfoFont = SYSETUP_LFONT_INT;
			else
				//GEmailFont = 'S';
				GOwnInfoFont = SYSETUP_SFONT_INT;
			email2_popup = TRUE;
			set_font = 1;
			MenuDeleteItem(MENU_SYSETUP, MENU_ITEM_FONT);
			if (GOwnInfoFont == SYSETUP_LFONT_INT)
			{
				font = MEDIUM_FONT;
				MenuInsertItem(MENU_SYSETUP, MENU_ITEM_FONT, SYSSFONT);
			}
			else
			{
				font = SMALL_FONT;
				MenuInsertItem(MENU_SYSETUP, MENU_ITEM_FONT, SYSLFONT);
			}
			
			for (active_id = FIELD_SYSETUP_EMAIL_ISP; active_id <= FIELD_SYSETUP_EMAIL_PASSWORD; active_id++)
				SySetupFieldSetFont(active_id, font);
			
			if (!email2_popup)
			{
				if (!SySetupRestoreEmailSettings())
					return TRUE;
			}
			if (!set_font)
			{
				FieldSetInsertPointOn(FIELD_SYSETUP_EMAIL_ISP);
				FieldSetInsertPointPositionByCharPos(FIELD_SYSETUP_EMAIL_ISP, 0);
				FormSetFormActiveObject(FORM_SYSETUP_EMAIL, FIELD_SYSETUP_EMAIL_ISP);
			}
			else
				set_font = 0;
			SySetupSetScreen(FORM_SYSETUP_EMAIL);
			SySetupSetTable(FORM_SYSETUP_EMAIL, TABLE_SYSETUP_EMAIL);
			//TableSetTopRowNum(TABLE_SYSETUP_EMAIL, 0);
			SySetupTableSetScrollbar(TABLE_SYSETUP_EMAIL, SCROLLBAR_SYSETUP_EMAIL);
			ScrollbarDrawScrollbar(SCROLLBAR_SYSETUP_EMAIL);
			TableDrawTable(TABLE_SYSETUP_EMAIL);
			break;
		default:
			break;
		}
		return TRUE;
		
		case EVT_KEYBOARD_STATUS:
			SySetupSetScreen(FORM_SYSETUP_EMAIL);
			SySetupSetTable(FORM_SYSETUP_EMAIL, TABLE_SYSETUP_EMAIL);
			SySetupTableSetScrollbar(TABLE_SYSETUP_EMAIL, SCROLLBAR_SYSETUP_EMAIL);
			TableEraseTable(TABLE_SYSETUP_EMAIL);
			TableDrawTable(TABLE_SYSETUP_EMAIL);
			return TRUE;
			
#ifdef PR31700
		case EVT_IO_KEY_CTRL:
			if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
            {
                if (Event->para2 == IO_UP_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_SYSETUP_EMAIL, SCROLLBAR_UP_ARROW);
                else if (Event->para2 == IO_DOWN_ARROW)
					ScrollbarHardButtonSetScrollbar(SCROLLBAR_SYSETUP_EMAIL, SCROLLBAR_DOWN_ARROW);
				return TRUE;
			}
			return FALSE;
#endif
		case EVT_SCROLLBAR_REPEAT:
			if (Event->para1 == Event->para2)
				return TRUE;
			SySetupScrollbarSetTable(TABLE_SYSETUP_EMAIL, FIELD_SYSETUP_EMAIL_ISP, SCROLLBAR_SYSETUP_EMAIL, Event);
			return	TRUE;
			
		case EVT_SCROLLBAR_SELECT:
			SySetupScrollbarSetTable(TABLE_SYSETUP_EMAIL, FIELD_SYSETUP_EMAIL_ISP, SCROLLBAR_SYSETUP_EMAIL, Event);
			return	TRUE;
			
		case EVT_KEY:
			if (Event->para2 & 0x00000300)
				return TRUE;
			if (Event->eventID == SOFT_KEY)
			{
				FormGetActiveObject(FORM_SYSETUP_EMAIL, &active_id);
				if (active_id != FIELD_SYSETUP_EMAIL_LOGIN_PASSWORD && active_id != FIELD_SYSETUP_EMAIL_PASSWORD)
				{
					if ((active_id >= FIELD_SYSETUP_EMAIL_ISP) && (active_id <= FIELD_SYSETUP_EMAIL_PASSWORD))
						FieldAddKeyInChar(active_id, (BYTE)(Event->para1));
					return	TRUE;
				}
				else
				{	
					if (Event->para1 == '\r' || Event->para1 == '\n' || Event->para1 < 32)
						return TRUE;
					FieldAddKeyInChar(active_id, '*');
				}						
				
				FieldGetNumOfChars(active_id, &num_chars);
				if (num_chars <= 40)
				{
					switch(active_id)
					{
					case FIELD_SYSETUP_EMAIL_LOGIN_PASSWORD:
						login_password[num_chars-1] = (BYTE)Event->para1;
						login_password[num_chars] = 0;
						break;	
					case FIELD_SYSETUP_EMAIL_PASSWORD:
						email_password[num_chars-1] = (BYTE)Event->para1;
						email_password[num_chars] = 0;
						break;	
					default:
						return FALSE;
					}
				}			
				return TRUE;
			}					
			return TRUE;
		case EVT_FIELD_CHANGED:
			SySetupSetScreen(FORM_SYSETUP_EMAIL);
			if (SySetupKeyInChangeTable(FORM_SYSETUP_EMAIL, TABLE_SYSETUP_EMAIL, SCROLLBAR_SYSETUP_EMAIL))
				TableDrawTable(TABLE_SYSETUP_EMAIL);
			return	TRUE;
			
		case EVT_BITMAP_SELECT:
			switch(Event->eventID)
			{	
			case BITMAP_SYSETUP_EMAIL_DNARW:
				FormSetFormActiveObject(FORM_SYSETUP_EMAIL2, TEXTBOX_SYSETUP_EMAIL2_PRIDNS1);
				TextboxSetInsertPointOn(TEXTBOX_SYSETUP_EMAIL2_PRIDNS1);
				TextboxSetInsertPointPositionByCharPos(TEXTBOX_SYSETUP_EMAIL2_PRIDNS1, 0);
				FormPopupForm(FORM_SYSETUP_EMAIL2);
				return TRUE;
				
			default:	return FALSE;
			}
			
			case EVT_CONTROL_SELECT:
				email2_popup = FALSE;
				FieldSetInsertPointPositionByCharPos(FIELD_SYSETUP_EMAIL_ISP, 0);
				FormSetFormActiveObject(FORM_SYSETUP_EMAIL, FIELD_SYSETUP_EMAIL_ISP);
				switch(Event->eventID)
				{	
				case PUSH_SYSETUP_EMAIL_ISP:
					FormPopupForm(FORM_SYSETUP_EMAIL);
					return TRUE;
					
				case PUSH_SYSETUP_EMAIL_ISP2:
					FormPopupForm(FORM_SYSETUP_EMAIL);
					return TRUE;
					
				case PUSH_SYSETUP_EMAIL_ISP3:
					FormPopupForm(FORM_SYSETUP_EMAIL);
					return TRUE;
					
				case PUSH_SYSETUP_EMAIL_ISP4:
					FormPopupForm(FORM_SYSETUP_EMAIL);
					return TRUE;
					
				default: return FALSE;
				}
				
				
				case EVT_INLAY_SELECT:
					switch(Event->para1)
					{	
					case INLAY_OK:
						if (!SySetupSetEmailSettings())
							return TRUE;
						email2_popup = FALSE;
						FormPopupForm(FORM_SYSETUP_MENU);
						return TRUE;
						
					case INLAY_EXIT:
						email2_popup = FALSE;
						FormPopupForm(FORM_SYSETUP_MENU);
						return TRUE;
						
					default:	return FALSE;
					}
					
	}
	
	return FALSE;
}

/*****************************************************************
* Function:	SySetupEmail2
* Purpose: 	This function is the event handler for the email login
*				script settings page of the setup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupEmail2(EvtType *Event)
{
	
	ObjectID	active_id;
	WORD		num_chars, char_pos;
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SYSETUP_EMAIL2);
		return TRUE;
		
	case EVT_BITMAP_SELECT:
		switch(Event->eventID)
		{	
		case BITMAP_SYSETUP_EMAIL2_UPARW:
			email2_popup = TRUE;
			FormGetActiveObject(FORM_SYSETUP_EMAIL2, &active_id);
			if (active_id >= TEXTBOX_SYSETUP_EMAIL2_PRIDNS1 && active_id <= TEXTBOX_SYSETUP_EMAIL2_IP_ADDR4)
				TextboxSetInsertPointOff(active_id);
			FormPopupForm(FORM_SYSETUP_EMAIL);
			return TRUE;
			
		default:	return FALSE;
		}
		
		case EVT_KEY:
			if (Event->para2 & 0x00000300)
				return TRUE;
			if (Event->para1 < '0' || Event->para1 > '9')
				return TRUE;
			FormGetActiveObject(FORM_SYSETUP_EMAIL2, &active_id);
			//Bug Fixed 15-Feb-2001
			//Make sure the active object of the form should be textbox before setting anything about textbox
			//---------------------------------------------------------------------------------- Modifying codes
			if (active_id >= TEXTBOX_SYSETUP_EMAIL2_PRIDNS1 && active_id <= TEXTBOX_SYSETUP_EMAIL2_IP_ADDR4)
			{
				TextboxGetNumOfCharsDisplayed(active_id, &num_chars);
				TextboxGetInsertPointPosition(active_id, &char_pos);
				if (char_pos > 2)
				{
					TextboxSetInsertPointOff(active_id);
					if (active_id == TEXTBOX_SYSETUP_EMAIL2_IP_ADDR4)
						active_id = TEXTBOX_SYSETUP_EMAIL2_PRIDNS1;
					else
						active_id++;
					FormSetFormActiveObject(FORM_SYSETUP_EMAIL2, active_id);
					TextboxSetInsertPointPositionByCharPos(active_id, 0);
				}
				TextboxSetInsertPointOn(active_id);
				TextboxAddKeyInChar(active_id, (BYTE)Event->para1);
			}
			//---------------------------------------------------------------------------------- Modifying codes
			return TRUE;
			
		case EVT_INLAY_SELECT:
			FormGetActiveObject(FORM_SYSETUP_EMAIL2, &active_id);
			//Bug Fixed 16-Feb-2001
			//Make sure the active object should be textbox before passing to set insertPoint off of textbox
			//---------------------------------------------------------------------------------- Modifying codes
			if (active_id >= TEXTBOX_SYSETUP_EMAIL2_PRIDNS1 && active_id <= TEXTBOX_SYSETUP_EMAIL2_IP_ADDR4)
				TextboxSetInsertPointOff(active_id);
			//---------------------------------------------------------------------------------- Modifying codes
			switch(Event->para1)
			{	
			case INLAY_OK:
				if (!SySetupSetEmailSettings())
					return TRUE;
				email2_popup = FALSE;
				FormPopupForm(FORM_SYSETUP_MENU);
				return TRUE;
				
			case INLAY_EXIT:
				email2_popup = FALSE;
				FormPopupForm(FORM_SYSETUP_MENU);
				return TRUE;
				
			default:	return FALSE;
			}
			
			default:	return FALSE;
	}
	
	return FALSE;
}




/*****************************************************************
* Function:	SySetupSetTextboxHighlightSelectionOff
* Purpose: 	This function is used to disable the insert point and the
highlighted section of the input textbox
* Scope:		application/internal
* Input:		object_id				object ID
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
*****************************************************************/
void SySetupSetTextboxHighlightSelectionOff(ObjectID object_id)
{
	BYTE	object_type;
	
	Textbox	*textbox_ptr;
	
	FormGetObjectPointer(object_id, &object_type, (void**)&textbox_ptr);
    textbox_ptr->textbox_highlight_start_char = 0;
    textbox_ptr->textbox_highlight_end_char = 0;
    textbox_ptr->textbox_highlight_length = 0;
	textbox_ptr->textbox_attr.textbox_highlight = FALSE;
    textbox_ptr->textbox_attr.textbox_insert_pt_visible = FALSE;
	
	return;
}

/*****************************************************************
* Function:	SySetupDialogLowMemory
* Purpose: 	This function is the event handler for the low memory
*				dialog box of the system sysetup application
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
******************************************************************/
BOOLEAN SySetupDialogLowMemory(EvtType *Event)
{
	
	switch(Event->eventType)
	{
	case EVT_FORM_OPEN:
		FormDrawForm(FORM_SYSETUP_DIALOG_LOW_MEMORY);
		return TRUE;
		
	case EVT_BITMAP_SELECT:
		switch(Event->eventID)
		{		
		case BITMAP_SYSETUP_DIALOG_LOW_MEMORY_X:
			FormPopupForm(FORM_SYSETUP_MENU);
			return TRUE;
			
		default:	return FALSE;
		}
		
		
		case EVT_INLAY_SELECT:
			switch(Event->para1)
			{	
			case INLAY_OK:
			case INLAY_EXIT:
				FormPopupForm(FORM_SYSETUP_MENU);
				return TRUE;
				
			default:	return FALSE;
			}
			
	}
	
	
	return FALSE;
}

/*****************************************************************
* Function:	SySetupHandleEmailPasswords
* Purpose: 	This function is used to handle the status of the password's fields
in Email Settings screen
* Scope:		application
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupHandleEmailPasswords(EvtType *Event)
{
	ObjectID	active_form_id, active_object;
	WORD		i, char_pos;
	
	
	if (FormGetActiveFormID(&active_form_id) != TRUE)
		return FALSE;
	if (active_form_id != FORM_SYSETUP_EMAIL)
		return FALSE;
	
	FormGetActiveObject(FORM_SYSETUP_EMAIL, &active_object);
	
	if (active_object != FIELD_SYSETUP_EMAIL_LOGIN_PASSWORD && active_object != FIELD_SYSETUP_EMAIL_PASSWORD)
		return FALSE;
	
	switch (Event->eventType)
	{
	case EVT_FIELD_JOT_PASTE_STRING:
		return TRUE;
	case EVT_TEXTBOX_JOT_PASTE_STRING:
		return TRUE;		
	case EVT_KEY:
		if (Event->para2 & 0x00000300)
			return FALSE;
		if (Event->eventID == SOFT_KEY)
		{
			Event->para2 &= 0x000000FF;
			if (Event->para2)
			{
				switch(Event->para2)
				{
				case KEY_LEFT:
					return TRUE;
				case KEY_RIGHT:
					return TRUE;					
				case KEY_UNDO:
					return TRUE;
				case KEY_HOME:
					return TRUE;
				case KEY_END:
					return TRUE;
				case KEY_COPY:
					return TRUE;
				case KEY_PASTE:
					return TRUE;
				case KEY_CUT:
					return TRUE;
				case KEY_DEL:
					return TRUE;
				default:
					return FALSE;
				}
			}
		}
		return FALSE;				
	default:
		return FALSE;
	}						
}

/*****************************************************************
* Function:	SySetupHandlePasswordTextboxStatus
* Purpose: 	This function is used to handle the status of the password's textbox
* Scope:		application/internal
* Input:		Event			received event
* Output:		None
* Return:		TRUE if handled
*				FALSE if not handled
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupHandlePasswordTextboxStatus(EvtType *Event)
{
	ObjectID	active_form_id, active_id;
	WORD		i, char_pos;
	
	if (FormGetActiveFormID(&active_form_id) != TRUE)
		return FALSE;
	if (active_form_id != FORM_SYSETUP_PASSWORD && active_form_id != FORM_SYSETUP_PASSWORD_ENTER)
		return FALSE;
	
	switch (Event->eventType)
	{
	case EVT_FIELD_JOT_PASTE_STRING:
		return TRUE;
	case EVT_TEXTBOX_JOT_PASTE_STRING:
		return TRUE;
	case EVT_KEY:
		if (Event->para2 & 0x00000300)
			return FALSE;
		if (Event->eventID == SOFT_KEY)
		{
			Event->para2 &= 0x000000ff;
			if (Event->para2 != 0)
				switch(Event->para2)
			{
	case KEY_LEFT:
		return TRUE;
	case KEY_RIGHT:
		return TRUE;					
	case KEY_UNDO:
		return TRUE;
	case KEY_HOME:
		return TRUE;
	case KEY_END:
		return TRUE;
	case KEY_COPY:
		return TRUE;
	case KEY_PASTE:
		return TRUE;
	case KEY_CUT:
		return TRUE;
	case KEY_DEL:
		if (Textbox_Highlight_Flag)
		{
			if (active_form_id == FORM_SYSETUP_PASSWORD_ENTER)
			{	
				for(i=0; i<20; i++)
					enter_text[i] = 0;
			}
			else
			{
				for(i=0; i<20; i++)
				{
					change_text[i] = 0;
					confirm_text[i] = 0;
				}
			}
		}
		else
		{
			FormGetActiveObject(active_form_id, &active_id);
			TextboxGetInsertPointPosition(active_id, &char_pos);				  
			if (char_pos > 0)
			{
				char_pos--;
				switch(active_id)
				{
				case TEXTBOX_SYSETUP_PASSWORD_OLD:
					enter_text[char_pos] = 0;
					break;													
				case TEXTBOX_SYSETUP_PASSWORD_NEW:
					change_text[char_pos] = 0;
					break;
				case TEXTBOX_SYSETUP_PASSWORD_CONFIRM:
					confirm_text[char_pos] = 0;
					break;
				default:
					break;
				}
			}
		}
		return FALSE;
	default:
				 			return FALSE;
			}
			
			if (Event->para1 != 0)
				switch(Event->para1)
			{
	case KEY_BACKSPACE:
		FormGetActiveObject(active_form_id, &active_id);
		if (Textbox_Highlight_Flag)
		{
			if (active_form_id == FORM_SYSETUP_PASSWORD_ENTER)
			{	
				for(i=0; i<20; i++)
					enter_text[i] = 0;
			}
			else
			{
				if (active_id == TEXTBOX_SYSETUP_PASSWORD_NEW)
					for(i=0; i<20; i++)
						change_text[i] = 0;
					if (active_id == TEXTBOX_SYSETUP_PASSWORD_CONFIRM)
						for(i=0; i<20; i++)
							confirm_text[i] = 0;
			}
		}
		else
		{
			TextboxGetInsertPointPosition(active_id, &char_pos);				  
			if (char_pos > 0)
			{
				char_pos--;
				switch(active_id)
				{
				case TEXTBOX_SYSETUP_PASSWORD_OLD:
					enter_text[char_pos] = 0;
					break;													
				case TEXTBOX_SYSETUP_PASSWORD_NEW:
					change_text[char_pos] = 0;
					break;
				case TEXTBOX_SYSETUP_PASSWORD_CONFIRM:
					confirm_text[char_pos] = 0;
					break;
				default:
					break;
				}
			}
		}
		return FALSE;
	default:
		return FALSE;
			}
			}	   
		default:     
			return FALSE;
	}
	
	return FALSE;
}
