/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   hwinit.c
Author(s)   :   Andrew Hui
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   hardward init
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "platform.h"

#ifdef PR31700


#include "datatype.h"
#include "Pr31700c.h"
#include "Pr31700s.h"
#include "CpuIoReg.h"
#include "init.h"
#include "dev_pwr.h"


#define  UART_A         0
#define  FALSE          0

extern UartrPrintf(int, char*) ;

#define SD16M_RAM_16BIT 1
#define SD16M_RAM_8BIT  2

#define S_RAM_16BIT     3
#define S_RAM_32BIT     4

#define D_RAM_16BIT     5
#define D_RAM_32BIT     6

#define SD64M_RAM_16BIT 8
#define SD64M_RAM_8BIT  9

#define LITTLE_ENDIAN   1
#define BIG_ENDIAN      2
#define CS0_1ACCESS     CS0ACCVAL1_4    /* wait state of CS0 first  access */
#define CS0_2ACCESS     CS0ACCVAL2_4    /* wait state of CS0 second access */


/* define MIO pin position */
#define UART_TX_ENABLE  (1<<10)
#define UART_RX_DISABLE (1<<16)
#define AUDIO_DISABLE   (1<<6)


#define NO_RAM_TEST     0x0A0
#define DO_RAM_TEST     0x050
#define RAM_TEST_MASK   0x0F0

#define FULL_SPEED      0x005
#define HALF_SPEED      0x00A
#define SPEED_MASK      0x00F

#define CLICK_NONE  0
#define CLICK_SHORT 1
#define CLICK_LONG  2
#define CLICK_TIME  1400000  /* 1,000ms    @ 75MHz*/


////////////////////////////////////////
#define START_UP_COLD       0xAA
#define START_UP_WARM       0x55
////////////////////////////////////////


int HwStartUpStatus;   /*  warm start or cold start */
int HwRamType;   /*  warm start or cold start */

void start();  /* start.s */
void reset_exception;

// Init cpu register and detect RAM config and size
BootUpInit()
{
    ///////////////////////////////////////
    register int *CpuReg;
    register int j;
    register int startup_status;
    ///////////////////////////////////////
	
    register int *ptr;
    register int i;
	
    register int ram_type;
	
	
	
	__asm(" .globl ResetHandler");
	__asm("ResetHandler:");
	
    ///////////////////////////////////////
    CpuReg=(int*)0xb0c00000;
	
	
    /* check it is cold start or warm start */
	
    if ((CpuReg[IOREG_POWER_CTRL] & ONBUTN)==0)   /* if warm start */
        startup_status=START_UP_WARM;
    else
        startup_status=START_UP_COLD;
	
	
	
	
    /****************** init CPU IO register *********************/
	
	/* Sib module */
	CpuReg[IOREG_SIB_CTRL]         =0;                         /*  0X  74 */
	
	
    /* empty the input buffer */
	j=CpuReg[IOREG_SIB_SF0_STATUS];                            /*  0X  88 */
	j=CpuReg[IOREG_SIB_SF0_STATUS];                            /*  0X  88 */
	j=CpuReg[IOREG_SIB_SF1_STATUS];                            /*  0X  8C */
	j=CpuReg[IOREG_SIB_SF1_STATUS];                            /*  0X  8C */
	
	j=CpuReg[IOREG_SIB_SND_HLDG];                              /*  0X  78 */
	j=CpuReg[IOREG_SIB_SND_HLDG];                              /*  0X  78 */
	j=CpuReg[IOREG_SIB_TEL_HLDG];                              /*  0X  7C */
	j=CpuReg[IOREG_SIB_TEL_HLDG];                              /*  0X  7C */
	
	
	/* Uart module */
	CpuReg[IOREG_UARTA_CTRL_1]     &=DISTXD;                   /*  0X  B0 */
	CpuReg[IOREG_UARTA_CTRL_2]      =0;                        /*  0X  B4 */
	
    /* empty the input buffer */
	j=CpuReg[IOREG_UARTA_HLDG];                                /*  0X  C4 */
	j=CpuReg[IOREG_UARTA_HLDG];                                /*  0X  C4 */
	
	
	/* SPI module */
	
	CpuReg[IOREG_SPI_CTRL]         =0;                         /*  0X 160 */
	
	j=CpuReg[IOREG_SPI_HLDG];                                  /*  0X 164 */
	j=CpuReg[IOREG_SPI_HLDG];                                  /*  0X 164 */
	
	
	/* IO module */
	
	CpuReg[IOREG_IO_CTRL]          =(0x7f<<24)|(0<<16);        /*  0X 180 */
	CpuReg[IOREG_MFIO_SEL]         =0xf27fffff;                /*  0X 190 */
	CpuReg[IOREG_MFIO_DIRECTN]     =0xffffffff;                /*  0X 188 */
	CpuReg[IOREG_MFIO_DATA_OUT]    =0;                         /*  0X 184 */
	
	/* power down IO pin */
	/* io pin is connected to key input, so don't power down */
	
	CpuReg[IOREG_IO_POWER_DOWN]  =0x7f;                 /*  0X 194 */
	//     CpuReg[IOREG_IO_POWER_DOWN]  =0x0;                 /*  0X 194 */
	CpuReg[IOREG_MFIO_POWER_DOWN]  =0xffffffff;                /*  0X 198 */
	
	
	/* MISC */
	
	CpuReg[IOREG_CLK_CTRL]         =0;                         /*  0X 1C0 */
	
	CpuReg[IOREG_POWER_CTRL]       = (DIVMOD|VCCON|PWRCS|COLDSTART
		|FORCESHUTDOWNOCC) ;      /*  0X 1C4 */
	
	/************** these module will never use *************/
	
	CpuReg[IOREG_SIU_TEST]          =0;                        /*  0X 1C8 */
	
	/* Chi Module */
	CpuReg[IOREG_CHI_CTRL]          =0;                        /*  0X 1D8 */
	CpuReg[IOREG_CHI_PTR_ENABLE]    =0;                        /*  0X 1DC */
	CpuReg[IOREG_CHI_RX_PTR_A]      =0;                        /*  0X 1E0 */
	CpuReg[IOREG_CHI_RX_PTR_B]      =0;                        /*  0X 1E4 */
	CpuReg[IOREG_CHI_TX_PTR_A]      =0;                        /*  0X 1E8 */
	CpuReg[IOREG_CHI_TX_PTR_B]      =0;                        /*  0X 1EC */
	CpuReg[IOREG_CHI_SIZE]          =0;                        /*  0X 1F0 */
	CpuReg[IOREG_CHI_RX_START]      =0;                        /*  0X 1F4 */
	CpuReg[IOREG_CHI_TX_START]      =0;                        /*  0X 1F8 */
	
	j=CpuReg[IOREG_CHI_HLDG];                                  /*  0X 1FC */
	j=CpuReg[IOREG_CHI_HLDG];                                  /*  0X 1FC */
	
	/* Uart B */
	
	CpuReg[IOREG_UARTB_CTRL_1]     &=DISTXD;                   /*  0X  C8 */
	CpuReg[IOREG_UARTB_CTRL_2]      =0;                        /*  0X  CC */
	CpuReg[IOREG_UARTB_DMA_CTRL_1]  =0;                        /*  0X  D0 */
	CpuReg[IOREG_UARTB_DMA_CTRL_2]  =0;                        /*  0X  D4 */
	CpuReg[IOREG_UARTB_DMA_CNT]     =0;                        /*  0X  D8 */
	
    /* empty the input buffer */
	j=CpuReg[IOREG_UARTB_HLDG];                                /*  0X  DC */
	j=CpuReg[IOREG_UARTB_HLDG];                                /*  0X  DC */
	
	/* MagicBus module */
	CpuReg[IOREG_MBUS_CTRL_1]       =0;                        /*  0X  E0 */
	CpuReg[IOREG_MBUS_CTRL_2]       =0;                        /*  0X  E4 */
	CpuReg[IOREG_MBUS_DMA_CTRL_1]   =0;                        /*  0X  E8 */
	CpuReg[IOREG_MBUS_DMA_CTRL_2]   =0;                        /*  0X  EC */
	CpuReg[IOREG_MBUS_DMA_COUNT]    =0;                        /*  0X  F0 */
	j=CpuReg[IOREG_MBUS_RX_HLDG];                              /*  0X  F8 */
	j=CpuReg[IOREG_MBUS_RX_HLDG];                              /*  0X  F8 */
	
	/* IR module */
	CpuReg[IOREG_IR_CTRL_1]         =0;                        /*  0X  A0 */
	CpuReg[IOREG_IR_CTRL_2]         =0;                        /*  0X  A4 */
	
	
	
	
	//==================================================================
	//==================================================================
	
    CpuReg[IOREG_POWER_CTRL] |= DIVMOD;     /* independent of RF */
	
    /********************************************************************/
	
	/******  now ram should be available */
	
    HwStartUpStatus=startup_status;
    HwRamType = ram_type;
	
	//    /* clear Power On Status */
	//    PowerOnStatus.PwrOn       = FALSE ;
	//    PowerOnStatus.KeyRec      = FALSE ;
	//    PowerOnStatus.KeyPlay     = FALSE ;
	//    PowerOnStatus.KeyStop     = FALSE ;
	//    PowerOnStatus.KeyPhoneBook= FALSE ;
	//    PowerOnStatus.KeyToDoList = FALSE ;
	//    PowerOnStatus.KeyScheduler= FALSE ;
	//
	//    PowerOnStatus.SioDevDect  = FALSE ;
	//    PowerOnStatus.SioDataRdy  = FALSE ;
	//
	//    PowerOnStatus.HotSync     = FALSE ;
	//
	//    PowerOnStatus.RtcInt      = FALSE ;
	//    PowerOnStatus.AlarmInt    = FALSE ;
	
	
    
    NormalOperation = TRUE;
    WakeCpuUp       = FALSE;
	
    __asm("la   $26, Reset");
    __asm("jr  $26");
    __asm("nop");
	
	
	
	//    start();
	
	
    while (1);
	
}




#endif
