/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   autopwr.c
Author(s)   :   Garick Ngai
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Auto Power off
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "autopwr.h"
#include "qtype.h"
#include "eventmgr.h"
#include "sysetup.h"

volatile UWORD first_on_pda;
volatile UWORD en_onpda_timer;
volatile UWORD are_pda_on;

extern BYTE GAutoPwrOffTime;

void OnPdaInit();
void EnOnPdaTimerInt();
void DisOnPdaTimerInt();
void OnPdaCtrl();
void OffPda();
void OnPda();
void ResetOnPda();
void PdaPwrState(UWORD *pdapwrstate);
void CheckPdaPwr();
void SynDisOnPdaTimerInt();

void OnPdaInit()
{
	
#ifdef DEBUG
	printf("\nCall OnPdaInit");
#endif
	en_onpda_timer = 0;
	first_on_pda = 0;
	first_on_pda++;
	are_pda_on = TRUE;
	
	//        EnOnPdaTimerInt();
	OnPda();
	
}


void EnOnPdaTimerInt()
{
	if((SHORT)GAutoPwrOffTime == 0)
		(SHORT)GAutoPwrOffTime = 1;
	if(en_onpda_timer == 0)
		en_onpda_timer = TmrIntEnable(((UWORD)GAutoPwrOffTime)*60*1000,OffPda);
	
}

void AppDisOnPdaTimerInt()
{
	if(en_onpda_timer != 0) {
#ifdef DEBUG
		printf("\nSyn en_onpda_timer = %x",en_onpda_timer);
#endif
		
		TmrIntDisable(en_onpda_timer);
		en_onpda_timer = 0;
		first_on_pda = 0;
		
		are_pda_on = FALSE;
		
#ifdef DEBUG
		printf("\nSyn Disable Auto timer");
#endif
	}
}


void DisOnPdaTimerInt()
{
	if(en_onpda_timer != 0){
#ifdef DEBUG
		printf("\nDis en_onpda_timer = %x",en_onpda_timer);
#endif
		
		TmrIntDisable(en_onpda_timer);
		en_onpda_timer = 0;
		
#ifdef DEBUG
		printf("\nDisable Auto timer");
#endif
	}
}


void OffPda()
{
	if( are_pda_on == TRUE ){
		DisOnPdaTimerInt();
		first_on_pda = 0;
		are_pda_on = FALSE;
		
#ifdef DEBUG
		printf("\n PDA Auto Power Off\n");
#endif
		
		EvtAppendEvt(EVT_IO_KEY_CTRL, EVT_IO_KEY_PRESS, 0, EVT_POWER_OFF, NULL);
	}
	else
	{
		first_on_pda = 0;
		are_pda_on = FALSE;
	}
}

void ResetOnPda()
{
	if( first_on_pda != 0 ) {
#ifdef DEBUG
		printf("\nReset the OnPda Timer\n");
#endif
		
		DisOnPdaTimerInt();
		EnOnPdaTimerInt();
		are_pda_on = TRUE;
	}
}

void OnPda()
{
#ifdef DEBUG
	printf("\nCall OnPDa");
#endif
	
	if( first_on_pda == 0 ){
		EnOnPdaTimerInt();
		first_on_pda++;
		are_pda_on = TRUE;
	}
	else
	{
#ifdef DEBUG
		printf("Reset the PDA ON Timer\n");
#endif
		
		DisOnPdaTimerInt();
		EnOnPdaTimerInt();
	}
}

void PdaPwrState(UWORD *pdapwrstate)
{
    *pdapwrstate = are_pda_on;
}


void CheckPdaPwr()
{
	if( first_on_pda == 0 ) {
		//		printf("EL Without On\n");
	}
	else
	{
#ifdef DEBUG
		printf("Reset the Pwr Timer\n");
#endif
		
		DisOnPdaTimerInt();
		EnOnPdaTimerInt();
	}
}
