/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   cal_pen.c
Author(s)   :   Andrew Hui
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Cal pen
Revision    :   1.1
Note        :   None
===========================================================================
*/              

#include "platform.h"
#ifdef PR31700

#include "dev_pen.h"
#include "penmgr.h"
#include "dev_bety.h"
#include "dev_io.h"
#include "datatype.h"
#include "lcdapi.h"

#define PENUP				0
#define PENDOWN 			1

extern int pen_xy_exchange;


cal_pen_init()
{
	/* for pen calibration */
	//                        IntDisableAll();    /* disable all interrupt */
	DIS_INT_ALL;
	LcdInit();
	LcdTurnOn();
	
	/* init Betty and SIB  */
	
	SibInit();
	SibEnable();
	Delay(0x1fff);
	BettyReset();
	Delay(0x1fff);
	
}

ClearScreen()
{
	
    int i, j;
	
    for (j=0; j<160; j++)
        for (i=0; i<160;i++)   /* x1, y1 */
		{
            LcdSetPixel(i, j,    COLOR_WHITE);
		}
}


cal_pen()
{
	WORD i;
	WORD x1,x2,x3,x4,y1,y2,y3,y4;
	ObjectBounds bounds;
	bounds.xcoord = 30;
	bounds.ycoord = 75;
	bounds.width = 130;
	bounds.height = 85;
	/* clear Interrupt */
	
	BtyClearSF0Int();
	BtyWaitSF0Int();
	
    pen_xy_exchange=0;
	
#if 0
	
	pen_xy_exchange=99;
	while ( pen_xy_exchange==99)
	{
		printf("\n\nPen Calibration...\n");
		
		
		for (i=0; i<10;i++)   /* x1, y1 */
		{
			LcdSetPixel(0, i, COLOR_BLACK);
			LcdSetPixel(1, i, COLOR_BLACK);
			LcdSetPixel(i, 0, COLOR_BLACK);
			LcdSetPixel(i, 1, COLOR_BLACK);
			LcdSetPixel(i, i, COLOR_BLACK);
		}
		
		
		printf("\n\tCalibrate Left  Top    ");
		while (TtpGetxy(&x1, &y1)==PENUP);
		while (TtpGetxy(&i, &i)==PENDOWN);
		printf("done");
        Delay(0x10000);
		
		
		
        ClearScreen();
		
		
		//        LcdInit();
		
		
		
		
		for (i=0; i<10;i++)   /* x2, y2 */
		{
            LcdSetPixel(0+158, i, COLOR_BLACK);
            LcdSetPixel(1+158, i, COLOR_BLACK);
			LcdSetPixel(i+150, 0, COLOR_BLACK);
			LcdSetPixel(i+150, 1, COLOR_BLACK);
            LcdSetPixel(i+150, 10-i, COLOR_BLACK);
			
		}
		//        LcdDrawFixedString(&bounds, "Calibrate Right Top    ", COLOR_BLACK, COLOR_WHITE, SMALL_FONT, NO_DOTDOT, 0);
		printf("\n\tCalibrate Right Top    ");
		while (TtpGetxy(&x2, &y2)==PENUP);
		while (TtpGetxy(&i, &i)==PENDOWN);
		printf("done");
        Delay(0x10000);
		
		
		
		
        ClearScreen();
		
		//        LcdInit();
		
		
		
		
		for (i=0; i<10;i++)   /* x3, y3 */
		{
            LcdSetPixel(158+0, i+150, COLOR_BLACK);
            LcdSetPixel(158+1, i+150, COLOR_BLACK);
            LcdSetPixel(150+i, 158+0, COLOR_BLACK);
            LcdSetPixel(150+i, 158+1, COLOR_BLACK);
			LcdSetPixel(150+i, 150+i, COLOR_BLACK);
		}
		//        LcdDrawFixedString(&bounds, "Calibrate Right Bottom " , COLOR_BLACK, COLOR_WHITE, SMALL_FONT, NO_DOTDOT, 0);
		
		printf("\n\tCalibrate Right Bottom ");
		while (TtpGetxy(&x3, &y3)==PENUP);
		while (TtpGetxy(&i, &i)==PENDOWN);
		printf("done");
        Delay(0x10000);
		
		
		
        ClearScreen();
		
		//        LcdInit();
		
		
		
		
		
        for (i=0; i<10;i++)   /* x4, y4 */
		{
			LcdSetPixel(0, i+150, COLOR_BLACK);
			LcdSetPixel(1, i+150, COLOR_BLACK);
            LcdSetPixel(i, 0+158, COLOR_BLACK);
            LcdSetPixel(i, 1+158, COLOR_BLACK);
            LcdSetPixel(10-i, i+150, COLOR_BLACK);
		}
		
		
		
		
		//        LcdDrawFixedString(&bounds, "Calibrate Left  Bottom ", COLOR_BLACK, COLOR_WHITE, SMALL_FONT, NO_DOTDOT, 0);
		
		printf("\n\tCalibrate Left  Bottom ");
		while (TtpGetxy(&x4, &y4)==PENUP);
		while (TtpGetxy(&i, &i)==PENDOWN);
		printf("done");
        Delay(0x10000);
		
		
		
		
        ClearScreen();
		
		//        LcdInit();
		
		
		
		
		
		
		CPU->REG_SIB_SF0_CTRL =  BETTY_INT_CLEAR|BTY_WRT ;
		Delay(0x1ff);
		BtyClearSF0Int();	/* clear all interrupt */
		BtyWaitSF0Int();
		
		CPU->REG_SIB_SF0_CTRL =  BETTY_INT_CLEAR|0xffff|BTY_WRT ;
		Delay(0x1ff);
		BtyClearSF0Int();	/* clear all interrupt */
		BtyWaitSF0Int();
		
		pen_xy_exchange=99;
		
		if (Iabs(y1-y2) <20)   /* no rotation is required */
		{
			pen_xy_exchange=0;
		}
		else
            if (Iabs(x1-x2) <20)
			{
				pen_xy_exchange=1;
			}
			
			if(pen_xy_exchange==0)
			{
				PenMinX=(x1+x4)>>1;
				PenMinY=(y1+y2)>>1;
				PenMaxX=(x3+x2)>>1;
				PenMaxY=(y3+y4)>>1;
			}
			else
				if(pen_xy_exchange==1)
				{
					PenMinX=(y1+y4)>>1;
					PenMinY=(x1+x2)>>1;
					PenMaxX=(y3+y2)>>1;
					PenMaxY=(x4+x3)>>1;
				}
	}
	
	
    if ( (PenMinX==PenMaxX) || (PenMinY==PenMaxY))
        pen_xy_exchange=99;
	
	
	
    printf("\n\n1: %d %d    2: %d %d    3: %d %d    4: %d %d",
		x1,y1, x2,y2, x3,y3, x4,y4);
	
    printf("\n Min(%d,%d), Max(%d,%d)    xy-axis exchange :  %d  \n\n", PenMinX, PenMinY, PenMaxX, PenMaxY, pen_xy_exchange);
	
	
#endif
	
	
}

WORD TtpGetx()
{
	WORD cor_x;
	/* read X */
	
	BtyClearSF0Int();
	BtyWaitSF0Int();
	
	CPU->REG_SIB_SF0_CTRL = BETTY_TS_CTRL |BTY_TSMY_POW |BTY_TSPY_GND |BTY_TSC_MODE(2) |BTY_TSC_BIAS_ENA |BTY_WRT;
	
	Delay(0x100);
	
	/* start AD conversion */
	BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
	
    CPU->REG_SIB_SF0_CTRL = BETTY_ADC_CTRL |BTY_WRT;
	
	Delay(0xffff);
	
	BtyClearSF0Int();
	BtyWaitSF0Int();
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
    CPU->REG_SIB_SF0_CTRL = BETTY_ADC_CTRL |BTY_VREFBYP_CON |BTY_ADC_ENA |BTY_ADC_START |BTY_WRT| TTP_ADC_MX;
    BtyClearSF0Int();
	BtyWaitSF0Int();
	
	
	Delay(0xffff);
	
	BtyClearSF0Int();	   /* wait one frame */
	BtyWaitSF0Int();
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
	
	BtyClearSF0Int();	   /*  Read Request  */
	BtyWaitSF0Int();
	CPU->REG_SIB_SF0_CTRL = BETTY_ADC_DATA	;
	
	Delay(0xffff);
	
	BtyClearSF0Int();	   /* wait for frame 0 */
	BtyWaitSF0Int();
	
	BtyClearSF0Int();	   /* wait for frame 0 */
	BtyWaitSF0Int();
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
	
	while( !(((CPU->REG_SIB_SF0_STATUS)>>15)&0x1) ) ;	 /* wait for ADC complete */
	
	BtyClearSF0Int();	   /* obtain X coordinate */
	BtyWaitSF0Int();
	cor_x=((CPU->REG_SIB_SF0_STATUS)>>5) &0x3FF ;
	return cor_x;
}

WORD TtpGety()
{
	WORD cor_y;
	/* read Y */
	
	BtyClearSF0Int();
	BtyWaitSF0Int();
	
	CPU->REG_SIB_SF0_CTRL = BETTY_TS_CTRL |BTY_TSMX_GND |BTY_TSPX_POW |BTY_TSC_MODE(2) |BTY_TSC_BIAS_ENA |BTY_WRT;
	Delay(0x100);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
	
	/* start AD conversion */
	BtyClearSF0Int();
	BtyWaitSF0Int();
	CPU->REG_SIB_SF0_CTRL = BETTY_ADC_CTRL |BTY_WRT;
	
	Delay(0xffff);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
	
	BtyClearSF0Int();
	BtyWaitSF0Int();
	CPU->REG_SIB_SF0_CTRL = BETTY_ADC_CTRL |BTY_VREFBYP_CON |BTY_ADC_ENA |BTY_ADC_START |BTY_WRT| TTP_ADC_MY;
	
	Delay(0xffff);
	BtyClearSF0Int();	   /* wait one frame */
	BtyWaitSF0Int();
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
	
	BtyClearSF0Int();	   /*  Read Request  */
	BtyWaitSF0Int();
	CPU->REG_SIB_SF0_CTRL = BETTY_ADC_DATA ;
	Delay(0xffff);
    BtyClearSF0Int();
	BtyWaitSF0Int();
    Delay(0x100);
	
	BtyClearSF0Int();	   /* wait for frame 0 */
	BtyWaitSF0Int();
	
	BtyClearSF0Int();	   /* wait for frame 0 */
	BtyWaitSF0Int();
	
	while( !(((CPU->REG_SIB_SF0_STATUS)>>15)&0x1) ) ;	 /* wait for ADC complete */
	
	BtyClearSF0Int();	   /* obtain Y coordinate */
	BtyWaitSF0Int();
	cor_y=((CPU->REG_SIB_SF0_STATUS)>>5) &0x3FF ;
	
	return cor_y;
}

void TtpSetPenChkMode()
{
	BtyClearSF0Int();
	BtyWaitSF0Int();
	CPU->REG_SIB_SF0_CTRL = BETTY_TS_CTRL |BTY_TSMX_POW |BTY_TSPX_POW |BTY_TSMY_GND |BTY_TSPY_GND |BTY_TSC_MODE(0) |BTY_WRT;
	
	Delay(0x100);
	
	BtyClearSF0Int();	   /*  Read Request  */
	BtyWaitSF0Int();
	CPU->REG_SIB_SF0_CTRL = BETTY_TS_CTRL  ;
	
	BtyClearSF0Int();
	BtyWaitSF0Int();
}

WORD TtpGetxy(WORD *cor_x, WORD *cor_y)
{
	TtpSetPenChkMode();
	
	if (((CPU->REG_SIB_SF0_STATUS)>>12) & 0x1)	 return (PENUP);
	
	*cor_x = TtpGetx();
	
	*cor_y = TtpGety();
	
	TtpSetPenChkMode();
	if (((CPU->REG_SIB_SF0_STATUS)>>12) & 0x1)	 return (PENUP);
	
	return (PENDOWN);
}
#endif
