/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   cp0.s
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Coprocessor registers read and write routine (ASM language)
Revision    :   1.1
Note        :   None
===========================================================================
*/              




#include "pr3910.h"

#define FRAME(name,frm_reg,offset,ret_reg)	\
    .globl name;							\
    .ent name;								\
name:;										\
    .frame frm_reg,offset,ret_reg			\

#define ENDFRAME(name)						\
    .end name

	.text
FRAME(CP0ReadCauseReg, sp, 0, ra)
	mfc0	v0, C0_CAUSE
	j		ra
ENDFRAME(CP0ReadCauseReg)

FRAME(CP0WriteCauseReg, sp, 0, ra)
	mtc0	a0, C0_CAUSE
	j		ra
ENDFRAME(CP0WriteCauseReg)

FRAME(CP0ReadEPCReg, sp, 0, ra)
	mfc0	v0, C0_EPC
	j		ra
ENDFRAME(CP0ReadEPCReg)

FRAME(CP0WriteEPCReg, sp, 0, ra)
	mtc0	a0, C0_EPC
	j		ra
ENDFRAME(CP0WriteEPCReg)

FRAME(CP0ReadStatusReg, sp, 0, ra)
	mfc0	v0, C0_STATUS
	j		ra
ENDFRAME(CP0ReadStatusReg)

FRAME(CP0WriteStatusReg, sp, 0, ra)
	mtc0	a0, C0_STATUS
	j		ra
ENDFRAME(CP0WriteStatusReg)

FRAME(CP0ReadBadVAddrReg, sp, 0, ra)
	mfc0	v0, C0_BADVADDR
	j		ra
ENDFRAME(CP0ReadBadVAddrReg)

FRAME(CP0WriteBadVAddrReg, sp, 0, ra)
	mtc0	a0, C0_BADVADDR
	j		ra
ENDFRAME(CP0WriteBadVAddrReg)

FRAME(CP0ReadPrIDReg, sp, 0, ra)
	mfc0	v0, C0_PRID
	j		ra
ENDFRAME(CP0ReadPrIDReg)

FRAME(CP0WritePrIDReg, sp, 0, ra)
	mtc0	a0, C0_PRID
	j		ra
ENDFRAME(CP0WritePrIDReg)

FRAME(CP0ReadCacheReg, sp, 0, ra)
	mfc0	v0, C0_CACHE
	j		ra
ENDFRAME(CP0ReadCacheReg)

FRAME(CP0WriteCacheReg, sp, 0, ra)
	mtc0	a0, C0_CACHE
	j		ra
ENDFRAME(CP0WriteCacheReg)

FRAME(CP0ReadConfigReg, sp, 0, ra)
	mfc0	v0, C0_CONFIG
	j		ra
ENDFRAME(CP0ReadConfigReg)

FRAME(CP0WriteConfigReg, sp, 0, ra)
	mtc0	a0, C0_CONFIG
	j		ra
ENDFRAME(CP0WriteConfigReg)

FRAME(CP0ReadContextReg, sp, 0, ra)
	mfc0	v0, C0_CONTEXT
	j		ra
ENDFRAME(CP0ReadContextReg)

FRAME(CP0WriteContextReg, sp, 0, ra)
	mtc0	a0, C0_CONTEXT
	j		ra
ENDFRAME(CP0WriteContextReg)

FRAME(CP0ReadEntryHiReg, sp, 0, ra)
	mfc0	v0, C0_ENTRYHI
    j		ra
ENDFRAME(CP0ReadEntryHiReg)

FRAME(CP0WriteEntryHiReg, sp, 0, ra)
	mtc0	a0, C0_ENTRYHI
    j		ra
ENDFRAME(CP0WriteEntryHiReg)

FRAME(CP0ReadEntryLoReg, sp, 0, ra)
	mfc0	v0, C0_ENTRYLO
	j       ra
ENDFRAME(CP0ReadEntryLoReg)

FRAME(CP0WriteEntryLoReg, sp, 0, ra)
	mtc0	a0, C0_ENTRYLO
	j		ra
ENDFRAME(CP0WriteEntryLoReg)

FRAME(CP0ReadIndexReg, sp, 0, ra)
	mfc0	v0, C0_INDEX
	j		ra
ENDFRAME(CP0ReadIndexReg)

FRAME(CP0WriteIndexReg, sp, 0, ra)
	mtc0	a0, C0_INDEX
	j		ra
ENDFRAME(CP0WriteIndexReg)

FRAME(CP0ReadRandReg, sp, 0, ra)
	.set	noat
	mfc0	v0, C0_RAND
	j		ra
	.set	at
ENDFRAME(CP0ReadRandReg)

FRAME(CP0WriteRandReg, sp, 0, ra)
	.set	noat
	mfc0	a0, C0_RAND
	j		ra
	.set	at
ENDFRAME(CP0WriteRandReg)

