/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   dbinit.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   DB init
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "system.h"

//#define  INIT_DB
//#define  DEBUG

typedef struct _APPOINTMENT_DB
{
	BYTE hour;
	BYTE minute;
	BYTE alarm;
	BYTE alarm_time;
	WORD appointment;
    UWORD appmt_num;
	DatabaseID dbid;
	RecordID recid;
}AppointmentDB;

typedef struct
{
	BYTE	yr;
	BYTE	mon;
	BYTE	day;
	BYTE	hr;
	BYTE	min;
	BYTE	sec;
} VOX_DATE;

#define F_DATE			0
#define F_DATA			1
#define F_STRING		2
#define F_ALARM			3

#define NO_ALARM        0

#define TIME_INDEX_RECID	0x80001001

#ifdef EL32
#undef EL32
#endif
#define EL32(x) 	((x <<24) | ((x &0xff00) <<8) | ((x &0xff0000) >>8) | (x>>24))

/********************************************************
* Function:	AppPhonebookDatabaseInit
* Purpose: 	Init Phonebook Database
* Scope:	application
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AppPhonebookDatabaseInit()
{
	DatabaseID 	pb_dbid;
	RecordID	rec_id;	
	UBYTE		email_cate;
	BYTE 		count, count1;
	BYTE		note[2000];
    WORD        i;
    BYTE        index[7];
    BYTE        selected_item_default;
	
	
	if (DataFindDB(PBDB, &pb_dbid) != TRUE)
	{
		/* New Database */
		DataNewDB(PBDB,1,PBAPP,&pb_dbid);
		DataOpenDB(pb_dbid, 0, OPEN_RW);
		
		/* Open Database */
		DataCategorySetName(pb_dbid,0,SYUNFILED);
		DataCategorySetName(pb_dbid,1,SYBUS);
		DataCategorySetName(pb_dbid,2,SYPER);
		
        /* Record 1*/                                  
        DataNewRecord(pb_dbid,0,31,&rec_id);
		DataWriteField(pb_dbid,rec_id, 0, 12, SY_PB_ACC);
		DataWriteField(pb_dbid,rec_id, 1, 1, (BYTE*)(""));
        DataWriteField(pb_dbid,rec_id, 2, 12, SY_PB_ACC);
		DataWriteField(pb_dbid,rec_id, 3, 22, SY_VTECH);
		DataWriteField(pb_dbid,rec_id, 4, 1, (BYTE*)(""));
		DataWriteField(pb_dbid,rec_id, 5, 17, SY_INFO_TEL); /*TEL*/
		DataWriteField(pb_dbid,rec_id, 6, 15, (BYTE*)("1-877-883-2446")); /*Direct Line*/
		DataWriteField(pb_dbid,rec_id, 7, 1, (BYTE*)("")); /*FAX*/
		DataWriteField(pb_dbid,rec_id, 8, 20, SY_EMAIL1);
		DataWriteField(pb_dbid,rec_id, 9, 18, SY_WEB);
		DataWriteField(pb_dbid,rec_id, 10, 36, SY_ADDR);
		DataWriteField(pb_dbid,rec_id, 11, 10, SY_CITY); /*City*/
		DataWriteField(pb_dbid,rec_id, 12, 3, SY_STATE); /*State*/
		DataWriteField(pb_dbid,rec_id, 13, 6, (BYTE*)("97005")); /*Country*/
		DataWriteField(pb_dbid,rec_id, 14, 4, SY_COU); /*Country*/
		//strcpy(note, SYSTR23);
		DataWriteField(pb_dbid,rec_id, 25, strlen(SYSTR23) + 1, SYSTR23); /*Country*/
		email_cate = 0;
		DataWriteField(pb_dbid,rec_id, 26, 1, (BYTE*)&email_cate);
		
        index[0]=0;
        index[1]=1;
        index[2]=2;
        index[3]=0;
        index[4]=1;
        index[5]=2;
        index[6]=3;
		DataWriteField(pb_dbid,rec_id,27,7,index);
		
		selected_item_default=0;
        DataWriteField(pb_dbid,rec_id,28,1,&selected_item_default);
        DataWriteField(pb_dbid,rec_id,29,(strlen(SY_VTECH) + 1), SY_VTECH);
        DataWriteField(pb_dbid,rec_id,30,(strlen(SY_PB_ACC) + 1), SY_PB_ACC);
		
        DataSetRecordAttribute(pb_dbid, rec_id, ATTR_SET, ATTR_UNCHG, 2);
		DataCloseRecord(pb_dbid,rec_id);
		
		/* Record 2*/
        DataNewRecord(pb_dbid,0,31,&rec_id);
        DataWriteField(pb_dbid,rec_id, 0, 18, SY_PB_TEC);
        DataWriteField(pb_dbid,rec_id, 1, 1, (BYTE*)(""));
        DataWriteField(pb_dbid,rec_id, 2, 18, SY_PB_TEC);
		DataWriteField(pb_dbid,rec_id, 3, 22, SY_VTECH);
		DataWriteField(pb_dbid,rec_id, 4, 1, (BYTE*)(""));
		DataWriteField(pb_dbid,rec_id, 5, 17, SY_HELP_TEL); /*TEL*/
		DataWriteField(pb_dbid,rec_id, 6, 15, (BYTE*)("1-877-883-2443")); /*Direct Line*/
		DataWriteField(pb_dbid,rec_id, 7, 1, (BYTE*)("")); /*FAX*/
		DataWriteField(pb_dbid,rec_id, 8, 26, SY_EMAIL2);
		DataWriteField(pb_dbid,rec_id, 9, 18, SY_WEB);
		DataWriteField(pb_dbid,rec_id, 10, 36, SY_ADDR);
		DataWriteField(pb_dbid,rec_id, 11, 10, SY_CITY); /*City*/
		DataWriteField(pb_dbid,rec_id, 12, 3, SY_STATE); /*State*/
		DataWriteField(pb_dbid,rec_id, 13, 6, (BYTE*)("97005")); /*Country*/
		DataWriteField(pb_dbid,rec_id, 14, 4, SY_COU); /*Country*/
        //strcpy(note, SYSTR24);
		DataWriteField(pb_dbid,rec_id, 25, strlen(SYSTR24) + 1, SYSTR24); /*Country*/
		email_cate = 0;
		DataWriteField(pb_dbid,rec_id, 26, 1, (BYTE*)&email_cate);
		
        index[0]=0;
        index[1]=1;
        index[2]=2;
        index[3]=0;
        index[4]=1;
        index[5]=2;
        index[6]=3;
		DataWriteField(pb_dbid,rec_id,27,7,index);
		selected_item_default=0;
        DataWriteField(pb_dbid,rec_id,28,1,&selected_item_default);
        DataWriteField(pb_dbid,rec_id,29,(strlen(SY_VTECH) + 1), SY_VTECH);
        DataWriteField(pb_dbid,rec_id,29,(strlen(SY_VTECH) + 1), (BYTE*)(SY_VTECH));
        DataWriteField(pb_dbid,rec_id,30,(strlen(SY_PB_TEC) + 1), (BYTE*)(SY_PB_TEC));
        
        DataSetRecordAttribute(pb_dbid, rec_id, ATTR_SET, ATTR_UNCHG, 2);
		DataCloseRecord(pb_dbid,rec_id);
		
		/* Record 3*/
        DataNewRecord(pb_dbid,0,31,&rec_id);
        DataWriteField(pb_dbid,rec_id, 0, 17, SY_PB_CUS);
        DataWriteField(pb_dbid,rec_id, 1, 1, (BYTE*)(""));
        DataWriteField(pb_dbid,rec_id, 2, 17, SY_PB_CUS);
		DataWriteField(pb_dbid,rec_id, 3, 22, SY_VTECH);
		DataWriteField(pb_dbid,rec_id, 4, 1, (BYTE*)(""));
		DataWriteField(pb_dbid,rec_id, 5, 17, SY_INFO_TEL); /*TEL*/
		DataWriteField(pb_dbid,rec_id, 6, 15, (BYTE*)("1-877-883-2446")); /*Direct Line*/
		DataWriteField(pb_dbid,rec_id, 7, 1, (BYTE*)("")); /*FAX*/
		DataWriteField(pb_dbid,rec_id, 8, 26, SY_EMAIL3);
		DataWriteField(pb_dbid,rec_id, 9, 18, SY_WEB);
		DataWriteField(pb_dbid,rec_id, 10, 36, SY_ADDR);
		DataWriteField(pb_dbid,rec_id, 11, 10, SY_CITY); /*City*/
		DataWriteField(pb_dbid,rec_id, 12, 3, SY_STATE); /*State*/
		DataWriteField(pb_dbid,rec_id, 13, 6, (BYTE*)("97005")); /*Country*/
		DataWriteField(pb_dbid,rec_id, 14, 4, SY_COU); /*Country*/
        //strcpy(note, SYSTR25);
		DataWriteField(pb_dbid,rec_id, 25, strlen(SYSTR25) + 1, SYSTR25); /*Country*/
		email_cate = 0;
		DataWriteField(pb_dbid,rec_id, 26, 1, (BYTE*)&email_cate);
		
        index[0]=0;
        index[1]=1;
        index[2]=2;
        index[3]=0;
        index[4]=1;
        index[5]=2;
        index[6]=3;
		DataWriteField(pb_dbid,rec_id,27,7,index);
		selected_item_default=0;
        DataWriteField(pb_dbid,rec_id,28,1,&selected_item_default);    
        DataWriteField(pb_dbid,rec_id,29,(strlen(SY_VTECH) + 1), SY_VTECH);
        DataWriteField(pb_dbid,rec_id,30,(strlen(SY_PB_CUS) + 1), SY_PB_CUS);
		
        DataSetRecordAttribute(pb_dbid, rec_id, ATTR_SET, ATTR_UNCHG, 2);
		DataCloseRecord(pb_dbid,rec_id);
		
		
		for (count = 0; count < 3; count++)
		{
            DataOpenRecord(pb_dbid, count, &rec_id, NULL);
            for (count1 = 15; count1 <= 24; count1 ++) 
				DataWriteField(pb_dbid, rec_id, count1, 1, (BYTE*)(""));
			DataCloseRecord(pb_dbid, rec_id);
		}
        DataCloseDB(pb_dbid);
    }
	
}

/********************************************************
* Function:	AppEmailDatabaseInit
* Purpose: 	Init Email Database
* Scope:	application
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AppEmailDatabaseInit()
{
    DatabaseID  email_dbid, emess_dbid, message_id_dbid;
	RecordID	rec_id;
	BYTE		date[20], to[100], cc[100], bcc[100], from[100], sub[100], body[4000];
	WORD 		time_index;
	
    /* Check message_id_dbid*/
    if (DataFindDB(MSGIDDB, &message_id_dbid) != TRUE)
	{
		/* New Database */
        DataNewDB(MSGIDDB,1,EMAILAPP,&message_id_dbid);
	}
	
	
	/* Check email_dbid */
	if (DataFindDB(EMAILDB, &email_dbid) != TRUE)
	{
		/* New Database */
		DataNewDB(EMAILDB,1,EMAILAPP,&email_dbid);
        DataOpenDB(email_dbid, 0, OPEN_RW);
		
		/* Open Database */
		DataCategorySetName(email_dbid,0,SYUNFILED);
		DataCategorySetName(email_dbid,1,SYBUS);
		DataCategorySetName(email_dbid,2,SYPER);
        DataCloseDB(email_dbid);
	}
	
	/* Check emess_dbid */
	if (DataFindDB(EMAILMSGDB, &emess_dbid) != TRUE)
	{
		/* New Database */
        DataNewDB(EMAILMSGDB,1,EMAILAPP,&emess_dbid);
        DataOpenDB(emess_dbid, 0, OPEN_RW);
		
		/* Open Database */
		DataCategorySetName(emess_dbid,0,(BYTE*)(""));
		DataCategorySetName(emess_dbid,1,SYINBOX);
		DataCategorySetName(emess_dbid,2,SYOUTBOX);
		DataCategorySetName(emess_dbid,3,SYSENT);
		DataCategorySetName(emess_dbid,4,SYDRAFT);
		
		/* Record 1 */
		//DataNewRecord(emess_dbid, 1, 9, &rec_id);
		DataNewRecord(emess_dbid, 1, 8, &rec_id);
        strcpy(date, (BYTE*)("20000301000000"));
		DataWriteField(emess_dbid,rec_id,0, strlen(date) + 1, date);
		DataWriteField(emess_dbid,rec_id,1,1, (BYTE*)(""));
        strcpy(from, SY_EMAIL4);
		DataWriteField(emess_dbid,rec_id,2,(strlen(from) + 1), from);
        strcpy(to, SY_EMAIL5);
		DataWriteField(emess_dbid,rec_id,3,(strlen(to) + 1), to);
		strcpy(cc, (BYTE*)(""));
		DataWriteField(emess_dbid,rec_id,4,(strlen(cc) + 1), cc);
		strcpy(bcc, (BYTE*)(""));
		DataWriteField(emess_dbid,rec_id,5,(strlen(bcc) + 1),bcc);
		strcpy(sub, SYSTR21);
		DataWriteField(emess_dbid,rec_id,6,(strlen(sub) + 1), sub);
        //strcpy(body,SYSTR26);
		DataWriteField(emess_dbid,rec_id,7,(strlen(SYSTR26) + 1), SYSTR26);
		DataCloseRecord(emess_dbid,rec_id);
		
		DataNewRecordWithID(emess_dbid, TIME_INDEX_RECID, 0, 4);
		
		/* inbox time index */
		time_index = 1;
		time_index = EL32(time_index);
		DataWriteField(emess_dbid, TIME_INDEX_RECID, 0, 4, (BYTE*) &time_index);
		
		/* outbox time index */
		time_index = 0;
		time_index = EL32(time_index);
		DataWriteField(emess_dbid, TIME_INDEX_RECID, 1, 4, (BYTE*) &time_index);
		
		/* sent time index */
		time_index = 0;
		time_index = EL32(time_index);
		DataWriteField(emess_dbid, TIME_INDEX_RECID, 2, 4, (BYTE*) &time_index);
		
		/* draft time index */
		time_index = 0;
		time_index = EL32(time_index);
		DataWriteField(emess_dbid, TIME_INDEX_RECID, 3, 4, (BYTE*) &time_index);
		
        DataCloseDB(emess_dbid);
	}
}

/*****************************************************************
* Function:	AppExpenseDatabaseInit
* Purpose: 	Init Expense Database
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	This function should be called in the StartApplication() function.
*****************************************************************/
void AppExpenseDatabaseInit()
{
	DatabaseID		Expense_dbid, Expense_type_dbid;
    Err             Error;
	BYTE			curr_to_cat;
	WORD			i;
	RecordID		Expense_type_rec_id;
	
	
	/* New Database */
	if (DataFindDB(EXPDB, &Expense_dbid) != TRUE)
    {
        Error = DataNewDB(EXPDB, 0, EXPAPP, &Expense_dbid);
        DataOpenDB(Expense_dbid, 0, OPEN_RW);
		
		
		if (DataNewRecordWithID(Expense_dbid, 0x80001000, 0, 50) != TRUE)
			return;
		
		curr_to_cat = DEFAULT_CURR;
		for(i=0; i<50; i++)
			if (DataWriteField(Expense_dbid, 0x80001000, (USHORT)i, sizeof(BYTE), &curr_to_cat) != TRUE)
				return;
			
			/* Open Database */
			DataCategorySetName(Expense_dbid,0,SYUNFILED);
			DataCategorySetName(Expense_dbid,1,SYBUS);
			DataCategorySetName(Expense_dbid,2,SYPER);
			DataCloseDB(Expense_dbid);
    }
    
    
    if (DataFindDB(EXPTYPEDB, &Expense_type_dbid) != TRUE)
	{
		Error = DataNewDB(EXPTYPEDB, 0, EXPAPP, &Expense_type_dbid);
        DataOpenDB(Expense_type_dbid, 0, OPEN_RW);
		
        DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP1) + 1, SY_EXP1);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP2) + 1, SY_EXP2);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP3) + 1, SY_EXP3);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP4) + 1, SY_EXP4);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP5) + 1, SY_EXP5);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP6) + 1, SY_EXP6);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP7) + 1, SY_EXP7);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP8) + 1, SY_EXP8);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP9) + 1, SY_EXP9);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP10) + 1, SY_EXP10);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP11) + 1, SY_EXP11);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP12) + 1, SY_EXP12);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP13) + 1, SY_EXP13);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP14) + 1, SY_EXP14);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP15) + 1, SY_EXP15);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP16) + 1, SY_EXP16);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP17) + 1, SY_EXP17);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP18) + 1, SY_EXP18);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP19) + 1, SY_EXP19);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP20) + 1, SY_EXP20);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP21) + 1, SY_EXP21);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP22) + 1, SY_EXP22);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP23) + 1, SY_EXP23);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP24) + 1, SY_EXP24);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP25) + 1, SY_EXP25);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP26) + 1, SY_EXP26);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataNewRecord(Expense_type_dbid, 0, 2, &Expense_type_rec_id);
		DataWriteField(Expense_type_dbid, Expense_type_rec_id, 0, strlen(SY_EXP27) + 1, SY_EXP27);
		DataCloseRecord(Expense_type_dbid, Expense_type_rec_id);
		
		DataCloseDB(Expense_type_dbid);    
	}		
}


/********************************************************
* Function:	AppSchedulerDatabaseInit
* Purpose: 	Init Scheduler Database
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AppSchedulerDatabaseInit()
{
    DatabaseID  sch_appmt_dbid, sch_voice_dbid, sch_repeat_dbid, sch_except_dbid;
	
	if (DataFindDB(SCHAPPDB, &sch_appmt_dbid) != TRUE)
		DataNewDB(SCHAPPDB,1,SCHAPP,&sch_appmt_dbid);
	if (DataFindDB(SCHVOICEDB, &sch_voice_dbid) != TRUE)
		DataNewDB(SCHVOICEDB,1,SCHAPP,&sch_voice_dbid);
	
	
	if (DataFindDB(SCHREPDB, &sch_repeat_dbid) != TRUE)
		DataNewDB(SCHREPDB,1,SCHAPP,&sch_repeat_dbid);
	
	if (DataFindDB(SCHEXCEPTDB, &sch_except_dbid) != TRUE)
		DataNewDB(SCHEXCEPTDB, 1, SCHAPP, &sch_except_dbid);
}

/********************************************************
* Function:	AppToDoDatabaseInit
* Purpose: 	Init ToDo Database
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AppToDoDatabaseInit()
{
	DatabaseID	tdl_dbid, sound_dbid;
    BYTE        temp, content[4000];
    RecordID    rec_id;
	
	
    if (DataFindDB(TODODB, &tdl_dbid) != TRUE)
    {		
		DataNewDB(TODODB,0,TODOAPP,&tdl_dbid);
		DataOpenDB(tdl_dbid, 1, OPEN_RW);	
		
		
		/* Record 1 */
		DataNewRecord(tdl_dbid,0,7,&rec_id);
		temp = 0;
		DataWriteField(tdl_dbid,rec_id, 0, 1,  (BYTE*)&temp);
		temp = 0;
		DataWriteField(tdl_dbid,rec_id, 1, 1,  (BYTE*)&temp);
		temp = 1;
		DataWriteField(tdl_dbid,rec_id, 2, 1,  (BYTE*)&temp);
		//strcpy(content, SYSTR27);
		DataWriteField(tdl_dbid,rec_id, 3, strlen(SYSTR27) + 1,  SYSTR27);
		//strcpy(content, (BYTE*)("2000/03/01"));
		DataWriteField(tdl_dbid,rec_id, 4, strlen("2000/03/01") + 1,  "2000/03/01");
		//strcpy(content, (BYTE*)(""));
		DataWriteField(tdl_dbid,rec_id, 5, strlen("") + 1,  "");
		DataWriteField(tdl_dbid,rec_id, 6, sizeof(RecordID),  (BYTE*)&rec_id);
		DataCloseRecord(tdl_dbid, rec_id);
		
		DataCloseDB(tdl_dbid);
    }
    if (DataFindDB(TODOSOUNDDB, &sound_dbid) != TRUE)
        DataNewDB(TODOSOUNDDB,0,TODOAPP,&sound_dbid);
}

/********************************************************
* Function:	AppAnniversariesDatabaseInit
* Purpose: 	Init Anniversaries Database
* Scope:	application/internal
* Input:   None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AppAnniversariesDatabaseInit()
{
	DatabaseID	ann_dbid;
	
    if (DataFindDB(ANNDB, &ann_dbid) != TRUE)
		DataNewDB(ANNDB,1,ANNAPP,&ann_dbid);
}

/********************************************************
* Function:	AppVoxMemoDatabaseInit
* Purpose: 	Init VoxMemo Database
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AppVoxMemoDatabaseInit()
{
	DatabaseID	VoxMemo_dbid;
	RecordID	rec_id;
	UBYTE		CodeData;
	VOX_DATE	date;
	UBYTE		Temp = 0;
	RTM			date_source;
	
	RtcGetTime(&date_source);
	date.sec = (BYTE)date_source.sec;
	date.min = (BYTE)date_source.min;
	date.hr	 = (BYTE)date_source.hour;
	date.day = (BYTE)date_source.mday;
    date.mon = (BYTE)(date_source.mon+1);
	date.yr  = (BYTE)(date_source.year - 1999); 
	
	if (DataFindDB(VOICEDB, &VoxMemo_dbid) != TRUE)
    {
		DataNewDB(VOICEDB, 0, VOICEAPP, &VoxMemo_dbid);
		
		/*        
        DataOpenDB(VoxMemo_dbid, 0, OPEN_RW);    
		
		  if (DataNewRecord(VoxMemo_dbid, 0x01, 4, &rec_id) != TRUE)
		  return FALSE;
		  
			DataWriteField(VoxMemo_dbid, rec_id, 0, sizeof(VOX_DATE), (BYTE*)&date);
			DataWriteField(VoxMemo_dbid, rec_id, 1, 1 * 1024 * 1024, &CodeData);     
			DataWriteField(VoxMemo_dbid, rec_id, 3, 1, &Temp);
			
			  if (DataNewRecord(VoxMemo_dbid, 0x01, 4, &rec_id) != TRUE)
			  return FALSE;
			  
				DataWriteField(VoxMemo_dbid, rec_id, 0, sizeof(VOX_DATE), (BYTE*)&date);
				DataWriteField(VoxMemo_dbid, rec_id, 1, 1 * 1024 * 1024, &CodeData);     
				DataWriteField(VoxMemo_dbid, rec_id, 3, 1, &Temp);
				
				  if (DataNewRecord(VoxMemo_dbid, 0x01, 4, &rec_id) != TRUE)
				  return FALSE;
				  
					DataWriteField(VoxMemo_dbid, rec_id, 0, sizeof(VOX_DATE), (BYTE*)&date);
					DataWriteField(VoxMemo_dbid, rec_id, 1, 1 * 1024 * 1024, &CodeData);     
					DataWriteField(VoxMemo_dbid, rec_id, 3, 1, &Temp);
		*/        
    }
	
	DataCloseDB(VoxMemo_dbid);
}

/********************************************************
* Function:    AppMemoDatabaseInit
* Purpose: 	Init VoxMemo Database
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AppMemoDatabaseInit()
{
	DatabaseID	memo_dbid;	
    BYTE        content[4000];
	BYTE		sketch;
    RecordID    rec_id;
    WORD        length;
	
	if (DataFindDB(MEMODB, &memo_dbid) != TRUE)	
	{
		DataNewDB(MEMODB,1,MEMOAPP,&memo_dbid);
		DataOpenDB(memo_dbid, 1, OPEN_RW);	
		DataCategorySetName(memo_dbid, 0, SYUNFILED);
		DataCategorySetName(memo_dbid, 1, SYBUS);
        DataCategorySetName(memo_dbid, 2, SYPER);      
		
		/* Record 1 */
        DataNewRecord(memo_dbid,0,4,&rec_id);
		sketch = 0;
        DataWriteField(memo_dbid,rec_id, 0, 8,  (BYTE*)&sketch);
        strcpy(content, SYSTR28);
        length = strlen(content);
        content[length] = 174;
        content[length + 1] = 0;
        sprintf(content + length + 1, "%s", SYSTR29);
        DataWriteField(memo_dbid,rec_id, 1, (strlen(content) + 1),  content);
        //strcpy(content, (BYTE*)("2000/03/01"));
		DataWriteField(memo_dbid,rec_id, 2, (strlen("2000/03/01") + 1),  "2000/03/01");
        DataWriteField(memo_dbid,rec_id, 3, 1, (BYTE*)(""));
		DataCloseRecord(memo_dbid,rec_id);
		
		DataCloseDB(memo_dbid);
	}
	
}

/********************************************************
* Function:    AppSketchDatabaseInit
* Purpose:     Init Sketch Database
* Scope:	application/internal
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AppSketchDatabaseInit()
{
    DatabaseID  dbid; 
	
    if (DataFindDB(SKETCHDB, &dbid) != TRUE)
        DataNewDB(SKETCHDB, 0, SKETCHAPP, &dbid);
}

/********************************************************
* Function:	AllApplicationDatabaseInit
* Purpose: 	This function is called to init all database 
* Scope:	application
* Input:	None
* Output:	None
* Return:	None
* Comment: 	None
*********************************************************/
void AllApplicationDatabaseInit()
{
#ifdef DEBUG
    printf("\n =========== Enter DBINIT ===========");
#endif
	
    AppPhonebookDatabaseInit();
    
    AppEmailDatabaseInit();
    
    AppExpenseDatabaseInit();
	
    AppSchedulerDatabaseInit();
    
    AppToDoDatabaseInit();
    
	SySetupDatabaseInit();
	
    AppAnniversariesDatabaseInit();
    
    AppVoxMemoDatabaseInit();
    
    AppMemoDatabaseInit();
    
    AppSketchDatabaseInit();
    
    OpenJotMacroDB();
	
#ifdef DEBUG
    printf("\n =========== Exit DBINIT ===========");
#endif
}



