/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   el.c
Author(s)   :   Garick Ngai
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   EL on and off
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "EL.h"
//#include "qtype.h"
//#include "eventmgr.h"
//#include "msg.h"

//#define DEBUG

volatile UWORD first_on_el;
volatile UWORD en_el_timer;
volatile UWORD are_el_on;

extern WORD CheckBatteryLow();
extern volatile UWORD    el_status_on;
extern SndAction;

void ELInit()
{
	//        CPU->REG_INT_ENABLE_3 |= EL_PIN;
	CPU->REG_MFIO_SEL |= EL_PIN;
	CPU->REG_MFIO_DATA_OUT &= OFF_EL_PIN;
	CPU->REG_MFIO_DIRECTN |= EL_PIN;
	
	en_el_timer = 0;
	first_on_el = 0;
	are_el_on = FALSE;
}


void EnELTimerInt()
{
	en_el_timer = TmrIntEnableIntPen(Time_On_EL, OffEL);
}                       


void DisELTimerInt()
{
    if(en_el_timer != 0)
        TmrIntDisableInt(en_el_timer);
}



void OffEL()
{
	if( are_el_on == TRUE )
	{
#ifdef DEBUG
		printf("\n OffEl are_el_on == TRUE");
#endif
		DisELTimerInt();
		CPU->REG_MFIO_DATA_OUT &= OFF_EL_PIN;
		first_on_el = 0;
		are_el_on = FALSE;
	}
	else
	{
#ifdef DEBUG
		printf("\n OffEl are_el_on == FALSE");
#endif
		CPU->REG_MFIO_DATA_OUT &= OFF_EL_PIN;
		first_on_el = 0;
		are_el_on = FALSE;
	}
#ifdef DEBUG
	printf("\n are_el_on = %x\n",are_el_on);
#endif
	el_status_on = FALSE;
	
}

void ResetELWhenOn()
{
	if( first_on_el != 0 )
	{
		//            printf("Reset the EL Timer\n");
		DisELTimerInt();
		EnELTimerInt();
		are_el_on = TRUE;
	}
}

void OnEL()
{
	
#ifdef SNDMGR_DEBUG
	printf("\n(EL) ---------->>> SndAction=%ld", SndAction);
#endif
	
    if(CheckBatteryLow() == FALSE && (SndAction==SND_STOP || SndAction==SND_PAUSE))
    {
#ifdef SNDMGR_DEBUG
		printf("\n(EL) ---->>> Enter OnEL <<<----");
#endif
        if( first_on_el == 0 )
        {
#ifdef DEBUG
            printf("Enable EL Timer\n");
#endif
            CPU->REG_MFIO_DATA_OUT |= ON_EL_PIN;
            EnELTimerInt();
            first_on_el++;
            are_el_on = TRUE;
        }
        else
        {
#ifdef DEBUG
            printf("Reset the EL Timer\n");
#endif
            DisELTimerInt();
            EnELTimerInt();
        }
	}       
#ifdef DEBUG
    printf("EL On\n");
#endif
}


void ELState(UWORD *elstate)
{
	//     printf("\n are_el_on = %x\n",are_el_on);
    *elstate = are_el_on;
}


void CheckEL()
{
	if( first_on_el == 0 )
	{
		//            printf("EL Without On\n");
	}
	else
	{
		printf("Reset the EL Timer\n");
		DisELTimerInt();
		EnELTimerInt();
	}
}

