/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   font.c
Author(s)   :   Henry Fok, thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   font
Revision    :   1.1
Note        :   None
===========================================================================
*/              

#include "stdafx.h"
#include "font.h"

const BYTE* 	FontWidth;
const USHORT* 	Font1;
const USHORT* 	Font2;
const USHORT* 	Font3;


BYTE FONT_HEIGHT[NUM_OF_FONTS] = {FONT_1_HEIGHT,FONT_2_HEIGHT,FONT_3_HEIGHT };

const BYTE SYS_FONT_WIDTH[NUM_OF_FONTS][NUM_OF_CHARS] =
	{
		{ 0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		  1,1,3,7,5,7,6,1,3,3,5,5,2,3,1,3,
		  4,2,4,4,5,4,4,3,4,4,1,2,4,5,4,4,
		  7,4,4,4,4,3,3,4,4,1,4,4,4,5,5,4,
          4,5,4,4,3,4,5,7,5,5,4,3,3,3,7,7,
		  2,3,3,3,3,3,3,3,3,1,3,3,1,5,3,3,
          3,3,3,3,3,4,3,5,3,3,3,3,1,3,6,6,

		  5,5,0,4,0,0,3,3,3,9,5,0,6,5,7,4,
          7,2,2,4,4,0,0,0,4,9,4,0,5,5,6,5,
		  0,1,4,5,5,5,0,5,3,7,3,6,0,0,7,0,
		  3,3,0,0,0,4,0,0,0,0,3,6,0,0,0,4,
		  4,4,4,5,4,4,6,4,3,3,3,3,2,2,3,3,
		  5,4,4,4,4,4,4,0,7,4,4,4,4,5,4,5,
		  3,3,3,4,3,3,5,3,3,3,3,3,2,2,3,3,
		  0,4,3,3,3,4,3,3,6,3,3,3,3,3,3,3 },
		{
		  0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,   /*  0 - 15*/
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		  1,1,5,7,5,7,8,2,3,3,7,7,2,3,2,3,
		  5,2,5,5,6,5,5,4,5,5,2,2,5,6,5,5,
		  9,5,5,5,5,4,4,5,5,1,5,5,5,7,6,5,
		  5,6,5,5,5,5,5,9,5,5,5,3,3,3,9,7,
		  2,4,4,4,4,4,4,4,4,1,3,4,1,5,4,4,
		  4,4,3,4,4,4,5,7,5,4,4,3,1,3,6,8,

		  6,6,0,5,0,0,5,5,3,9,5,0,8,6,9,5,
		  9,2,2,5,5,0,0,0,4,10,4,0,7,5,6,5,
		  0,1,4,6,8,7,0,5,3,7,4,7,0,0,7,0,
		  3,5,0,0,0,5,0,0,0,0,4,7,0,0,0,5,
		  4,4,4,5,4,4,8,4,3,3,3,3,2,2,3,3,
		  6,5,4,4,4,4,4,0,7,4,4,4,4,5,4,6,
		  4,4,4,4,4,4,7,3,4,4,4,4,2,2,3,3,
		  0,4,4,4,4,4,4,5,6,4,4,4,4,4,3,4 },
		{
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		  1,0,0,0,0,0,0,0,0,0,0,0,2,6,2,0,
		  8,8,8,8,8,8,8,8,8,8,0,0,0,0,0,0,
		  0,8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,

		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
	};


const USHORT SYS_FONT_1[NUM_OF_CHARS][FONT_1_HEIGHT] =
{												/* ASCII CODE */
	{ 0,0,0,0,0,0,0,0 },                     	/*  0  */
	{ 0,0,0,0,0,0,0,0 },                     	/*  1  */
	{ 0,0,0,0,0,0,0,0 },                     	/*  2  */
	{ 0,0,0,0,0,0,0,0 },                     	/*  3  */
	{ 0,0,0,0,0,0,0,0 },                     	/*  4  */
	{ 0,0,0,0,0,0,0,0 },                     	/*  5  */
	{ 0,0,0,0,0,0,0,0 },                     	/*  6  */
	{ 0,0,0,0,0,0,0,0 },                     	/*  7  */
    { 0,0,0,0,0,0,0,0 },                     	/*  8  */
    { 0,0,0,0,0,0,0,0 },                     	/*  9  */
	{ 0,0,0,0,0,0,0,0 },                     	/*  A  */
	{ 0,0,0,0,0,0,0,0 },                     	/*  B  */
    { 0,0,0,0,0,0,0,0 },                     	/*  C  */
	{ 0,0,0,0,0,0,0,0 },                     	/*  D  */
	{ 0,0,0,0,0,0,0,0 },                     	/*  E  */
	{ 0,0,0,0,0,0,0,0 },                     	/*  F  */
	{ 0,0,0,0,0,0,0,0 },                     	/* 10  */
	{ 0,0,0,0,0,0,0,0 },                     	/* 11  */
	{ 0,0,0,0,0,0,0,0 },                     	/* 12  */
    { 0,0,0,0,0,0,0,0 },                     	/* 13  */
    { 0,0,0,0,0,0,0,0 },                     	/* 14  */
    { 0,0,0,0,0,0,0,0 },                     	/* 15  */
	{ 0,0,0,0,0,0,0,0 },                     	/* 16  */
	{ 0,0,0,0,0,0,0,0 },                     	/* 17  */
	{ 0,0,0,0,0,0,0,0 },                     	/* 18  */
    { 0,0,0,0,0,0,0,0 },                     	/* 19  */
    { 0,0,0,0,0,0,0,0 },                     	/* 1A  */
    { 0,0,0,0,0,0,0,0 },                     	/* 1B  */
	{ 0,0,0,0,0,0,0,0 },                     	/* 1C  */
	{ 0,0,0,0,0,0,0,0 },                     	/* 1D  */
	{ 0,0,0,0,0,0,0,0 },                     	/* 1E  */
	{ 0,0,0,0,0,0,0,0 },						/* 1F  */
	{ 0,0,0,0,0,0,0,0 },						/* 20  */
	{ 0x8000,0x8000,0x8000,0x8000,0x8000,0x0000,0x8000,0x0000 },	/* 21  */
	{ 0xA000,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 22  */
	{ 0x1400,0x1400,0x7E00,0x2800,0xFC00,0x5000,0x5000,0x0000 },	/* 23  */
	{ 0x2000,0x7000,0xA000,0x7000,0x2800,0x7000,0x2000,0x0000 },	/* 24  */
	{ 0x4400,0xA400,0xA800,0x5400,0x2A00,0x4A00,0x4400,0x0000 },	/* 25  */
	{ 0x3000,0x4800,0x5000,0x2000,0x5400,0x8800,0x7400,0x0000 },	/* 26  */
	{ 0x8000,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 27  */
	{ 0x2000,0x4000,0x8000,0x8000,0x8000,0x4000,0x2000,0x0000 },	/* 28  */
	{ 0x8000,0x4000,0x2000,0x2000,0x2000,0x4000,0x8000,0x0000 },	/* 29  */
	{ 0x8800,0x5000,0x2000,0xD800,0x2000,0x5000,0x8800,0x0000 },	/* 2A  */
	{ 0x0000,0x2000,0x2000,0xF800,0x2000,0x2000,0x0000,0x0000 },	/* 2B  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x8000 },	/* 2C  */
	{ 0x0000,0x0000,0x0000,0xE000,0x0000,0x0000,0x0000,0x0000 },	/* 2D  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8000,0x0000 },	/* 2E  */
	{ 0x0000,0x2000,0x2000,0x4000,0x4000,0x8000,0x8000,0x0000 },	/* 2F  */
	{ 0x6000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },	/* 30  */
	{ 0xC000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },	/* 31  */
	{ 0x6000,0x9000,0x1000,0x2000,0x4000,0x8000,0xF000,0x0000 },	/* 32  */
	{ 0x6000,0x9000,0x1000,0x6000,0x1000,0x9000,0x6000,0x0000 },	/* 33  */
	{ 0x1000,0x3000,0x5000,0x9000,0xF800,0x1000,0x1000,0x0000 },	/* 34  */
	{ 0xF000,0x8000,0x8000,0xE000,0x1000,0x1000,0xE000,0x0000 },	/* 35  */
	{ 0x6000,0x8000,0x8000,0xE000,0x9000,0x9000,0x6000,0x0000 },	/* 36  */
	{ 0xE000,0x2000,0x2000,0x4000,0x4000,0x8000,0x8000,0x0000 },	/* 37  */
	{ 0x6000,0x9000,0x9000,0x6000,0x9000,0x9000,0x6000,0x0000 },	/* 38  */
	{ 0x6000,0x9000,0x9000,0x7000,0x1000,0x1000,0x6000,0x0000 },	/* 39  */
	{ 0x0000,0x0000,0x0000,0x8000,0x0000,0x8000,0x0000,0x0000 },	/* 3A  */
	{ 0x0000,0x0000,0x0000,0x4000,0x0000,0x4000,0x4000,0x8000 },	/* 3B  */
	{ 0x1000,0x2000,0x4000,0x8000,0x4000,0x2000,0x1000,0x0000 },	/* 3C  */
	{ 0x0000,0x0000,0xF800,0x0000,0xF800,0x0000,0x0000,0x0000 },	/* 3D  */
	{ 0x8000,0x4000,0x2000,0x1000,0x2000,0x4000,0x8000,0x0000 },	/* 3E  */
	{ 0x6000,0x9000,0x1000,0x2000,0x2000,0x0000,0x2000,0x0000 },	/* 3F  */
	{ 0x3800,0x4400,0x9A00,0xAA00,0x9400,0x4000,0x3800,0x0000 },	/* 40  */
	{ 0x6000,0x9000,0x9000,0x9000,0xF000,0x9000,0x9000,0x0000 },	/* 41A */
	{ 0xE000,0x9000,0x9000,0xE000,0x9000,0x9000,0xE000,0x0000 },	/* 42B */
	{ 0x6000,0x9000,0x8000,0x8000,0x8000,0x9000,0x6000,0x0000 },	/* 43C */
	{ 0xE000,0x9000,0x9000,0x9000,0x9000,0x9000,0xE000,0x0000 },	/* 44D */
	{ 0xE000,0x8000,0x8000,0xE000,0x8000,0x8000,0xE000,0x0000 },	/* 45E */
	{ 0xE000,0x8000,0x8000,0xE000,0x8000,0x8000,0x8000,0x0000 },	/* 46F */
	{ 0x6000,0x8000,0x8000,0xB000,0x9000,0x9000,0x6000,0x0000 },	/* 47G */
	{ 0x9000,0x9000,0x9000,0xF000,0x9000,0x9000,0x9000,0x0000 },	/* 48H */
	{ 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },	/* 49I */
	{ 0xF000,0x2000,0x2000,0x2000,0xA000,0xA000,0x4000,0x0000 },	/* 4AJ */
	{ 0x9000,0xA000,0xC000,0x8000,0xC000,0xA000,0x9000,0x0000 },	/* 4BK */
	{ 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xF000,0x0000 },	/* 4CL */
	{ 0x8800,0xD800,0xA800,0xA800,0x8800,0x8800,0x8800,0x0000 },	/* 4DM */
	{ 0x8800,0xC800,0xC800,0xA800,0x9800,0x9800,0x8800,0x0000 },	/* 4EN */
	{ 0x6000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },	/* 4FO */
	{ 0xE000,0x9000,0x9000,0xE000,0x8000,0x8000,0x8000,0x0000 },	/* 50P */
	{ 0x6000,0x9000,0x9000,0x9000,0xB000,0x9000,0x6800,0x0000 },	/* 51Q */
	{ 0xE000,0x9000,0x9000,0xE000,0x9000,0x9000,0x9000,0x0000 },	/* 52R */
	{ 0x7000,0x8000,0x8000,0x6000,0x1000,0x1000,0xE000,0x0000 },	/* 53S */
	{ 0xE000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },	/* 54T */
	{ 0x9000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },	/* 55U */
	{ 0x8800,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x0000 },	/* 56V */
    { 0x9200,0x9200,0x9200,0xAA00,0xAA00,0x4400,0x4400,0x0000 },	/* 57W */
	{ 0x8800,0x8800,0x5000,0x2000,0x5000,0x8800,0x8800,0x0000 },	/* 58X */
	{ 0x8800,0x8800,0x5000,0x2000,0x2000,0x2000,0x2000,0x0000 },	/* 59Y */
	{ 0xF000,0x1000,0x1000,0x2000,0x4000,0x8000,0xF000,0x0000 },	/* 5AZ */
	{ 0xE000,0x8000,0x8000,0x8000,0x8000,0x8000,0xE000,0x0000 },	/* 5B  */
	{ 0x0000,0x8000,0x8000,0x4000,0x4000,0x2000,0x2000,0x0000 },	/* 5C  */
	{ 0xE000,0x2000,0x2000,0x2000,0x2000,0x2000,0xE000,0x0000 },	/* 5D  */
	{ 0x1000,0x2800,0x4400,0x8200,0x0000,0x0000,0x0000,0x0000 },	/* 5E  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFE00,0x0000 },	/* 5F  */
	{ 0x8000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 60  */
	{ 0x0000,0x0000,0xC000,0x2000,0xE000,0xA000,0xE000,0x0000 },	/* 61a */
	{ 0x8000,0x8000,0xC000,0xA000,0xA000,0xA000,0xC000,0x0000 },	/* 62b */
	{ 0x0000,0x0000,0x6000,0x8000,0x8000,0x8000,0x6000,0x0000 },	/* 63c */
	{ 0x2000,0x2000,0x6000,0xA000,0xA000,0xA000,0x6000,0x0000 },	/* 64d */
	{ 0x0000,0x0000,0x4000,0xA000,0xE000,0x8000,0x6000,0x0000 },	/* 65e */
	{ 0x2000,0x4000,0xE000,0x4000,0x4000,0x4000,0x4000,0x0000 },	/* 66f */
	{ 0x0000,0x0000,0x4000,0xA000,0xA000,0x6000,0x2000,0xC000 },	/* 67g */
	{ 0x8000,0x8000,0xC000,0xA000,0xA000,0xA000,0xA000,0x0000 },	/* 68h */
    { 0x8000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },    /* 69i */
    { 0x2000,0x0000,0x2000,0x2000,0x2000,0xA000,0x4000,0x0000 },    /* 6Aj */
	{ 0x8000,0x8000,0xA000,0xA000,0xC000,0xA000,0xA000,0x0000 },	/* 6Bk */
	{ 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },	/* 6Cl */
	{ 0x0000,0x0000,0xF000,0xA800,0xA800,0xA800,0xA800,0x0000 },	/* 6Dm */
	{ 0x0000,0x0000,0xC000,0xA000,0xA000,0xA000,0xA000,0x0000 },	/* 6En */
	{ 0x0000,0x0000,0x4000,0xA000,0xA000,0xA000,0x4000,0x0000 },	/* 6Fo */
	{ 0x0000,0x0000,0xC000,0xA000,0xA000,0xC000,0x8000,0x8000 },	/* 70p */
	{ 0x0000,0x0000,0x6000,0xA000,0xA000,0x6000,0x2000,0x2000 },	/* 71q */
	{ 0x0000,0x0000,0xA000,0xC000,0x8000,0x8000,0x8000,0x0000 },	/* 72r */
	{ 0x0000,0x0000,0x6000,0x8000,0x4000,0x2000,0xC000,0x0000 },	/* 73s */
	{ 0x4000,0x4000,0xE000,0x4000,0x4000,0x4000,0x2000,0x0000 },	/* 74t */
    { 0x0000,0x0000,0x9000,0x9000,0x9000,0x9000,0x7000,0x0000 },    /* 75u */
	{ 0x0000,0x0000,0xA000,0xA000,0xA000,0x4000,0x4000,0x0000 },	/* 76v */
	{ 0x0000,0x0000,0xA800,0xA800,0xA800,0x5000,0x5000,0x0000 },	/* 77w */
	{ 0x0000,0x0000,0xA000,0xA000,0x4000,0xA000,0xA000,0x0000 },	/* 78x */
	{ 0x0000,0x0000,0xA000,0xA000,0xA000,0x6000,0x2000,0xC000 },	/* 79y */
	{ 0x0000,0x0000,0xE000,0x2000,0x4000,0x8000,0xE000,0x0000 },	/* 7Az */
	{ 0x2000,0x4000,0x4000,0x8000,0x4000,0x4000,0x2000,0x0000 },	/* 7B  */
	{ 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },	/* 7C  */
	{ 0x8000,0x4000,0x4000,0x2000,0x4000,0x4000,0x8000,0x0000 },	/* 7D  */
	{ 0x0000,0x0000,0x6400,0x9800,0x0000,0x0000,0x0000,0x0000 },	/* 7E  */
	{ 0x0C00,0x0800,0x0800,0xD000,0x5000,0x2000,0x2000,0x0000 }, 	/* 7F  */
	{ 0x3800,0x4000,0xF000,0x4000,0xF000,0x4000,0x3800,0x0000 }, 	/* 80  */
	{ 0x7000,0x0800,0x0800,0x7800,0x8800,0x8800,0x7000,0x0000 }, 	/* 81  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 82  */
	{ 0x1000,0x2000,0x7000,0x2000,0x4000,0x4000,0x8000,0x0000 }, 	/* 83  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 84  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 85  */
	{ 0x4000,0xE000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 }, 	/* 86  */
	{ 0x4000,0xE000,0x4000,0x4000,0xE000,0x4000,0x4000,0x0000 }, 	/* 87  */
	{ 0x4000,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 88  */
	{ 0x0000,0x4400,0xA800,0x5000,0x2900,0x5680,0x8900,0x0000 }, 	/* 89  */
	{ 0x5000,0x2000,0x7000,0x8000,0x7000,0x0800,0x0800,0x7000 },	/* 8A  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 8B  */
	{ 0x7B00,0x9000,0x9000,0x9B00,0x9000,0x9000,0x7B00,0x0000 }, 	/* 8C  */
	{ 0x6000,0x9000,0x9000,0xB000,0x8800,0x8800,0xB000,0x0000 }, 	/* 8D  */
	{ 0x3800,0x4400,0x8200,0x8200,0x4400,0x2800,0xEE00,0x0000 }, 	/* 8E  */
	{ 0xF000,0x8000,0x4000,0x2000,0x4000,0x8000,0xF000,0x0000 }, 	/* 8F  */
	{ 0x0000,0x0000,0x7400,0x9A00,0xB200,0x5C00,0x0000,0x0000 }, 	/* 90  */
	{ 0x8000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 91  */
	{ 0x4000,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 92  */
	{ 0x5000,0xA000,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 93  */
	{ 0x5000,0x5000,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 94  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 95  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 96  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 97  */
	{ 0x5000,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 98  */
    { 0x0000,0xE880,0x4D80,0x4A80,0x4A80,0x4A80,0x0000,0x0000 },    /* 99  */
    { 0xA000,0x4000,0x6000,0x8000,0x4000,0x2000,0x9000,0x6000 },    /* 9A  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* 9B  */
	{ 0x0000,0x0000,0x5000,0xA800,0xB800,0xA000,0x5800,0x0000 }, 	/* 9C  */
	{ 0xF800,0x5000,0x5000,0x5000,0x9000,0x9000,0x9000,0x0000 }, 	/* 9D  */
	{ 0x0000,0x6400,0x9800,0x0000,0x6400,0x9800,0x0000,0x0000 }, 	/* 9E  */
	{ 0x5000,0x0000,0x8800,0x5000,0x2000,0x2000,0x2000,0x0000 }, 	/* 9F  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* A0  */
	{ 0x8000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 }, 	/* A1  */
	{ 0x2000,0x7000,0xA000,0xA000,0xA000,0x7000,0x2000,0x0000 }, 	/* A2  */
	{ 0x3800,0x4000,0x4000,0xF000,0x4000,0x4000,0xF800,0x0000 }, 	/* A3  */
	{ 0x0000,0x8800,0x7000,0x5000,0x7000,0x8800,0x0000,0x0000 }, 	/* A4  */
	{ 0x8800,0x5000,0xF800,0x2000,0xF800,0x2000,0x2000,0x0000 }, 	/* A5  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* A6  */
	{ 0x7000,0x8000,0x7000,0x8800,0x7000,0x0800,0x7000,0x0000 }, 	/* A7  */
	{ 0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* A8  */
	{ 0x3800,0x4400,0x9A00,0xA200,0xA200,0x9A00,0x4400,0x3800 }, 	/* A9  */
    { 0xE000,0x2000,0xE000,0xA000,0xE000,0x0000,0xE000,0x0000 },	/* AA  */
	{ 0x0000,0x2400,0x4800,0x9000,0x4800,0x2400,0x0000,0x0000 }, 	/* AB  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* AC  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* AD  */
	{ 0x3800,0x4400,0xB200,0xAA00,0xB200,0xAA00,0x4400,0x3800 }, 	/* AE  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* AF  */
	{ 0x4000,0xA000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* B0  */
	{ 0x0000,0x4000,0xE000,0x4000,0x0000,0xE000,0x0000,0x0000 }, 	/* B1  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* B2  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* B3  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* B4  */
	{ 0x9000,0x9000,0x9000,0xB000,0xD000,0x8000,0x8000,0x0000 }, 	/* B5  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* B6  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* B7  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* B8  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* B9  */
	{ 0x4000,0xA000,0xA000,0xA000,0x4000,0x0000,0xE000,0x0000 }, 	/* BA  */
	{ 0x0000,0x9000,0x4800,0x2400,0x4800,0x9000,0x0000,0x0000 }, 	/* BB  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* BC  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* BD  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* BE  */
	{ 0x4000,0x0000,0x4000,0x4000,0x8000,0x9000,0x6000,0x0000 }, 	/* BF  */
	{ 0x2000,0x1000,0x6000,0x9000,0x9000,0xF000,0x9000,0x0000 }, 	/* C0  */
	{ 0x4000,0x8000,0x6000,0x9000,0x9000,0xF000,0x9000,0x0000 }, 	/* C1  */
	{ 0x2000,0x5000,0x6000,0x9000,0x9000,0xF000,0x9000,0x0000 }, 	/* C2  */
	{ 0x6800,0xB000,0x6000,0x9000,0x9000,0xF000,0x9000,0x0000 }, 	/* C3  */
	{ 0x9000,0x0000,0x6000,0x9000,0x9000,0xF000,0x9000,0x0000 }, 	/* C4  */
	{ 0x6000,0x9000,0x6000,0x6000,0x9000,0xF000,0x9000,0x0000 }, 	/* C5  */
	{ 0x7C00,0x9000,0x9000,0xFC00,0x9000,0x9000,0x9C00,0x0000 }, 	/* C6  */
	{ 0x6000,0x9000,0x8000,0x8000,0x9000,0x6000,0x4000,0x8000 }, 	/* C7  */
	{ 0x4000,0x2000,0xE000,0x8000,0xE000,0x8000,0xE000,0x0000 }, 	/* C8  */
	{ 0x4000,0x8000,0xE000,0x8000,0xE000,0x8000,0xE000,0x0000 }, 	/* C9  */
	{ 0x4000,0xA000,0xE000,0x8000,0xE000,0x8000,0xE000,0x0000 }, 	/* CA  */
	{ 0xA000,0x0000,0xE000,0x8000,0xE000,0x8000,0xE000,0x0000 }, 	/* CB  */
    { 0x8000,0x4000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },    /* CC  */
	{ 0x4000,0x8000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 }, 	/* CD  */
	{ 0x4000,0xA000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 }, 	/* CE  */
	{ 0xA000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 }, 	/* CF  */
	{ 0x7000,0x4800,0x4800,0xE800,0x4800,0x4800,0x7000,0x0000 }, 	/* D0  */
	{ 0x5000,0xA000,0x0000,0x9000,0xD000,0xB000,0x9000,0x0000 }, 	/* D1  */
	{ 0x2000,0x1000,0x6000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* D2  */
	{ 0x4000,0x8000,0x6000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* D3  */
	{ 0x2000,0x5000,0x6000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* D4  */
	{ 0x5000,0xA000,0x6000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* D5  */
	{ 0x9000,0x0000,0x6000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* D6  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* D7  */
	{ 0x3A00,0x4400,0x4C00,0x5400,0x6400,0x4400,0xB800,0x0000 }, 	/* D8  */
	{ 0x4000,0x2000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* D9  */
	{ 0x2000,0x4000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* DA  */
	{ 0x2000,0x5000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* DB  */
	{ 0x9000,0x0000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 }, 	/* DC  */
	{ 0x1000,0x2000,0x8800,0x5000,0x2000,0x2000,0x2000,0x0000 }, 	/* DD  */
	{ 0x8000,0xE000,0x9000,0x9000,0xE000,0x8000,0x8000,0x0000 }, 	/* DE  */
	{ 0x6000,0x9000,0x9000,0xB000,0x8800,0x8800,0xB000,0x0000 }, 	/* DF  */
	{ 0x4000,0x2000,0x0000,0xC000,0x2000,0xE000,0xA000,0xE000 }, 	/* E0  */
	{ 0x4000,0x8000,0x0000,0xC000,0x2000,0xE000,0xA000,0xE000 }, 	/* E1  */
	{ 0x4000,0xA000,0x0000,0xC000,0x2000,0xE000,0xA000,0xE000 }, 	/* E2  */
	{ 0x5000,0xA000,0x0000,0xC000,0x2000,0xE000,0xA000,0xE000 }, 	/* E3  */
	{ 0xA000,0x0000,0x0000,0xC000,0x2000,0xE000,0xA000,0xE000 }, 	/* E4  */
	{ 0x4000,0xA000,0x4000,0xC000,0x2000,0xE000,0xA000,0xE000 }, 	/* E5  */
	{ 0x0000,0x0000,0xD000,0x2800,0xF800,0xA000,0xF800,0x0000 }, 	/* E6  */
    { 0x6000,0x8000,0x8000,0x8000,0x8000,0x6000,0x4000,0x8000 },    /* E7  */
	{ 0x4000,0x2000,0x0000,0x4000,0xA000,0xE000,0x8000,0x6000 }, 	/* E8  */
	{ 0x4000,0x8000,0x0000,0x4000,0xA000,0xE000,0x8000,0x6000 }, 	/* E9  */
	{ 0x4000,0xA000,0x0000,0x4000,0xA000,0xE000,0x8000,0x6000 }, 	/* EA  */
	{ 0x0000,0xA000,0x0000,0x4000,0xA000,0xE000,0x8000,0x6000 }, 	/* EB  */
    { 0x0000,0x8000,0x4000,0x0000,0x8000,0x8000,0x8000,0x8000 },    /* EC  */
	{ 0x0000,0x4000,0x8000,0x0000,0x4000,0x4000,0x4000,0x4000 }, 	/* ED  */
	{ 0x0000,0x4000,0xA000,0x0000,0x4000,0x4000,0x4000,0x4000 }, 	/* EE  */
	{ 0x0000,0xA000,0x0000,0x0000,0x4000,0x4000,0x4000,0x4000 }, 	/* EF  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 }, 	/* F0  */
	{ 0x5000,0xA000,0x0000,0xC000,0xA000,0xA000,0xA000,0xA000 }, 	/* F1  */
	{ 0x4000,0x2000,0x0000,0x4000,0xA000,0xA000,0xA000,0x4000 }, 	/* F2  */
	{ 0x4000,0x8000,0x0000,0x4000,0xA000,0xA000,0xA000,0x4000 }, 	/* F3  */
	{ 0x4000,0xA000,0x0000,0x4000,0xA000,0xA000,0xA000,0x4000 }, 	/* F4  */
	{ 0x5000,0xA000,0x0000,0x4000,0xA000,0xA000,0xA000,0x4000 }, 	/* F5  */
	{ 0xA000,0x0000,0x0000,0x4000,0xA000,0xA000,0xA000,0x4000 }, 	/* F6  */
	{ 0x0000,0x0000,0x4000,0x0000,0xE000,0x0000,0x4000,0x0000 }, 	/* F7  */
	{ 0x0000,0x3400,0x4800,0x5800,0x6800,0x4800,0xB000,0x0000 }, 	/* F8  */
	{ 0x4000,0x2000,0x0000,0xA000,0xA000,0xA000,0xA000,0x4000 }, 	/* F9  */
	{ 0x4000,0x8000,0x0000,0xA000,0xA000,0xA000,0xA000,0x4000 }, 	/* FA  */
	{ 0x4000,0xA000,0x0000,0xA000,0xA000,0xA000,0xA000,0x4000 }, 	/* FB  */
	{ 0xA000,0x0000,0x0000,0xA000,0xA000,0xA000,0xA000,0x4000 }, 	/* FC  */
	{ 0x4000,0x8000,0x0000,0xA000,0xA000,0x6000,0x2000,0xC000 }, 	/* FD  */
	{ 0x0000,0x8000,0xC000,0xA000,0xA000,0xC000,0x8000,0x8000 }, 	/* FE  */
	{ 0x0000,0xA000,0x0000,0xA000,0xA000,0x6000,0x2000,0xC000 } 	/* FF  */
};

const USHORT SYS_FONT_2[NUM_OF_CHARS][FONT_2_HEIGHT] =
{
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	 /*   0   */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   1   */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   2   */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   3   */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0xF000,0x8000,0x8000,0x8000,0xF000,0x0800,0x0800,0x0800,0xF000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   32   */
	{ 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000,0x8000,0x0000 },  /*   33   */
	{ 0x4800,0x9000,0xD800,0xD800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   34   */
	{ 0x1400,0x1400,0x7E00,0x1400,0x2800,0x5000,0xFB00,0x5000,0x5000,0x0000 },  /*   35   */
	{ 0x2000,0x7800,0xA000,0xA000,0x7000,0x2800,0x2800,0xF000,0x2000,0x0000 },  /*   36   */
	{ 0x4200,0xA200,0xA400,0x4800,0x1000,0x2400,0x4B00,0x8B00,0x8400,0x0000 },  /*   37   */
	{ 0x3000,0x4800,0x5000,0x2000,0x5000,0x8A00,0x8400,0x4A00,0x3100,0x0000 },  /*   38   */
	{ 0xc000,0xc000,0x4000,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   39   */
	{ 0x2000,0x4000,0x8000,0x8000,0x8000,0x8000,0x8000,0x4000,0x2000,0x0000 },  /*   40   */
	{ 0x8000,0x4000,0x2000,0x2000,0x2000,0x2000,0x2000,0x4000,0x8000,0x0000 },  /*   41   */
	{ 0x8200,0x4400,0x2800,0x1000,0xEE00,0x1000,0x2800,0x4400,0x8200,0x0000 },  /*   42   */
	{ 0x0000,0x1000,0x1000,0x1000,0xFE00,0x1000,0x1000,0x1000,0x0000,0x0000 },  /*   43   */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xc000,0xc000,0x4000,0x8000 },  /*   44   */
	{ 0x0000,0x0000,0x0000,0x0000,0xE000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   45   */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xc000,0xc000,0x0000 },  /*   46   */
	{ 0x2000,0x2000,0x2000,0x4000,0x4000,0x4000,0x8000,0x8000,0x8000,0x0000 },  /*   47   */
	{ 0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000 },  /*   48   */
	{ 0xC000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },  /*   49   */
	{ 0x7000,0x8800,0x0800,0x1000,0x2000,0x4000,0x8000,0x8000,0xF800,0x0000 },  /*   50   */
	{ 0x7000,0x8800,0x0800,0x0800,0x7000,0x0800,0x0800,0x8800,0x7000,0x0000 },  /*   51   */
	{ 0x0800,0x1800,0x2800,0x4800,0x8800,0xFC00,0x0800,0x0800,0x0800,0x0000 },  /*   52   */
	{ 0xF000,0x8000,0X8000,0x8000,0xF000,0x0800,0x0800,0x0800,0xF000,0x0000 },  /*   53   */
	{ 0x7000,0x8000,0x8000,0x8000,0x7000,0x8800,0x8800,0x8800,0x7000,0x0000 },  /*   54   */
	{ 0xF000,0x1000,0x1000,0x2000,0x2000,0x2000,0x4000,0x4000,0x4000,0x0000 },  /*   55   */
	{ 0x7000,0x8800,0x8800,0x8800,0x7000,0x8800,0x8800,0x8800,0x7000,0x0000 },  /*   56   */
	{ 0x7000,0x8800,0x8800,0x8800,0x7000,0x0800,0x0800,0x0800,0x7000,0x0000 },  /*   57   */
    { 0x0000,0xc000,0xc000,0x0000,0x0000,0xc000,0xc000,0x0000,0x0000,0x0000 },  /*   58   */
    { 0x0000,0x0000,0x0000,0xC000,0xC000,0x0000,0xC000,0xC000,0x4000,0x8000 },  /*   59   */
	{ 0x0800,0x1000,0x2000,0x4000,0x8000,0x4000,0x2000,0x1000,0x0800,0x0000 },  /*   60   */
	{ 0x0000,0x0000,0x0000,0xFC00,0x0000,0xFC00,0x0000,0x0000,0x0000,0x0000 },  /*   61   */
	{ 0x8000,0x4000,0x2000,0x1000,0x0800,0x1000,0x2000,0x4000,0x8000,0x0000 },  /*   62   */
	{ 0x7000,0x8800,0x0800,0x0800,0x1000,0x2000,0x2000,0x0000,0x2000,0x0000 },  /*   63   */
	{ 0x1C00,0x2200,0x5D00,0xA480,0xA480,0xA480,0x5B00,0x2000,0x1C00,0x0000 },  /*   64   */
	{ 0x7000,0x8800,0x8800,0x8800,0x8800,0xF800,0x8800,0x8800,0x8800,0x0000 },  /*   65   */
	{ 0xF000,0x8800,0x8800,0x8800,0xF000,0x8800,0x8800,0x8800,0xF000,0x0000 },  /*   66   */
	{ 0x7000,0x8800,0x8000,0x8000,0x8000,0x8000,0x8000,0x8800,0x7000,0x0000 },  /*   67   */
	{ 0xF000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0xF000,0x0000 },  /*   68   */
	{ 0xF000,0x8000,0x8000,0x8000,0xF000,0x8000,0x8000,0x8000,0xF000,0x0000 },  /*   69   */
	{ 0xF000,0x8000,0x8000,0x8000,0xF000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   70   */
	{ 0x7000,0x8000,0x8000,0x8000,0xB800,0x8800,0x8800,0x8800,0x7000,0x0000 },  /*   71   */
	{ 0x8800,0x8800,0x8800,0x8800,0xF800,0x8800,0x8800,0x8800,0x8800,0x0000 },  /*   72   */
	{ 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   73   */
	{ 0xF800,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x9000,0x6000,0x0000 },  /*   74   */
	{ 0x8800,0x8800,0x9000,0xA000,0xC000,0xA000,0x9000,0x8800,0x8800,0x0000 },  /*   75   */
	{ 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xF800,0x0000 },  /*   76   */
	{ 0x8200,0xC600,0xAA00,0x9200,0x8200,0x8200,0x8200,0x8200,0x8200,0x0000 },  /*   77   */
	{ 0x8400,0xC400,0xC400,0xA400,0xA400,0x9400,0x9400,0x8C00,0x8C00,0x0000 },  /*   78   */
	{ 0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000 },  /*   79   */
	{ 0xF000,0x8800,0x8800,0x8800,0xF000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   80   */
	{ 0x7000,0x8800,0x8800,0x8800,0xC800,0xA800,0x9800,0x8800,0x7400,0x0000 },  /*   81   */
	{ 0xF000,0x8800,0x8800,0x8800,0xF000,0x8800,0x8800,0x8800,0x8800,0x0000 },  /*   82   */
	{ 0x7800,0x8000,0x8000,0x8000,0x7000,0x0800,0x0800,0x0800,0xF000,0x0000 },  /*   83   */
	{ 0xF800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000 },  /*   84   */
	{ 0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000 },  /*   85   */
	{ 0x8800,0x8800,0x8800,0x5000,0x5000,0x5000,0x2000,0x2000,0x2000,0x0000 },  /*   86   */
	{ 0x8880,0x8880,0x8880,0x8880,0x5500,0x5500,0x5500,0x2200,0x2200,0x0000 },  /*   87   */
	{ 0x8800,0x8800,0x8800,0x5000,0x2000,0x5000,0x8800,0x8800,0x8800,0x0000 },  /*   88   */
	{ 0x8800,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x2000,0x2000,0x0000 },  /*   89   */
	{ 0xF800,0x0800,0x0800,0x1000,0x2000,0x4000,0x8000,0x8000,0xF800,0x0000 },  /*   90   */
	{ 0xE000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xE000,0x0000 },  /*   91   */
	{ 0x8000,0x8000,0x8000,0x4000,0x4000,0x4000,0x2000,0x2000,0x2000,0x0000 },  /*   92  */
	{ 0xE000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0xE000,0x0000 },  /*   93   */
	{ 0x0000,0x0800,0x1400,0x2200,0x4100,0x8080,0x0000,0x0000,0x0000,0x0000 },  /*   94   */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFE00,0x0000 },  /*   95   */
	{ 0x8000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   96   */
	{ 0x0000,0x0000,0x0000,0x6000,0x1000,0x7000,0x9000,0x9000,0x7000,0x0000 },  /*   97   */
	{ 0x8000,0x8000,0x8000,0xE000,0x9000,0x9000,0x9000,0x9000,0xE000,0x0000 },  /*   98   */
	{ 0x0000,0x0000,0x0000,0x7000,0x8000,0x8000,0x8000,0x8000,0x7000,0x0000 },  /*   99   */
	{ 0x1000,0x1000,0x1000,0x7000,0x9000,0x9000,0x9000,0x9000,0x7000,0x0000 },  /*   100  */
	{ 0x0000,0x0000,0x0000,0x6000,0x9000,0x9000,0xF000,0x8000,0x7000,0x0000 },  /*   101  */
	{ 0x2000,0x5000,0x4000,0x4000,0xF000,0x4000,0x4000,0x4000,0x4000,0x0000 },  /*   102  */
	{ 0x0000,0x0000,0x0000,0x6000,0x9000,0x9000,0x9000,0x7000,0x1000,0xE000 },  /*   103  */
	{ 0x8000,0x8000,0x8000,0xE000,0x9000,0x9000,0x9000,0x9000,0x9000,0x0000 },  /*   104  */
	{ 0x0000,0x8000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   105  */
	{ 0x0000,0x2000,0x0000,0x2000,0x2000,0x2000,0x2000,0xA000,0x4000,0x0000 },  /*   106  */
	{ 0x8000,0x8000,0x8000,0x9000,0x9000,0xA000,0xC000,0xA000,0x9000,0x0000 },  /*   107  */
	{ 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   108  */
	{ 0x0000,0x0000,0x0000,0xF000,0xA800,0xA800,0xA800,0xA800,0xA800,0x0000 },  /*   109  */
	{ 0x0000,0x0000,0x0000,0xE000,0x9000,0x9000,0x9000,0x9000,0x9000,0x0000 },  /*   110  */
	{ 0x0000,0x0000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   111  */
	{ 0x0000,0x0000,0x0000,0xE000,0x9000,0x9000,0x9000,0xE000,0x8000,0x8000 },  /*   112  */
	{ 0x0000,0x0000,0x0000,0x7000,0x9000,0x9000,0x9000,0x7000,0x1000,0x1000 },  /*   113  */
	{ 0x0000,0x0000,0x0000,0xA000,0xC000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   114  */
	{ 0x0000,0x0000,0x0000,0x6000,0x9000,0x4000,0x2000,0x9000,0x6000,0x0000 },  /*   115  */
	{ 0x0000,0x4000,0x4000,0xF000,0x4000,0x4000,0x4000,0x5000,0x2000,0x0000 },  /*   116  */
	{ 0x0000,0x0000,0x0000,0x9000,0x9000,0x9000,0x9000,0x9000,0x7000,0x0000 },  /*   117  */
	{ 0x0000,0x0000,0x0000,0x8800,0x8800,0x5000,0x5000,0x2000,0x2000,0x0000 },  /*   118  */
	{ 0x0000,0x0000,0x0000,0x8200,0x8200,0x5400,0x5400,0x2800,0x2800,0x0000 },  /*   119  */
	{ 0x0000,0x0000,0x0000,0x8800,0x5000,0x2000,0x2000,0x5000,0x8800,0x0000 },  /*   120  */
	{ 0x0000,0x0000,0x0000,0x9000,0x9000,0x9000,0x9000,0x7000,0x1000,0x6000 },  /*   121  */
	{ 0x0000,0x0000,0x0000,0xF000,0x1000,0x2000,0x4000,0x8000,0xF000,0x0000 },  /*   122  */
	{ 0x2000,0x4000,0x4000,0x4000,0x8000,0x4000,0x4000,0x4000,0x2000,0x0000 },  /*   123  */
	{ 0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000 },  /*   124  */
	{ 0x8000,0x4000,0x4000,0x4000,0x2000,0x4000,0x4000,0x4000,0x8000,0x0000 },  /*   125  */
	{ 0x0000,0x0000,0x0000,0x0000,0x6400,0x9800,0x0000,0x0000,0x0000,0x0000 },  /*   126  */
	{ 0x0000,0x0700,0x0400,0x0800,0x0800,0xD000,0x6000,0x2000,0x2000,0x0000 },  /*   127  */
	{ 0x3800,0x4400,0x4000,0xF800,0x4000,0xF800,0x4000,0x4400,0x3800,0x0000 },  /*   128  */
	{ 0x7800,0x0400,0x0400,0x7B00,0x8400,0x8400,0x8400,0x8400,0x7800,0x0000 },  /*   129  */
	{ 0x0000,0x0000,0x0000,0x6400,0x9800,0x0000,0x6400,0x9800,0x0000,0x0000 },  /*   130  */
	{ 0x1000,0x2800,0x2000,0x7000,0x2000,0x4000,0x4000,0x8000,0x8000,0x0000 },  /*   131  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   132  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   133  */
	{ 0x2000,0x2000,0xF800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000 },  /*   134  */
	{ 0x2000,0x2000,0xF800,0x2000,0x2000,0xF800,0x2000,0x2000,0x2000,0x0000 },  /*   135  */
	{ 0x0000,0x4000,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   136  */
	{ 0x0000,0x4800,0xA800,0x5000,0x1000,0x2000,0x2900,0x5680,0x4900,0x0000 },  /*   137  */
	{ 0x5000,0x2000,0x7800,0x8000,0x8000,0x7000,0x0800,0x0800,0xF000,0x0000 },  /*   138  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   139  */
	{ 0x7F00,0x8800,0x8800,0x8800,0x8F00,0x8800,0x8800,0x8800,0x7F00,0x0000 },  /*   140  */
	{ 0x7000,0x8800,0x8800,0x8800,0x9800,0x8400,0x8400,0x8400,0xB800,0x0000 },  /*   141  */
	{ 0x1e00,0x2200,0x4100,0x8080,0x8080,0x4100,0x2200,0x1400,0x7700,0x0000 },  /*   142  */
	{ 0xF000,0x8000,0x4000,0x2000,0x1000,0x2000,0x4000,0x8000,0xF800,0x0000 },  /*   143  */
	{ 0x0000,0x0000,0x7100,0x8A80,0x8c80,0x9880,0xA880,0x4780,0x0000,0x0000 },  /*   144  */
	{ 0x0000,0x8000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   145 */
	{ 0x0000,0x4000,0x8000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   146  */
	{ 0x4800,0x9000,0xD800,0xD800,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   147 */
	{ 0xD800,0xD800,0x4800,0x9000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   148 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   149 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   150 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   151 */
	{ 0x0000,0x5000,0xA000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   152 */
	{ 0x0000,0x0000,0xE840,0x4Cc0,0x4B40,0x4840,0x4840,0x4840,0x0000,0x0000 },  /*   153 */
	{ 0x5000,0x2000,0x0000,0x6000,0x9000,0x4000,0x2000,0x9000,0x6000,0x0000 },  /*   154 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   155 */
	{ 0x0000,0x0000,0x0000,0x6C00,0x9200,0x9200,0x9E00,0x9000,0x6E00,0x0000 },  /*   156 */
	{ 0xF800,0x5000,0x5000,0x5000,0x9000,0x9000,0x9000,0x9000,0x9000,0x0000 },  /*   157 */
	{ 0x0000,0x0000,0x0000,0x6400,0x9800,0x0000,0x6400,0x9800,0x0000,0x0000 },  /*   158 */
	{ 0x5000,0x0000,0x8800,0x8800,0x8800,0x5000,0x2000,0x2000,0x2000,0x0000 },  /*   159 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   160 */
	{ 0x8000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   161 */
	{ 0x0000,0x2000,0x7000,0xA000,0xA000,0xA000,0xA000,0x7000,0x2000,0x0000 },  /*   162 */
	{ 0x3C00,0x4000,0x4000,0xF800,0x4000,0x4000,0x4000,0x4000,0xFC00,0x0000 },  /*   163 */
	{ 0x8100,0x4200,0x3C00,0x2400,0x2400,0x2400,0x3C00,0x4200,0x8100,0x0000 },  /*   164 */
	{ 0x8200,0x4400,0x2800,0xFE00,0x1000,0xFE00,0x1000,0x1000,0x1000,0x0000 },  /*   165 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   166 */
	{ 0x7000,0x8000,0x8000,0x7000,0x8800,0x7000,0x0800,0x0800,0x7000,0x0000 },  /*   167 */
	{ 0x0000,0x5000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   168 */
	{ 0x0000,0x3800,0x4400,0x9A00,0xA200,0xA200,0x9A00,0x4400,0x3800,0x0000 },  /*   169 */
	{ 0x0000,0x6000,0x1000,0x7000,0x9000,0x9000,0x7000,0x0000,0xF000,0x0000 },  /*   170 */
	{ 0x0000,0x1200,0x2400,0x4800,0x9000,0x4800,0x2400,0x1200,0x0000,0x0000 },  /*   171 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   172 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   173 */
	{ 0x0000,0x3800,0x4400,0xB200,0xAa00,0xB200,0xAC00,0x4400,0x3800,0x0000 },  /*   174 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   175 */
	{ 0x0000,0x4000,0xA000,0x4000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   176 */
	{ 0x0000,0x0000,0x2000,0x2000,0xF800,0x2000,0x2000,0x0000,0xF800,0x0000 },  /*   177 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   178 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   179 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   180 */
	{ 0x8800,0x8800,0x8800,0x8800,0x9800,0xA800,0xC000,0x8000,0x8000,0x0000 },  /*   181 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   182 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   183 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   184 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   185 */
	{ 0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000,0xF000,0x0000 },  /*   186 */
	{ 0x0000,0x9000,0x4800,0x2400,0x1200,0x2400,0x4800,0x9000,0x0000,0x0000 },  /*   187 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   188 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   189 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   190 */
	{ 0x2000,0x0000,0x2000,0x2000,0x4000,0x8000,0x8000,0x8100,0x7000,0x0000 },  /*   191 */
	{ 0x2000,0x1000,0x6000,0x9000,0x9000,0x9000,0xF000,0x9000,0x9000,0x0000 },  /*   192 */
	{ 0x4000,0x8000,0x6000,0x9000,0x9000,0x9000,0xF000,0x9000,0x9000,0x0000 },  /*   193 */
	{ 0x2000,0x5000,0x6000,0x9000,0x9000,0x9000,0xF000,0x9000,0x9000,0x0000 },  /*   194 */
	{ 0x6800,0xB000,0x6000,0x9000,0x9000,0x9000,0xF000,0x9000,0x9000,0x0000 },  /*   195 */
	{ 0x9000,0x0000,0x6000,0x9000,0x9000,0x9000,0xF000,0x9000,0x9000,0x0000 },  /*   196 */
	{ 0x6000,0x9000,0x6000,0x9000,0x9000,0x9000,0xF000,0x9000,0x9000,0x0000 },  /*   197 */
	{ 0x7F00,0x8800,0x8800,0x8800,0x8F00,0xF800,0x8800,0x8800,0x8F00,0x0000 },  /*   198 */
	{ 0x6000,0x9000,0x8000,0x8000,0x8000,0x9000,0x6000,0x4000,0x8000,0x0000 },  /*   199 */
	{ 0x4000,0x2000,0xE000,0x8000,0x8000,0xE000,0x8000,0x8000,0xE000,0x0000 },  /*   200 */
	{ 0x4000,0x8000,0xE000,0x8000,0x8000,0xE000,0x8000,0x8000,0xE000,0x0000 },  /*   201 */
	{ 0x4000,0xA000,0xE000,0x8000,0x8000,0xE000,0x8000,0x8000,0xE000,0x0000 },  /*   202 */
	{ 0xA000,0x0000,0xE000,0x8000,0x8000,0xE000,0x8000,0x8000,0xE000,0x0000 },  /*   203 */
	{ 0x8000,0x4000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   204 */
	{ 0x4000,0x8000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },  /*   205 */
	{ 0x4000,0xA000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },  /*   206 */
	{ 0xA000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },  /*   207 */
	{ 0x7800,0x4400,0x4400,0x4400,0xE400,0x4400,0x4400,0x4400,0x7800,0x0000 },  /*   208 */
	{ 0x6800,0xB000,0x8800,0xC800,0xC800,0xA800,0xA800,0x9800,0x9800,0x0000 },  /*   209 */
	{ 0x2000,0x1000,0x6000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   210 */
	{ 0x2000,0x4000,0x6000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   211 */
	{ 0x2000,0x5000,0x6000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   212 */
	{ 0x5000,0xA000,0x6000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   213 */
	{ 0x9000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   214 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   215 */
	{ 0x3500,0x4400,0x4c00,0x5400,0x5400,0x5400,0x6400,0x4400,0xB800,0x0000 },  /*   216 */
	{ 0x4000,0x2000,0x9000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   217 */
	{ 0x4000,0x8000,0x9000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   218 */
	{ 0x2000,0x5000,0x9000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   219 */
	{ 0x9000,0x0000,0x9000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   220 */
	{ 0x1000,0x2000,0x8800,0x8800,0x8800,0x5000,0x2000,0x2000,0x2000,0x0000 },  /*   221 */
	{ 0x8000,0xE000,0x9000,0x9000,0x9000,0xE000,0x8000,0x8000,0x8000,0x0000 },  /*   222 */
	{ 0x7000,0x8800,0x8800,0x8800,0x9800,0x8400,0x8400,0x8400,0xB800,0x0000 },  /*   223 */
	{ 0x4000,0x2000,0x0000,0x6000,0x1000,0x7000,0x9000,0x9000,0x7000,0x0000 },  /*   224 */
	{ 0x2000,0x4000,0x0000,0x6000,0x1000,0x7000,0x9000,0x9000,0x7000,0x0000 },  /*   225 */
	{ 0x2000,0x5000,0x0000,0x6000,0x1000,0x7000,0x9000,0x9000,0x7000,0x0000 },  /*   226 */
	{ 0x5000,0xA000,0x0000,0x6000,0x1000,0x7000,0x9000,0x9000,0x7000,0x0000 },  /*   227 */
	{ 0x0000,0x5000,0x0000,0x6000,0x1000,0x7000,0x9000,0x9000,0x7000,0x0000 },  /*   228 */
	{ 0x2000,0x5000,0x2000,0x6000,0x1000,0x7000,0x9000,0x9000,0x7000,0x0000 },  /*   229 */
	{ 0x0000,0x0000,0x0000,0x6c00,0x1200,0x7200,0x9E00,0x9000,0x7E00,0x0000 },  /*   230 */
	{ 0x0000,0x0000,0x6000,0x8000,0x8000,0x8000,0x6000,0x4000,0x8000,0x0000 },  /*   231 */
	{ 0x4000,0x2000,0x0000,0x6000,0x9000,0x9000,0xF000,0x8000,0x7000,0x0000 },  /*   232 */
	{ 0x2000,0x4000,0x0000,0x6000,0x9000,0x9000,0xF000,0x8000,0x7000,0x0000 },  /*   233 */
	{ 0x4000,0xA000,0x0000,0x6000,0x9000,0x9000,0xF000,0x8000,0x7000,0x0000 },  /*   234 */
	{ 0xA000,0x0000,0x0000,0x6000,0x9000,0x9000,0xF000,0x8000,0x7000,0x0000 },  /*   235 */
	{ 0x8000,0x4000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },  /*   236 */
	{ 0x4000,0x8000,0x0000,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0x0000 },  /*   237 */
	{ 0x4000,0xA000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },  /*   238 */
	{ 0x0000,0xA000,0x0000,0x4000,0x4000,0x4000,0x4000,0x4000,0x4000,0x0000 },  /*   239 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },  /*   240 */
	{ 0xA000,0x5000,0x0000,0xE000,0x9000,0x9000,0x9000,0x9000,0x9000,0x0000 },  /*   241 */
	{ 0x4000,0x2000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   242 */
	{ 0x2000,0x4000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   243 */
	{ 0x2000,0x5000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   244 */
	{ 0x5000,0xA000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   245 */
	{ 0x0000,0x9000,0x0000,0x6000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   246 */
	{ 0x0000,0x0000,0x2000,0x0000,0xF800,0x0000,0x2000,0x0000,0x0000,0x0000 },  /*   247 */
	{ 0x0000,0x0000,0x0000,0x3400,0x4800,0x5800,0x6800,0x4800,0xB000,0x0000 },  /*   248 */
	{ 0x4000,0x2000,0x0000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   249 */
	{ 0x2000,0x4000,0x0000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   250 */
	{ 0x2000,0x5000,0x0000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   251 */
	{ 0x0000,0x9000,0x0000,0x9000,0x9000,0x9000,0x9000,0x9000,0x6000,0x0000 },  /*   252 */
	{ 0x2000,0x4000,0x0000,0x9000,0x9000,0x9000,0x9000,0x7000,0x1000,0x6000 },  /*   253 */
    { 0x0000,0x0000,0x0000,0x8000,0xc000,0xA000,0xA000,0xc000,0x8000,0x8000 },  /*   254 */
	{ 0x0000,0x9000,0x0000,0x9000,0x9000,0x9000,0x9000,0x7000,0x1000,0x6000 },  /*   255 */
};

const USHORT SYS_FONT_3[NUM_OF_CHARS][FONT_3_HEIGHT] =
{
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 0 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 1  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 2  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 3  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 4  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 5  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 6  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 7  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 8  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 9  */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 10 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 11 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 12 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 13 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 14 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 15 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 16 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 17 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 18 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 19 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 20 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 21 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 22 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 23 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 24 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 25 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 26 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 27 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 28 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 29 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 30 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 31 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 32 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 33 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 34 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 35 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 36 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 37 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 38 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 39 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 40 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 41 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 42 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 43 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x4000,0x4000,0x8000 },	/* 44 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFC00,
	  0xFC00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 45 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xC000,0xC000,0x0000 },	/* 46 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 47 */
	{ 0x3C00,0x3C00,0xC300,0xC300,0xC300,0xC300,0xC300,0xC300,
	  0xC300,0xC300,0xC300,0xC300,0xC300,0xC300,0x3C00,0x3C00,0x0000 },	/* 48 */
	{ 0x3C00,0x3C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,
	  0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x7F00,0x7F00,0x0000 },	/* 49 */
	{ 0x3C00,0x3C00,0xC300,0xC300,0x0300,0x0300,0x0300,0x0300,
	  0x0C00,0x0C00,0x3000,0x3000,0xC000,0xC000,0xFF00,0xFF00,0x0000 },	/* 50 */
	{ 0x3C00,0x3C00,0xC300,0xC300,0x0300,0x0300,0x0300,0x3C00,
	  0x3C00,0x0300,0x0300,0x0300,0xC300,0xC300,0x3C00,0x3C00,0x0000 },	/* 51 */
	{ 0x0C00,0x0C00,0xCC00,0xCC00,0xCC00,0xCC00,0xCC00,0xCC00,
	  0xCC00,0xFF00,0xFF00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0000 },	/* 52 */
	{ 0xFC00,0xFC00,0xC000,0xC000,0xC000,0xC000,0xC000,0xFC00,
	  0xFC00,0x0300,0x0300,0x0300,0x0300,0x0300,0xFC00,0xFC00,0x0000 },	/* 53 */
	{ 0x3C00,0x3C00,0xC000,0xC000,0xC000,0xC000,0xC000,0xFC00,
	  0xFC00,0xC300,0xC300,0xC300,0xC300,0xC300,0x3C00,0x3C00,0x0000 },	/* 54 */
	{ 0xFC00,0xFC00,0x0300,0x0300,0x0300,0x0300,0x0300,0x0C00,
	  0x0C00,0x0C00,0x0C00,0x3000,0x3000,0x3000,0x3000,0x3000,0x0000 },	/* 55 */
	{ 0x3C00,0x3C00,0xC300,0xC300,0xC300,0xC300,0xC300,0x3C00,
	  0x3C00,0xC300,0xC300,0xC300,0xC300,0xC300,0x3C00,0x3C00,0x0000 },	/* 56 */
	{ 0x3C00,0x3C00,0xC300,0xC300,0xC300,0xC300,0xC300,0x3C00,
	  0x3C00,0x0300,0x0300,0x0300,0x0300,0x0300,0x3C00,0x3C00,0x0000 },    /* 57 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 58 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 59 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 60 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 61 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 62 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 63 */
	{ 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 },	/* 64 */
	{ 0x3C00,0x3C00,0xC300,0xC300,0xC300,0xC300,0xC300,0xC300,
	  0xC300,0xFF00,0xFF00,0xC300,0xC300,0xC300,0xC300,0xC300,0x0000 },	/* 65 */
	{ 0xFC00,0xFC00,0xC300,0xC300,0xC300,0xC300,0xC300,0xFC00,
	  0xFC00,0xC300,0xC300,0xC300,0xC300,0xC300,0xFC00,0xFC00,0x0000 },	/* 66 */
	{ 0x3C00,0x3C00,0xC300,0xC300,0xC000,0xC000,0xC000,0xC000,
	  0xC000,0xC000,0xC000,0xC000,0xC300,0xC300,0x3C00,0x3C00,0x0000 },	/* 67 */
	{ 0xFC00,0xFC00,0xC300,0xC300,0xC300,0xC300,0xC300,0xC300,
	  0xC300,0xC300,0xC300,0xC300,0xC300,0xC300,0xFC00,0xFC00,0x0000 },	/* 66 */
	{ 0xFF00,0xFF00,0xC000,0xC000,0xC000,0xC000,0xC000,0xFF00,
	  0xFF00,0xC000,0xC000,0xC000,0xC000,0xC000,0xFF00,0xFF00,0x0000 },	/* 69 */
	{ 0xFF00,0xFF00,0xC000,0xC000,0xC000,0xC000,0xC000,0xFF00,
	  0xFF00,0xC000,0xC000,0xC000,0xC000,0xC000,0xC000,0xC000,0x0000 },	/* 70 */
};



//================================ API CALLS ===============================

BYTE SysGetFontHeight(BYTE font_id)
{
	return FONT_HEIGHT[font_id];
}

void SysFontRestoreFont()
{
	FontWidth 	= &SYS_FONT_WIDTH[0][0];
	Font1 		= &SYS_FONT_1[0][0];
	Font2 		= &SYS_FONT_2[0][0];
	Font3 		= &SYS_FONT_3[0][0];
}

void SysFontSetCustomFont(const USHORT **CustomFontPtrs, const BYTE* CustomFontWidth)
{
	if(CustomFontWidth == NULL || CustomFontPtrs == NULL)
		return;

	FontWidth = CustomFontWidth;

	if(CustomFontPtrs[0])
		Font1	= CustomFontPtrs[0];
	else
		Font1 	= &SYS_FONT_1[0][0];
		

	if(CustomFontPtrs[1])
		Font2	= CustomFontPtrs[1];
	else
		Font2 	= &SYS_FONT_2[0][0];

	if(CustomFontPtrs[2])
		Font3	= CustomFontPtrs[2];
	else
		Font3 	= &SYS_FONT_3[0][0];
}
