// actions.h

#ifndef ACTIONS2_H
#define ACTIONS2_H

#define ACTIONCOUNT 14

// define some indexes
#define JOT_INDEX_TIME	5
#define JOT_INDEX_DATE1 6
#define JOT_INDEX_DATE2 7
#define JOT_INDEX_DATETIME	8

// define time and date format strings
#define JOT_TIME_FORMAT		TEXT("h':'mm':'ss tt")
#define JOT_DATE_FORMAT1	TEXT("ddd MMM d',' yyyy")
#define JOT_DATE_FORMAT2	TEXT("M'/'d'/'yy")

// define these VK_* for our purpose, the values are not used by MS Windows
#define VK_TIME			0x05
#define VK_DATE1		0x06
#define VK_DATE2		0x07
#define VK_DATETIME		0x0A

static unsigned char cutS[] = {VK_CONTROL, 'X', 'X' | 0x80, VK_CONTROL | 0x80, 0};
static unsigned char copyS[] = {VK_CONTROL, 'C', 'C' | 0x80, VK_CONTROL | 0x80, 0};
static unsigned char pasteS[] = {VK_CONTROL, 'V', 'V' | 0x80, VK_CONTROL | 0x80, 0};
static unsigned char undoS[] = {VK_CONTROL, 'Z', 'Z' | 0x80, VK_CONTROL | 0x80, 0};
static unsigned char deleteS[] = {VK_DELETE, VK_DELETE | 0x80, 0};
static unsigned char timeS[] = {VK_TIME, 0};
static unsigned char date1S[] = {VK_DATE1, 0};
static unsigned char date2S[] = {VK_DATE2, 0};
static unsigned char datetimeS[] = {VK_DATETIME, 0};
static unsigned char pageupS[] = {VK_PRIOR, VK_PRIOR | 0x80, 0};
static unsigned char pagedownS[] = {VK_NEXT, VK_NEXT | 0x80, 0};
static unsigned char homeS[] = {VK_HOME, VK_HOME | 0x80, 0};
static unsigned char endS[] = {VK_END, VK_END | 0x80, 0};
static unsigned char escS[] = {VK_ESCAPE, VK_ESCAPE | 0x80, 0};

unsigned char *actionkeysAr[ACTIONCOUNT] = 
	{
	cutS,
	copyS,
	pasteS, 
	undoS,
	deleteS,
	timeS,
	date1S,
	date2S,
	datetimeS,
	pageupS,
	pagedownS,
	homeS,
	endS,
	escS,
	};

#endif