/* HWTABPUB.h           CIC Proprietary
 *-----------------------------------------------------------------------------
 * SCCS Version 1.11, 17:47:42 7/19/95
 *-----------------------------------------------------------------------------
 * Public header file for XPEN.
 *
 * Peter Garst          03/29/95
 * J. Wang          26-Jun-95   Adapted from Peter's math recognizer.
 *-----------------------------------------------------------------------------
 */
#ifndef HWTABPUB_H
#define HWTABPUB_H

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/Xlib.h>

#define HW_MAX_PORT_NAME	80     /* Max length of port name.      */
#define DEFAULT_TABLET_PORT	"/dev/ttya"

#define HW_SHORT_WAIT		10
#define HW_LONG_WAIT		1000000

#define HW_MAX_CHAR_SIZE	1024

#define X_TC_TO_DC(tc, hwintP)		(((tc) * (hwintP)->x_ratioI) >> 12)
#define Y_TC_TO_DC(tc, hwintP)		((((hwintP)->tab_ysizeI - (tc)) * (hwintP)->y_ratioI) >> 12)

#define NUMERAL_MODE	0
#define UPPER_MODE	1
/*
 *-----------------------------------------------------------------------------
 * This structure holds some parameter for the pen.
 *-----------------------------------------------------------------------------
 */
typedef struct
    {
    CIC_INT	ink_widthI;	/* Inking width				*/
    CIC_INT	ink_colorI;	/* Color of ink				*/
    CIC_INT	tap_diamI;	/* Diameter for a tap			*/
    CIC_INT	dtap_diamI;	/* Diameter for a double tap		*/
    CIC_INT	dtap_speedI;	/* Speed for a double tap		*/
    CIC_UINT32	ink_timeoutL;	/* Timeout for inking of a sentence	*/
    } PEN_CONTROL;

/*
 *--------------------------------------------------------------------------
 * This structure holds information on one processed pen point.
 *--------------------------------------------------------------------------
 */
typedef struct
    {
    CIC_INT32   xL;
    CIC_INT32   yL;
    CIC_INT32   dxL;            /* Display point.       */
    CIC_INT32   dyL;            /* Display point.       */
    CIC_INT32   statusL;
    CIC_BOOL    proximityB;
    } HW_TABBUF;

/*
 *-----------------------------------------------------------------------------
 * This is the tablet buffer.
 *-----------------------------------------------------------------------------
 */
#define CIC_TABLET_MAX_POINTS	4096
#define CIC_TABLET_MAX_STROKES  32
#define CIC_TABLET_MAX_CHARS	500

typedef struct
    {
    CIC_INT16           npointsW;       /* Number of points in buffer   */
    CIC_INT16           nstrokesW;      /* Number of strokes            */
    CIC_INT16           xbufW[CIC_TABLET_MAX_POINTS];
    CIC_INT16           ybufW[CIC_TABLET_MAX_POINTS];
    CIC_INT16           strokeW[CIC_TABLET_MAX_STROKES + 1];
    CIC_INT16		xminW;
    CIC_INT16		yminW;
    CIC_INT16		xmaxW;
    CIC_INT16		ymaxW;
    } TAB_BUFFER;

typedef struct
    {
    TAB_BUFFER		history[CIC_TABLET_MAX_CHARS];
    CIC_TEXT		rec_resultS[CIC_TABLET_MAX_CHARS];
    CIC_INT16		nsaveW;
    }	SAVE_HISTORY;

/*
 *--------------------------------------------------------------------------
 * Bits used in the status field:
 *--------------------------------------------------------------------------
 */
#define PEN_DOWN        1
#define PEN_BUTTON      4

typedef struct hw_interface     HW_INTERFACE;

/*
 *--------------------------------------------------------------------------
 * This is a typedef for the callback function which processes new data
 * points from the tablet.
 *--------------------------------------------------------------------------
 */
typedef CIC_VOID (*HW_PCALLBACK)
    (
    HW_TABBUF           *bufP,
    HW_INTERFACE        *hwintP
    );

/*
 *--------------------------------------------------------------------------
 * This is a typedef for the callback function which processes new data
 * strokes and end of input.
 *--------------------------------------------------------------------------
 */
typedef CIC_VOID (*HW_CALLBACK)
    (
    HW_INTERFACE        *hwintP
    );

/*
 *--------------------------------------------------------------------------
 * This is the main structure for the tablet interface. This is large
 * and complex because it needs to control a lot of different variables.
 * If we add much more, it would make sense to go to an ioctl type interface,
 * where we maintain an internal structure but allow the user to set
 * parameters one at a time by name.
 *--------------------------------------------------------------------------
 */
struct hw_interface
    {
   /* 
    *--------------------------------------------------------------------------
    * Field control the pen
    *--------------------------------------------------------------------------
    */
    PEN_CONTROL		pen_control;

   /*
    *--------------------------------------------------------------------------
    * Fields controlling taking data off the tablet:   
    *--------------------------------------------------------------------------
    */
    HW_CALLBACK         sentence_proc;  /* Sentence callback routine.   */
    HW_CALLBACK         stroke_proc;    /* Stroke callback routine.     */
    HW_PCALLBACK        point_proc;     /* Point callback routine.      */

   /*
    *--------------------------------------------------------------------------
    * Tablet paramters
    *--------------------------------------------------------------------------
    */
    CIC_INT		tab_xsizeI;	/* X dimension of tablet	*/
    CIC_INT		tab_ysizeI;	/* Y dimension of tablet	*/
    CIC_INT		x_ratioI;	/* X ratio to transform from    */
					/*  tablet to display           */
    CIC_INT		y_ratioI;	/* Y ratio to transform from    */
					/*  tablet to display		*/
    TAB_BUFFER          tab_buff;
    CIC_TEXT            portS[HW_MAX_PORT_NAME]; 
 					/* Default is /dev/ttya.        */
    CIC_INT32           ttyL;           /* Tablet file descriptor.      */

   /*
    *--------------------------------------------------------------------------
    * Internal fields for display pointer and inking.
    *--------------------------------------------------------------------------
    */
    CIC_INT		dpy_xsizeI;	/* Display X dimension		*/
    CIC_INT		dpy_ysizeI;	/* Display Y dimension		*/	
    Display		*dpyP;		/* Display of X Window		*/
    GC			ink_gc;		/* GC for inking		*/
    Window		root;		/* Root window			*/
    Window		ink_win;	/* Current inking window	*/
    CIC_INT		xoffI, yoffI;	/* Offset of inking window	*/
    CIC_INT		xlimI, ylimI;	/* Limit of inking window	*/
    CIC_BOOL 		inkingB;	/* YES if it's inking now	*/

   /*
    *--------------------------------------------------------------------------
    * Field for usr attached information
    *--------------------------------------------------------------------------
    */
    CIC_VOID            *user_infoP;    /* User can attach local info   */
    CIC_INT16		flagW;		/* Flag for use information	*/
    CIC_TEXT		fileS[256];	/* Save/load file name		*/
    SAVE_HISTORY	save_buff;	/* Buffer saves all ink		*/
    CIC_BOOL		loadB;		/* YES if "load" button active  */
    };

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

/*
 *--------------------------------------------------------------------------
 * Prototypes for main interface functions.
 *--------------------------------------------------------------------------
 */

CIC_BOOL hwtab_open
    (
    CIC_INT             *argcP,
    CIC_TEXT            **argvP,
    HW_INTERFACE        *hwintP
    );

CIC_BOOL hwtab_close
    (
    HW_INTERFACE        *hwintP
    );

CIC_BOOL hwtab_clear
    (
    HW_INTERFACE        *hwintP
    );

CIC_VOID ink_timeout
    (
    CIC_INT     sig
    );

CIC_VOID hw_pen_proc
    (
    HW_TABBUF           *bufP,
    HW_INTERFACE        *hwintP
    );

CIC_VOID move_ink
    (
    HW_INTERFACE *hwintP
    );

CIC_VOID clear_ink
    (
    HW_INTERFACE  *hwintP
    );

CIC_LOCAL CIC_VOID mouse_button
    (
    HW_INTERFACE        *hwintP,
    CIC_INT32           xL,
    CIC_INT32           yL,
    CIC_UINT            buttonUI,
    CIC_INT             stateI,
    CIC_INT             etype_mask,
    int                 etype
    );

CIC_VOID hwbuf_init
    (
    HW_INTERFACE        *bufP
    );

CIC_LOCAL CIC_VOID hwbuf_point
    (
    HW_INTERFACE        *bufP,
    CIC_INT32           xL,
    CIC_INT32           yL,
    CIC_INT32           dxL,
    CIC_INT32           dyL
    );

CIC_LOCAL CIC_VOID hwbuf_stroke
    (
    HW_INTERFACE        *bufP
    );

CIC_BOOL save_ink
    (
    CIC_TEXT    *save_fileS,
    SAVE_HISTORY *in_bufP
    );

CIC_VOID hw_clear_save_buffer
    (
    SAVE_HISTORY *bufP
    );

CIC_VOID get_current_save_file_name
    (
    CIC_TEXT    *save_fileS
    );

CIC_VOID refresh_text_file
    (
    );
#endif  /* HWTABPUB_H   */
