/*********************************************************
**	Company      : Communication Intelligence Corporation**
**	Project      : PDA                                  **
**	Programmer	 : Jiping Wang (CIC)                    **
**	Date         : 20-OCT-98							**
**	Comment      : Jot Macro Editor releated functions	**
**	Version      : 1.0                                  **
**********************************************************
**/
#ifndef JOT_H
#define JOT_H

/* The default timeout for symbol mode: 2 seconds*/
#define JOT_SYMBOL_TIMEOUT 1200
#define JOT_MIN_SYMBOL_TIMEOUT 600

/* The default timeout for 2-stroke chars 't', 'x' etc: 0.6 seconds */
#define JOT_STROKE_TIMEOUT 600

#define JOT_READ_DB 0
#define JOT_WRITE_DB 1

#define JOT_MACRO_DB_NAME (BYTE *)"jotmacrodb"
#define JOT_MACRO_DB_VERSION 0x0100
#define JOT_MACRO_DB_INFO (BYTE *)"Developed by Jiping Wang of CIC"

#define JOT_TRAINER_DB_NAME (BYTE *)"jottrainerdb"
#define JOT_TRAINER_DB_VERSION 0x0100
#define JOT_TRAINER_DB_INFO (BYTE *)"Developed by Jiping Wang of CIC"

/* These are main API functions for Jot's systam part */
void JotInit();
BOOLEAN JotHandleEvent(EvtType *Event);
void JotUpdate();

BOOLEAN OpenJotMacroDB();
BOOLEAN CloseJotMacroDB();
BOOLEAN IsJotMacroAlreadyExist(BYTE *macroName);
BOOLEAN AddJotMacro(BYTE *macroName, BYTE *macroText);
BOOLEAN DeleteJotMacro(BYTE *macroName);
BOOLEAN ChangeJotMacro(BYTE *macroName, BYTE *macroText);
int GetJotMacroNum();
BOOLEAN GetJotMacro(int index);
int MatchJotMacro
	(
    int         num_input,      /* Number of input macro name   */
    char        *inputS,        /* Input macro string           */
    int         *num_outputP,   /* Number of output characters  */
    char        **outputP       /* Returned pointer to a string */
                                /*   for recognized output      */
	);

BOOLEAN UpdateJotTrainerDB(int read_or_write);

#endif
