/* modpub.h			CIC Proprietary
 *----------------------------------------------------------------------------
 * SCCS Version 1.2, 10:02:55 9/3/96
 *----------------------------------------------------------------------------
 * Definition of parameters and structures used in model matching routines.
 *
 * D. Hwang         24-Aug-92   Initial
 * D. Hwang         23-Sep-92   Changed HOOK_THRESHOLD_HMM from 76 to 73, based
 *                              on comparison run from 71-77.  Added recogUC
 *                              to HMMVER structure.
 * D. Hwang         24-Sep-92   Moved constant SCORE_PENALTY to compub.h
 * D. Hwang         25-Sep-92   Added fillmods() function prototype.
 * D. Hwang         26-Oct-92   Restructured modlib
 * D. Hwang         21-Dec-92   Added force include model feature
 * JP Shipherd      22-Dec-92   Added SetPointer()
 * JP Shipherd      21-Jan-93   Added ifndef MODPUB_H
 * K. Rolle         16-Feb-92   Set HMM_THRESHOLD to special value for
 *                                numbers-only recognizer.
 * D. Hwang         19-Oct-93   Added segpoint argument to recogHMM
 * M. Wenocur       12-Nov-93   Moved OBS_VEC_TAG to local modloc.h, fixed
 *                                enum ',' problem
 * M Wenocur        13-Jan-94   Modified definitions of recogHMM and deskptch
 *                              Added definition of DESK_CNTRL
 * Dan Illowski     28-Mar-94   Changed MAXTEMPS_HMM from 400 to 200
 * M Wenocur        23-May-94   Redefined MAXTEMPS_HMM to 270 for JPN system
 * M Wenocur        05-Jul-94   Added set_maskUC to recogHMM and deskew_patch
 * J. Wang          13-Aug-96   Adapted for low end recognizer.
 *-----------------------------------------------------------------------------
 */
#ifndef MODPUB_H
#define MODPUB_H

 /*
  *----------------------------------------------------------------------------
  * Include necessary header files
  *----------------------------------------------------------------------------
  */

#include <params.h>             /* for RCVBL definition                      */

#define NUM_HMM_MODELS 84	/* Number of HMM models in current version   */
#define STK_REC_SCORE	97	/* Score from stroke recognition	     */

/*
 *----------------------------------------------------------------------------
 * Additional option switches
 *----------------------------------------------------------------------------
 */
/*
 *----------------------------------------------------------------------------
 * Used for both offline and online
 *----------------------------------------------------------------------------
 */
#define MAXTEMPS_HMM 200        /* Maximum # character templates per subject */
#define CHARSEGS_HMM 40		/* number of points in angle templates       */
#define CHARPTS_HMM (CHARSEGS_HMM + 1) /* number of points in  X, Y templates*/
#define MAX_TEMP_FEATS 7        /* maximum # features in template feature    */
                                /* mask - see TEMCHAR_UI below               */
#define DEF_NUMOBS (CHARSEGS_HMM / 2) /* default number of observations      */
#define LIKELIHOOD_RATIO_THRESHOLD (UINT) (2.44 * 256)/*factor used in det'g */
#define NUM_FEATURES  (MAX_TEMP_FEATS - 3)	/* # of feature masks used   */
#define PROB_OFFSET 100         /* offset used in estimating condidence      */
                                /* values from log probability values in     */
                                /* function NEW_LIST                         */
#define PRECISION_MULT 15	/* Multiplier used to convert the FP aF, bF  */
				/* durF, to LONG values.  Needed to maintain */
				/* adequate precision			     */

#define HMM_THRESHOLD      29	/* recog threshold for HMM matching	     */

#define HOOK_THRESHOLD_HMM 73	/* threshold for hook detection activation   */
#define MIN_2ND_PASS 6          /* min num of CVs to be passed to 2nd pass   */
#define NUM_DESKEW 8
#define FULL_PROCESS_HMM   12	/* # templates used for full processing      */
#define MAX_STATES CHARSEGS_HMM	/* MAXIMUM number of states per HMM model    */

#define INFO_FIELDS         4
#define CIC_REC_VERSION     0
#define CIC_REC_NUMSTAT     1
#define CIC_REC_AVG_LOG     2
#define CIC_REC_CHRSET      3

#define CIC_REC_NUMOUT1    32
#define CIC_REC_NUMOUT2    16
#define CIC_REC_NUMOUT3    18

#define NUM_HMM_SAVE        6	/* # of models to save (and sort) after      */

#define HMM_MODEL_BYTE_PC struct HMM_model_byte_pc
typedef struct		/* structure for saving HMM model params     */
    {
    CIC_UINT8 infoUC[INFO_FIELDS]; 
				/* contains fields for all auxilliary info   */
    CIC_INT16 aW;		/* transition probabilities                  */
    CIC_INT16 b11W;		/* state output prob for feature #1          */
    CIC_INT16 b22W;		/* state output prob for feature #2          */
    CIC_INT16 b33W;		/* state output prob for feature #3          */
    CIC_INT16 beg_stateW;	/* beginning index for states (used          */
				/* by viterbi_2RL_hori_mult_long)            */
    CIC_INT16 end_stateW;       /* ending    index for states (used          */
				/* by viterbi_2RL_hori_mult_long)            */
    CIC_INT16 b11_infoW;        /* Compression info for b11                  */
    CIC_INT16 b22_infoW;        /* Compression info for b22                  */
    CIC_INT16 b33_infoW;        /* Compression info for b33                  */
    } HMM_MODEL;

#endif	/* ifndef MODPUB_H */

