/* PARAMS.H                     CIC Proprietary
 *------------------------------------------------------------------------------
 * SCCS VERSION 1.5, 10:02:53 9/3/96
 *------------------------------------------------------------------------------
 * Header file for CIC recognition programs in C.  Contains parameters that
 * have the same value in the Japan and USA systems, for both off-line and
 * on-line programs.
 *
 * D. C. Foyt    13-Sep-84
 * P. Edberg     21-Apr-86   Added JISTD structure (moved from spadel.h)
 * P. Edberg      1-May-86   Changed JISTD structure to replace timeS and
 *                           dateS with packtdL
 * P. Edberg     19-Feb-87   Added MXSPECVAL and MXSPECSTR for command line
 *                           processing
 * P. Edberg     09-Feb-88   Added PARAMSINC constant and related condi-
 *                             tional code to prevent multiple inclusions
 *                             of this file
 * P. Edberg     29-Feb-88   Added MAXDICNAM, TIMESIZE, DATESIZE
 * D. Hwang      22-Aug-91   Added MAXCODES
 * D. Hwang      19-Feb-92   Took out comment of MAXSTK and added sound enum
 * D. Hwang      28-Feb-92   Took out enum of sound change constants
 * S. Tien       09-Mar-92   Added GESTURE define
 * D. Hwang      23-Mar-92   Added MAXSTKS, MAXRESULTS and typedef RCVBLKX
 * D. Hwang      29-Jun-92   Added NUMERIC, ENG_UC
 * D. Hwang      10-Jul-92   Added bit mask constants for character sets
 * K. Rolle      15-Dec-92   Add fields "asciiUC" and "orig_clUC" to RCVBL,
 *                             and field "id" to STROKE.
 * JP Shipherd   21-Jan-93   Added ifndef PARAMS_H
 * V. Wilburn    03-Feb-93   Merged US and Japanese
 * D. Hwang      27-Sep-93   Optimized arguments passing to the dictionary
 *                             disambiguation function
 * D. Foyt       09-Feb-94   Added RAT3 macro for calling irat3 conveniently
 * JP Shipherd   16-Feb-94   Added Dan Illowski's CIC_INT ipls3nc macro
 * D. Foyt       05-Apr-94   Make MAXSTKS 6 instead of 4 for European
 * PL Spoltore   17-Oct-94   Added stroke numbers for OS/2 dictionaries
 * P.L. Spoltore 02-Feb-95   Changed variables declarations of TEXT to
 *                             CIC_TEXT.
 * J. Wang       13-Apr-95   Add hmmverUC and stkverUC in RCVBL structure.
 * P.L. Spoltore 03-May-95   Defined GESTURE so that both the suns and the
 *                             pc's can use the same symbol (as opposed to
 *                             GESTURE and GESTURES as it was previously).
 * P.L. Spoltore 08-Jun-95   Added new stroke recognition dictionary counters
 *                             for recognition of gestures as the strokes are
 *                             added to the system. This is (for example) the
 *                             gesture recognition used by Windows 3.1.
 *------------------------------------------------------------------------------
 */
#ifndef PARAMS_H
#define PARAMS_H

#define NSEGS     30		/* Number of segments in a stroke             */
#define NPTS      31		/* Number of points in a stroke               */
#define MAXPTN    33		/* Size of pointer arrays in data file        */
/*
 *------------------------------------------------------------------------------
 * MAXIMUM number of strokes allowed for each dictionary group
 *
 * MAXSTKGES ... Maximum strokes in the gesture recognition that
 *               takes place at the normal recognition time.
 *
 * MAXSTKONE ... Maximum strokes in the gesture recognition that
 *               takes place when each stroke is added to the system.
 *
 * MAXSTKENG ...
 *
 * MAXSTKLOW ...
 *
 * MAXSTKMIX ...
 *
 *------------------------------------------------------------------------------
 */
#if USWIN
#define MAXSTKGES 1
#define MAXSTKENG 4
#define MAXSTKLOW 4
#define MAXSTKMIX 2
#define MAXSTKONE 0

#elif WIN95
#define MAXSTKGES 1
#define MAXSTKENG 4
#define MAXSTKLOW 4
#define MAXSTKMIX 2
#define MAXSTKONE 1

#elif OS2
#define MAXSTKGES 3
#define MAXSTKENG 4
#define MAXSTKLOW 4
#define MAXSTKMIX 2
#define MAXSTKONE 0

#elif JWIN
#define MAXSTKENG 4
#define MAXSTKGES 1
#define MAXSTKLOW 3
#define MAXSTKMIX 3
#define MAXSTKONE 0

#else
#define MAXSTKGES 2
#define MAXSTKENG 4
#define MAXSTKLOW 4
#define MAXSTKMIX 2
#define MAXSTKONE 0
#endif

/*
 *-----------------------------------------------------------------------------
 * MAXSTK is defined in japan.h or usa.h on the Alcyon
 *-----------------------------------------------------------------------------
 */
#define MAXREC    12		/* Maximum number of strokes recognized       */
#define MAXSTKPTR 26		/* Maximum number of strokes in arrays        */
#define MAXSTKDSK 32		/* Maximum number of strokes in disk file     */
#define MAXSTKHK   6		/* Max. no. strokes for mixed H/K	      */
#define MAXSTKNK   6		/* Max. no. strokes in a non-Kanji character  */
#define NRCCTL    64		/* Length of a control file record (bytes)    */
#define NRCCOD    48		/* Length of a CODDIC record (bytes)	      */
#define NRCSPA   208		/* Length of a data file record (bytes)       */
#define NRCCPX   192		/* Length of a CPXTST-type data file record   */
#define MAXDIS    10		/* For statistics on disambiguation routines  */
#define MAXFAL    20		/* Max. no. of disamb. failures/version	      */
#define MAXVRF   128		/* Max. no. of failed versions/character      */
#define MAXLST   500		/* Max. length of dictionary list	      */
#define MAXCNS   200		/* Max. length of confusion list	      */
#define MAXCV   1024		/* Max. no. of dictionary cv's per JIS code   */
#define JMAXLEN	 800		/* Maximum stroke length for Japan system     */

#ifdef sun
#define NCMD      68		/* (No. of host commands = 34) * 2	      */
#else
#if JPNREC
#define NCMD      68		/* (No. of host commands = 34) * 2	      */
#else
#define NCMD      18		/* (No. of host commands = 9) * 2	      */
#endif
#endif

#define MXSPECVAL 16		/* Max. # of values in cmd line string	      */
#define MXSPECSTR 34		/* Max. cmd line strng bytes = MXSPECVAL*2+2  */
#define MAXDICNAM  3		/* Max. number of chars. in a dict. name      */
#define TIMESIZE   8		/* Number of characters for time	      */
#define DATESIZE   9		/* Number of characters for date	      */

#define MAXCODES   10		/* Max. number of chars. recognized	      */

#if !CIC_EUR_RECOG
#define MAXSTKS    4            /* Max. number of strokes per character       */
#else
#define MAXSTKS    6            /* Max. number of strokes per character       */
#endif

#define MAXRESULTS 20           /* Max. number of chars. in result buffer     */

#if JPNREC
#define MAX_NUM_ROWS  200       /* Max. number of rows in dos version         */
#define MAX_NUM_COLS  200       /* Max. number of cols in dos version         */
#endif

#define DT3103     0		/* Seiko DT-3103 tablet			      */
#define DT3503     1		/* Seiko DT-3503-00 tablet		      */
#define SUMAMM     2		/* Summagraphics MM2101 tablet		      */
#define IS_ONE     3		/* Kurta IS/ONE with cordless 2-button pen    */
#define GTCO_DP5A  4		/* GTCO DP5 tablet			      */
#define HP_7060A   5		/* HP 7060A in GTCO DP5 LRB format	      */
#define CAL_2000   6		/* Calcomp 2000 tablet			      */
#define CAL_2300   7		/* Calcomp 2300 tablet in 2000 binary format  */
#define PUMA       8		/* Hitachi 1212D tablet			      */
#define DI3010     9		/* Seiko DI-3010 tablet (transparent)	      */

#ifndef sun
#define RECBUFSIZ 1024
#endif

#define KANJI      1		/* Character sets (possible values of chtype) */
#define HIRAGANA   2
#define KATAKANA   3
#define ENGLISH    4
#define MIXED_HK   5

#ifdef sun
#define SYMBOLS     6
#define GESTURE     8
#define GESTURE_STK 9
#define ENG_LC     13
#define ENG_UC     31
#define NUMERIC    32
#else
#define GESTURE     6
#define GESTURE_STK 7
#define SYMBOLS     8
#endif

#define ENG_LC    13
#define LOWERCASE 20
#define EUROPEAN   7
#define GERMANY	  21
#define FRENCH    22
#define SWEDISH   23
#define MIXCASE   30
#if JPNREC
#define GESTURE     6
#define GESTURE_STK 7
#define ENG_UC     31
#define NUMERIC    32
#endif

/*
 *-----------------------------------------------------------------------------
 * Bit mask values of all character sets supported by PenDOS 2.0
 *-----------------------------------------------------------------------------
 */
#define MAX_CSETS	8
#define CSET_ALPHA_LC   0x1L
#define CSET_ALPHA_UC   0x2L
#define CSET_NUMERIC    0x4L
#define CSET_SYMBOLS    0x20L
#define CSET_GESTURES   0x4000L
#define CSET_HIRAGANA   0x10000L
#define CSET_KATAKANA   0x20000L
#define CSET_KANJI      0x40000L

#if CICDOS
#define PENDOS_ALPHA_LC   0x1
#define PENDOS_ALPHA_UC   0x2
#define PENDOS_NUMERIC    0x4
#define PENDOS_SYMBOLS    0x8
#define PENDOS_GESTURES	  0x10
#define PENDOS_HIRAGANA   0x20
#define PENDOS_KATAKANA   0x40
#define PENDOS_KANJI      0x80
#endif

#define EUROPE     1            /* Binary dictionay directory                 */
#define JAPAN      2
#define US         3

#define LUN_STK    1		/* Lun # for stkdic data file	              */
#define LUN_DIS    2		/* Lun # for disamb data file	              */
#define LUN_SPA    3		/* Lun # for subject data file	      	      */

#define IS_SMALL   1		/* Bit definitions for punctuation detection  */
#define HAS_SMALL  2

#define RAT2_S     0		/* Symbolic parameters for disamb routines    */
#define RAT2_L  0x40
#define RAT2_E  0x80
#define RAT2_D  0xc0

#define FIN2_A     4
#define FIN2_B     5
#define FIN2_H     0
#define FIN2_D     1
#define FIN2_L     2
#define FIN2_R     3
#define FIN2_W     6
#define FIN2_X     7
#define FIN2_Y     8
#define FIN2_Z     9

#define CCCW_C     1
#define CCCW_N    -1

#define RTLT_R     !
#define RTLT_L

#define HORI_B     0
#define HORI_E     1
#define HORI_R     2
#define HORI_L     3
#define HORI_M     4
#define HORI_A     5

#define HOR2_B     0
#define HOR2_E     1
#define HOR2_R     2
#define HOR2_L     3
#define HOR2_M     4
#define HOR2_A     5

#define VERT_B     0
#define VERT_E     1
#define VERT_H     2
#define VERT_L     3
#define VERT_M     4
#define VERT_A     5

#define VER2_B     0
#define VER2_E     1
#define VER2_H     2
#define VER2_L     3
#define VER2_M     4
#define VER2_A     5

#define LENG_C     0
#define LENG_H     1
#define LENG_V     2

#define LEN2_H     1
#define LEN2_V     2

#define DIST_A     0
#define DIST_D     1
#define DIST_S     2
#define DIST_R     3

#define RAT3_S		0x00	/* RAT3() defines			     */
#define RAT3_L		0x40	/* RAT3() defines			     */
#define RAT3_E		0x80	/* RAT3() defines			     */
#define RAT3_D		0xc0	/* RAT3() defines			     */

#define NO_PARITY   0
#define ODD_PARITY  1
#define EVEN_PARITY 2

#define HMM_RESULTS struct HMM_results
HMM_RESULTS                     /* structure for saving HMM rec result       */
    {
    CIC_UINT8 version_no;       /* version # HMM model                       */
    CIC_UINT16 log_prob;        /* value of HMM log liklihood                */
    };

#define STROKE struct stroke	/* Data structure for one sampled stroke      */
STROKE
    {
    COUNT    arclen;               /* Arc length along stroke                    */
    COUNT    boxlen;               /* Diagonal length of box enclosing stroke    */
    CIC_TEXT minxpt;               /* Minimum x-coordinate for stroke            */
    CIC_TEXT minypt;               /* Minimum y-coordinate for stroke            */
    CIC_TEXT maxxpt;               /* Maximum x-coordinate for stroke            */
    CIC_TEXT maxypt;               /* Maximum y-coordinate for stroke            */
    COUNT    theta[NSEGS];         /* Spatially-sampled angle values             */
    COUNT    x[NPTS];              /* Spatially-sampled x-coordinates            */
    COUNT    y[NPTS];              /* Spatially-sampled y-coordinates            */
    COUNT    id;
    };

#define RCVB struct rcvb	/* Data structure for dict. list & conf. list*/
RCVB
    {
    UTINY row;			/* Row number				     */
    UTINY col;			/* Column number			     */
    UTINY ver;			/* Version number			     */
    UTINY typ;			/* First byte of bdat array		     */
    };

#define RCVBL struct rcvbl	/* Data structure for dict. list & conf. list*/
RCVBL
    {
    UTINY row;			/* Row number				     */
    UTINY col;			/* Column number			     */
    UTINY ver;			/* Version number			     */
    CIC_UINT8 hmmverUC;		/* HMM version number			     */
    CIC_UINT8 stkverUC;		/* STK version number			     */
    UTINY typ;			/* First byte of bdat array		     */
    UTINY conf_lev;		/* Confident level after disambiguation      */
    UTINY orig_clUC;  	        /* Confident level before disambiguation     */
#if !(JPNREC)
    UTINY asciiUC;	     	/* Ascii value of recognized character	     */
#endif
    };

#define RCVBLKX struct rcvblkx	/* Data structure for dict. list & conf. list*/
RCVBLKX
    {
    UTINY rowUC; 		/* Row number				     */
    UTINY colUC; 		/* Column number			     */
    UTINY verUC; 		/* Version number			     */
    UTINY typUC; 		/* First byte of bdat array		     */
    UTINY conf_levUC;		/* Confident level			     */
    METACH asciiC;	     	/* Ascii value of recognized character	     */
    UTINY num_stksUC; 	    	/* Number of strokes in the character	     */
    UTINY indexUC[MAXSTKS];   	/* Index of strokes that make up character   */
    };

#define JISTD struct jistd	/* Structure for a handwritten character     */
JISTD
    {
    UTINY nstrokC;		/* Number of strokes			     */
    UTINY jisrowC;		/* JIS chart row number			     */
    UTINY jiscolC;		/* JIS chart column number	             */
    LONG  packtdL;		/* Packed time and date info from ctdtol()   */
    LONG  recnoL;		/* Record number of character header	     */
    };

#define STKTMP struct stktmp	/* Data structure for stroke templates	     */
STKTMP				/* (old format)				     */
	{
        CIC_TEXT    nact;
        CIC_TEXT    id;
        COUNT       avg[NSEGS];
        UTINY       std[NSEGS];
	};

#define NEWTMP struct newtmp	/* Data structure for stroke templates	     */
NEWTMP				/* (new format, Feb. 85			     */
    {
    UCOUNT      activ8;
    UTINY       activC;
    CIC_TEXT    id8;
    COUNT	avg8[NSEGS];
    UTINY	std8[NSEGS];
    };

#ifndef sun
#define TABDAT struct tabdat	/* Data structure for one sampled stroke     */
TABDAT
    {
    /*
    COUNT   DeltaX;
    COUNT   DeltaY;
    COUNT   DeltaTime;
    */
    COUNT   UID;
    COUNT   NumCoordPairs;
    };
#endif

#define MINX(sP) (sP)->x[(sP)->minxpt]
#define MAXX(sP) (sP)->x[(sP)->maxxpt]
#define MINY(sP) (sP)->y[(sP)->minypt]
#define MAXY(sP) (sP)->y[(sP)->maxypt]

#define NO_HOOK  -1	/* For US English hook detector return values	     */
#define BEG_HOOK  1
#define MID_HOOK  2
#define END_HOOK  3
#define BEG_CHOOK 4
#define END_CHOOK 5

#define AVAN(istk1, istk2, ibeg, iend, ilower, iupper, sign) \
    iavan((istk1), (istk2), (ibeg), (iend), \
    (ilower) / 5, (iupper) / 5, (sign))

#define CCCW(s1P, s2P, ipoint, ibeg, iend, parm) \
    icccw((s1P)->x[(ipoint)], (s1P)->y[(ipoint)], s2P, (ibeg), (iend), parm)

#define CMP4(sP, ibeg, iend, ithres, limit, itype, sign) \
    icmp4((sP), (ibeg), (iend), (((ithres) << 3) + ((ithres) << 1)), (itype), \
    (sign), (((limit) << 3) + ((limit) << 1)))

#define CPX2(sP, ibeg, iend, ithres) \
    icpx2((sP), (ibeg), (iend), (ithres) * (ithres) / 100)

#define DVLN(sP, ibeg, iend, ithres, sign) \
    idvln((sP), (ibeg), (iend), (ithres) / 10, (sign))

#define FIN2(sP, ibeg, iend, parm) ifin2((sP), (ibeg), (iend), (parm))

#define HORI(s1P, s2P, parm1, parm2) ihori((s1P), (s2P), (parm1), (parm2))

#define HOR2(s1P, s2P, parm1, parm2) ihor2((s1P), (s2P), (parm1), (parm2))

#define KANGL(s1P, s2P, ibeg1, iend1, ibeg2, iend2, parm1, parm2) \
    kangl((s1P), (s2P), (ibeg1), (iend1), (ibeg2), (iend2), (parm1) / 5, \
    (parm2) / 5)

#define LENG(istk1, istk2, s3P, parm1, parm2) \
    ileng((istk1), (istk2), (s3P), (parm1), (parm2))

#define LEN2(istk1, istk2, s3P, parm1, parm2) \
    ilen2((istk1), (istk2), (s3P), (parm1), (parm2))

#define PLSC(sP, ibeg, iend, lghseg, anglow, angup, dirlow, dirup) \
    ipls3((sP), (ibeg), (iend), 1, (lghseg), \
    (((anglow) << 3) + ((anglow) << 1)), (((angup) << 3) + ((angup) << 1)), \
    (((dirlow) << 3) + ((dirlow) << 1)), (((dirup) << 3) + ((dirup) << 1)))

#define PLSN(sP, ibeg, iend, lghseg, anglow, angup, dirlow, dirup) \
    ipls3((sP), (ibeg), (iend), -1, (lghseg), \
    (((anglow) << 3) + ((anglow) << 1)), \
    (((angup) << 3) + ((angup) << 1)), (((dirlow) << 3) + ((dirlow) << 1)), \
    (((dirup) << 3) + ((dirup) << 1)))

#define PLSNC(sP, ibeg, iend, lghseg, anglow, angup, dirlow, dirup) \
    ipls3nc((sP), (ibeg), (iend), (lghseg), \
    (((anglow) << 3) + ((anglow) << 1)), \
    (((angup) << 3) + ((angup) << 1)), (((dirlow) << 3) + ((dirlow) << 1)), \
    (((dirup) << 3) + ((dirup) << 1)))

#define RAT2(sP, ithres, parm) irat2((sP), (parm), (ithres) >> 2)

#define RAT3(sP, ibeg, iend, ithres, parm) irat3((sP), (ibeg), (iend), (parm), \
    (ithres) >> 2)

#define RTLT(sP, parm, ibeg, iend) parm irtlt((sP), (ibeg), (iend))

#define VERT(s1P, s2P, parm1, parm2) ivert((s1P), (s2P), (parm1), (parm2))

#define VER2(s1P, s2P, parm1, parm2) iver2((s1P), (s2P), (parm1), (parm2))

#define VR2P(s1P, s2P, parm1, parm2) iver2((s1P), (s2P), (parm1), (parm2))

#define XING(s1P, s2P, ibeg1, iend1, ibeg2, iend2) \
    ixing((s2P), (ibeg2), (iend2), 0, 0, (s1P)->x[(ibeg1)], \
    (s1P)->x[(iend1)], (s1P)->y[(ibeg1)], (s1P)->y[(iend1)])

#define DIST(s1P, s2P, ipoint, ibeg, iend, type, thres) \
    idist((s1P), (s2P), (ipoint), (ibeg), (iend), (type), (thres))

#endif	/* ifndef PARAMS_H */
