/* SIGPUB.H
 *------------------------------------------------------------------------------
 * SCCS Version 1.6, 16:24:02 3/15/95
 *------------------------------------------------------------------------------
 * Header file for modules that use siglib functions but are not in siglib
 *
 * JP Shipherd 06-May-92
 * D. C. Foyt  26-Jan-93	Added former contents of sigver.h
 * JP Shipherd 28-Jan-93        Added ifndef SIGPUB_H
 * V. Wilburn  03-Feb-93        Merge US and Japanese
 *------------------------------------------------------------------------------
 */
#ifndef SIGPUB_H
#define SIGPUB_H

/*
 *------------------------------------------------------------------------------
 * Constants used by the sigver component
 *------------------------------------------------------------------------------
 */
#define INPUTSEGS 200           /* max number of allowed segments in signtr.*/
#define MAXSIG 1024             /* max length for arrays used in sign. ver. */
#define MAXTEMP 6               /* maximum number of signatures in a        */
#define MMAX 256
#define TEMPPTS 256             /* number of points in signature templates  */
#define DPTHRES 25000L          /* stopping distance for DP calculation     */
                                /* subject's signature template             */

#if JPNREC
#define NUMFEAT 44              /* number of features (length of oldvalL))  */
#else   /* not JPNREC   */
#define SAVESEGS 20             /* max number of segments saved in template */

#ifdef sun
#define NUMFEAT 44              /* number of features (length of oldvalL))  */
#define MAXWRD 20               /* max length of a word in connected script */
#define EETEMP    4             /* No. of template can be stored in EEPROM   */
#define EEWRIT   16             /* No. of word can be programmed at a time   */
#define NAMSIZ   64             /* No. of byte for each template id          */
#define TEMSIZ (4096 - NAMSIZ)  /* No. of byte for each template data        */
#define SIG_RAM  39     /* Extra RAM pair not present                        */
#define SEE_NON  46     /* EEPROM loading no such id template                */
#define SEE_FUL  47     /* EEPROM loading no more room                       */
#define SEE_ERR  48     /* EEPROM loading error                              */
#endif
#define SNE_OVR  31     /* Too many signature collected                      */
#define SNE_INI  32     /* Enrollment is not initialized                     */
#define SCC_ERL  33     /* Incomplete enrollment                             */
#define SVS_TEM  34     /* Template not exist                                */
#define SVS_VRY  35     /* Verification error                                */
#define SGS_SEG  36     /* Too many segments                                 */
#define SGS_SAM  37     /* Too many samples                                  */
#define SNE_NON  38     /* No signature collected                            */

#define SUH_RNG  40     /* Uploading record # out of range                   */
#define SDH_HDR  41     /* Downloading record illegal header                 */
#define SDH_RNG  42     /* Downloading record # out of range                 */
#define SDH_LEN  43     /* Downloading record length incorrect               */
#define SDH_SUM  44     /* Downloading record check-sum error                */
#define SDH_PRS  45     /* Downloading record parsing error                  */

#define BEGREC    1     /* Signature template record starts at 1             */

#ifndef sun
#define LENG41   20     /* Template record 41 to 44 have 20 bytes            */
#define ENDREC  230     /* Signature template record ends at 230             */
#define LENG8    28     /* Template record 8 has 8 datum                     */
#else
#define ENDREC  206     /* Signature template record ends at 206             */
#define LENG8    8      /* Template record 8 has 8 datum                     */
#endif
#define LENG1    17     /* Template record 1 has 17 datum                    */
#define LENG2_7  24     /* Template record 2 to 7 has 24 datum               */
#define SEPPTS   16     /* Template record 9 to 40 has 16 datum              */
#endif  /* JPNREC       */

/*
 *------------------------------------------------------------------------------
 * Types used by the sigver component
 *------------------------------------------------------------------------------
 */
#ifdef sun
#if !(JPNREC)
#define SHARE1 union share1
SHARE1
    {
    CIC_TEXT  eenamb[NAMSIZ];
    COUNT eenamw[NAMSIZ / 2];
    };

#define SHARE2 union share2
SHARE2
    {
    CIC_TEXT  eetemb[TEMSIZ];
    COUNT eetemw[TEMSIZ / 2];
    };

#define SHARE3 union share3
SHARE3
    {
    CIC_TEXT  eebufb[2 * EEWRIT];
    COUNT eebufw[EEWRIT];
    };

#define TEMPDAT struct tempdat
TEMPDAT				/* structure for signatures templates	    */
    {
    COUNT timedown;		/* total time that pen is down 		    */
    COUNT nsegments;		/* number of down segments (i.e. pen-downs) */
    COUNT x_energy;		/* standard deviation of X-signal 	    */
    COUNT y_energy;		/* standard deviation of Y-signal 	    */
    COUNT xtemp[TEMPPTS];	/* data for X-signal template     	    */
    COUNT ytemp[TEMPPTS];	/* data for Y-signal template    	    */
    };
#endif  /* !JPNREC      */

#else   /* ifdef sun 	*/

#define TEMPDAT struct tempdat

TEMPDAT                         /* structure for signatures templates       */
    {
    COUNT timedown;             /* total time that pen is down              */
    COUNT nsegments;            /* number of down segments (i.e. pen-downs) */
    COUNT x_energy;             /* standard deviation of X-signal           */
    COUNT y_energy;             /* standard deviation of Y-signal           */
    COUNT xtemp[TEMPPTS];       /* data for X-signal template               */
    COUNT ytemp[TEMPPTS];       /* data for Y-signal template               */
#if !(JPNREC)
    COUNT segptrs[SAVESEGS];    /* indices to beginnings of segments        */
    COUNT endptrs[SAVESEGS];    /* indices to ends of segments (except last)*/
    LONG  xacoefL;              /* linear x trend a coefficient (from a+bt) */
    LONG  xbcoefL;              /* linear x trend b coefficient (from a+bt) */
    LONG  yacoefL;              /* linear y trend a coefficient (from a+bt) */
    LONG  ybcoefL;              /* linear y trend b coefficient (from a+bt) */
    COUNT xave;                 /* x average after detrending               */
    COUNT yave;                 /* y average after detrending               */
#endif
    };

#endif	/* ifdef sun */

/*
 *------------------------------------------------------------------------------
 * Function Prototypes
 *------------------------------------------------------------------------------
 */
#if ANSI_C
/* Chktmp.C module */
VOID chktmp
    (
#if PEN_WINDOWS
    LONG  **dpmatrixL,
#else
    LONG  dpmatrixL[MAXTEMP][MAXTEMP],
#endif
    	    	    	    	    	/* pairwise DP distances for n sign. */
    COUNT ref1,                         /* index of   primary reference      */
    COUNT ref2,                         /* index of secondary reference      */
    COUNT *consistP                     /* consistency number for template   */
    );

/* Findpair.C module */
VOID findpair
    (
#if PEN_WINDOWS
    LONG **dpmatrixL,                    /* [MAXTEMP][MAXTEMP]               */
#else
    LONG dpmatrixL[MAXTEMP][MAXTEMP],
#endif
    	    	    	    	    	/* pairwise DP distances for n sign. */
    FAST COUNT *ref1P,                  /* number (index) of derived ref #1  */
    FAST COUNT *ref2P                   /* number (index) of derived ref #2  */
    );

#else   /* not ANSI_C   */
VOID findpair();
VOID chktmp();
#endif  /* ANSI_C       */

#endif  /* ifndef SIGPUB_H */
