/* STDTYP.H                                                     CIC Proprietary
 *-----------------------------------------------------------------------------
 * SCCS VERSION 1.1, 09:54:04 6/21/96
 *-----------------------------------------------------------------------------
 * Standard CIC data types
 *
 * D. C. Foyt		15-Dec-88
 * JP Shipherd      20-Feb-92   Simplified KENDAT structure
 * JP Shipherd      04-Nov-92   Backport from PC.
 * K. Rolle         07-Jan-93   Added typedef enum TRI.
 * JP Shipherd      20-May-93   Added NEARARRAY type
 * PL Spoltore      04-Jan-94   Added protection against multiple inclusion
 *                              and protected some typedefs so that this file
 *                              may be included before or after WINDOWS.H
 *                              without any change in definitions.
 * PL Spoltore      10-Jan-94   Added some other changes so that we can include
 *                              this file before or after WINDOWS.H with the
 *                              Watcom Compiler.
 * JP Shipherd      16-Feb-94   Added Dan Illowski's CIC_INT typedefs
 * BJ Paulsen       22-Feb-94   Added stuff from CRAPI Revision 0.3 plus
 *                              miscellaneous #defines implied thereby.  Also
 *                              commented out #include of <cic.h> for sun
 *                              platform.
 * JP Shipherd      25-Feb-94   Add and use #define SIGNED, and other minor
 * BJ Paulsen       21-Mar-94   Added check for CIC_NOTEXT define.  If not
 *                              defined, behavior is as before; if defined
 *                              (recommend -DCIC_NOTEXT in makefile), the TEXT
 *                              typedef is not instantiated.
 * BJ Paulsen       04-Apr-94   Incorporated JP's CIC_AUTO_OR_STATIC addition.
 * K. Rolle         04-Apr-94   Added SUN only fields arnum, artype, and lfno
 *                                in non-JPNREC version of KENDAT.
 * JP Shipherd      20-Apr-94   Added is_bottomB type to KENDAT
 *                              Fixed up WINDOWS special def's at the bottom
 *                                 of this file
 * PL Spoltore      21-Jul-94   Updated to include any requirments to build
 *                                 an OS/2 version of the recognizer.
 * D. Hwang	    29-Sep-94	Added more CIC_ type.  Changed CIC_BOOL from
 *				   signed short to signed long
 * P.L. Spoltore    02-Feb-95   Updated to allow for both 16-bit and 32-bit
 *                                builds under Windows-95.
 *                              Removed name conflict with LPSTR.
 * P.L. Spoltore    02-Feb-95   Updated to allow for both 16-bit and 32-bit
 * P.L. Spoltore    06-Feb-95   Added a trap to cause a compiler error if this
 *                                file is ever included without including
 *                                OPTIONS.H first.
 * P.L. Spoltore    14-Jul-95   Changed size of CIC_BOOL to native int,
 *                                and added CIC_BOOL8, CIC_BOOL16, and CIC_BOOL32.
 *-----------------------------------------------------------------------------
 */

#ifndef STDTYP_H /* Prevent multiple inclusion */
#define STDTYP_H

/*
 *-----------------------------------------------------------------------------
 * Be Sure that OPTIONS.H has already been inclued
 *
 * IMPLEMENTATION NOTE: (By Paul Spoltore)
 *
 * To be sure that the code that is written on the sun is portable,
 * this file can only be used if OPTIONS.H has already been included
 * in the parent file. If the error below is being seen at compile
 * time -- please go back and add OPTIONS.H as the first include file
 * that your module uses.
 *-----------------------------------------------------------------------------
 */

#if !defined(OPTIONS_INCLUDED) && !defined(OPTIONS_H)
#error OPTIONS.H has not yet been included!
#endif

/*
 *-----------------------------------------------------------------------------
 * Somthing a little different for DEBUG PenWindows
 *-----------------------------------------------------------------------------
 */

#ifndef WINDOWS_H
#if PEN_WINDOWS && !defined(WINCE)
#if ((!defined(NDEBUG)) || (_WATCOM_API_) || (MEM_MANAGER_WINDOWS))
#define WINDOWS_H
#include <windows.h>
#endif
#endif
#endif

/*--------------------------------------------------------------------------*/
/* Somthing a little different for DEBUG OS/2                               */
/*--------------------------------------------------------------------------*/

#if OS2
#ifndef NDEBUG
/* #include <os2def.h> */
#endif
#endif

/*
 *-----------------------------------------------------------------------------
 * Somthing a little different for 32-BIT Windows-95
 *-----------------------------------------------------------------------------
 */

#if WIN95 && CORE32 && (_MSC_VER >= 900)
#pragma data_seg(".global","DATA")
#endif

/*
 *-----------------------------------------------------------------------------
 * If OS2 is not being included then Define Conflicts
 * If your system is using any of the types defined below it is actually
 * better to use one of the equivilent CIC_ types defined above
 *-----------------------------------------------------------------------------
 */
#ifndef OS2DEF_INCLUDED
#if !defined(WINDOWS_H) && !defined(_INC_WINDOWS) && !defined(___WIN386_INCLUDED__)
#define VOID void  
#endif
typedef unsigned short  USHORT;
typedef unsigned long   ULONG;
#endif

#ifdef sun
#ifndef SUN
#define SUN     1
#endif
#endif

/*
 *-----------------------------------------------------------------------------
 * CODETOOL on the sun does not like the keyword signed  - therefore we'll
 * define a type SIGNED that will allow us to use signed integers on the
 * platforms and vanilla(defaults to signed) integers on the sun
 *-----------------------------------------------------------------------------
 */
#if SUN
#define SIGNED
#else
#define SIGNED signed
#endif

/*
*-----------------------------------------------------------------------------
* Begin INCLUDE statements
*-----------------------------------------------------------------------------
*/

#define FAST            register
#define GLOBAL
#define IMPORT          extern
#define THISFL          extern
#define INTERN          static
#define LOCAL           static

typedef SIGNED char     TBOOL, TINY;
typedef SIGNED short    COUNT;
typedef SIGNED short    ARGINT, METACHAR, METACH;

#ifndef OS2DEF_INCLUDED
typedef SIGNED short    SHORT;
typedef SIGNED int      INT;
#endif

typedef unsigned char   UTINY, TBITS, UTEXT;
typedef unsigned short  BITS, UCOUNT, SIZETYPE;

typedef unsigned short  BYTES;
typedef unsigned long   LBITS;

typedef float           FLOAT;
typedef double          DOUBLE;
typedef unsigned short  ERCTYPE;

#ifndef NO
#define NO    0
#endif

#ifndef YES
#define YES   1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE  1
#endif

typedef enum
    {
    CIC_SUCCEED     = 0,
    CIC_FAIL        = 1
    } CIC_SUCCESS;

typedef enum
    {
    CIC_DONT_KNOW = 0,
    CIC_ON        = 1,
    CIC_OFF       = 2
    } CIC_TRI;

#ifndef abs
#define abs(x)    (((x) < 0) ? -(x) : (x))
#endif
#ifndef max
#define max(x,y)  (((x) < (y)) ? (y) : (x))
#endif
#ifndef min
#define min(x,y)  (((x) < (y)) ? (x) : (y))
#endif

#define FOREVER while(YES)

/* The UNUSED macro below is defined in two ways. By voiding out the */
/* variables, we do not do away with the warnings from the MS Visual */
/* C Compiler. So it has it's own definition. This definition has    */
/* been checked in assembler and gets compiled to no instructions    */
/* when both DEBUG and OPTIMIZED versions are built.                 */

#ifndef UNUSED
#ifndef __WATCOMC__
#define UNUSED(x) x=x
#else
#define UNUSED(x) ((void)(x))
#endif
#endif

#define EOS ('\0')
#define CIC_EOS ('\0')

/*
 *-----------------------------------------------------------------------------
 *  CIC_AUTO_OR_STATIC can be used for large automatic variable.  Dynamic
 * allocation at load time should eventually replace this type of thing
 *-----------------------------------------------------------------------------
 */
#if OS2        /* plug in a platform here that needs to conserve stack space */
#define CIC_AUTO_OR_STATIC  INTERN
#else
#define CIC_AUTO_OR_STATIC
#endif

/*------------------- Added by j.s. ostrem  6/7/90 ------------------------ */

#define MAX16       32767	/* equals -->   (2 to the power 15) - 1	    */
#define MIN16      -32768	/* equals -->  -(2 to the power 15) 	    */
#define MAX32  2147483647	/* equals -->   (2 to the power 31) - 1	    */
#define MIN32 -2147483648	/* equals -->  -(2 to the power 31) 	    */
/*--------------------------------------------------------------------------*/

#ifndef NULL
#define  NULL    0L
#endif

#define CIC_GLOBAL
#define CIC_LOCAL       static
#define CIC_INTERN      static
#define CIC_IMPORT      extern
#define CIC_READONLY
#define CIC_DIAG


#define CIC_MAXFILENAME 256

#define CIC_NO          0
#define CIC_YES         1
#define CIC_NULL	0L
#define CIC_FALSE	CIC_NO
#define CIC_TRUE	CIC_YES

#define CIC_NULLHANDLE	((CIC_HANDLE) -1)

typedef void            CIC_VOID;
typedef void            *CIC_MEMP;
typedef unsigned long   CIC_HANDLE;
typedef unsigned char   CIC_UTINY, CIC_TBITS, CIC_UTEXT, CIC_UCHAR;
typedef unsigned short  CIC_BITS, CIC_UCOUNT, CIC_USHORT, CIC_SIZETYPE;
typedef unsigned short  CIC_BYTES;
typedef unsigned long   CIC_ULONG, CIC_LBITS;

typedef SIGNED int      CIC_INT16OR32, CIC_INDEX;
typedef SIGNED int      LOOP, CIC_INT, CIC_LOOP;
typedef unsigned int    CIC_UINT16OR32;
typedef unsigned int    ULOOP, CIC_UINT, CIC_ULOOP;

typedef SIGNED char     CIC_INT8;
typedef SIGNED short    CIC_INT16;
typedef SIGNED long     CIC_INT32;
typedef unsigned char   CIC_UINT8;
typedef unsigned short  CIC_UINT16;
typedef unsigned long   CIC_UINT32;

typedef float           CIC_FLOAT;
typedef double          CIC_DOUBLE;
typedef unsigned short  CIC_ERCTYPE;
typedef SIGNED char     CIC_TBOOL, CIC_TINY, CIC_TEXT, CIC_CHAR;
typedef SIGNED short    CIC_COUNT, CIC_SHORT, CIC_ARGINT;
typedef SIGNED short    CIC_METACHAR, CIC_METACH;
typedef SIGNED long     CIC_LONG;
typedef short           CIC_STATUS;

typedef SIGNED int      CIC_BOOL;
typedef SIGNED char     CIC_BOOL8;
typedef SIGNED short    CIC_BOOL16;
typedef SIGNED long     CIC_BOOL32;

typedef struct tagCIC_POINT
    {
    long x;
    long y;
    } CIC_POINT;
typedef CIC_POINT * CIC_PPOINT;


/*
 *-----------------------------------------------------------------------------
 * The kendat structure in the past has provided all types of information
 * about what type of area a stroke was written on in a template that overlayed
 * an opaque tablet.  This is now obsolete (any stroke that is passed to the
 * recognizer is considered to be in a "text area") but it is still used to
 * provide information about where in a grid the stroke belongs JPS 4/21/94
 *-----------------------------------------------------------------------------
 */
#if JPNREC
#define KENDAT struct kendat
KENDAT                          /* atlret:  ATL returned data                */
    {
#if SUN
   /*
    *--------------------------------------------------------------------------
    * Area types and area numbers are a throwback to a different time.  I've
    * weeded out the unnecessary references to these on the platforms.  It
    * really should be done on the sun as well
    * JPS 4/20/94
    *--------------------------------------------------------------------------
    */

    USHORT   artype;            /* Area type:
                                    0 (GRAR) ==> graphics
                                    1 (TXAR) ==> text
                                    2 (RFAR) ==> remote-function
                                    3 (LFAR) ==> local-function
                                    4 (NOAR) ==> no area                     */
    USHORT   arnum;             /* Area number (within type)                 */
#endif
    USHORT   yyrr;              /* For graphics area:  y-coord (0.1mm unit)
                                   Otherwise:          grid row.             */
    USHORT   xxcc;              /* For graphics area:  x-coord (0.1mm unit)
                                   Otherwise:          grid column.          */
    USHORT   boxht;             /* Grid-box height (TXAR only) (0.1mm unit)  */
    USHORT   boxwth;            /* Grid-box width (TXAR only) (0.1mm unit)   */
    USHORT   bxorgy;            /* ATL y-coordinate of lower-left corner of
                                        grid box (0.1mm unit)                */
    USHORT   bxorgx;            /* ATL x-coordinate of lower-left corner of
                                        grid box (0.1mm unit)                */
    USHORT   boxhtp;            /* Height of printed grid-box (0.1mm unit)   */
    USHORT   boxwthp;           /* Width of printed grid-box (0.1mm unit)    */
    UTINY    dflttype;          /* Default recognition type number           */
    UTINY    lfno;              /* Local function number                     */
    USHORT   numcols;           /* Number of grid columns.  (TXAR only)      */
    USHORT   numrows;           /* Number of grid rows.     (TXAR only)      */
    USHORT   inner_x_origin;    /* X-origin of inner box                     */
    USHORT   inner_y_origin;    /* Y-origin of inner box                     */
    CIC_BOOL in_bottomB;        /* set if stroke is between printed baseline */
                                /* and the bottom of the box                 */
    };
#else  /* not JPNREC	*/

#define KENDAT struct kendat
KENDAT                          /* atlret:  ATL returned data                */
    {

#if SUN
   /*
    *--------------------------------------------------------------------------
    * Area types and area numbers are a throwback to a different time.  I've
    * weeded out the unnecessary references to these on the platforms.  It
    * really should be done on the sun as well
    * JPS 4/20/94
    *--------------------------------------------------------------------------
    */

    USHORT  artype;		/* Area type:
    					0 (GRAR) ==> graphics
    					1 (TXAR) ==> text
    					2 (RFAR) ==> remote-function
    					3 (LFAR) ==> local-function
    					4 (NOAR) ==> no area                 */
    USHORT  arnum;		/* Area number (within type)		     */
#endif

    USHORT  yyrr;               /* For graphics area:  y-coord (0.1mm unit)
                                   Otherwise:          grid row.             */
    USHORT  xxcc;               /* For graphics area:  x-coord (0.1mm unit)
                                   Otherwise:          grid column.          */
    USHORT  boxht;              /* Grid-box height (TXAR only) (0.1mm unit)  */
    USHORT  boxwth;             /* Grid-box width (TXAR only) (0.1mm unit)   */
    USHORT  bxorgy;             /* ATL y-coordinate of lower-left corner of
                                        grid box (0.1mm unit)                */
    USHORT  bxorgx;             /* ATL x-coordinate of lower-left corner of
                                        grid box (0.1mm unit)                */
    USHORT  boxhtp;             /* Height of printed grid-box (0.1mm unit)   */
    USHORT  boxwthp;            /* Width of printed grid-box (0.1mm unit)    */
    UTINY   dflttype;           /* Default recognition type number           */

#if SUN
    UTINY   lfno;		/* Local function number		     */
#endif

    USHORT  numcols;            /* Number of grid columns.  (TXAR only)      */
    USHORT  numrows;            /* Number of grid rows.     (TXAR only)      */
    USHORT  inner_x_origin;     /* X-origin of inner box                     */
    USHORT  inner_y_origin;     /* Y-origin of inner box                     */
    CIC_BOOL in_bottomB;        /* set if stroke is between printed baseline */
                                /* and the bottom of the box                 */
    };
#endif  /* JPNREC       */

/*
 *------------------------------------------------------------------------------
 * define pointer casts for PENDOS
 *------------------------------------------------------------------------------
 */
#if CICDOS

#define CICNEAR
#define CICFAR
#define NEARPTR     *
#define FARPTR	    *
#define HUGEPTR	    *
#define FARARRAY
#define NEARARRAY
#define NEARFUNC
#define FARFUNC
#define CICFARPROC
#define CICPASCAL   _pascal
#if CICDOS
#define MAX_NUM_ROWS	200
#define MAX_NUM_COLS	200
#endif

/*
 *------------------------------------------------------------------------------
 * define pointer casts for MAC
 *------------------------------------------------------------------------------
 */
#elif MAC

#define CICNEAR
#define CICFAR
#define NEARPTR     *
#define FARPTR	    *
#define HUGEPTR	    *
#define FARARRAY
#define NEARARRAY
#define NEARFUNC
#define FARFUNC
#define CICFARPROC
#define CICPASCAL   _pascal

/*
 *------------------------------------------------------------------------------
 * define pointer casts Pen Windows 1.0 (both 16 and 32 bit)
 *------------------------------------------------------------------------------
 */
#elif PEN_WINDOWS_1

#if __WATCOMC__
#define CICNEAR
#define CICFAR
#define NEARPTR     *
#define FARPTR	    *
#define CICHUGE
#define HUGEPTR	    *
#define FARARRAY
#define NEARARRAY
#define NEARFUNC
#define FARFUNC
#define CICFARPROC
#define CICPASCAL   _pascal
#else
#define FARPTR      _far *
#define CICHUGE
#define HUGEPTR     _huge *
#define FARARRAY    _far
#define NEARARRAY   _near
#define NEARFUNC    _near
#define FARFUNC     _far
#define CICFARPROC  _far
#define CICPASCAL   _pascal
#if !JPNREC
#define NEARPTR     *
#define CICNEAR     _near
#define CICFAR
#else
#define CICNEAR     _near
#define CICFAR      _far
#define NEARPTR     *
#endif
#endif

/*
 *------------------------------------------------------------------------------
 * define pointer casts for Pen Windows 2.0
 *------------------------------------------------------------------------------
 */
#elif PEN_WINDOWS_2

#if defined(WIN32)
#define CICNEAR
#define CICFAR
#define NEARPTR     *
#define FARPTR	    *
#define CICHUGE
#define HUGEPTR	    *
#define FARFUNC
#define NEARFUNC
#define FARARRAY
#define NEARARRAY
#define CICFARPROC
#define CICPASCAL   __stdcall
#else
#define CICNEAR     _near
#define CICFAR      _far
#define NEARPTR     _near *
#define FARPTR	    _far *
#define CICHUGE     _huge
#define HUGEPTR     _huge *
#define FARFUNC     _far
#define NEARFUNC    _near
#define FARARRAY    _far
#define NEARARRAY   _near
#define CICFARPROC  _far
#define CICPASCAL   _pascal
#endif

/*
 *------------------------------------------------------------------------------
 * define pointer casts for OS/2
 *------------------------------------------------------------------------------
 */
#elif OS2

#define CICNEAR
#define CICFAR
#define NEARPTR     *
#define FARPTR	    *
#define CICHUGE
#define HUGEPTR	    *
#define FARARRAY
#define NEARARRAY
#define NEARFUNC
#define FARFUNC
#define CICFARPROC

/*
 *------------------------------------------------------------------------------
 * define pointer casts for SUN
 *------------------------------------------------------------------------------
 */
#elif SUN

#define NEARFUNC
#define FARFUNC
#define NEARPTR   *
#define FARPTR    *
#define CICHUGE
#define HUGEPTR	  *
#define CICNEAR
#define CICFAR
#define FARARRAY
#define NEARARRAY
#define CICPASCAL

/*
 *------------------------------------------------------------------------------
 * No Platform Defined -- Generate an Error Message
 *------------------------------------------------------------------------------
 */
#else

#error No Platform Defined for STDTYP.H!

#endif

/*
 *-----------------------------------------------------------------------------
 * If WINDOWS is not being included then Define Conflicts
 * If your system is using any of the types defined below it is actually
 * better to use one of the equivilent CIC_ types defined above
 *-----------------------------------------------------------------------------
 */
#ifndef WINDOWS_H
#ifndef WINAPI

#ifndef OS2DEF_INCLUDED

#if OS2
typedef unsigned long BOOL;
#else
typedef SIGNED int BOOL;
#endif

typedef unsigned short UINT;
typedef SIGNED long LONG;
#endif

typedef struct tagPOINT
    {
    short x;
    short y;
    } POINT;
typedef POINT * PPOINT;

#if SUN
#ifndef NEAR
#define NEAR _near
#endif
#endif

#endif
#endif

/*
 *-----------------------------------------------------------------------------
 * End of Include - Do not put anything below these lines
 * End of Include - Do not put anything below these lines
 * End of Include - Do not put anything below these lines
 *-----------------------------------------------------------------------------
 */

#endif /* EndIf STDTYP_H */

/*
 *-----------------------------------------------------------------------------
 * End of File
 * End of File
 * End of File
 *-----------------------------------------------------------------------------
 */
