/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   alarmgr.h
Author(s)   :   Kenny Ng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   alarm manager header file
Revision    :   1.1
Note        :   None
===========================================================================
*/

#ifndef __ALARMGR_H__
#define __ALARMGR_H__
#include "mmu.h"

#define ALARMMGR_MIN_SOUND_VOLUME   23

struct _alarm_extra_info
{
	UBYTE	   type;
	DatabaseID dbid;
	RecordID   rec_id;
	USHORT	   field_num;
};
typedef struct _alarm_extra_info AlarmExtraInfo;

struct _alarm_event_hit
{
	UBYTE type;
	DatabaseID dbid;
	RecordID rec_id;
	UWORD reference;
    RTM hit_time;
};
typedef struct _alarm_event_hit AlarmEventHit;

struct _alarm_event
{
	AppID app;
	UBYTE type;
	DatabaseID dbid;
	RecordID rec_id;
	UWORD reference;
	RTM hit_time;
	BYTE *alert_msg;
	AlarmExtraInfo *extra_info;
};
typedef struct _alarm_event AlarmEvent;

struct _alarm_query_app
{
	AppID app;
        AlarmEventHit *evt_hit_ptr;
	struct _alarm_query_app *next;
};
typedef struct _alarm_query_app AlarmQueryLink;

struct _alarm_link
{
	AlarmEvent *event;
	struct _alarm_link *next;
};
typedef struct _alarm_link AlarmEventLink;

struct _alarm_hit_link
{
	AlarmEvent *event;
	UBYTE status;        /* read or unread */
	struct _alarm_hit_link *next;
};
typedef struct _alarm_hit_link AlarmHitLink;

#define ALARM_NEW       1
#define ALARM_UNREAD    2
#define ALARM_READ      3

/* event class */
#define ALARM_ONTIME    0x00
#define ALARM_ONDAY     0x40
#define ALARM_RESV1      0x80
#define ALARM_RESV2      0xC0

#define ALARM_TODO	0x00
#define ALARM_ANI	0x01
#define ALARM_SCH	0x02

#define TYPE_VOICE	0x00
#define TYPE_TONE	0x01
#define TYPE_NOACTION	0x02

#define ALARM_HIT_DELAY  60        /* allow 60 sec tolerance */

#define AlarmSetEventType(evt, atype)   {(evt)->type &= 0xc0;(evt)->type |= atype;}
#define AlarmSetEventClass(evt, cl)    {(evt)->type &= 0x3f;(evt)->type |= cl;}
#define AlarmGetEventType(evt)         (UBYTE) ((UBYTE) (evt)->type & (UBYTE) 0x3f)
#define AlarmGetEventClass(evt)        ((evt)->type & 0xc0)

void AlarmMgrInit();
BOOLEAN AlarmGetLastAlarmTime(AppID appid, RTM* last_time);
USHORT AlarmTotalEvent(void);
BOOLEAN AlarmFindEvent(AlarmEvent *alm_evt, AlarmEventLink **evt_ptr);
BOOLEAN AlarmAddEvent(AlarmEvent alm_evt);
BOOLEAN AlarmDelEvent(AlarmEvent alm_evt);
BOOLEAN AlarmDelEventEx(AlarmEvent alm_evt, BOOLEAN remove_node);
BOOLEAN AlarmAddHit(AlarmEvent *alm_evt);
BOOLEAN AlarmDelHit(AlarmEvent alm_evt);
//BOOLEAN AlarmAddQuery(AppID app, UBYTE type, RecordID recid, USHORT appdata, DatabaseID dbid, RTM hit_time);
BOOLEAN AlarmAddQuery(AppID app, UBYTE type, RecordID recid, UWORD appdata, DatabaseID dbid, RTM hit_time);
BOOLEAN AlarmDelQuery(AppID app, UBYTE type);
void AlarmSetAlarm();
void AlarmOnHit();
void AlarmGetVariable(AlarmEventLink **alarm_list, AlarmHitLink **alarm_hit,
		AlarmQueryLink **alarm_query, UBYTE *alarm_en);
void AlarmDelAllHit();
void AlarmPwrUpCheck();
void AlarmDelAppEvent(AppID appid);
BOOLEAN AlarmCallApp();
void AlarmSetCallApp();
void AlarmResetCallApp();
//18-Aug-2000
void AlarmSaveAlarmHitCount();


#endif
