/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this
file except in compliance with the License.

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
for the specific language governing rights and limitations under the License.

The Original Code is VT-OS Ver. 1.1 Operating System, released
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   dev_tel.h
Author(s)   :   Andrew Hui, Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio
Date:	    :   October 1st, 1999
Purpose:	:   Telecom codec low level driver
Revision    :   1.1
Note        :   27/08/99   1.0 Totally rewritten from Telecom.h (by TC).
                           This new version is adopt to use new sib
                           accessing method and system call.
                08/09/99   1.1 Fixed Buffer size problem
===========================================================================
*/


#define SIBSCLK                 SIB_CLK_RATE         /* SIB Clock Rate */

#define TEL_BLOCK_SIZE          48
#define TEL_SAMPLE_RATE(a)      ((SIBSCLK*2)/(64*a))
#define TEL_SAMPLING_RATE       8000

void TelSetDmaAddress(SHORT *inbuf, SHORT *outbuf);
void TelSetSamplingRate(WORD SamplingRate);
void TelSetBufferSize(WORD Size);
void TelSetUpBty(WORD SamplingRate );
void TelStartDma();
void TelStopDma();
void TelEnable();
void TelDisable();

                       /* Buffer for modem */
extern SHORT tel_rx_buf[TEL_BLOCK_SIZE*4];
extern SHORT tel_tx_buf[TEL_BLOCK_SIZE*4];

void TelInit();
void TelOnHook();
void TelOffHook();
BOOLEAN TelHookStatus();

