/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   errcode.h
Author(s)   :   
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for collection of known error codes
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef __ERRCODE_H__
#define __ERRCODE_H__

/* MMU */
#define ErrInvFlashSize		2
#define ErrInvChunkSize		3
#define ErrInvFieldSize		4
#define ErrInvHeapNumber	5
#define ErrInvChunkID		6
#define ErrInvFieldNumber	7
#define ErrInvChunkResize       8
#define ErrInvSrcAdd            9
#define ErrInvDstAdd            10
#define ErrInvStartAdd          11
#define ErrInvTypeID            12
#define ErrInvErrorCode         13
#define ErrMemReadFail          14
#define ErrMemWriteFail         15
#define ErrMemEraseFail         16
#define ErrInitFail             17
#define ErrUpdateFail           18
#define ErrSortFail             19
#define ErrNotFound	        20
#define ErrProgramNotAllow      21
#define ErrUpdateNotAllow       22
#define ErrEraseNotAllow        23
#define ErrNoMemCard		24
#define ErrNotEnoughMem		25
#define ErrNotEnoughRAM		26
#define ErrInvChunkNumber	27

/* DATA Manager */
#define ErrDBExist		40
#define ErrInvParam		41
#define ErrOpenExclusive	42
#define ErrDBProtected		43
#define ErrAlreadyOpen		44
#define ErrCannotOpenEx		45
#define ErrDBNotOpen		46
#define ErrRecordNotOpen	47
#define ErrTooManyDB		48
#define ErrInvRecordNumber	49
#define ErrInvRecordID		50
#define ErrRecordInUse		51
#define ErrRecordLocked		52
#define ErrInvReadStart		53
#define ErrNoNextRecord		54
#define ErrNoPrevRecord		55
#define ErrNoSortTable		56
#define ErrDBInUse		57
#define ErrMMUFault		58

/* Alarm Manager */
#define ErrNoEvent		70

/* UART Manager */
#define ErrInvPort		80
#define ErrInvHandle		81
#define ErrPortBusy		82
#define ErrInvBuffer		83

#endif

