/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   lcdapi.h
Author(s)   :   Brian Lee, Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for LCD API functions
Revision    :   1.1
Note        :   None
===========================================================================
*/              
                
#ifndef _LCDAPI_
#define _LCDAPI_

#include "LcdDrv.h"
#include "StrApi.h"

#define C_RLE			1
#define C_NULL			0

#define Q_FOUR_BIT		4
#define Q_TWO_BIT		2
#define Q_ONE_BIT		1

#define DOTDOT			1
#define NO_DOTDOT		0

#define DOTTED_LINE		0
#define NON_DOTTED_LINE	1

#define FILL_TRANSPARENT	2
#define FILL_SOLID		1
#define FILL_EMPTY		0

#define COLOR_INVERT	1
#define COLOR_NO_INVERT	0

#define SPACE_CHAR		1
#define SPACE_LINE		1

#define MARGIN_0		0
#define MARGIN_1		1
#define MARGIN_2		2

#define COLOR_GREY16_16	15
#define COLOR_GREY15_16	14
#define COLOR_GREY14_16	13
#define COLOR_GREY13_16	12
#define COLOR_GREY12_16	11
#define COLOR_GREY11_16	10
#define COLOR_GREY10_16	9
#define COLOR_GREY9_16	8
#define COLOR_GREY8_16	7
#define COLOR_GREY7_16	6
#define COLOR_GREY6_16	5
#define COLOR_GREY5_16	4
#define COLOR_GREY4_16	3
#define COLOR_GREY3_16	2
#define COLOR_GREY2_16	1
#define COLOR_GREY1_16	0

#define COLOR_GREY4_4		COLOR_GREY16_16
#define COLOR_GREY3_4       COLOR_GREY12_16
#define COLOR_GREY2_4       COLOR_GREY8_16
#define COLOR_GREY1_4		COLOR_GREY1_16

#define COLOR_TRANSPARENT	4

#define COLOR_BLACK_COLOR	3
#define COLOR_GREY2_COLOR	2
#define COLOR_GREY1_COLOR	1
#define COLOR_WHITE_COLOR	0


#define COLOR_BLACK			UIColorConversion(COLOR_BLACK_COLOR)
#define COLOR_GREY2			UIColorConversion(COLOR_GREY2_COLOR)
#define COLOR_GREY1			UIColorConversion(COLOR_GREY1_COLOR)
#define COLOR_WHITE			UIColorConversion(COLOR_WHITE_COLOR)


//#define COLOR_BLACK			COLOR_GREY16_16
//#define COLOR_GREY1			COLOR_GREY2_4
//#define COLOR_GREY2			COLOR_GREY3_4
//#define COLOR_WHITE			COLOR_GREY1_16

#define ColorInvert(c)	((~c) & 0xF)


/* color level selection */
#define	BLACK_AND_WHITE_MODE		0
#define GREYSCALE_MODE				1

/*	color level for flexible color arrangement */
extern BYTE	color_mode;
extern BYTE	color_level[4];



void LcdDrawHoriLine(SHORT xcoord1, SHORT xcoord2, SHORT ycoord1, BYTE style, BYTE color, BYTE bg_color);
void LcdDrawVertLine(SHORT xcoord1, SHORT ycoord1, SHORT ycoord2, BYTE style, BYTE color, BYTE bg_color);
void LcdInvertHoriLine(SHORT xcoord1, SHORT xcoord2, SHORT ycoord1);
void LcdGetPixel(SHORT xcoord1, SHORT ycoord1, BYTE *color);
void LcdSetPixel(SHORT xcoord1, SHORT ycoord1, BYTE color);
void LcdDrawLine(SHORT xcoord1, SHORT ycoord1, SHORT xcoord2, SHORT ycoord2,
	 			 BYTE thick, BYTE style, BYTE color, BYTE bg_color);
void LcdDrawBox(ObjectBounds *bounds, BYTE color, BYTE bg_color, BYTE fill);
void LcdInvertBox(ObjectBounds *bounds);
void LcdDrawEllipse(SHORT xcoord1, SHORT ycoord1, SHORT major_radius,
					SHORT minor_radius, BYTE color, BYTE bg_color, BYTE fill);
void LcdDrawArc(SHORT xcoord1, SHORT ycoord1, SHORT radius, BYTE style,
				BYTE color, BYTE bg_color, BYTE fill, BYTE arc_location);
void LcdEraseRegion(ObjectBounds *bounds);
void LcdGetBitmap(BitmapTemplate *save_behind);
void LcdDrawBitmap(BitmapTemplate *bitmap_struct, BOOLEAN invert);
				   BitmapTemplate *FontToBmp(BYTE character, BYTE color, BYTE bg_color, BYTE font);
void BmpQ2ToBmpQ4(BitmapTemplate *bitmap_struct1, BitmapTemplate *bitmap_struct2);
void BmpQ4ToBmpQ1(BitmapTemplate *bitmap_struct1, BitmapTemplate *bitmap_struct2);
void BmpQ1ToBmpQ4(BitmapTemplate *bitmap_struct1, BitmapTemplate *bitmap_struct2);
void LcdDrawCharacter(SHORT xcoord, SHORT ycoord, BYTE character,
					  BYTE color, BYTE bg_color, BYTE font);
void LcdDrawCharSpace(SHORT xcoord1, SHORT ycoord1, BYTE color, BYTE font);
void LcdDrawFixedString(ObjectBounds *bounds, BYTE *string, BYTE color,
						BYTE bg_color, BYTE font, BOOLEAN dotdot,SHORT margin);

void LcdTextboxDrawString(Textbox *textbox_ptr);

void LcdDrawVariableString(Field *field_ptr);
void LcdEnableInsertPt(BOOLEAN enable, SHORT xcoord, SHORT ycoord, BYTE font_id);
void LcdGetInsertPt(BOOLEAN *enable, SHORT *xcoord, SHORT *ycoord, BYTE *font_id);
					BOOLEAN LcdCheckInsertPt(ObjectBounds bounds);
void LcdMsgInsertPt();
void LcdDrawBlinkInsertPt();
void LcdDrawInsertPt(SHORT xcoord, SHORT ycoord);
void LcdSetOrientation(BYTE rot);
void LcdShowExceptionCode(UWORD addr, UWORD code);
BYTE LcdGetOrientation();


void LcdSetColorMode(BYTE input_color_mode);
BYTE LcdGetColorMode();

#endif
