/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   pr31700c.h
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   CPU-dependent definitions for the PHILIPS pr31700 architecture
Revision    :   1.1
Note        :   1. Memory configuration
 			    2. Video control
 				3. SIB control
 				4. IR control
 				5. UART control
 				6. Interrupt
 				7. Timer
 				8. SPI control
 				9. Multi-function IO
 				10. Clock control
 				11. Power control
 				12. CHI control
===========================================================================
*/              
                

#ifndef _PR31700C_
#define _PR31700C_

/*****************************************/
/*      Poseidon Register Definition     */
/*****************************************/

typedef struct
{
        volatile int REG_MEM_CONFIG_0;
        volatile int REG_MEM_CONFIG_1;
        volatile int REG_MEM_CONFIG_2;
        volatile int REG_MEM_CONFIG_3;
        volatile int REG_MEM_CONFIG_4;
        volatile int REG_MEM_CONFIG_5;
        volatile int REG_MEM_CONFIG_6;
        volatile int REG_MEM_CONFIG_7;
        volatile int REG_MEM_CONFIG_8;

        volatile int REG_DUMMY_1;

        volatile int REG_VIDEO_CTRL_1;
        volatile int REG_VIDEO_CTRL_2;
        volatile int REG_VIDEO_CTRL_3;
        volatile int REG_VIDEO_CTRL_4;
        volatile int REG_VIDEO_CTRL_5;
        volatile int REG_VIDEO_CTRL_6;
        volatile int REG_VIDEO_CTRL_7;
        volatile int REG_VIDEO_CTRL_8;
        volatile int REG_VIDEO_CTRL_9;
        volatile int REG_VIDEO_CTRL_10;
        volatile int REG_VIDEO_CTRL_11;
        volatile int REG_VIDEO_CTRL_12;
        volatile int REG_VIDEO_CTRL_13;
        volatile int REG_VIDEO_CTRL_14;

        volatile int REG_SIB_SIZE;
        volatile int REG_SIB_SND_RX_START;
        volatile int REG_SIB_SND_TX_START;
        volatile int REG_SIB_TEL_RX_START;
        volatile int REG_SIB_TEL_TX_START;
        volatile int REG_SIB_CTRL;
        volatile int REG_SIB_SND_HLDG;
        volatile int REG_SIB_TEL_HLDG;
        volatile int REG_SIB_SF0_CTRL;
        volatile int REG_SIB_SF1_CTRL;
        volatile int REG_SIB_SF0_STATUS;
        volatile int REG_SIB_SF1_STATUS;
        volatile int REG_SIB_DMA_CTRL;

        volatile int REG_DUMMY_2[3];

        volatile int REG_IR_CTRL_1;
        volatile int REG_IR_CTRL_2;
        volatile int REG_IR_HLDG;

        volatile int REG_DUMMY_3;

        volatile int REG_UARTA_CTRL_1;
        volatile int REG_UARTA_CTRL_2;
        volatile int REG_UARTA_DMA_CTRL_1;
        volatile int REG_UARTA_DMA_CTRL_2;
        volatile int REG_UARTA_DMA_CNT;
        volatile int REG_UARTA_HLDG;
        volatile int REG_UARTB_CTRL_1;
        volatile int REG_UARTB_CTRL_2;
        volatile int REG_UARTB_DMA_CTRL_1;
        volatile int REG_UARTB_DMA_CTRL_2;
        volatile int REG_UARTB_DMA_CNT;
        volatile int REG_UARTB_HLDG;

        volatile int REG_DUMMY_4[8];

        volatile int REG_INT_STATUS_1;
        volatile int REG_INT_STATUS_2;
        volatile int REG_INT_STATUS_3;
        volatile int REG_INT_STATUS_4;
        volatile int REG_INT_STATUS_5;
        volatile int REG_INT_STATUS_6;
        volatile int REG_INT_ENABLE_1;
        volatile int REG_INT_ENABLE_2;
        volatile int REG_INT_ENABLE_3;
        volatile int REG_INT_ENABLE_4;
        volatile int REG_INT_ENABLE_5;
        volatile int REG_INT_ENABLE_6;

        volatile int REG_DUMMY_5[4];

        volatile int REG_RTC_HIGH;
        volatile int REG_RTC_LOW;
        volatile int REG_ALARM_HIGH;
        volatile int REG_ALARM_LOW;
        volatile int REG_TIMER_CTRL;
        volatile int REG_PERIODIC_TIMER;

        volatile int REG_DUMMY_6[2];

        volatile int REG_SPI_CTRL;
        volatile int REG_SPI_HLDG;

        volatile int REG_DUMMY_7[6];

        volatile int REG_IO_CTRL;
        volatile int REG_MFIO_DATA_OUT;
        volatile int REG_MFIO_DIRECTN;
        volatile int REG_MFIO_DATA_IN;
        volatile int REG_MFIO_SEL;
        volatile int REG_IO_POWER_DOWN;
        volatile int REG_MFIO_POWER_DOWN;

        volatile int REG_DUMMY_8[9];

        volatile int REG_CLK_CTRL;

        volatile int REG_POWER_CTRL;

        volatile int REG_SIU_TEST;

        volatile int REG_DUMMY_9[3];

        volatile int REG_CHI_CTRL;
        volatile int REG_CHI_PTR_ENABLE;
        volatile int REG_CHI_RX_PTR_A;
        volatile int REG_CHI_RX_PTR_B;
        volatile int REG_CHI_TX_PTR_A;
        volatile int REG_CHI_TX_PTR_B;
        volatile int REG_CHI_SIZE;
        volatile int REG_CHI_RX_START;
        volatile int REG_CHI_TX_START;
        volatile int REG_CHI_HLDG;
} SCPU;

#define CPU  ((SCPU *) CPU_REGS_BASE_ADDR)

#endif	/* _PR31700C_ */
