/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   system.h
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for system, low battery, global find
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#ifndef __SYSTEM_H_
#define __SYSTEM_H_

#ifdef PC_SIM
#include "resource.h"
#endif
#include "datatype.h"
#include "resmgr.h"
#include "kernel.h"
#include "ui.h"
#include "uifunc.h"
#include "inlay.h"
#include "mmu.h"
#include "eventmgr.h"
#include "alaunch.h"
#include "alarmgr.h"
#include "ioconmsg.h"
#include "sndmevt.h"
#include "sndmgr.h"
#include "sndres.h"
#include "el.h"
#include "battery.h"
#include "siopopup.h"
#include "sylang.h"
#include "lcddebug.h"

extern BYTE mapped_hardware_button_enable;

//================= MACRO ====================
#define PRINT_RA		{														\
							WORD RA_REG;												\
							register WORD rtn __asm__ ("$2");					\
							__asm__ volatile ("move	%0, $31;" : "=r"(rtn));		\
							RA_REG = rtn;												\
							printf("\nRA is %08x", RA_REG);							\
						}							

//#define	PIN_A_DEBUG		(1 << 13)		// define this to enable pin debug
//#define	PIN_B_DEBUG		(1 << 14)		// define this to enable pin debug

#ifdef	PIN_A_DEBUG	////////////////////////////////////////////////////////////

#define	DebugPinAInit()	\
		CPU->REG_MFIO_SEL |= PIN_A_DEBUG;	\
		CPU->REG_MFIO_DATA_OUT &= ~(PIN_A_DEBUG);	\
		CPU->REG_MFIO_DIRECTN |= PIN_A_DEBUG
#define	DebugSetPinA()		CPU->REG_MFIO_DATA_OUT |= PIN_A_DEBUG
#define	DebugClearPinA()		CPU->REG_MFIO_DATA_OUT &= ~PIN_A_DEBUG
#define	DebugTogglePinA()	CPU->REG_MFIO_DATA_OUT ^= PIN_A_DEBUG

#else	////////////////////////////////////////////////////////////////////////

#define	DebugPinAInit()
#define	DebugSetPinA()
#define	DebugClearPinA()
#define	DebugTogglePinA()

#endif	PIN_A_DEBUG	////////////////////////////////////////////////////////////

#ifdef	PIN_B_DEBUG	////////////////////////////////////////////////////////////

#define	DebugPinBInit()	\
		CPU->REG_MFIO_SEL |= PIN_B_DEBUG;	\
		CPU->REG_MFIO_DATA_OUT &= ~(PIN_B_DEBUG);	\
		CPU->REG_MFIO_DIRECTN |= PIN_B_DEBUG
#define	DebugSetPinB()		CPU->REG_MFIO_DATA_OUT |= PIN_B_DEBUG
#define	DebugClearPinB()	CPU->REG_MFIO_DATA_OUT &= ~PIN_B_DEBUG
#define	DebugTogglePinB()	CPU->REG_MFIO_DATA_OUT ^= PIN_B_DEBUG

#else	////////////////////////////////////////////////////////////////////////

#define	DebugPinInit()
#define	DebugSetPin()
#define	DebugClearPin()
#define	DebugTogglePin()

#endif	PIN_B_DEBUG	////////////////////////////////////////////////////////////



#define     EVT_POWER_DOWN      7213

#define     FROM_SYSTEM_DIALOG  1000

//========= System Resources Defines (UI Object Defines) ====================
//================= FORM_GFIND_INPUT ====================
#define FORM_GFIND_INPUT			(0 + SYS_RES_ID)
#define STRING_GFIND_INPUT			(1 + SYS_RES_ID)
#define TEXTBOX_GFIND_INPUT			(2 + SYS_RES_ID)
#define BUTTON_GFIND_INPUT_PROCEED	(3 + SYS_RES_ID)
#define BUTTON_GFIND_INPUT_CANCEL	(4 + SYS_RES_ID)

//================= FORM_GFIND_RESULT ====================
#define FORM_GFIND_RESULT			(5 + SYS_RES_ID)
#define STRING_GFIND_RESULT_MATCH	(6 + SYS_RES_ID)
#define TABLE_GFIND_RESULT			(7 + SYS_RES_ID)
#define STRING_GFIND_RESULT_0		(8 + SYS_RES_ID)
#define STRING_GFIND_RESULT_1		(9 + SYS_RES_ID)
#define STRING_GFIND_RESULT_2		(10 + SYS_RES_ID)
#define STRING_GFIND_RESULT_3		(11 + SYS_RES_ID)
#define STRING_GFIND_RESULT_4		(12 + SYS_RES_ID)
#define STRING_GFIND_RESULT_5		(13 + SYS_RES_ID)
#define STRING_GFIND_RESULT_6		(14 + SYS_RES_ID)
#define STRING_GFIND_RESULT_7		(15 + SYS_RES_ID)
#define STRING_GFIND_RESULT_8		(16 + SYS_RES_ID)
#define STRING_GFIND_RESULT_9		(17 + SYS_RES_ID)
#define STRING_GFIND_RESULT_10		(18 + SYS_RES_ID)
#define SCROLLBAR_GFIND_RESULT		(19 + SYS_RES_ID)
#define BUTTON_GFIND_RESULT_CANCEL	(20 + SYS_RES_ID)

//================= FORM_BATTERY ====================
#define FORM_BATTERY                (21 + SYS_RES_ID)
#define BITMAP_BATTERY              (22 + SYS_RES_ID)
#define STRING_BATTERY              (23 + SYS_RES_ID)

//================= FORM_SIO ====================
#define FORM_SIO                    (24 + SYS_RES_ID)
#define STRING_SIO_1                (25 + SYS_RES_ID)
#define STRING_SIO_2                (26 + SYS_RES_ID)


//========= System Handle Event Function ====================
BOOLEAN SystemHandleEvent(EvtType *Event);
BOOLEAN SysApplicationHandleEvent(EvtType *Event);
BOOLEAN SysTranslateCustomiseButtons(EvtType *Event);
BOOLEAN SystemButtonTranslation(BYTE key);
void SystemSetMappedHardwareKeyStatus(BOOLEAN status);
BOOLEAN SystemCheckMappedHardwareKeyStatus();
void SystemApplicationInit();
BOOLEAN SysTranslateCustomiseButtonsWithoutPowerOff(EvtType *Event);
BOOLEAN SystemButtonTranslationWithoutPowerOff(BYTE key);


#endif
