/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   uartmgr.h
Author(s)   :   Kenny Ng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for uart manager 
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef __UART_COM_H__
#define __UART_COM_H__
#include "datatype.h"
#include "eventmgr.h"
#include "uart.h"
#include "mmu.h"

#define UART_PORT_MAX   1       /* port 0 & 1 only, total 2 port */
#define COM_FREE	(USHORT) 0x0000
#define COM_MODE_BUFFER 1
#define COM_MODE_CHAR   2
#define COM_RX_ENABLE      1
#define COM_RX_DISABLE     2

typedef char ComMode;      /* com mode, buffer or char */
extern EvtQueueType evtQueue;


/* event defination */
#define EVT_UART_GET_CHAR     	7000
#define EVT_UART_GET_BUFFER   	7001

#define COM_DATA_BIN          	1
#define COM_DATA_TEXT         	2  


#define UART_START_TX   		502

/* msg defination */

/* error code */
#define ERR_COM_INV_HANDLE      700
#define ERR_COM_INV_PARAM       701
#define ERR_COM_INV_BUFFER      702
#define ERR_COM_PORT_BUSY       703


/* prototype  */
Err 	ComOpenPort(WORD, WORD*);
void 	ComReset();
Err 	ComCapture(WORD, ComMode, UWORD, UWORD, BYTE*);
void 	ComWriteOutData(WORD);
Err 	ComClosePort(WORD);
BOOLEAN ComIsHandleValid(WORD);
void 	UartMgrInit();
Err 	ComGetMode(WORD, ComMode*);
Err 	ComConfigPort(WORD, WORD, WORD);
Err 	ComGetConfig(WORD, WORD*, WORD*);
Err 	ComSendData(WORD port_hdle, BYTE *buffer, UWORD buffer_size);
Err 	ComSendChar(WORD, BYTE);
void 	ComGetUartBuffer(WORD);
void 	ComWriteOutData(WORD);
void 	ComSetDataMode(int mode);
#endif
