/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   inlay.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Inlay related functions
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "uidef.h"
#include "uifunc.h"
#include "inlay.h"
#include "ioconmsg.h"

BYTE            inlay_status = 1;
extern SHORT    stored_bitmap_index;
extern BOOLEAN  battery_popup;
extern BOOLEAN  gf_keyboard_status;

//#define DEBUG
//#define DEBUG_MENU

/********************************************************
* Function:	InlayControlHandleEvent
* Purpose:		to handle the event that has occured in the inlay
* Scope:		internal
* Input:       Event 		received event
* Output:		None
* Return:		TRUE if handled
FALSE if not handled
* Comment:     None
*********************************************************/
BOOLEAN InlayHandleEvent(EvtType *Event)
{
	SHORT clicked_region;
    ObjectID form_id, menu_id, active_object_id;
	Menu *menu_ptr;
	Err error;
	BYTE object_type;
	Form *form_ptr;
	BOOLEAN found = FALSE;
	WORD i = 0;
	void *addr;
    BYTE temp_undo_action, *text_text;
    AppID app_id = 0xffff;
	
	
	switch (Event->eventType)
	{
	case EVT_INLAY_SELECT:
		switch (Event->para1)
		{
		case INLAY_LEFT:
			SndPlaySndEffect(SNDRES5_BEEP);
			return FALSE;
		case INLAY_RIGHT:
			SndPlaySndEffect(SNDRES5_BEEP);
			return FALSE;
		case INLAY_OK:
			SndPlaySndEffect(SNDRES5_BEEP);
			return FALSE;
		case INLAY_EXIT:
			SndPlaySndEffect(SNDRES5_BEEP);
			return FALSE;
		case INLAY_MAIN_MENU:
			if (inlay_status && !battery_popup)
			{
				SysGetAppID(MAINMENU, &app_id);
				if (app_id == 0xffff)
					return FALSE;
				if(SysGetActiveAppID() != app_id)
				{
					EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
					EvtAppendEvt(EVT_APP_LAUNCH, app_id, 0, 0, NULL);
					SndPlaySndEffect(SNDRES5_BEEP);
				}
			}
			return TRUE;
		case INLAY_CALCULATOR:
			FormGetActiveFormID(&form_id);
			UISearchForAddress(form_id, &object_type, (void**)&form_ptr);
			FormGetActiveObject(form_id, &active_object_id);
			FormGetObjectPointer(active_object_id, &object_type, (void**)&addr);
			if (object_type == FIELD || object_type == TEXTBOX)
			{
				if (object_type == FIELD)
				{
					if (((Field*)addr)->field_attr.field_insert_pt_visible || ((Field*)addr)->field_attr.field_highlight)
						found = TRUE;
				}
				else
				{
					if (((Textbox*)addr)->textbox_attr.textbox_insert_pt_visible || ((Textbox*)addr)->textbox_attr.textbox_highlight)
						found = TRUE;
				}
			}
			if (keyboard_status == TRUE && keyboard.keyboard_current_bitmap_index == 4)
			{
				if (gf_popup && gf_keyboard_status)
					return FALSE;
				FormGetActiveFormID(&form_id);			  			  				
				keyboard_status = FALSE;
				keyboard.keyboard_attr.keyboard_drawn = FALSE;
				KeyboardRestoreBitBehind();
				stored_bitmap_index = -1;
				EvtAppendEvt(EVT_KEYBOARD_STATUS, 0, 0, 0, NULL);
				SndPlaySndEffect(SNDRES5_BEEP);
				return TRUE;
			}
			else if (keyboard_status == TRUE && keyboard.keyboard_current_bitmap_index != 4)
			{
				stored_bitmap_index = keyboard.keyboard_current_bitmap_index;
				KeyboardDefineKeyboard(4);
				KeyboardDrawKeyboard();                  
				SndPlaySndEffect(SNDRES5_BEEP);
				return TRUE;
			}
			else if (keyboard_status == FALSE && menu_status == FALSE && 
				popup_status == FALSE && found == TRUE && keyboard.keyboard_attr.keyboard_visible == TRUE)
			{
				if (LcdCheckInsertPt(keyboard.bounds))
					LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT);
				//stored_bitmap_index = 4;
				stored_bitmap_index = 0;
				KeyboardSaveBehindBits();
				KeyboardDefineKeyboard(4);
				KeyboardDrawKeyboard();
				EvtAppendEvt(EVT_KEYBOARD_STATUS, 0, 1, 0, NULL);                  
				SndPlaySndEffect(SNDRES5_BEEP);
				return TRUE;
			}				  
			return FALSE;                                    
		case INLAY_KEYBOARD:
			FormGetActiveFormID(&form_id);
			UISearchForAddress(form_id, &object_type, (void**)&form_ptr);
			FormGetActiveObject(form_id, &active_object_id);
			FormGetObjectPointer(active_object_id, &object_type, (void**)&addr);
			if (object_type == FIELD || object_type == TEXTBOX)
			{
				if (object_type == FIELD)
				{
					if (((Field*)addr)->field_attr.field_insert_pt_visible ||
						((Field*)addr)->field_attr.field_highlight)
						found = TRUE;
				}
				else
				{
					if (((Textbox*)addr)->textbox_attr.textbox_insert_pt_visible ||
						((Textbox*)addr)->textbox_attr.textbox_highlight)
						found = TRUE;
				}
			}
			if (keyboard_status == TRUE && keyboard.keyboard_current_bitmap_index != 4)
			{
				if (gf_popup && gf_keyboard_status)
					return FALSE;
				FormGetActiveFormID(&form_id);			  			  				
				keyboard_status = FALSE;
				keyboard.keyboard_attr.keyboard_drawn = FALSE;
				KeyboardRestoreBitBehind();
				stored_bitmap_index = -1;
				EvtAppendEvt(EVT_KEYBOARD_STATUS, 0, 0, 0, NULL);
				SndPlaySndEffect(SNDRES5_BEEP);
				return TRUE;
			}
			else if (keyboard_status == TRUE && keyboard.keyboard_current_bitmap_index == 4)
			{
				KeyboardDefineKeyboard(stored_bitmap_index);
				KeyboardDrawKeyboard();
				SndPlaySndEffect(SNDRES5_BEEP);
				return TRUE;
			}
			else if (keyboard_status == FALSE && menu_status == FALSE 
				&& popup_status == FALSE && found == TRUE && keyboard.keyboard_attr.keyboard_visible == TRUE)
			{
				if (LcdCheckInsertPt(keyboard.bounds))
					LcdEnableInsertPt(FALSE, 0, 0, SMALL_FONT);	
				
				KeyboardSaveBehindBits();
				if (object_type == FIELD)
					FieldGetTextPointer(active_object_id, &text_text);
				else TextboxGetTextPointer(active_object_id, &text_text);
				
				if (strlen(text_text)) {
					stored_bitmap_index = 0;
					//KeyboardDrawKeyboard();    				  
					KeyboardDefineKeyboard(0);
					KeyboardDrawKeyboard();
				}
				else
				{
					stored_bitmap_index = 1;
					KeyboardDefineKeyboard(1);
					KeyboardDrawKeyboard();
				}
				EvtAppendEvt(EVT_KEYBOARD_STATUS, 0, 1, 0, NULL);
				SndPlaySndEffect(SNDRES5_BEEP);
				return TRUE;
			}				  
			return FALSE;
		case INLAY_MENU:
			if (popup_status == TRUE) return TRUE;	
			
			FormGetActiveFormID(&form_id);
			error = FormGetMenuID(form_id,&menu_id);
			if (error != TRUE) return FALSE;
			
			UISearchForAddress(menu_id,&object_type,(void**)&menu_ptr);
			
			if (menu_ptr->menu_attr.menu_drawn || menu_ptr->menu_attr.menu_visible == FALSE)
				return TRUE;
			
			if (error == TRUE)
			{
				menu_status = TRUE;
				EvtAppendEvt(EVT_MENU_SELECT, menu_id, 0, 0, (void*)menu_ptr);
				temp_undo_action = undo_action;
				LcdEnableInsertPt(FALSE, 0, 0, 0);
				undo_action = temp_undo_action;
			}
			return TRUE;
		default:
			return FALSE;
		}
		break;
	case PEN_EVENT:
		switch (Event->eventID)
		{
		case PEN_UP:
			if (inlay_event.eventType != EVT_INLAY_ENTER && inlay_event.eventType != EVT_INLAY_EXIT)
				return FALSE;
			if (inlay_event.eventType == EVT_INLAY_ENTER 
					&& menu_status == FALSE && popup_status == FALSE)
			{
				EvtAppendEvt(EVT_INLAY_SELECT, 0, inlay_event.para1, 0, NULL);
				inlay_event.eventType = NULL_EVENT;
			}
			else if (inlay_event.eventType == EVT_INLAY_EXIT)
				inlay_event.eventType = NULL_EVENT;
			return TRUE;
		case PEN_DOWN:
			clicked_region = InlayGetClickedRegion((SHORT)(Event->para1),(SHORT)(Event->para2));
			if (clicked_region != NO_SELECTION && menu_status == FALSE && popup_status == FALSE)
			{				
				EvtAppendEvt(EVT_INLAY_ENTER, 0, clicked_region, 0, NULL);
				inlay_event.eventType = NULL_EVENT;
				return TRUE;
			}
			return FALSE;
		case PEN_MOVE:
			if (inlay_event.eventType != EVT_INLAY_ENTER && inlay_event.eventType != EVT_INLAY_EXIT)
				return FALSE;
			clicked_region = InlayGetClickedRegion((SHORT)(Event->para1),(SHORT)(Event->para2));
			if ((clicked_region == NO_SELECTION && inlay_event.eventType == EVT_INLAY_ENTER))
				EvtAppendEvt(EVT_INLAY_EXIT, 0, inlay_event.para1, 0, NULL);
			else if (clicked_region != NO_SELECTION && inlay_event.eventType == EVT_INLAY_EXIT
					&& clicked_region == inlay_event.para1)
				EvtAppendEvt(EVT_INLAY_ENTER, 0, inlay_event.para1, 0, NULL);
			return TRUE;
		default:
			return FALSE;
		}
		break;
	case EVT_INLAY_ENTER:
		inlay_event = *Event;	
		return TRUE;
	case EVT_INLAY_EXIT:
		inlay_event = *Event;
		return TRUE;
	default:
		return FALSE;
	}
}

/********************************************************
* Function:	InlayGetClickedRegion
* Purpose:		to find out which inlay button is being clicked
* Scope:		internal
* Input:       xcoord	the x-coord of the pen
ycoord the y-coord of the pen
* Output:		None
* Return:		INLAY_MENU
INLAY_OK
INLAY_KEYBOARD
INLAY_EXIT
NO_SELECTION if not hitted
* Comment:     None
*********************************************************/

SHORT InlayGetClickedRegion(SHORT xcoord, SHORT ycoord)
{
	
    if (xcoord >= -1 &&
        xcoord <= 18 &&
        ycoord >= 169 &&
        ycoord <= 183)
		return INLAY_MENU;
	
    else if (xcoord >= -1 &&
		xcoord <= 18 &&
		ycoord >= 186 &&
		ycoord <= 199)
		return INLAY_OK;
	
    else if (xcoord >= -1 &&
		xcoord <= 18 &&
		ycoord >= 202 &&
		ycoord <= 215)
		return INLAY_MAIN_MENU;
	
    else if (xcoord >= 138 &&
		xcoord <= 160 &&
		ycoord >= 169 &&
		ycoord <= 183)
		return INLAY_KEYBOARD;
	
    else if (xcoord >= 138 &&
		xcoord <= 160 &&
		ycoord >= 186 &&
		ycoord <= 199)
		return INLAY_EXIT;
	
    else if (xcoord >= 138 &&
		xcoord <= 160 &&
		ycoord >= 202 &&
		ycoord <= 215)
		return INLAY_CALCULATOR;
	
    else if (xcoord >= 19 &&
		xcoord <= 36 &&
		ycoord >= 207 &&
		ycoord <= 217)
		return INLAY_LEFT;
	
    else if (xcoord >= 120 &&
		xcoord <= 138 &&
		ycoord >= 207 &&
		ycoord <= 217)
		return INLAY_RIGHT;
	
	else return NO_SELECTION;
}

/********************************************************
* Function:    InlayCheckEnableStatus
* Purpose:     This function is called to get the status of
the inlay
* Scope:       Application
* Input:       None
* Output:      None
* Return:      status
* Comment:     None
*********************************************************/
BOOLEAN InlayCheckEnableStatus()
{
	return inlay_status;
}

/********************************************************
* Function:    InlaySetEnableStatus
* Purpose:     This function is called to set the status of
the inlay
* Scope:       Application
* Input:       status
* Output:      None
* Return:      status
* Comment:     None
*********************************************************/
void    InlaySetEnableStatus(BOOLEAN status)
{
	if (status)
		inlay_status = 1;
	else    inlay_status = 0;
}
