/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
  
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   jotmacdb.c
Author(s)   :   J. Wang
Company     :   Communcation Intelligence Corporation
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Jot macro editor related functions
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "mmu.h"
#include "ui.h"
#include "uifunc.h"
#include "sylang.h"
#include <jot.h>

DatabaseID	g_dbID = (DatabaseID)NULL;

BOOLEAN OpenJotMacroDB()
{
	BOOLEAN newDB = FALSE;
	
	if (DataFindDB(JOT_MACRO_DB_NAME, &g_dbID) != TRUE)
	{
		newDB = TRUE;
		if (DataNewDB(JOT_MACRO_DB_NAME, JOT_MACRO_DB_VERSION,
			JOT_MACRO_DB_INFO, &g_dbID) != TRUE)
		{
			//                        printf("cannot create macro db\n");
			return FALSE;
		}
	}
	
	if (DataOpenDB(g_dbID, 0, OPEN_RW) != TRUE)
	{
		//                printf("cannot open macro db\n");
		return FALSE;
	}
	
	/* Add a few default macros if it's a new database */
	if (newDB)
	{
		AddJotMacro(SYSTR1, SYSTR5);
		AddJotMacro(SYSTR2, SYSTR6);
		AddJotMacro(SYSTR3, SYSTR7);
		AddJotMacro(SYSTR4, SYSTR8);
	}
	DataCloseDB(g_dbID);
	return TRUE;
}

BOOLEAN CloseJotMacroDB()
{
	return (BOOLEAN)DataCloseDB(g_dbID);
}

BOOLEAN AddJotMacro(BYTE *macroName, BYTE *macroText)
{
	RecordID recID;
	
	if (DataNewRecord(g_dbID, 0, 2, &recID) != TRUE)
		return FALSE;
	
	if (DataWriteField(g_dbID, recID, 0, strlen((char *)macroName)+1, macroName) != TRUE)
		return FALSE;
	
	if (DataWriteField(g_dbID, recID, 1, strlen((char *)macroText)+1, macroText) != TRUE)
		return FALSE;
	DataCloseRecord(g_dbID, recID);
	return TRUE;
}

/* NOTE: remember to qfree(*outputP) after call */
int MatchJotMacro
(
 int         num_input,      /* Number of input macro name   */
 char        *inputS,        /* Input macro string           */
 int         *num_outputP,   /* Number of output characters  */
 char        **outputP       /* Returned pointer to a string */
 /*   for recognized output      */
	)
{
	RecordID recordID;
	UWORD    recordNum;
	Err err;
	UWORD  i, total;
	BYTE     *name;
	UWORD    nameLen;
	
	*num_outputP = 0;
	*outputP = NULL;
	
	//	printf("input macro = %s\n", inputS);
	
	if (DataOpenDB(g_dbID, 0, OPEN_RW) != TRUE)
	{
		//                printf("Cannot open macro db\n");
		return FALSE;
	}
	
	inputS[num_input] = 0;
	if (DataTotalRecord(g_dbID, &total) != TRUE)
		return FALSE;
	
	//        printf("Total record = %d, g_dbID = %d\n", total, g_dbID);
	for (i = 0; i < total; i++)
	{
		err = DataOpenRecord(g_dbID, i, &recordID, NULL);
		//                printf("DataOpenRecord err = %d, g_dbID = %d\n", err, g_dbID);
		err = DataGetField(g_dbID, recordID, 0, (BYTE**)&name, &nameLen);
		//                printf("DataGetField err = %d\n", err);
		
		if (err == TRUE)
		{
			//			printf("Macro %d: name = %s, ", i, name);
			qfree((void *)name);
			err = DataGetField(g_dbID, recordID, 1, (BYTE**)outputP, (UWORD *)num_outputP);
			//			printf("output = %s, len = %d\n", *outputP, *num_outputP);
			DataCloseRecord(g_dbID, recordID);
		}
	}
	
	i = 0;
	while(1)
	{
		if (DataFindRecord(g_dbID, 0, i, (BYTE *)inputS, &recordID) != TRUE)
		{	
			//			printf("Cannot find macro\n");
			*num_outputP = 0;
			return FALSE;
		}
		
		DataRecIDtoNum(g_dbID, recordID, &recordNum);
		DataOpenRecord(g_dbID, recordNum, &recordID, NULL);
		err = DataGetField(g_dbID, recordID, 0, (BYTE**)&name, &nameLen);
		if (err == TRUE && strcmp((char *)name, (char *)inputS) == 0)
		{
			qfree((void *)name);
			err = DataGetField(g_dbID, recordID, 1, (BYTE**)outputP, (UWORD *)num_outputP);
			DataCloseRecord(g_dbID, recordID);
			
			//			printf("outputP = %s\n", *outputP);
			return TRUE;
		}
		DataCloseRecord(g_dbID, recordID);
		i = recordNum + 1;
		if (i >= total)
			break;
	}
	*num_outputP = 0;
	return FALSE;
}


