/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   kb_mgr.c
Author(s)   :   Garick Ngai
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Keyboard manager
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "kb_dev.h"
#include "kb_mgr.h"
#include "sio.h"
#include "sio_rxtx.h"
#include "Mmu.h"
#include "qtype.h"
#include "eventmgr.h"
#include "msg.h"
#include "system.h"


extern BOOLEAN menu_status;
extern BOOLEAN popup_status;

volatile UBYTE  keymap_value;
volatile UBYTE  el_is_on = 0;

volatile UBYTE  keymap0[61] = { 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 45, 61,
		9,113,119,101,114,116,121,117,105,111,112,  8,
		0, 97,115,100,102,103,104,106,107,108, 59, 13,
		0,122,120, 99,118, 98,110,109, 44, 46, 47, 28,  0,
		0,  0,  0, 91, 93, 32, 96, 92, 39, 31, 29, 30};

volatile UBYTE  keymap1[61] = { 33, 64, 35, 36, 37, 94, 38, 42, 40, 41, 95, 43,
		9, 81, 87, 69, 82, 84, 89, 85, 73, 79, 80,  8,
		0, 65, 83, 68, 70, 71, 72, 74, 75, 76, 58, 13,
		0, 90, 88, 67, 86, 66, 78, 77, 60, 62, 63, 21,  0,
		0,  0,  0,123,125, 32,126,124, 34, 20, 22, 23};


void KBCtrlMgr(MsgType* message)
{
	
    switch(message->msgID)
    {
	case MSG_KB_PRESS:
		//                        printf("\nfunction data = %x",message->para1);
		//                        printf(", KeyBoard data = %x\n",message->para2);
		KBMapData(message->para1, message->para2);
		
		break;
		
    }
}

void KBMapData(UWORD func_data, UWORD kb_data)
{
    AppID       appid = 0xffff, pass_appid = 0xffff;
    BYTE        object_type;
    Scrollbar   *scroll_ptr;
    List        *ptr;
    void        *addr;
    USHORT      count;
	
    if((kb_data < 17) || (kb_data == 66))
    {
        switch (kb_data)
		{
		case 1:				
			if (!menu_status && !popup_status)
				EvtAppendEvt(EVT_INLAY_SELECT, 0, INLAY_EXIT, 0, NULL);
			MenuCloseMenu();
			ControlPopupTriggerClosePopupTrigger();
			SndPlaySndEffect(SNDRES5_BEEP);
			return;
		case 2:
			SysGetAppID(JOT, &appid);
			break;
		case 3:
			SysGetAppID(CALCULATOR, &appid);
			break;
		case 4:
			SysGetAppID(EMAIL, &appid);
			break;
		case 5:
			SysGetAppID(MEMO, &appid);
			break;
		case 6 :
			SysGetAppID(SCHEDULER, &appid);
			break;
		case 7:
			SysGetAppID(MAINMENU, &appid);
			break;        	
		case 8:
			SysGetAppID(PHONEBOOK, &appid);
			break;
		case 9:
			SysGetAppID(TODOLIST, &appid);
			break;
		case 10:
			SysGetAppID(SKETCH, &appid);
			break;
		case 11:
			SysGetAppID(SYSETUP, &appid);
			break;
		case 12:
			SysGetAppID(EXPENSE, &appid);
			break;
		case 13:
			SysGetAppID(VOXMEMO, &appid);
			break;
		case 14:
			if (!menu_status && !popup_status)
				EvtAppendEvt(EVT_INLAY_SELECT, 0, INLAY_OK, 0, NULL);
			MenuCloseMenu();
			ControlPopupTriggerClosePopupTrigger();
			SndPlaySndEffect(SNDRES5_BEEP);
			return;
		case 15: /*backlight*/				
			if(el_is_on == 0)
			{
				OnEL();
				el_is_on = 1;
			}
			else
			{
				OffEL();
				el_is_on = 0;
			}
			return;
		case 16:
			el_is_on = 0;
			return;
			
		case 66:
			if (menu_status)
				MenuCloseMenu();                                               
			else
			{
				if (old_event.eventType != NULL_EVENT)
				{
					if (old_event.eventType == EVT_KEYBOARD_ENTER || old_event.eventType == EVT_KEYBOARD_EXIT)
					{
						if (keyboard.keyboard_attr.keyboard_enter)
						{
							KeyboardDrawInvertKey(keyboard.keyboard_highlight_key);    
							keyboard.keyboard_attr.keyboard_enter = FALSE;
						}                       		    
					}            		
					else
					{
						FormGetObjectPointer((ObjectID)old_event.eventID, &object_type, (void**)&addr);                     
						switch(object_type)
						{
						case CONTROL:                  
							if (((Control*)addr)->control_attr.control_enter)
							{
								((Control*)addr)->control_attr.control_enter = FALSE;
								ControlDrawControl(old_event.eventID);
							}                   
							break;
						case FIELD:
							LcdEnableInsertPt(FALSE, 0, 0, ((Field*)addr)->field_font_id);
							break;
						case LIST:					
							ListHighlightOneItem(((List*)addr), ((List*)addr)->list_highlighted_item, FALSE);
							((List*)addr)->list_highlighted_item = -1;
							ListHighlightOneItem(((List*)addr), ((List*)addr)->list_selected_item, TRUE);
							
							count = ((List*)addr)->list_num_related_list;
							while (count)
							{
								count --;
								if (FormGetObjectPointer(((List*)addr)->list_related_list_id[count], &object_type, (void**)&ptr) != TRUE)
									break;
								ListHighlightOneItem(ptr, ptr->list_highlighted_item, FALSE);
								ptr->list_highlighted_item = -1;
								ListHighlightOneItem(ptr, ptr->list_selected_item, TRUE);
							}
							break;
						case SCROLLBAR:
							scroll_ptr = (Scrollbar *)addr;
							if (scroll_ptr->scrollbar_attr.scrollbar_enter ||
								scroll_ptr->scrollbar_attr.scrollbar_enter1 ||
								scroll_ptr->scrollbar_attr.scrollbar_enter2)
							{
								scroll_ptr->scrollbar_attr.scrollbar_enter 	= FALSE;
								scroll_ptr->scrollbar_attr.scrollbar_enter1 = FALSE;
								scroll_ptr->scrollbar_attr.scrollbar_enter2 = FALSE;										
								ScrollbarDrawScrollbar(old_event.eventID);					                					                
							}
							break;
						case TABLE:
							if (((Table*)addr)->table_attr.table_enter)
							{
								((Table*)addr)->table_attr.table_enter = FALSE;
								((Table*)addr)->table_current_row = (USHORT) (old_event.para1);
								((Table*)addr)->table_current_col = (USHORT) (old_event.para2);
								TableDrawTable(old_event.eventID);
							}
							break;
						case SCHLINE:                     
							break;
						case BITMAP:
							if (((Bitmap*)addr)->bitmap_attr.bitmap_enter)
							{
								((Bitmap*)addr)->bitmap_attr.bitmap_enter = FALSE;
								BitmapDrawBitmap(old_event.eventID);
							}
							break;
						case TEXTBOX:
							LcdEnableInsertPt(FALSE, 0, 0, ((Textbox*)addr)->textbox_font_id);
							break;
						}
					}
				}                
				ControlPopupTriggerClosePopupTrigger();                    
				EvtAppendEvt(EVT_INLAY_SELECT, 0, INLAY_MENU, 0, NULL);
			}                    
			SndPlaySndEffect(SNDRES5_BEEP);
			return;
		default: return;
		}			
        SysGetAppID(SYPASSWORD, &pass_appid);
        if (appid != 0xffff && appid != SysGetActiveAppID() &&
            SysGetActiveAppID() != pass_appid)
		{
			EvtAppendEvtReplace(EVT_APP_STOP, 0, 0, 0, NULL);
			EvtAppendEvtReplace(EVT_APP_LAUNCH, appid, LAUNCH_CMD_NORMAL_LAUNCH, 0, NULL);
			SndPlaySndEffect(SNDRES5_BEEP);
			return;
		}			
    }
    else
    {
        if(((kb_data > 29) && (kb_data < 51)) || ((kb_data >53) && (kb_data < 61)))
        {
            if((func_data & 0x0000000c) == 0x0000000c)
            {
                keymap_value = keymap0[kb_data-17];
				//                EvtAppendEvt(EVT_KEY ,SOFT_KEY , keymap_value, func_data, NULL);
                KeyBoardSentEvt(keymap_value, func_data);
            }
            else
            {
                if((((func_data & 0x00000008) != 0) || (func_data & 0x00000004) != 0))
                {
                    keymap_value = keymap1[kb_data-17];
					//                EvtAppendEvt(EVT_KEY ,SOFT_KEY , keymap_value, func_data, NULL);
                    KeyBoardSentEvt(keymap_value, func_data);
                }
                else
                {
                    keymap_value = keymap0[kb_data-17];
					//                EvtAppendEvt(EVT_KEY ,SOFT_KEY , keymap_value, func_data, NULL);
                    KeyBoardSentEvt(keymap_value, func_data);
                }
            }
        }
        else
        {
			
            if(((func_data & 0x00000004) != 0))
            {
                keymap_value = keymap1[kb_data-17];
				//                EvtAppendEvt(EVT_KEY ,SOFT_KEY , keymap_value, func_data, NULL);
                KeyBoardSentEvt(keymap_value, func_data);
            }
            else
            {
                keymap_value = keymap0[kb_data-17];
				//                EvtAppendEvt(EVT_KEY ,SOFT_KEY , keymap_value, func_data, NULL);
                KeyBoardSentEvt(keymap_value, func_data);
            }
        }
		
    }
}

void KeyBoardSentEvt(UWORD para1, UWORD para2)
{
    UWORD       para2_key = 0;
    ObjectID    active_form_id, active_object_id;
    BYTE        object_type;
    void        *addr;
    BOOLEAN     error = FALSE;
    BOOLEAN     done = FALSE;
	
    para2_key = para2;
    //para2 = (para2 << 8);
	//        printf("\n %x",para2);
	
	if((para1 >= 32 && para1 <= 255) || (para1 == 8) || (para1 == 9) || (para1 == 13) || (para1 == 27))
	{
		para2 = 0;
	}
	else
	{
		para2 = 0;
		para2 |= para1;
		//            printf("\n %x",para2);
		
		para1 = 0;
	}
	
	if (para2_key & 0x8)
		para2 += 0x0800;
	if (para2_key & 0x4)
		para2 += 0x0400;
	if (para2_key & 0x2)
		para2 += 0x0200;
	if (para2_key & 0x1)
		para2 += 0x0100;
	
	
	if ((para2 & 0x100))
	{
		FormGetActiveFormID(&active_form_id);
		FormGetActiveObject(active_form_id, &active_object_id);
		if (FormGetObjectPointer(active_object_id, &object_type, (void**)&addr) != TRUE)
			error = TRUE;
		
		if (object_type != FIELD && object_type != TEXTBOX)
			error = TRUE;
		
		if (!error)
		{
			done = TRUE;
			if (para1 == 'C' || para1 == 'c')
				KeyboardSendEvent(KEY_COPY, FALSE, FALSE, FALSE);
			else if (para1 == 'V' || para1 == 'v')
				KeyboardSendEvent(KEY_PASTE, FALSE, FALSE, FALSE);
			else if (para1 == 'X' || para1 == 'x')            
				KeyboardSendEvent(KEY_CUT, FALSE, FALSE, FALSE);
			else if ((para1 == 'Z' || para1 == 'z') && UIGetUndoStatus() != UNDO_EMPTY)                               
				KeyboardSendEvent(KEY_UNDO, FALSE, FALSE, FALSE);
			else
				done = FALSE;
		}
		else
			done = FALSE;
	}            
	else if ((para2 & 0x200))
	{
		if (para1 == 'G' || para1 == 'g')
		{
			done = TRUE;
			if (!menu_status && !popup_status && !gf_popup && inlay_status)
				GlobalFindPopupGlobalFind();
		}
		else
			done = FALSE;
	}
	
	if (!done)
		EvtAppendEvt(EVT_KEY ,SOFT_KEY , para1, para2, NULL);
}
